/*
 * Decompiled with CFR 0.152.
 */
package org.summerboot.jexpress.integration.httpclient;

import io.netty.handler.codec.http.HttpResponseStatus;
import java.io.IOException;
import java.net.URLEncoder;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Optional;
import org.summerboot.jexpress.integration.httpclient.HTTPClientStringSubscriber;
import org.summerboot.jexpress.integration.httpclient.RPCResult;
import org.summerboot.jexpress.nio.server.SessionContext;

public interface RPCDelegate {
    public static String convertFormDataToString(Map<Object, Object> data) {
        StringBuilder sb = new StringBuilder();
        data.entrySet().forEach(entry -> {
            if (sb.length() > 0) {
                sb.append("&");
            }
            sb.append(URLEncoder.encode(entry.getKey().toString(), StandardCharsets.UTF_8)).append("=").append(URLEncoder.encode(entry.getValue().toString(), StandardCharsets.UTF_8));
        });
        return sb.toString();
    }

    public static String getHttpRequestBody(HttpRequest req) {
        String reqBody = null;
        Optional<HttpRequest.BodyPublisher> pub = req.bodyPublisher();
        if (pub.isPresent()) {
            reqBody = pub.map(p -> {
                HttpResponse.BodySubscriber<String> bodySubscriber = HttpResponse.BodySubscribers.ofString(StandardCharsets.UTF_8);
                HTTPClientStringSubscriber flowSubscriber = new HTTPClientStringSubscriber(bodySubscriber);
                p.subscribe(flowSubscriber);
                return bodySubscriber.getBody().toCompletableFuture().join();
            }).get();
        }
        return reqBody;
    }

    public <T> RPCResult<T> rpcEx(SessionContext var1, HttpRequest.Builder var2, HttpResponseStatus ... var3) throws IOException;

    public <T> RPCResult<T> rpcEx(SessionContext var1, HttpRequest var2, HttpResponseStatus ... var3) throws IOException;

    public <T> RPCResult<T> rpcEx(SessionContext var1, HttpRequest var2, String var3, HttpResponseStatus ... var4) throws IOException;

    public <T> RPCResult<T> rpcEx(SessionContext var1, RPCResult<T> var2, HttpResponseStatus ... var3) throws IOException;
}

