/*
 * Decompiled with CFR 0.152.
 */
package org.summerboot.jexpress.integration.httpclient;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.TimeZone;
import org.apache.commons.lang3.StringUtils;
import org.summerboot.jexpress.boot.BootErrorCode;
import org.summerboot.jexpress.nio.server.SessionContext;
import org.summerboot.jexpress.nio.server.domain.Err;
import org.summerboot.jexpress.nio.server.domain.ServiceErrorConvertible;
import org.summerboot.jexpress.util.BeanUtil;

public class RPCResult<T> {
    public static ObjectMapper DefaultJacksonMapper = new ObjectMapper();
    protected final HttpRequest originRequest;
    protected final String originRequestBody;
    protected final HttpResponse httpResponse;
    protected final String rpcResponseBody;
    protected final int httpStatusCode;
    protected final HttpResponseStatus httpStatus;
    protected final boolean remoteSuccess;
    protected T successResponse;

    public static void init(TimeZone timeZone, boolean fromJsonFailOnUnknownProperties, boolean fromJsonCaseInsensitive) {
        if (fromJsonCaseInsensitive) {
            DefaultJacksonMapper = ((JsonMapper.Builder)JsonMapper.builder().configure(MapperFeature.ACCEPT_CASE_INSENSITIVE_PROPERTIES, true)).build();
        }
        RPCResult.update(DefaultJacksonMapper, timeZone, fromJsonFailOnUnknownProperties);
    }

    protected static void update(ObjectMapper objectMapper, TimeZone timeZone, boolean isFromJsonFailOnUnknownProperties) {
        objectMapper.registerModules(new Module[]{new JavaTimeModule()});
        objectMapper.setTimeZone(timeZone);
        objectMapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
        objectMapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        objectMapper.configure(DeserializationFeature.FAIL_ON_IGNORED_PROPERTIES, false);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, isFromJsonFailOnUnknownProperties);
    }

    public RPCResult(HttpRequest originRequest, String originRequestBody, HttpResponse httpResponse, boolean remoteSuccess) {
        this.originRequest = originRequest;
        this.originRequestBody = originRequestBody;
        this.httpResponse = httpResponse;
        this.rpcResponseBody = httpResponse == null ? null : String.valueOf(httpResponse.body());
        this.httpStatusCode = httpResponse == null ? 0 : httpResponse.statusCode();
        this.httpStatus = HttpResponseStatus.valueOf((int)this.httpStatusCode);
        this.remoteSuccess = remoteSuccess;
    }

    public HttpRequest getOriginRequest() {
        return this.originRequest;
    }

    public String getOriginRequestBody() {
        return this.originRequestBody;
    }

    public HttpResponse httpResponse() {
        return this.httpResponse;
    }

    public HttpResponseStatus httpStatus() {
        return this.httpStatus;
    }

    public int httpStatusCode() {
        return this.httpStatusCode;
    }

    public String httpResponseBody() {
        return this.rpcResponseBody;
    }

    public boolean remoteSuccess() {
        return this.remoteSuccess;
    }

    public T successResponse() {
        return this.successResponse;
    }

    public RPCResult<T> update(Class<T> successResponseClass, SessionContext context) {
        if (this.remoteSuccess) {
            this.successResponse = this.parseJsonResponse(successResponseClass, context);
        }
        return this;
    }

    public RPCResult<T> update(JavaType successResponseType, SessionContext context) {
        if (this.remoteSuccess) {
            this.successResponse = this.parseJsonResponse(successResponseType, context);
        }
        return this;
    }

    public <R> R parseJsonResponse(Class<R> responseClass, SessionContext context) {
        return this.parseJsonResponse(DefaultJacksonMapper, null, responseClass, true, context);
    }

    public <R> R parseJsonResponse(JavaType responseType, SessionContext context) {
        return this.parseJsonResponse(DefaultJacksonMapper, responseType, null, true, context);
    }

    public <R> R parseJsonResponse(ObjectMapper jacksonMapper, JavaType responseType, Class<R> responseClass, boolean doValidation, SessionContext context) {
        Object ret;
        if (responseClass == null && responseType == null || StringUtils.isBlank((CharSequence)this.rpcResponseBody)) {
            return null;
        }
        try {
            String error2;
            Object object = ret = responseClass == null ? jacksonMapper.readValue(this.rpcResponseBody, responseType) : jacksonMapper.readValue(this.rpcResponseBody, responseClass);
            if (doValidation && (error2 = BeanUtil.getBeanValidationResult(ret)) != null) {
                if (context != null) {
                    Err e = new Err(BootErrorCode.HTTPCLIENT_INVALID_RESPONSE_FORMAT, null, "Invalid HTTP client JSON response", null, (Object)error2);
                    context.status(HttpResponseStatus.BAD_GATEWAY).error(e);
                }
                return null;
            }
            if (!this.remoteSuccess && context != null && ret instanceof ServiceErrorConvertible) {
                ServiceErrorConvertible errorResponse = (ServiceErrorConvertible)ret;
                if (errorResponse.isSingleError()) {
                    Err e = errorResponse.toServiceError(this.httpStatus);
                    context.error(e);
                } else {
                    List<Err> errors = errorResponse.toServiceErrors(this.httpStatus);
                    context.errors(errors);
                }
            }
        }
        catch (Throwable ex) {
            if (context != null) {
                Err e = new Err(BootErrorCode.HTTPCLIENT_UNKNOWN_RESPONSE_FORMAT, null, "Unknown HTTP client JSON response", ex, (Object)ex.toString());
                context.status(HttpResponseStatus.BAD_GATEWAY).error(e);
            }
            return null;
        }
        return (R)ret;
    }

    static {
        RPCResult.init(TimeZone.getDefault(), true, false);
    }
}

