/*
 * Decompiled with CFR 0.152.
 */
package org.summerboot.jexpress.integration.jpa;

import com.fasterxml.jackson.annotation.JsonIgnore;
import jakarta.persistence.EntityManager;
import org.hibernate.SessionFactory;
import org.hibernate.boot.Metadata;
import org.hibernate.boot.MetadataSources;
import org.hibernate.boot.registry.StandardServiceRegistry;
import org.hibernate.boot.registry.StandardServiceRegistryBuilder;
import org.hibernate.service.ServiceRegistry;
import org.summerboot.jexpress.boot.config.annotation.ConfigHeader;
import org.summerboot.jexpress.integration.jpa.JPAConfig;

public abstract class JPAHibernateConfig
extends JPAConfig {
    @ConfigHeader(title="1. Hibernate properties for Database Connection", callbackMethodName4Dump="generateTemplate_JPAConnection")
    protected final String dummyfield4annotion1;
    @ConfigHeader(title="2. Connection Pool", callbackMethodName4Dump="generateTemplate_ConnectionPool")
    protected final String dummyfield4annotion2;
    @JsonIgnore
    protected volatile SessionFactory sessionFactory;

    public static void main(String[] args) {
        class A
        extends JPAHibernateConfig {
            A() {
            }
        }
        String t = JPAHibernateConfig.generateTemplate(A.class);
        System.out.println(t);
    }

    protected void generateTemplate_JPAConnection(StringBuilder sb) {
        sb.append("jakarta.persistence.jdbc.url=\n");
        sb.append("jakarta.persistence.jdbc.user=\n");
        sb.append("jakarta.persistence.jdbc.password=DEC(plain text inside DEC() will be automatically encrypted by app root password when the application starts or is running)\n");
        sb.append("jakarta.persistence.jdbc.driver=\n");
        sb.append("#hibernate.dialect=\n");
        sb.append("hibernate.show_sql=false\n");
        sb.append("hibernate.hbm2ddl.auto=validate\n");
        sb.append("#hibernate.proc.param_null_passing=true\n");
        sb.append("#hibernate.loaded_classes=\n");
    }

    protected void generateTemplate_ConnectionPool(StringBuilder sb) {
        sb.append("# Maximum waiting time for a connection from the pool\n");
        sb.append("hibernate.hikari.connectionTimeout=20000\n");
        sb.append("# Minimum number of ideal connections in the pool\n");
        sb.append("hibernate.hikari.minimumIdle=10\n");
        sb.append("# Maximum number of actual connection in the pool\n");
        sb.append("hibernate.hikari.maximumPoolSize=20\n");
        sb.append("# Maximum time that a connection is allowed to sit ideal in the pool\n");
        sb.append("hibernate.hikari.idleTimeout=300000\n");
        sb.append("hibernate.hikari.registerMbeans=true\n");
    }

    protected JPAHibernateConfig() {
        this.dummyfield4annotion1 = null;
        this.dummyfield4annotion2 = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void buildEntityManagerFactory() {
        try {
            SessionFactory old = this.sessionFactory;
            StandardServiceRegistryBuilder registryBuilder = new StandardServiceRegistryBuilder();
            registryBuilder.applySettings(this.settings);
            StandardServiceRegistry registry = registryBuilder.build();
            MetadataSources sources = new MetadataSources((ServiceRegistry)registry);
            this.entityClasses.forEach(arg_0 -> ((MetadataSources)sources).addAnnotatedClass(arg_0));
            Metadata metadata = sources.getMetadataBuilder().build();
            this.sessionFactory = metadata.getSessionFactoryBuilder().build();
            if (old != null) {
                this.logger.warn("close current db connection due to config changed");
                try {
                    old.close();
                }
                catch (Throwable ex) {
                    this.logger.warn("failed to close current db connection", ex);
                }
            }
        }
        finally {
            if (this.settings.get("jakarta.persistence.jdbc.password") != null) {
                this.settings.put("jakarta.persistence.jdbc.password", "****");
            }
            if (this.settings.get("hibernate.connection.password") != null) {
                this.settings.put("hibernate.connection.password", "****");
            }
        }
    }

    @Override
    public void shutdown() {
        if (this.sessionFactory != null) {
            System.out.println(Thread.currentThread().getName() + ": shutdown DB.SessionFactory");
            try {
                this.sessionFactory.close();
                this.sessionFactory = null;
            }
            catch (Throwable ex) {
                ex.printStackTrace(System.err);
            }
        }
    }

    public SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    @Override
    public EntityManager em() {
        return this.sessionFactory.createEntityManager();
    }
}

