/*
 * Decompiled with CFR 0.152.
 */
package org.summerboot.jexpress.nio.grpc;

import io.grpc.Attributes;
import io.grpc.EquivalentAddressGroup;
import io.grpc.NameResolver;
import io.grpc.NameResolverProvider;
import io.grpc.StatusOr;
import java.net.InetSocketAddress;
import java.net.URI;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class BootLoadBalancerProvider
extends NameResolverProvider {
    protected final List<EquivalentAddressGroup> servers;
    protected final String scheme;
    protected final int priority;
    protected final String defaultAuthorityWhitoutTrustManager;

    public BootLoadBalancerProvider(String scheme, int priority, InetSocketAddress ... addresses) {
        this.scheme = scheme;
        this.priority = priority;
        this.defaultAuthorityWhitoutTrustManager = this.getAuthorityFromAddress(addresses);
        this.servers = Arrays.stream(addresses).map(EquivalentAddressGroup::new).collect(Collectors.toList());
    }

    public BootLoadBalancerProvider(String scheme, int priority, List<? extends InetSocketAddress> addresses) {
        this.scheme = scheme;
        this.priority = priority;
        this.defaultAuthorityWhitoutTrustManager = this.getAuthorityFromAddress(addresses);
        this.servers = addresses.stream().map(EquivalentAddressGroup::new).collect(Collectors.toList());
    }

    public String getAuthorityFromAddress(InetSocketAddress ... addresses) {
        if (addresses == null || addresses.length < 1) {
            return "unknownhost";
        }
        InetSocketAddress addr = addresses[0];
        return addr.getHostName() + ":" + addr.getPort();
    }

    public String getAuthorityFromAddress(List<? extends InetSocketAddress> addresses) {
        if (addresses == null || addresses.isEmpty()) {
            return "unknownhost";
        }
        InetSocketAddress addr = addresses.get(0);
        return addr.getHostName() + ":" + addr.getPort();
    }

    public NameResolver newNameResolver(final URI notUsedTargetUri, NameResolver.Args args) {
        return new NameResolver(){

            public String getServiceAuthority() {
                String auth = notUsedTargetUri.getAuthority();
                if (auth == null) {
                    auth = BootLoadBalancerProvider.this.defaultAuthorityWhitoutTrustManager;
                }
                return auth;
            }

            public void start(NameResolver.Listener2 listener) {
                listener.onResult(NameResolver.ResolutionResult.newBuilder().setAddressesOrError(StatusOr.fromValue(BootLoadBalancerProvider.this.servers)).setAttributes(Attributes.EMPTY).build());
            }

            public void shutdown() {
            }
        };
    }

    public String getDefaultScheme() {
        return this.scheme;
    }

    protected boolean isAvailable() {
        return true;
    }

    protected int priority() {
        return 0;
    }
}

