/*
 * Decompiled with CFR 0.152.
 */
package org.summerboot.jexpress.nio.server;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelProgressiveFuture;
import io.netty.channel.ChannelProgressiveFutureListener;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.stream.ChunkedFile;
import io.netty.util.AsciiString;
import io.netty.util.CharsetUtil;
import io.netty.util.concurrent.GenericFutureListener;
import jakarta.activation.MimetypesFileTypeMap;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.time.OffsetDateTime;
import java.util.Base64;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.tika.Tika;
import org.summerboot.jexpress.boot.BackOffice;
import org.summerboot.jexpress.boot.BootConstant;
import org.summerboot.jexpress.boot.BootErrorCode;
import org.summerboot.jexpress.integration.cache.SimpleLocalCache;
import org.summerboot.jexpress.integration.cache.SimpleLocalCacheImpl;
import org.summerboot.jexpress.nio.server.ErrorAuditor;
import org.summerboot.jexpress.nio.server.NioConfig;
import org.summerboot.jexpress.nio.server.ResponseEncoder;
import org.summerboot.jexpress.nio.server.SessionContext;
import org.summerboot.jexpress.nio.server.domain.Err;
import org.summerboot.jexpress.nio.server.domain.ProcessorSettings;
import org.summerboot.jexpress.nio.server.domain.ServiceRequest;
import org.summerboot.jexpress.security.SecurityUtil;
import org.summerboot.jexpress.util.TimeUtil;

public class NioHttpUtil {
    protected static final Logger log = LogManager.getLogger((String)NioHttpUtil.class.getName());
    public static final String HTTP_HEADER_AUTH_TOKEN = "Authorization";
    public static final String HTTP_HEADER_AUTH_TYPE = "Bearer";
    public static final AsciiString KEEP_ALIVE = new AsciiString((CharSequence)"keep-alive");
    public static final AsciiString CONNECTION = new AsciiString((CharSequence)"Connection");
    protected static final String DEFAULT_CHARSET = "UTF-8";
    public static final SimpleLocalCache<String, File> WebResourceCache = new SimpleLocalCacheImpl<String, File>();
    protected static final Pattern ALLOWED_FILE_NAME = Pattern.compile("[A-Za-z0-9][-_A-Za-z0-9\\.]*");

    public static String encodeMimeBase64(File file) throws IOException {
        byte[] contentBytes = Files.readAllBytes(file.toPath());
        return Base64.getMimeEncoder().encodeToString(contentBytes);
    }

    public static String encodeMimeBase64(byte[] contentBytes) {
        return Base64.getMimeEncoder().encodeToString(contentBytes);
    }

    public static byte[] decodeMimeBase64(String contentBase64) {
        return Base64.getMimeDecoder().decode(contentBase64);
    }

    public static void decodeMimeBase64(String contentBase64, File dest) throws IOException {
        byte[] contentBytes = Base64.getMimeDecoder().decode(contentBase64);
        FileUtils.writeByteArrayToFile((File)dest, (byte[])contentBytes);
    }

    private static void sendRedirect(ChannelHandlerContext ctx, String newUri, HttpResponseStatus status) {
        DefaultFullHttpResponse resp = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, status);
        resp.headers().set((CharSequence)HttpHeaderNames.LOCATION, (Object)newUri);
        ctx.writeAndFlush((Object)resp).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
    }

    public static long sendResponse(ChannelHandlerContext ctx, boolean isKeepAlive, SessionContext sessionContext, ErrorAuditor errorAuditor, ProcessorSettings processorSettings) {
        boolean hasErrorContent;
        String headerKey_serverTimestamp;
        String headerKey_reference;
        if (processorSettings == null) {
            headerKey_reference = "X-Reference";
            headerKey_serverTimestamp = "X-ServerTs";
        } else {
            headerKey_reference = processorSettings.getHttpServiceResponseHeaderName_Reference();
            headerKey_serverTimestamp = processorSettings.getHttpServiceResponseHeaderName_ServerTimestamp();
        }
        sessionContext.responseHeader(headerKey_reference, sessionContext.txId());
        sessionContext.responseHeader(headerKey_serverTimestamp, OffsetDateTime.now().format(TimeUtil.ISO_ZONED_DATE_TIME3));
        HttpResponseStatus status = sessionContext.status();
        if (sessionContext.file() != null) {
            return NioHttpUtil.sendFile(ctx, isKeepAlive, sessionContext, errorAuditor, processorSettings);
        }
        if (sessionContext.redirect() != null) {
            NioHttpUtil.sendRedirect(ctx, sessionContext.redirect(), status);
            return 0L;
        }
        boolean bl = hasErrorContent = StringUtils.isEmpty((CharSequence)sessionContext.txt()) && status.code() >= 400;
        if (hasErrorContent) {
            String errorResponse;
            String clientAcceptContentType;
            if (sessionContext.error() == null) {
                sessionContext.error(null);
            }
            if ((clientAcceptContentType = sessionContext.clientAcceptContentType()) != null && clientAcceptContentType.contains("xml")) {
                errorResponse = sessionContext.error().toXML();
                sessionContext.contentType("application/xml");
            } else {
                errorResponse = sessionContext.error().toJson();
                sessionContext.contentType("application/json");
            }
            if (errorAuditor != null) {
                errorResponse = errorAuditor.beforeSendingError(errorResponse);
            }
            sessionContext.response(errorResponse);
        }
        if (HttpResponseStatus.OK.equals((Object)status) && sessionContext.autoConvertBlank200To204() && StringUtils.isEmpty((CharSequence)sessionContext.txt())) {
            sessionContext.status(HttpResponseStatus.NO_CONTENT);
        }
        return NioHttpUtil.sendText(ctx, isKeepAlive, sessionContext.responseHeaders(), sessionContext.status(), sessionContext.txt(), sessionContext.contentType(), sessionContext.charsetName(), true, sessionContext.responseEncoder());
    }

    protected static long sendText(ChannelHandlerContext ctx, boolean isKeepAlive, HttpHeaders serviceHeaders, HttpResponseStatus status, String content, String contentType, String charsetName, boolean flush, ResponseEncoder responseEncoder) {
        byte[] contentBytes;
        if (content == null) {
            content = "";
        }
        if (responseEncoder != null) {
            content = responseEncoder.encode(content);
        }
        if (charsetName == null) {
            contentBytes = content.getBytes(StandardCharsets.UTF_8);
            charsetName = DEFAULT_CHARSET;
        } else {
            try {
                contentBytes = content.getBytes(charsetName);
            }
            catch (UnsupportedEncodingException ex) {
                if (log.isWarnEnabled()) {
                    String error2 = SecurityUtil.sanitizeCRLF("Unsupported Header (Accept-Charset: " + charsetName + "): " + ex.getMessage());
                    log.warn(error2);
                }
                contentBytes = content.getBytes(StandardCharsets.UTF_8);
                charsetName = DEFAULT_CHARSET;
            }
        }
        DefaultFullHttpResponse resp = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, status, Unpooled.wrappedBuffer((byte[])contentBytes));
        HttpHeaders h = resp.headers();
        if (serviceHeaders != null) {
            h.set(serviceHeaders);
        }
        if (contentType != null) {
            h.set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)(contentType + ";charset=" + charsetName));
        }
        int responseDataBytes = resp.content().readableBytes();
        h.set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)String.valueOf(responseDataBytes));
        if (isKeepAlive) {
            h.set((CharSequence)HttpHeaderNames.CONNECTION, (Object)KEEP_ALIVE);
            if (flush) {
                ctx.writeAndFlush((Object)resp);
            } else {
                ctx.write((Object)resp);
            }
        } else if (flush) {
            ctx.writeAndFlush((Object)resp).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        } else {
            ctx.write((Object)resp).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }
        if (serviceHeaders != null) {
            serviceHeaders.set(h);
        }
        return responseDataBytes;
    }

    private static long sendFile(ChannelHandlerContext ctx, boolean isKeepAlive, SessionContext sessionContext, ErrorAuditor errorAuditor, ProcessorSettings processorSettings) {
        DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, sessionContext.status());
        HttpHeaders h = response.headers();
        h.set(sessionContext.responseHeaders());
        long fileLength = -1L;
        RandomAccessFile randomAccessFile = null;
        File file = sessionContext.file();
        if (!SecurityUtil.precheckFile(file, sessionContext)) {
            file = NioHttpUtil.buildErrorFile(sessionContext);
            sessionContext.response(file, false);
            return NioHttpUtil.sendResponse(ctx, isKeepAlive, sessionContext, errorAuditor, processorSettings);
        }
        sessionContext.memo("sendFile", file.getAbsolutePath());
        final String filePath = file.getName();
        try {
            final RandomAccessFile raf = randomAccessFile = new RandomAccessFile(file, "r");
            fileLength = randomAccessFile.length();
            if (isKeepAlive) {
                h.set((CharSequence)HttpHeaderNames.CONNECTION, (Object)KEEP_ALIVE);
            }
            ctx.write((Object)response);
            ChannelFuture sendFileFuture = ctx.write((Object)new ChunkedFile(randomAccessFile, 0L, fileLength, 8192), (ChannelPromise)ctx.newProgressivePromise());
            sendFileFuture.addListener((GenericFutureListener)new ChannelProgressiveFutureListener(){

                public void operationProgressed(ChannelProgressiveFuture future, long progress, long total) {
                    if (total < 0L) {
                        log.error(filePath + " -> Transfer progress: " + progress);
                    } else {
                        log.debug(() -> filePath + " -> Transfer progress: " + progress + " / " + total);
                    }
                }

                public void operationComplete(ChannelProgressiveFuture future) throws Exception {
                    log.debug(() -> filePath + " -> Transfer complete.");
                    raf.close();
                }
            });
            ChannelFuture lastContentFuture = ctx.writeAndFlush((Object)LastHttpContent.EMPTY_LAST_CONTENT);
            if (!isKeepAlive) {
                lastContentFuture.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
            }
        }
        catch (IOException ex) {
            if (randomAccessFile != null) {
                try {
                    randomAccessFile.close();
                }
                catch (IOException e) {
                    String error2 = SecurityUtil.sanitizeCRLF("Failed to close file: " + file.getAbsolutePath());
                    log.error(error2, (Throwable)e);
                }
            }
            Err err = new Err(BootErrorCode.NIO_UNEXPECTED_SERVICE_FAILURE, null, "Failed to send file: " + file.getName(), (Throwable)ex, (Object)("Failed to send file: " + file.getAbsolutePath()));
            file = null;
            sessionContext.response(file, false).error(err).status(HttpResponseStatus.INTERNAL_SERVER_ERROR);
            return NioHttpUtil.sendResponse(ctx, isKeepAlive, sessionContext, errorAuditor, processorSettings);
        }
        return fileLength;
    }

    public static File buildErrorFile(SessionContext sessionContext) {
        HttpResponseStatus status = sessionContext.status();
        int errorCode = status.code();
        boolean isDownloadMode = sessionContext.isDownloadMode();
        String errorFileName = errorCode + (isDownloadMode ? ".txt" : ".html");
        NioConfig nioCfg = NioConfig.cfg;
        String errorPageFolderName = nioCfg.getErrorPageFolderName();
        File errorFile = StringUtils.isBlank((CharSequence)errorPageFolderName) ? new File(nioCfg.getDocrootDir() + File.separator + errorFileName).getAbsoluteFile() : new File(nioCfg.getDocrootDir() + File.separator + errorPageFolderName + File.separator + errorFileName).getAbsoluteFile();
        if (!errorFile.exists()) {
            errorFile.getParentFile().mkdirs();
            String title = BackOffice.agent.getVersionShort();
            String errorDesc = status.reasonPhrase();
            StringBuilder sb = new StringBuilder();
            Path errorFilePath = errorFile.getAbsoluteFile().toPath();
            try (InputStream ioStream = sessionContext.getClass().getClassLoader().getResourceAsStream("org/summerboot/jexpress/template/HttpErrorTemplate" + (isDownloadMode ? ".txt" : ".html"));
                 InputStreamReader isr = new InputStreamReader(ioStream);
                 BufferedReader br = new BufferedReader(isr);){
                String line;
                while ((line = br.readLine()) != null) {
                    sb.append(line).append(BootConstant.BR);
                }
                String errorFileContent = sb.toString().replace("${title}", title).replace("${code}", "" + errorCode).replace("${desc}", errorDesc);
                Files.writeString(errorFilePath, (CharSequence)errorFileContent, new OpenOption[0]);
            }
            catch (IOException ex) {
                String message = title + ": errCode=" + errorCode + ", desc=" + errorDesc;
                Err e = new Err(BootErrorCode.FILE_NOT_FOUND, null, null, (Throwable)ex, (Object)("Failed to generate error page:" + errorFile.getName() + ", " + message));
                sessionContext.error(e);
            }
        }
        return errorFile;
    }

    public static void sendWebResource(ServiceRequest request, SessionContext response) throws IOException {
        String httpRequestPath = request.getHttpRequestPath();
        NioHttpUtil.sendWebResource(httpRequestPath, response);
    }

    public static void sendWebResource(String httpRequestPath, SessionContext context) throws IOException {
        String accept;
        HttpHeaders headers = context.requestHeaders();
        if (!(headers == null || (accept = headers.get((CharSequence)HttpHeaderNames.ACCEPT)) == null || (accept = accept.toLowerCase()).contains("html") || accept.contains("web") || accept.contains("image") || !accept.contains("json") && !accept.contains("xml"))) {
            Err error2 = new Err(BootErrorCode.NIO_REQUEST_BAD_HEADER, null, "Client request header expect " + String.valueOf(HttpHeaderNames.ACCEPT) + "=" + accept + ", but request a web resource", null);
            context.error(error2).status(HttpResponseStatus.NOT_FOUND);
            return;
        }
        File webResourceFile = WebResourceCache.get(httpRequestPath);
        if (webResourceFile == null) {
            webResourceFile = new File(NioConfig.cfg.getDocrootDir(), httpRequestPath);
            String requestedPath = webResourceFile.getCanonicalPath();
            if (!requestedPath.startsWith(NioConfig.cfg.getDocrootDir())) {
                Err e = new Err(BootErrorCode.FILE_NOT_ACCESSABLE, null, null, null, (Object)("Invalid request path: " + httpRequestPath));
                context.status(HttpResponseStatus.FORBIDDEN).error(e);
                return;
            }
            WebResourceCache.put(httpRequestPath, webResourceFile, BootConstant.WEB_RESOURCE_TTL_MS);
        }
        context.response(webResourceFile, false).level(Level.TRACE);
    }

    public static String getFileContentType(File file) {
        String mimeType;
        block2: {
            try {
                Tika tika = new Tika();
                mimeType = tika.detect(file);
            }
            catch (IOException ex) {
                MimetypesFileTypeMap mimeTypesMap = new MimetypesFileTypeMap();
                mimeType = mimeTypesMap.getContentType(file.getPath());
                if (!log.isWarnEnabled()) break block2;
                String error2 = SecurityUtil.sanitizeCRLF("Failed to get MIME type from " + file.getAbsolutePath() + ": " + ex.getMessage());
                log.warn(error2);
            }
        }
        return mimeType;
    }

    public static String getHttpPostBodyString(FullHttpRequest fullHttpRequest) {
        ByteBuf buf = fullHttpRequest.content();
        String jsonStr = buf.toString(CharsetUtil.UTF_8);
        log.debug(() -> "\n" + fullHttpRequest.uri() + "\n" + jsonStr);
        return jsonStr;
    }

    public static String decode(String value) {
        try {
            return URLDecoder.decode(value, StandardCharsets.UTF_8.toString());
        }
        catch (UnsupportedEncodingException ex) {
            return value;
        }
    }
}

