/*
 * Decompiled with CFR 0.152.
 */
package org.summerboot.jexpress.nio.server;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.DecoderException;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.QueryStringDecoder;
import io.netty.util.ReferenceCountUtil;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.time.ZoneId;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.RejectedExecutionException;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.summerboot.jexpress.boot.BootConstant;
import org.summerboot.jexpress.boot.BootErrorCode;
import org.summerboot.jexpress.nio.server.ErrorAuditor;
import org.summerboot.jexpress.nio.server.NioConfig;
import org.summerboot.jexpress.nio.server.NioCounter;
import org.summerboot.jexpress.nio.server.NioHttpUtil;
import org.summerboot.jexpress.nio.server.NioServer;
import org.summerboot.jexpress.nio.server.RequestProcessor;
import org.summerboot.jexpress.nio.server.SessionContext;
import org.summerboot.jexpress.nio.server.domain.Err;
import org.summerboot.jexpress.nio.server.domain.ProcessorSettings;
import org.summerboot.jexpress.nio.server.domain.ServiceError;
import org.summerboot.jexpress.nio.server.ws.rs.JaxRsRequestProcessorManager;
import org.summerboot.jexpress.security.SecurityUtil;
import org.summerboot.jexpress.util.FormatterUtil;
import org.summerboot.jexpress.util.GeoIpUtil;

@ChannelHandler.Sharable
public abstract class NioServerHttpRequestHandler
extends SimpleChannelInboundHandler<FullHttpRequest>
implements ErrorAuditor {
    protected Logger log = LogManager.getLogger(this.getClass());
    protected ZoneId zoneId = ZoneId.systemDefault();
    protected static NioConfig nioCfg = NioConfig.cfg;
    protected static String protectedContectReplaceWith = "***";
    protected final String me = ", hdl=" + this.toString();

    public NioServerHttpRequestHandler() {
        super(FullHttpRequest.class, false);
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        this.log.trace(() -> String.valueOf(evt) + " - " + this.info(ctx));
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        long tc = NioCounter.COUNTER_ACTIVE_CHANNEL.incrementAndGet();
        this.log.trace(() -> tc + " - " + this.info(ctx));
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        NioCounter.COUNTER_ACTIVE_CHANNEL.decrementAndGet();
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable ex) {
        if (ex instanceof DecoderException) {
            this.log.warn(String.valueOf(ctx.channel().remoteAddress()) + ": " + String.valueOf(ex));
        } else {
            this.log.warn(String.valueOf(ctx.channel().remoteAddress()) + ": " + String.valueOf(ex), ex);
        }
        if (ex instanceof OutOfMemoryError) {
            ctx.close();
        }
    }

    public void channelReadComplete(ChannelHandlerContext ctx) {
        this.log.trace(() -> this.info(ctx));
        ctx.flush();
    }

    public void channelRead0(ChannelHandlerContext ctx, FullHttpRequest req) {
        long start = System.currentTimeMillis();
        NioCounter.COUNTER_HIT.incrementAndGet();
        long hitIndex = NioCounter.COUNTER_BIZ_HIT.incrementAndGet();
        String txId = BootConstant.APP_ID + "-" + hitIndex;
        boolean isDecoderSuccess = req.decoderResult().isSuccess();
        String protocol = req.protocolVersion().toString();
        long requestDataBytes = req.content().capacity();
        HttpMethod httpMethod = req.method();
        String httpRequestUriRaw = req.uri();
        String httpRequestUriRawDecoded = URLDecoder.decode(httpRequestUriRaw, StandardCharsets.UTF_8);
        boolean isKeepAlive = HttpUtil.isKeepAlive((HttpMessage)req);
        HttpHeaders requestHeaders = req.headers();
        String httpPostRequestBody = HttpMethod.GET.equals((Object)httpMethod) || HttpMethod.HEAD.equals((Object)httpMethod) ? null : NioHttpUtil.getHttpPostBodyString(req);
        ReferenceCountUtil.release((Object)req);
        QueryStringDecoder queryStringDecoder = new QueryStringDecoder(httpRequestUriRaw, StandardCharsets.UTF_8, true);
        String httpRequestUri = queryStringDecoder.path();
        String requestMetaInfo = this.requestMetaInfo(ctx, txId, protocol, httpMethod, httpRequestUriRaw, httpRequestUriRawDecoded, isKeepAlive, requestDataBytes);
        this.log.debug(() -> requestMetaInfo);
        SessionContext context = SessionContext.build(ctx, txId, hitIndex, start, requestHeaders, protocol, httpMethod, httpRequestUriRawDecoded, httpPostRequestBody).responseHeaders(nioCfg.getServerDefaultResponseHeaders()).clientAcceptContentType(requestHeaders.get((CharSequence)HttpHeaderNames.ACCEPT));
        Runnable asyncTask = () -> {
            block36: {
                long queuingTime = System.currentTimeMillis() - start;
                NioServer.IDLE_EVENT_MONITOR.update(txId);
                String acceptCharset = requestHeaders.get((CharSequence)HttpHeaderNames.ACCEPT_CHARSET);
                if (StringUtils.isNotBlank((CharSequence)acceptCharset)) {
                    context.charsetName(acceptCharset);
                }
                long responseDataBytes = -1L;
                Throwable ioEx = null;
                long processTime = -1L;
                ProcessorSettings processorSettings = null;
                if (isDecoderSuccess) {
                    String error2 = GeoIpUtil.callerAddressFilter(context.remoteIP(), nioCfg.getCallerAddressFilterWhitelist(), nioCfg.getCallerAddressFilterBlacklist(), nioCfg.getCallerAddressFilterRegexPrefix(), nioCfg.getCallerAddressFilterOption());
                    if (error2 == null) {
                        processorSettings = this.service(ctx, requestHeaders, httpMethod, httpRequestUri, queryStringDecoder.parameters(), httpPostRequestBody, context);
                    } else {
                        err = new Err(BootErrorCode.AUTH_INVALID_IP, null, "Invalid caller IP", null, (Object)("Invalid IP address: " + error2));
                        context.error(err).status(HttpResponseStatus.NOT_ACCEPTABLE);
                    }
                } else {
                    Throwable cause = req.decoderResult().cause();
                    err = new Err(BootErrorCode.NIO_REQUEST_BAD_ENCODING, null, cause == null ? "" : cause.getMessage(), null, (Object)cause.toString());
                    context.error(err).status(HttpResponseStatus.BAD_REQUEST);
                }
                processTime = System.currentTimeMillis() - start;
                responseDataBytes = NioHttpUtil.sendResponse(ctx, isKeepAlive, context, this, processorSettings);
                context.poi("service.end");
                NioCounter.COUNTER_SENT.incrementAndGet();
                long responseTime = System.currentTimeMillis() - start;
                this.afterService(requestHeaders, httpMethod, httpRequestUri, queryStringDecoder.parameters(), httpPostRequestBody, context);
                String report = null;
                try {
                    boolean overtime = responseTime > nioCfg.getBizTimeoutWarnThresholdMs();
                    HttpResponseStatus status = context.status();
                    Level level = context.level();
                    if ((overtime || status.code() >= 400) && level.isLessSpecificThan(Level.WARN)) {
                        level = Level.WARN;
                    }
                    if (this.log.isEnabled(level)) {
                        List<String> protectedDataFields;
                        ProcessorSettings.LogSettings logSettings;
                        boolean isTraceAll = BootConstant.isDebugMode();
                        if (!isTraceAll && requestHeaders.contains((CharSequence)HttpHeaderNames.AUTHORIZATION)) {
                            requestHeaders.set((CharSequence)HttpHeaderNames.AUTHORIZATION, (Object)"***");
                        }
                        StringBuilder sb = new StringBuilder();
                        context.reportOverall(queuingTime, processTime, responseTime, sb);
                        context.reportPOI(nioCfg, sb);
                        String sanitizedUserInput = SecurityUtil.sanitizeCRLF(httpPostRequestBody);
                        NioServerHttpRequestHandler.verboseClientServerCommunication(nioCfg, requestHeaders, requestDataBytes, sanitizedUserInput, responseDataBytes, context, sb, isTraceAll);
                        context.reportMemo(sb);
                        context.reportError(sb);
                        sb.append(BootConstant.BR);
                        report = sb.toString();
                        if (!isTraceAll && processorSettings != null && (logSettings = processorSettings.getLogSettings()) != null && (protectedDataFields = logSettings.getProtectDataFieldsFromLogging()) != null) {
                            for (String protectedDataField : protectedDataFields) {
                                report = FormatterUtil.replaceDataField(report, protectedDataField, protectedContectReplaceWith);
                            }
                        }
                        report = this.beforeLogging(report, requestHeaders, httpMethod, httpRequestUriRawDecoded, httpPostRequestBody, context, queuingTime, processTime, responseTime, responseDataBytes, ioEx);
                        this.log.log(level, "{}", (Object)report);
                    }
                }
                catch (Throwable ex) {
                    this.log.fatal("logging failed \n{}", report, (Object)ex);
                }
                try {
                    this.afterLogging(report, requestHeaders, httpMethod, httpRequestUriRawDecoded, httpPostRequestBody, context, queuingTime, processTime, responseTime, responseDataBytes, ioEx);
                }
                catch (Throwable ex) {
                    this.log.error("afterLogging failed", ex);
                }
                break block36;
                catch (Throwable ex) {
                    ioEx = ex;
                    Err e = new Err(BootErrorCode.NIO_UNEXPECTED_SERVICE_FAILURE, null, "Failed to send context to client", ex);
                    context.error(e).status(HttpResponseStatus.INTERNAL_SERVER_ERROR).level(Level.FATAL);
                    responseDataBytes = NioHttpUtil.sendResponse(ctx, isKeepAlive, context, this, processorSettings);
                    NioCounter.COUNTER_SENT.incrementAndGet();
                    responseTime = System.currentTimeMillis() - start;
                    this.afterService(requestHeaders, httpMethod, httpRequestUri, queryStringDecoder.parameters(), httpPostRequestBody, context);
                    report = null;
                    try {
                        boolean overtime = responseTime > nioCfg.getBizTimeoutWarnThresholdMs();
                        HttpResponseStatus status = context.status();
                        Level level = context.level();
                        if ((overtime || status.code() >= 400) && level.isLessSpecificThan(Level.WARN)) {
                            level = Level.WARN;
                        }
                        if (this.log.isEnabled(level)) {
                            List<String> protectedDataFields;
                            ProcessorSettings.LogSettings logSettings;
                            boolean isTraceAll = BootConstant.isDebugMode();
                            if (!isTraceAll && requestHeaders.contains((CharSequence)HttpHeaderNames.AUTHORIZATION)) {
                                requestHeaders.set((CharSequence)HttpHeaderNames.AUTHORIZATION, (Object)"***");
                            }
                            StringBuilder sb = new StringBuilder();
                            context.reportOverall(queuingTime, processTime, responseTime, sb);
                            context.reportPOI(nioCfg, sb);
                            String sanitizedUserInput = SecurityUtil.sanitizeCRLF(httpPostRequestBody);
                            NioServerHttpRequestHandler.verboseClientServerCommunication(nioCfg, requestHeaders, requestDataBytes, sanitizedUserInput, responseDataBytes, context, sb, isTraceAll);
                            context.reportMemo(sb);
                            context.reportError(sb);
                            sb.append(BootConstant.BR);
                            report = sb.toString();
                            if (!isTraceAll && processorSettings != null && (logSettings = processorSettings.getLogSettings()) != null && (protectedDataFields = logSettings.getProtectDataFieldsFromLogging()) != null) {
                                for (String protectedDataField : protectedDataFields) {
                                    report = FormatterUtil.replaceDataField(report, protectedDataField, protectedContectReplaceWith);
                                }
                            }
                            report = this.beforeLogging(report, requestHeaders, httpMethod, httpRequestUriRawDecoded, httpPostRequestBody, context, queuingTime, processTime, responseTime, responseDataBytes, ioEx);
                            this.log.log(level, "{}", (Object)report);
                        }
                    }
                    catch (Throwable ex2) {
                        this.log.fatal("logging failed \n{}", report, (Object)ex2);
                    }
                    try {
                        this.afterLogging(report, requestHeaders, httpMethod, httpRequestUriRawDecoded, httpPostRequestBody, context, queuingTime, processTime, responseTime, responseDataBytes, ioEx);
                    }
                    catch (Throwable ex3) {
                        this.log.error("afterLogging failed", ex3);
                    }
                    catch (Throwable throwable) {
                        NioCounter.COUNTER_SENT.incrementAndGet();
                        long responseTime2 = System.currentTimeMillis() - start;
                        this.afterService(requestHeaders, httpMethod, httpRequestUri, queryStringDecoder.parameters(), httpPostRequestBody, context);
                        String report2 = null;
                        try {
                            boolean overtime = responseTime2 > nioCfg.getBizTimeoutWarnThresholdMs();
                            HttpResponseStatus status = context.status();
                            Level level = context.level();
                            if ((overtime || status.code() >= 400) && level.isLessSpecificThan(Level.WARN)) {
                                level = Level.WARN;
                            }
                            if (this.log.isEnabled(level)) {
                                List<String> protectedDataFields;
                                ProcessorSettings.LogSettings logSettings;
                                boolean isTraceAll = BootConstant.isDebugMode();
                                if (!isTraceAll && requestHeaders.contains((CharSequence)HttpHeaderNames.AUTHORIZATION)) {
                                    requestHeaders.set((CharSequence)HttpHeaderNames.AUTHORIZATION, (Object)"***");
                                }
                                StringBuilder sb = new StringBuilder();
                                context.reportOverall(queuingTime, processTime, responseTime2, sb);
                                context.reportPOI(nioCfg, sb);
                                String sanitizedUserInput = SecurityUtil.sanitizeCRLF(httpPostRequestBody);
                                NioServerHttpRequestHandler.verboseClientServerCommunication(nioCfg, requestHeaders, requestDataBytes, sanitizedUserInput, responseDataBytes, context, sb, isTraceAll);
                                context.reportMemo(sb);
                                context.reportError(sb);
                                sb.append(BootConstant.BR);
                                report2 = sb.toString();
                                if (!isTraceAll && processorSettings != null && (logSettings = processorSettings.getLogSettings()) != null && (protectedDataFields = logSettings.getProtectDataFieldsFromLogging()) != null) {
                                    for (String protectedDataField : protectedDataFields) {
                                        report2 = FormatterUtil.replaceDataField(report2, protectedDataField, protectedContectReplaceWith);
                                    }
                                }
                                report2 = this.beforeLogging(report2, requestHeaders, httpMethod, httpRequestUriRawDecoded, httpPostRequestBody, context, queuingTime, processTime, responseTime2, responseDataBytes, ioEx);
                                this.log.log(level, "{}", (Object)report2);
                            }
                        }
                        catch (Throwable ex4) {
                            this.log.fatal("logging failed \n{}", report2, (Object)ex4);
                        }
                        try {
                            this.afterLogging(report2, requestHeaders, httpMethod, httpRequestUriRawDecoded, httpPostRequestBody, context, queuingTime, processTime, responseTime2, responseDataBytes, ioEx);
                        }
                        catch (Throwable ex5) {
                            this.log.error("afterLogging failed", ex5);
                        }
                        throw throwable;
                    }
                }
            }
        };
        try {
            nioCfg.getBizExecutor().execute(asyncTask);
        }
        catch (RejectedExecutionException ex) {
            long queuingTime = System.currentTimeMillis() - start;
            Err e = new Err(BootErrorCode.NIO_TOO_MANY_REQUESTS, null, "Too many request, try again later", (Throwable)ex);
            context.error(e).status(HttpResponseStatus.TOO_MANY_REQUESTS).level(Level.FATAL);
            long responseDataBytes = NioHttpUtil.sendResponse(ctx, isKeepAlive, context, this, null);
            StringBuilder sb = new StringBuilder();
            sb.append("request_").append(txId).append("=").append(ex.toString()).append("ms\n\t").append(requestMetaInfo).append("\n\tresponse#").append(txId).append("=").append(context.status()).append(", errorCode=").append(e.getErrorCode()).append(", queuing=").append(queuingTime).append("ms, cont.len=").append(responseDataBytes).append("\n\t1req.headers=").append(requestHeaders).append("\n\t4resp.body=").append(context.txt());
            this.log.fatal(sb.toString());
        }
        catch (Throwable ex) {
            long queuingTime = System.currentTimeMillis() - start;
            Err e = new Err(BootErrorCode.NIO_UNEXPECTED_EXECUTOR_FAILURE, null, "NIO unexpected executor failure", ex);
            context.error(e).status(HttpResponseStatus.INTERNAL_SERVER_ERROR).level(Level.FATAL);
            long responseDataBytes = NioHttpUtil.sendResponse(ctx, isKeepAlive, context, this, null);
            StringBuilder sb = new StringBuilder();
            sb.append("request_").append(txId).append("=").append(ex.toString()).append("ms\n\t").append(requestMetaInfo).append("\n\tresponse#").append(txId).append("=").append(context.status()).append(", errorCode=").append(e.getErrorCode()).append(", queuing=").append(queuingTime).append("ms, cont.len=").append(responseDataBytes).append("\n\t1req.headers=").append(requestHeaders).append("\n\t4resp.body=").append(context.txt());
            this.log.fatal(sb.toString());
        }
    }

    protected String info(ChannelHandlerContext ctx) {
        return ", chn=" + ctx.channel() + ", ctx=" + ctx.hashCode() + this.me;
    }

    protected String requestMetaInfo(ChannelHandlerContext ctx, String hitIndex, String protol, HttpMethod httpMethod, String httpRequestUriRaw, String httpRequestUriDecoded, boolean isKeepAlive, long requestDataBytes) {
        StringBuilder sb = new StringBuilder().append(protol).append("_request_").append(hitIndex).append("=").append(httpMethod).append(" ").append(httpRequestUriDecoded).append(", requestDataBytes=").append(requestDataBytes).append(", KeepAlive=").append(isKeepAlive).append(", chn=").append(ctx.channel()).append(", ctx=").append(ctx.hashCode()).append(this.me);
        if (!httpRequestUriRaw.equals(httpRequestUriDecoded)) {
            sb.append(BootConstant.BR).append("\trawURI=").append(httpRequestUriRaw).append(BootConstant.BR);
        }
        return sb.toString();
    }

    public static void verboseClientServerCommunication(NioConfig cfg, HttpHeaders requestHeaders, long requestDataBytes, String httpPostRequestBody, long responseDataBytes, SessionContext context, StringBuilder sb, boolean isTraceAll) {
        Set<Long> s;
        boolean isInFilter = false;
        Object caller = context.caller();
        NioConfig.VerboseTargetUserType verboseTargetUserType = cfg == null ? NioConfig.VerboseTargetUserType.ignore : cfg.getFilterUserType();
        switch (verboseTargetUserType) {
            case ignore: {
                isInFilter = true;
                break;
            }
            case uid: {
                if (!StringUtils.isNotBlank((CharSequence)context.callerId())) break;
                isInFilter = cfg.getFilterCallerNameSet().contains(context.callerId());
                break;
            }
            case id: {
                if (caller == null || caller.getId() == null) break;
                Long target2 = caller.getId().longValue();
                s = cfg.getFilterCallerIdSet();
                if (s == null) {
                    isInFilter = target2 >= cfg.getFilterCallerIdFrom() && target2 <= cfg.getFilterCallerIdTo();
                    break;
                }
                isInFilter = s.contains(target2);
                break;
            }
            case group: {
                if (caller == null) break;
                isInFilter = cfg.getFilterCallerNameSet().stream().anyMatch(target -> caller.isInGroup((String)target));
                break;
            }
            case role: {
                if (caller == null) break;
                isInFilter = cfg.getFilterCallerNameSet().stream().anyMatch(target -> caller.isInRole((String)target));
            }
        }
        if (!isInFilter) {
            return;
        }
        isInFilter = false;
        NioConfig.VerboseTargetCodeType verboseTargetCodeType = cfg == null ? NioConfig.VerboseTargetCodeType.all : cfg.getFilterCodeType();
        s = cfg == null ? null : cfg.getFilterCodeSet();
        block8 : switch (verboseTargetCodeType) {
            case all: {
                isInFilter = true;
                break;
            }
            case ignore: {
                isInFilter = false;
                break;
            }
            case HttpStatusCode: {
                long target3 = context.status().code();
                if (s == null) {
                    isInFilter = target3 >= cfg.getFilterCodeRangeFrom() && target3 <= cfg.getFilterCodeRangeTo();
                    break;
                }
                isInFilter = s.contains(target3);
                break;
            }
            case ApplicationErrorCode: {
                long target3;
                ServiceError e = context.error();
                if (e == null) break;
                for (Err j : e.getErrors()) {
                    String errorCode = j.getErrorCode();
                    try {
                        target3 = Integer.parseInt(errorCode);
                        isInFilter = s == null ? target3 >= cfg.getFilterCodeRangeFrom() && target3 <= cfg.getFilterCodeRangeTo() : s.contains(target3);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    if (!isInFilter) continue;
                    break block8;
                }
                break;
            }
        }
        if (!isInFilter) {
            return;
        }
        boolean isVerbose = cfg == null ? true : cfg.isVerboseReqHeader();
        sb.append("\n\t1.client_req.headers=").append(isTraceAll || context.logRequestHeader() && isVerbose ? requestHeaders : "***");
        isVerbose = cfg == null ? true : cfg.isVerboseReqContent();
        sb.append("\n\t2.client_req.body(").append(requestDataBytes).append(" bytes)=").append(isTraceAll || context.logRequestBody() && isVerbose ? httpPostRequestBody : "***");
        isVerbose = cfg == null ? true : cfg.isVerboseRespHeader();
        sb.append("\n\t3.server_resp.headers=").append(isTraceAll || context.logResponseHeader() && isVerbose ? context.responseHeaders() : "***");
        isVerbose = cfg == null ? true : cfg.isVerboseRespContent();
        sb.append("\n\t4.server_resp.body(").append(responseDataBytes).append(" bytes)=").append(isTraceAll || context.logResponseBody() && isVerbose ? context.txt() : "***");
    }

    protected abstract ProcessorSettings service(ChannelHandlerContext var1, HttpHeaders var2, HttpMethod var3, String var4, Map<String, List<String>> var5, String var6, SessionContext var7);

    protected abstract void afterService(HttpHeaders var1, HttpMethod var2, String var3, Map<String, List<String>> var4, String var5, SessionContext var6);

    protected abstract String beforeLogging(String var1, HttpHeaders var2, HttpMethod var3, String var4, String var5, SessionContext var6, long var7, long var9, long var11, long var13, Throwable var15) throws Exception;

    protected abstract void afterLogging(String var1, HttpHeaders var2, HttpMethod var3, String var4, String var5, SessionContext var6, long var7, long var9, long var11, long var13, Throwable var15) throws Exception;

    protected RequestProcessor getRequestProcessor(HttpMethod httptMethod, String httpRequestPath) {
        return JaxRsRequestProcessorManager.getRequestProcessor(httptMethod, httpRequestPath);
    }
}

