/*
 * Decompiled with CFR 0.152.
 */
package org.summerboot.jexpress.nio.server.domain;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.summerboot.jexpress.nio.server.domain.Err;
import org.summerboot.jexpress.util.BeanUtil;

@JsonFilter(value="ServiceErrorFilter")
public class ServiceError {
    @Schema(requiredMode=Schema.RequiredMode.REQUIRED, description="The index of requests received by current server since start")
    protected final String ref;
    @JsonIgnore
    protected Object attachedData;
    @Schema(requiredMode=Schema.RequiredMode.NOT_REQUIRED, description="The optional error list")
    protected List<Err> errors;

    public ServiceError() {
        this.ref = null;
    }

    public ServiceError(String ref) {
        this.ref = ref;
    }

    public String toString() {
        return "ServiceError{ref=" + this.ref + ", attachedData=" + String.valueOf(this.attachedData) + ", errors=" + String.valueOf(this.errors) + "}";
    }

    public String toJson() {
        try {
            return BeanUtil.toJson(this, true, true);
        }
        catch (JsonProcessingException ex) {
            return this.toString();
        }
    }

    public String toXML() {
        try {
            return BeanUtil.toXML(this);
        }
        catch (JsonProcessingException ex) {
            return this.toString();
        }
    }

    public String getRef() {
        return this.ref;
    }

    public Object getAttachedData() {
        return this.attachedData;
    }

    public void setAttachedData(Object attachedData) {
        this.attachedData = attachedData;
    }

    public List<Err> getErrors() {
        return this.errors;
    }

    public ServiceError setErrors(List<Err> errors) {
        this.errors = errors;
        return this;
    }

    public ServiceError addErrors(Err ... error2) {
        if (this.errors == null) {
            this.errors = new ArrayList<Err>();
        }
        this.errors.addAll(Arrays.asList(error2));
        return this;
    }

    public ServiceError addErrors(Collection<Err> es) {
        if (es == null || es.isEmpty()) {
            return this;
        }
        if (this.errors == null) {
            this.errors = new ArrayList<Err>();
        }
        this.errors.addAll(es);
        return this;
    }

    @JsonIgnore
    public ServiceError addError(Err error2) {
        if (error2 == null) {
            return this;
        }
        if (this.errors == null) {
            this.errors = new ArrayList<Err>();
        }
        this.errors.add(error2);
        return this;
    }

    public ServiceError addError(int errorCode, String errorTag, String errorDesc, Throwable ex) {
        return this.addError(errorCode, errorTag, errorDesc, ex, null);
    }

    public ServiceError addError(int errorCode, String errorTag, String errorDesc, Throwable ex, String internalInfo) {
        if (this.errors == null) {
            this.errors = new ArrayList<Err>();
        }
        this.errors.add(new Err(errorCode, errorTag, errorDesc, ex, (Object)internalInfo));
        return this;
    }
}

