/*
 * Decompiled with CFR 0.152.
 */
package org.summerboot.jexpress.nio.server.domain;

import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.summerboot.jexpress.nio.server.SessionContext;
import org.summerboot.jexpress.nio.server.domain.Err;
import org.summerboot.jexpress.util.FormatterUtil;

public class ServiceRequest {
    protected final ChannelHandlerContext channelHandlerCtx;
    protected final HttpHeaders httpHeaders;
    protected final String httpRequestPath;
    protected final Map<String, List<String>> queryParams;
    protected final String httpPostRequestBody;
    protected Map<String, String> pathParams;
    protected Map<String, String> matrixParams;
    protected Map<String, String> formParams = null;

    public ServiceRequest(ChannelHandlerContext channelHandlerCtx, HttpHeaders httpHeaders, String httpRequestPath, Map<String, List<String>> queryParams, String httpPostRequestBody) {
        this.channelHandlerCtx = channelHandlerCtx;
        this.httpHeaders = httpHeaders;
        this.httpRequestPath = httpRequestPath;
        this.queryParams = queryParams;
        this.httpPostRequestBody = httpPostRequestBody;
    }

    public ChannelHandlerContext getChannelHandlerCtx() {
        return this.channelHandlerCtx;
    }

    public HttpHeaders getHttpHeaders() {
        return this.httpHeaders;
    }

    public String getHttpRequestPath() {
        return this.httpRequestPath;
    }

    public String getHttpPostRequestBody() {
        return this.httpPostRequestBody;
    }

    public void addPathParam(String pathParamName, String value) {
        if (this.pathParams == null) {
            this.pathParams = new HashMap<String, String>();
        }
        this.pathParams.put(pathParamName, value);
    }

    public String getPathParam(String key) {
        if (this.pathParams == null) {
            return null;
        }
        return this.pathParams.get(key);
    }

    public void addMatrixParam(String matrixParamName, String value) {
        if (this.matrixParams == null) {
            this.matrixParams = new HashMap<String, String>();
        }
        this.matrixParams.put(matrixParamName, value);
    }

    public String getMatrixParam(String key) {
        if (this.matrixParams == null) {
            return null;
        }
        return this.matrixParams.get(key);
    }

    public String getHeaderParam(String key) {
        if (this.httpHeaders == null) {
            return null;
        }
        return this.httpHeaders.get(key);
    }

    public Map<String, List<String>> getQueryParams() {
        return this.queryParams;
    }

    public String getQueryParam(String key) {
        return this.getParam(this.queryParams, key, null, 0);
    }

    public String getQueryParam(String key, SessionContext context, int errorCode) {
        return this.getParam(this.queryParams, key, context, errorCode);
    }

    public String getFormParam(String key) {
        if (this.formParams == null) {
            this.formParams = new LinkedHashMap<String, String>();
            FormatterUtil.parseFormParam(this.httpPostRequestBody, this.formParams);
        }
        return this.formParams.get(key);
    }

    protected String getParam(Map<String, List<String>> pms, String key, SessionContext context, int errorCode) {
        List<String> vs;
        String value = null;
        if (pms != null && !pms.isEmpty() && (vs = pms.get(key)) != null && !vs.isEmpty()) {
            value = vs.get(0);
            String string = value = StringUtils.isBlank((CharSequence)value) ? null : value;
        }
        if (value == null && context != null) {
            Err e = new Err(errorCode, null, null, null, (Object)(key + " is required"));
            context.status(HttpResponseStatus.BAD_REQUEST).error(e);
        }
        return value;
    }
}

