/*
 * Decompiled with CFR 0.152.
 */
package org.summerboot.jexpress.security.auth;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import io.grpc.Context;
import io.grpc.Grpc;
import io.grpc.Metadata;
import io.grpc.ServerCall;
import io.grpc.ServerCallHandler;
import io.grpc.ServerInterceptor;
import io.grpc.Status;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.ExpiredJwtException;
import io.jsonwebtoken.JwtBuilder;
import io.jsonwebtoken.JwtException;
import io.jsonwebtoken.JwtParser;
import io.jsonwebtoken.Jwts;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.net.SocketAddress;
import java.security.Key;
import java.time.Duration;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import javax.naming.NamingException;
import org.apache.commons.lang3.StringUtils;
import org.summerboot.jexpress.boot.BackOffice;
import org.summerboot.jexpress.boot.BootConstant;
import org.summerboot.jexpress.boot.BootErrorCode;
import org.summerboot.jexpress.integration.cache.AuthTokenCache;
import org.summerboot.jexpress.nio.grpc.BearerAuthCredential;
import org.summerboot.jexpress.nio.grpc.ContextualizedServerCallListenerEx;
import org.summerboot.jexpress.nio.grpc.GRPCServerConfig;
import org.summerboot.jexpress.nio.server.RequestProcessor;
import org.summerboot.jexpress.nio.server.SessionContext;
import org.summerboot.jexpress.nio.server.domain.Err;
import org.summerboot.jexpress.security.JwtUtil;
import org.summerboot.jexpress.security.auth.AuthConfig;
import org.summerboot.jexpress.security.auth.Authenticator;
import org.summerboot.jexpress.security.auth.AuthenticatorListener;
import org.summerboot.jexpress.security.auth.Caller;
import org.summerboot.jexpress.security.auth.User;
import org.summerboot.jexpress.util.FormatterUtil;
import org.summerboot.jexpress.util.GeoIpUtil;

@Singleton
public abstract class BootAuthenticator<E>
implements Authenticator<E>,
ServerInterceptor {
    protected static final String ERROR_NO_CFG = "JWT is not configured at " + BackOffice.agent.getAuthConfigFileName();
    @Inject(optional=true)
    protected AuthenticatorListener authenticatorListener;
    @Inject
    protected AuthTokenCache authTokenCache;
    private static final String KEY_TENANTNAME = "tenantName";
    protected static final String ERROR = "Bearer Authorization Failed: ";

    @Override
    public String signJWT(String username, String pwd, E metaData, int validForMinutes, SessionContext context) throws NamingException {
        context.poi("ldap.begin");
        Caller caller = this.authenticate(username, pwd, metaData, this.authenticatorListener, context);
        context.poi("ldap.end");
        context.caller(caller);
        return this.signJWT(caller, validForMinutes, context);
    }

    @Override
    public String signJWT(Caller caller, int validForMinutes, SessionContext context) {
        if (caller == null) {
            context.status(HttpResponseStatus.UNAUTHORIZED);
            return null;
        }
        JwtBuilder builder = this.toJwt(caller, context.txId());
        Key signingKey = AuthConfig.cfg.getJwtSigningKey();
        if (signingKey == null) {
            throw new UnsupportedOperationException(ERROR_NO_CFG);
        }
        Duration tokenTTL = Duration.ofMinutes(validForMinutes);
        String token = JwtUtil.createJWT(signingKey, builder, tokenTTL);
        if (this.authenticatorListener != null) {
            this.authenticatorListener.onLoginSuccess(caller.getUid(), token);
        }
        return token;
    }

    protected abstract Caller authenticate(String var1, String var2, E var3, AuthenticatorListener var4, SessionContext var5) throws NamingException;

    @Override
    public JwtBuilder toJwt(Caller caller, String txId) {
        Long tokenTtlSec;
        Set<Map.Entry<String, Object>> callerCustomizedFields;
        String jti = String.valueOf(caller.getTenantId()) + "-" + String.valueOf(caller.getId()) + "@" + txId;
        String issuer = AuthConfig.cfg.getJwtIssuer();
        String userName = caller.getUid();
        Set<String> groups = caller.getGroups();
        JwtBuilder builder = Jwts.builder();
        builder.id(jti).issuer(issuer).subject(userName).audience().add(groups);
        if (StringUtils.isNotBlank((CharSequence)caller.getTenantName())) {
            builder.claim(KEY_TENANTNAME, (Object)caller.getTenantName());
        }
        if ((callerCustomizedFields = caller.customizedFields()) != null) {
            for (Map.Entry<String, Object> entry : callerCustomizedFields) {
                if (StringUtils.isBlank((CharSequence)entry.getKey()) || entry.getValue() == null) continue;
                builder.claim(entry.getKey(), entry.getValue());
            }
        }
        if ((tokenTtlSec = caller.getTokenTtlSec()) != null) {
            Duration tokenTTL = Duration.ofSeconds(tokenTtlSec);
            JwtUtil.setJwtExpireTime(builder, tokenTTL);
        }
        return builder;
    }

    protected Claims parseJWT(String jwt) {
        JwtParser jwtParser = AuthConfig.cfg.getJwtParser();
        if (jwtParser == null) {
            throw new UnsupportedOperationException(ERROR_NO_CFG);
        }
        return (Claims)JwtUtil.parseJWT(jwtParser, jwt).getPayload();
    }

    protected Caller fromJwt(Claims claims) {
        Set keys;
        String userName = claims.getSubject();
        Set audience = claims.getAudience();
        String jti = claims.getId();
        Long tenantId = 0L;
        Long userId = 0L;
        try {
            String[] arr0 = FormatterUtil.parseDsv(jti, "-");
            if (arr0 != null && arr0.length > 1) {
                tenantId = Long.parseLong(arr0[0]);
                String[] arr1 = FormatterUtil.parseDsv(arr0[1], "@");
                userId = Long.parseLong(arr1[0]);
            }
        }
        catch (Exception arr0) {
            // empty catch block
        }
        String tenantName = (String)claims.get(KEY_TENANTNAME, String.class);
        User caller = new User(jti, tenantId, tenantName, userId, userName);
        if (audience != null) {
            for (String group : audience) {
                String[] arr;
                caller.addGroup(group);
                if (!BootConstant.CFG_JWT_AUD_AS_CSV || audience.size() != 1 || (arr = FormatterUtil.parseCsv(group)) == null) continue;
                for (String g : arr) {
                    if (!StringUtils.isNotBlank((CharSequence)g)) continue;
                    caller.addGroup(g);
                }
            }
        }
        if ((keys = claims.keySet()) != null) {
            for (String key : keys) {
                Object v = claims.get((Object)key);
                caller.setCustomizedField(key, v);
            }
        }
        caller.removeCustomizedField("aud");
        caller.removeCustomizedField("exp");
        caller.removeCustomizedField("jti");
        caller.removeCustomizedField("iat");
        caller.removeCustomizedField("iss");
        caller.removeCustomizedField("nbf");
        caller.removeCustomizedField("sub");
        caller.removeCustomizedField(KEY_TENANTNAME);
        return caller;
    }

    public static String getBearerToken(HttpHeaders httpRequestHeaders) {
        String authHeaderValue = httpRequestHeaders.get((CharSequence)HttpHeaderNames.AUTHORIZATION);
        return BootAuthenticator.getBearerToken(authHeaderValue);
    }

    public static boolean hasBearerToken(HttpHeaders httpRequestHeaders) {
        return StringUtils.isNotBlank((CharSequence)BootAuthenticator.getBearerToken(httpRequestHeaders));
    }

    public static String getBearerToken(String authHeaderValue) {
        if (StringUtils.isBlank((CharSequence)authHeaderValue) || !authHeaderValue.startsWith("Bearer ")) {
            return null;
        }
        String[] a = authHeaderValue.split(" ");
        if (a.length < 2) {
            return null;
        }
        authHeaderValue = a[1];
        if (StringUtils.isBlank((CharSequence)authHeaderValue)) {
            return null;
        }
        return authHeaderValue;
    }

    @Override
    public Caller verifyToken(HttpHeaders httpRequestHeaders, AuthTokenCache cache, Integer errorCode, SessionContext context) {
        String authToken = BootAuthenticator.getBearerToken(httpRequestHeaders);
        return this.verifyToken(authToken, cache, errorCode, context);
    }

    @Override
    public Caller verifyToken(String authToken, AuthTokenCache cache, Integer errorCode, SessionContext context) {
        errorCode = errorCode == null ? this.overrideVerifyTokenErrorCode() : errorCode;
        Caller caller = null;
        if (authToken == null) {
            Err e = new Err(errorCode != null ? errorCode : BootErrorCode.AUTH_REQUIRE_TOKEN, null, "AuthToken is required", null);
            context.error(e).status(HttpResponseStatus.UNAUTHORIZED);
        } else {
            try {
                Claims claims = this.parseJWT(authToken);
                String jti = claims.getId();
                context.callerId(jti);
                if (cache == null) {
                    cache = this.authTokenCache;
                }
                if (cache != null && cache.isBlacklist(jti)) {
                    Err e = new Err(errorCode != null ? errorCode : BootErrorCode.AUTH_EXPIRED_TOKEN, null, "AuthToken has been logout", null, (Object)("AuthToken has been logout: " + jti));
                    context.error(e).status(HttpResponseStatus.UNAUTHORIZED);
                } else {
                    caller = this.fromJwt(claims);
                }
            }
            catch (ExpiredJwtException ex) {
                Err e = new Err(errorCode != null ? errorCode : BootErrorCode.AUTH_EXPIRED_TOKEN, null, "Expired AuthToken", null, (Object)("Expired AuthToken: " + String.valueOf((Object)ex)));
                context.error(e).status(HttpResponseStatus.UNAUTHORIZED);
            }
            catch (JwtException ex) {
                Err e = new Err(errorCode != null ? errorCode : BootErrorCode.AUTH_INVALID_TOKEN, null, "Invalid AuthToken", null, (Object)("Invalid AuthToken: " + String.valueOf((Object)ex)));
                context.error(e).status(HttpResponseStatus.UNAUTHORIZED);
            }
        }
        context.caller(caller);
        return caller;
    }

    @Override
    public boolean customizedAuthorizationCheck(RequestProcessor processor, HttpHeaders httpRequestHeaders, String httpRequestPath, SessionContext context) throws Exception {
        return true;
    }

    protected Integer overrideVerifyTokenErrorCode() {
        return null;
    }

    @Override
    public void logoutToken(HttpHeaders httpRequestHeaders, AuthTokenCache cache, SessionContext context) {
        String authToken = BootAuthenticator.getBearerToken(httpRequestHeaders);
        this.logoutToken(authToken, cache, context);
    }

    @Override
    public void logoutToken(String authToken, AuthTokenCache cache, SessionContext context) {
        try {
            Claims claims = this.parseJWT(authToken);
            String jti = claims.getId();
            String uid = claims.getSubject();
            Date exp = claims.getExpiration();
            long expireInMilliseconds = exp.getTime() - System.currentTimeMillis();
            if (cache == null) {
                cache = this.authTokenCache;
            }
            if (cache != null) {
                cache.blacklist(jti, authToken, expireInMilliseconds);
            }
            if (this.authenticatorListener != null) {
                this.authenticatorListener.onLogout(claims, authToken, expireInMilliseconds);
            }
        }
        catch (ExpiredJwtException claims) {
        }
        catch (JwtException ex) {
            context.status(HttpResponseStatus.FORBIDDEN);
            return;
        }
        context.status(HttpResponseStatus.NO_CONTENT);
    }

    public <ReqT, RespT> ServerCall.Listener<ReqT> interceptCall(ServerCall<ReqT, RespT> serverCall, Metadata metadata, ServerCallHandler<ReqT, RespT> serverCallHandler) {
        Status status = null;
        Context ctx = Context.current();
        long start = System.currentTimeMillis();
        Caller caller = null;
        String jti = null;
        try {
            GRPCServerConfig gRPCCfg = GRPCServerConfig.cfg;
            SocketAddress remoteAddr = (SocketAddress)serverCall.getAttributes().get(Grpc.TRANSPORT_ATTR_REMOTE_ADDR);
            String error2 = GeoIpUtil.callerAddressFilter(remoteAddr, gRPCCfg.getCallerAddressFilterWhitelist(), gRPCCfg.getCallerAddressFilterBlacklist(), gRPCCfg.getCallerAddressFilterRegexPrefix(), gRPCCfg.getCallerAddressFilterOption());
            if (error2 != null) {
                status = Status.UNAUTHENTICATED.withDescription("Bearer Authorization Failed: Invalid IP address: " + error2);
            } else {
                ctx = ctx.withValue(GrpcCallerAddr, (Object)remoteAddr);
                String headerValueAuthorization = (String)metadata.get(BearerAuthCredential.AUTHORIZATION_METADATA_KEY);
                if (headerValueAuthorization == null) {
                    status = null;
                } else if (!headerValueAuthorization.startsWith("Bearer")) {
                    status = Status.UNAUTHENTICATED.withDescription("Bearer Authorization Failed: Unknown authorization type, non Bearer token provided");
                } else {
                    SessionContext context;
                    String jwt = headerValueAuthorization.substring("Bearer".length()).trim();
                    caller = this.verifyToken(jwt, this.authTokenCache, null, context = SessionContext.build(0L));
                    if (caller == null) {
                        Object desc = context.error().getErrors().get(0).getErrorDesc();
                        if (StringUtils.isBlank((CharSequence)desc)) {
                            desc = String.valueOf(context.status());
                        }
                        status = Status.UNAUTHENTICATED.withDescription(ERROR + (String)desc);
                    } else {
                        ctx = ctx.withValue(GrpcCaller, (Object)caller);
                        jti = context.callerId();
                        if (jti != null) {
                            ctx = ctx.withValue(GrpcCallerId, (Object)jti);
                        }
                        status = null;
                    }
                }
            }
        }
        catch (Throwable ex) {
            status = Status.UNAUTHENTICATED.withDescription(ERROR + ex.getMessage()).withCause(ex);
        }
        if (status == null) {
            return ContextualizedServerCallListenerEx.interceptCall(start, caller, jti, ctx, serverCall, metadata, serverCallHandler);
        }
        serverCall.close(status, metadata);
        return new ServerCall.Listener<ReqT>(this){};
    }
}

