/*
 * Decompiled with CFR 0.152.
 */
package org.summerboot.jexpress.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.SocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class GeoIpUtil {
    public static final String CHECKIP_URL_AWS = "http://checkip.amazonaws.com";
    public static Map<String, Pattern> REGEX_CACHE = new ConcurrentHashMap<String, Pattern>();

    public static String getExternalIp() throws IOException, URISyntaxException {
        return GeoIpUtil.getExternalIp(CHECKIP_URL_AWS);
    }

    public static String getExternalIp(String url) throws IOException, URISyntaxException {
        URL whatismyip = new URI(url).toURL();
        try (BufferedReader in = new BufferedReader(new InputStreamReader(whatismyip.openStream()));){
            String string = in.readLine();
            return string;
        }
    }

    public static String[] getMyIP() {
        String[] ret = new String[]{"", "", ""};
        StringBuilder sb0 = new StringBuilder();
        StringBuilder sb1 = new StringBuilder();
        try {
            sb0.append(GeoIpUtil.getExternalIp()).append(" - ");
            ret[0] = InetAddress.getLocalHost().getHostAddress();
            Enumeration<NetworkInterface> e = NetworkInterface.getNetworkInterfaces();
            while (e.hasMoreElements()) {
                NetworkInterface n = e.nextElement();
                Enumeration<InetAddress> ee = n.getInetAddresses();
                while (ee.hasMoreElements()) {
                    InetAddress i = ee.nextElement();
                    if (i.isAnyLocalAddress()) {
                        sb0.append(i.getHostAddress()).append(", ");
                        sb1.append("LocalAddress: ").append(i.toString()).append("<br>");
                    }
                    if (i.isLinkLocalAddress()) {
                        sb1.append("LinkLocalAddress: ").append(i.toString()).append("<br>");
                    }
                    if (i.isLoopbackAddress()) {
                        sb1.append("LoopbackAddress: ").append(i.toString()).append("<br>");
                    }
                    if (i.isSiteLocalAddress()) {
                        sb0.append(i.getHostAddress()).append(", ");
                        sb1.append("SiteLocalAddress: ").append(i.toString()).append("<br>");
                    }
                    if (i.isMCGlobal()) {
                        sb1.append("MCGlobal: ").append(i.toString()).append("<br>");
                    }
                    if (i.isMCLinkLocal()) {
                        sb1.append("MCLinkLocal: ").append(i.toString()).append("<br>");
                    }
                    if (i.isMCNodeLocal()) {
                        sb1.append("MCNodeLocal: ").append(i.toString()).append("<br>");
                    }
                    if (i.isMCOrgLocal()) {
                        sb1.append("MCOrgLocal: ").append(i.toString()).append("<br>");
                    }
                    if (!i.isMCSiteLocal()) continue;
                    sb1.append("MCSiteLocal: ").append(i.toString()).append("<br>");
                }
            }
        }
        catch (Throwable ex) {
            sb1.append(ex);
        }
        String systemInfo = "<br>Pid#" + ManagementFactory.getRuntimeMXBean().getName() + "<br>user.name=" + System.getProperty("user.name") + "<br>user=" + System.getProperty("user.name") + "<br>home=" + System.getProperty("user.home") + "<br>dir=" + System.getProperty("user.dir") + "<br>os=" + System.getProperty("os.arch") + " " + System.getProperty("os.name") + " " + System.getProperty("os.version") + "<br>Java=" + System.getProperty("java.vendor") + " " + System.getProperty("java.version");
        ret[0] = sb0.toString();
        ret[1] = sb1.toString();
        ret[2] = systemInfo;
        return ret;
    }

    public static void showAddress(String host, int port) {
        InetSocketAddress address = new InetSocketAddress(host, port);
        String info2 = GeoIpUtil.showAddress(address);
        System.out.println(info2);
    }

    public static String showAddress(InetSocketAddress address) {
        StringBuilder sb = new StringBuilder();
        sb.append("\n isUnresolved=").append(address.isUnresolved());
        sb.append("\n port=").append(address.getPort());
        sb.append("\n toString=").append(address.toString());
        sb.append("\n getHostString=").append(address.getHostString());
        sb.append("\n getHostName=").append(address.getHostName());
        sb.append("\n getAddress=").append(address.getAddress());
        sb.append("\n getHostAddress=").append(address.getAddress().getHostAddress());
        sb.append("\n getHostName=").append(address.getAddress().getHostName());
        sb.append("\n getCanonicalHostName=").append(address.getAddress().getCanonicalHostName());
        return sb.toString();
    }

    public static String callerAddressFilter(SocketAddress callerAddr, Set<String> whiteList, Set<String> blackList, String regexPrefix, CallerAddressFilterOption option) {
        String host;
        if (callerAddr == null) {
            return "caller address is null";
        }
        if (callerAddr instanceof InetSocketAddress) {
            InetSocketAddress address = (InetSocketAddress)callerAddr;
            if (address.isUnresolved()) {
                return "caller address (" + String.valueOf(address) + ") is unresolved";
            }
            switch (option.ordinal()) {
                case 0: {
                    host = address.toString();
                    break;
                }
                case 1: {
                    host = address.getHostString();
                    break;
                }
                case 2: {
                    host = address.getHostName();
                    break;
                }
                case 3: {
                    host = address.getAddress().toString();
                    break;
                }
                case 4: {
                    host = address.getAddress().getHostAddress();
                    break;
                }
                case 5: {
                    host = address.getAddress().getHostName();
                    break;
                }
                case 6: {
                    host = address.getAddress().getCanonicalHostName();
                    break;
                }
                default: {
                    host = address.getHostName();
                    break;
                }
            }
        } else {
            host = callerAddr.toString();
        }
        return GeoIpUtil.callerAddressFilter(host, whiteList, blackList, regexPrefix);
    }

    public static String callerAddressFilter(String host, Set<String> whiteList, Set<String> blackList, String regexPrefix) {
        if (whiteList != null && !whiteList.isEmpty() && !whiteList.contains(host)) {
            if (regexPrefix != null) {
                for (String whiteRegex : whiteList) {
                    if (!whiteRegex.startsWith(regexPrefix) || !GeoIpUtil.matches(host, whiteRegex, regexPrefix)) continue;
                    return null;
                }
            }
            return "caller address (" + host + ") is not in white list";
        }
        if (blackList != null && !blackList.isEmpty()) {
            if (blackList.contains(host)) {
                return "caller address (" + host + ") is in black list";
            }
            if (regexPrefix != null) {
                for (String blackRegex : blackList) {
                    if (!blackRegex.startsWith(regexPrefix) || !GeoIpUtil.matches(host, blackRegex, regexPrefix)) continue;
                    return "caller address (" + host + ") matches black list: " + blackRegex;
                }
            }
        }
        return null;
    }

    public static boolean matches(String input, String regex, String regexPrefix) {
        if (regex == null || regex.isEmpty()) {
            return true;
        }
        Pattern p = REGEX_CACHE.get(regex);
        if (p == null) {
            p = regexPrefix != null && regex.startsWith(regexPrefix) ? Pattern.compile(regex.substring(regexPrefix.length())) : Pattern.compile(regex);
            REGEX_CACHE.put(regex, p);
        }
        Matcher m = p.matcher(input);
        return m.find();
    }

    public static enum CallerAddressFilterOption {
        String,
        HostString,
        HostName,
        AddressStirng,
        HostAddress,
        AddrHostName,
        CanonicalHostName;

    }
}

