/*
 * Decompiled with CFR 0.152.
 */
package org.summerboot.jexpress.util.annotation;

import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;
import java.lang.reflect.Field;
import org.summerboot.jexpress.util.annotation.LimitNonNullGroup;

public class LimitNonNullGroupValidator
implements ConstraintValidator<LimitNonNullGroup, Object> {
    private String[] fieldNames;
    private int expectedCount;

    public void initialize(LimitNonNullGroup constraintAnnotation) {
        this.fieldNames = constraintAnnotation.fields();
        this.expectedCount = constraintAnnotation.limit();
    }

    public boolean isValid(Object value, ConstraintValidatorContext context) {
        if (value == null) {
            return false;
        }
        if (this.fieldNames == null || this.fieldNames.length == 0) {
            return false;
        }
        int nonNullCount = 0;
        try {
            for (String fieldName : this.fieldNames) {
                Field field = value.getClass().getDeclaredField(fieldName);
                field.setAccessible(true);
                Object fieldValue = field.get(value);
                if (fieldValue == null || ++nonNullCount <= this.expectedCount) continue;
                return false;
            }
        }
        catch (Exception e) {
            return false;
        }
        return nonNullCount == this.expectedCount;
    }
}

