/*
 * Decompiled with CFR 0.152.
 */
package org.summerboot.jexpress.boot;

import io.grpc.BindableService;
import io.grpc.ServerServiceDefinition;
import io.netty.channel.ChannelHandler;
import jakarta.annotation.security.DeclareRoles;
import jakarta.annotation.security.RolesAllowed;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.summerboot.jexpress.boot.BackOffice;
import org.summerboot.jexpress.boot.BootConstant;
import org.summerboot.jexpress.boot.BootErrorCode;
import org.summerboot.jexpress.boot.MasterPassword;
import org.summerboot.jexpress.boot.SummerApplication;
import org.summerboot.jexpress.boot.annotation.Controller;
import org.summerboot.jexpress.boot.annotation.GrpcService;
import org.summerboot.jexpress.boot.annotation.Service;
import org.summerboot.jexpress.boot.annotation.Unique;
import org.summerboot.jexpress.boot.annotation.Version;
import org.summerboot.jexpress.boot.config.ConfigUtil;
import org.summerboot.jexpress.boot.config.JExpressConfig;
import org.summerboot.jexpress.boot.config.annotation.ImportResource;
import org.summerboot.jexpress.i18n.I18n;
import org.summerboot.jexpress.integration.smtp.SMTPClientConfig;
import org.summerboot.jexpress.nio.grpc.GRPCServerConfig;
import org.summerboot.jexpress.nio.server.NioConfig;
import org.summerboot.jexpress.security.auth.AuthConfig;
import org.summerboot.jexpress.util.ApplicationUtil;
import org.summerboot.jexpress.util.BeanUtil;
import org.summerboot.jexpress.util.FormatterUtil;
import org.summerboot.jexpress.util.ReflectionUtil;

public abstract class SummerSingularity {
    public static final String HOST = SummerSingularity.jExpressInit();
    protected static Logger log;
    protected static final File DEFAULT_CFG_DIR;
    protected static final File CURRENT_DIR;
    protected File userSpecifiedConfigDir;
    protected File pluginDir;
    protected final StringBuilder memo = new StringBuilder();
    protected final Class primaryClass;
    protected CommandLine cli;
    protected final Options cliOptions = new Options();
    protected final HelpFormatter cliHelpFormatter = new HelpFormatter();
    protected Locale userSpecifiedResourceBundle;
    protected long userSpecifiedCfgMonitorThrottleMillis;
    protected final Set<String> userSpecifiedalternativeNames = new HashSet<String>();
    protected String jvmStartCommand;
    protected boolean jmxRequired;
    protected String[] callerRootPackageNames;
    protected String appVersion = "jExpress 2.6.1";
    protected String logFileName = "jExpress 2.6.1";
    protected final List<String> availableUniqueTagOptions = new ArrayList<String>();
    protected final Map<String, ConfigMetadata> scanedJExpressConfigs = new LinkedHashMap<String, ConfigMetadata>();
    protected final Set<String> availableImplTagOptions = new HashSet<String>();
    protected final Set<Class<? extends BindableService>> gRPCBindableServiceImplClasses = new HashSet<Class<? extends BindableService>>();
    protected final Set<Class<ServerServiceDefinition>> gRPCServerServiceDefinitionImplClasses = new HashSet<Class<ServerServiceDefinition>>();
    protected boolean hasControllers = false;
    protected boolean hasGRPCImpl = false;
    protected boolean hasAuthImpl = false;
    protected final Map<Class, Map<String, List<ServiceMetadata>>> scanedServiceBindingMap = new HashMap<Class, Map<String, List<ServiceMetadata>>>();
    protected final Map<Service.ChannelHandlerType, Set<String>> channelHandlerNames = new HashMap<Service.ChannelHandlerType, Set<String>>();

    protected static String jExpressInit() {
        String FILE_CFG_SYSTEM = "boot.conf";
        File etcDir = new File("etc").getAbsoluteFile();
        if (!etcDir.exists()) {
            etcDir.mkdirs();
        }
        File systemConfigFile = Paths.get(etcDir.getAbsolutePath(), "boot.conf").toFile();
        try {
            if (!systemConfigFile.exists()) {
                ConfigUtil.createConfigFile(BackOffice.class, etcDir, "boot.conf", false);
            }
            BackOffice.agent.load(systemConfigFile, false);
        }
        catch (IOException ex) {
            String msg = "Failed to init " + String.valueOf(systemConfigFile) + ", caused by " + String.valueOf(ex);
            ApplicationUtil.RTO(BootErrorCode.RTO_CFG_BOOT_ERROR, msg, ex);
        }
        String defaultAdminPwdFileName = BackOffice.agent.getDefaultMasterPasswordFile();
        try {
            File defaultAdminPwdFile = new File(etcDir, defaultAdminPwdFileName).getCanonicalFile();
            if (!defaultAdminPwdFile.exists()) {
                ConfigUtil.createConfigFile(MasterPassword.class, etcDir, defaultAdminPwdFileName, false);
            }
        }
        catch (IOException ex) {
            String msg = "Failed to init " + new File(defaultAdminPwdFileName).getAbsolutePath() + ", caused by " + String.valueOf(ex);
            ApplicationUtil.RTO(BootErrorCode.RTO_CFG_BOOT_ERROR, msg, ex);
        }
        return ApplicationUtil.getServerName(true);
    }

    protected SummerSingularity(Class callerClass, String ... args) {
        System.out.println("jExpress loading from " + HOST);
        System.setProperty(BootConstant.SYS_PROP_SERVER_NAME, HOST);
        this.primaryClass = callerClass == null ? this.getClass() : callerClass;
        this.singularity();
        this.bigBang(args);
    }

    protected void singularity() {
        if (BackOffice.agent.isTraceWithSystemOut()) {
            System.out.println("jExpress init.0");
        }
        this.memo.setLength(0);
        this.userSpecifiedConfigDir = null;
        this.pluginDir = null;
        System.getProperties().remove("log4j.configurationFile");
        System.getProperties().remove("java.util.logging.manager");
        System.getProperties().remove(BootConstant.SYS_PROP_APP_PACKAGE_NAME, "");
        System.getProperties().remove(BootConstant.SYS_PROP_LOGFILENAME, "");
        System.setProperty("log4j.configurationFile", "");
        this.userSpecifiedResourceBundle = null;
        this.userSpecifiedCfgMonitorThrottleMillis = BootConstant.CFG_CHANGE_MONITOR_THROTTLE_MS;
        this.userSpecifiedalternativeNames.clear();
        this.jvmStartCommand = null;
        this.jmxRequired = false;
        this.callerRootPackageNames = null;
        this.appVersion = "jExpress 2.6.1";
        this.logFileName = "jExpress 2.6.1";
        this.availableUniqueTagOptions.clear();
        this.scanedJExpressConfigs.clear();
        this.availableImplTagOptions.clear();
        this.gRPCBindableServiceImplClasses.clear();
        this.gRPCServerServiceDefinitionImplClasses.clear();
        this.hasControllers = false;
        this.hasGRPCImpl = false;
        this.hasAuthImpl = false;
    }

    protected <T extends SummerApplication> T bigBang(String[] args) {
        if (BackOffice.agent.isTraceWithSystemOut()) {
            System.out.println("jExpress init.1");
        }
        this.memo.append(BootConstant.BR).append("\t- deployee callerClass=").append(this.primaryClass.getName());
        HashSet<String> packageSet = new HashSet<String>();
        Set<String> configuredPackageSet = BackOffice.agent.getRootPackageNames();
        if (configuredPackageSet != null && !configuredPackageSet.isEmpty()) {
            packageSet.addAll(configuredPackageSet);
        }
        String rootPackageName = ReflectionUtil.getRootPackageName(this.primaryClass, BootConstant.PACKAGE_LEVEL);
        packageSet.add(rootPackageName);
        BackOffice.agent.setRootPackageNames(packageSet);
        this.callerRootPackageNames = (String[])packageSet.toArray(String[]::new);
        this.memo.append(BootConstant.BR).append("\t- callerRootPackageName=").append(packageSet);
        if (BackOffice.agent.isTraceWithSystemOut()) {
            System.out.println("jExpress init.2");
        }
        StringBuilder sb = new StringBuilder();
        this.jmxRequired = ApplicationUtil.scanJVM_StartCommand(sb);
        this.jvmStartCommand = sb.toString();
        if (BackOffice.agent.isTraceWithSystemOut()) {
            System.out.println("jExpress init.3");
        }
        this.scanAnnotation_Version(this.primaryClass);
        System.setProperty(BootConstant.SYS_PROP_LOGFILENAME, this.logFileName);
        System.setProperty(BootConstant.SYS_PROP_APP_PACKAGE_NAME, rootPackageName);
        BackOffice.agent.setVersion(this.appVersion);
        this.scanArgsToInitializeLogging(args);
        try {
            this.scanPluginJars(this.pluginDir, true);
        }
        catch (IOException ex) {
            String msg = String.valueOf(ex) + BootConstant.BR + "\tFailed to load plugin jar files from " + String.valueOf(this.pluginDir);
            ApplicationUtil.RTO(BootErrorCode.RTO_PLUGIN_ERROR, msg, ex);
        }
        String error2 = this.scanAnnotation_Unique(this.callerRootPackageNames, this.memo, new String[0]);
        if (error2 != null) {
            ApplicationUtil.RTO(BootErrorCode.RTO_CODE_ERROR_UNIQUE, error2, null);
        }
        String[] packages = FormatterUtil.arrayAdd(this.callerRootPackageNames, "org.summerboot.jexpress");
        this.scanImplementation_gRPC(this.callerRootPackageNames);
        this.scanAnnotation_Controller(this.callerRootPackageNames);
        this.scanAnnotation_Service(this.callerRootPackageNames);
        this.scanAnnotation_DeclareRoles(this.callerRootPackageNames);
        this.scanAnnotation_JExpressConfigImportResource(packages);
        return (T)((SummerApplication)this);
    }

    protected void scanAnnotation_Version(Class callerClass) {
        Version version;
        if (BackOffice.agent.isTraceWithSystemOut()) {
            System.out.println("jExpress scanning version");
        }
        if ((version = callerClass.getAnnotation(Version.class)) != null) {
            String logManager = version.LogManager();
            if (StringUtils.isNotBlank((CharSequence)logManager)) {
                System.setProperty("java.util.logging.manager", logManager);
            }
            this.logFileName = version.logFileName();
            if (StringUtils.isBlank((CharSequence)this.logFileName)) {
                this.logFileName = version.value()[0];
                this.logFileName = this.logFileName.replaceAll(" ", "_");
            }
            this.appVersion = version.value()[0];
            BackOffice.agent.setVersionShort(this.appVersion);
            int versionCount = version.value().length;
            if (versionCount > 1) {
                this.appVersion = this.appVersion + " (";
                for (int i = 1; i < versionCount; ++i) {
                    this.appVersion = this.appVersion + version.value()[i] + " ";
                }
                this.appVersion = this.appVersion + ")";
            }
        } else {
            this.logFileName = "app";
        }
        this.memo.append(BootConstant.BR).append("\t- callerVersion=").append(this.appVersion);
    }

    protected void scanArgsToInitializeLogging(String[] args) {
        if (BackOffice.agent.isTraceWithSystemOut()) {
            System.out.println("jExpress initLogger.1");
        }
        this.userSpecifiedConfigDir = null;
        if (args != null) {
            for (int i = 0; i < args.length; ++i) {
                String cli = args[i];
                if (("-" + BootConstant.CLI_CONFIG_DIR).equals(cli)) {
                    String cfgDir = args[++i];
                    this.userSpecifiedConfigDir = new File(cfgDir).getAbsoluteFile();
                    break;
                }
                if (!("-" + BootConstant.CLI_CONFIG_DOMAIN).equals(cli)) continue;
                String envTag = args[++i];
                String cfgDir = BootConstant.DIR_STANDALONE + "_" + envTag + File.separator + BootConstant.DIR_CONFIGURATION;
                this.userSpecifiedConfigDir = new File(cfgDir).getAbsoluteFile();
                System.setProperty("domainName", envTag);
                break;
            }
        }
        if (BackOffice.agent.isTraceWithSystemOut()) {
            System.out.println("jExpress initLogger.2");
        }
        if (this.userSpecifiedConfigDir == null) {
            this.userSpecifiedConfigDir = DEFAULT_CFG_DIR;
        }
        if (!this.userSpecifiedConfigDir.exists()) {
            this.userSpecifiedConfigDir.mkdirs();
        }
        if (BackOffice.agent.isTraceWithSystemOut()) {
            System.out.println("jExpress initLogger.3");
        }
        if (!(this.userSpecifiedConfigDir.exists() && this.userSpecifiedConfigDir.isDirectory() && this.userSpecifiedConfigDir.canRead())) {
            String msg = "Could access configuration path as a folder: " + String.valueOf(this.userSpecifiedConfigDir);
            ApplicationUtil.RTO(BootErrorCode.RTO_CFG_DIR_ACCESS_ERROR, msg, null);
        }
        System.setProperty(BootConstant.SYS_PROP_LOGID, BootConstant.APP_ID);
        System.setProperty(BootConstant.SYS_PROP_LOGFILEPATH, this.userSpecifiedConfigDir.getParent() + File.separator + BootConstant.DIR_LOG);
        this.pluginDir = new File(this.userSpecifiedConfigDir.getParentFile(), BootConstant.DIR_PLUGIN).getAbsoluteFile();
        if (BackOffice.agent.isTraceWithSystemOut()) {
            System.out.println("jExpress initLogger.4");
        }
        String location = this.userSpecifiedConfigDir.getAbsolutePath();
        ClassLoader classLoader = this.getClass().getClassLoader();
        Path logFilePath = ApplicationUtil.createIfNotExist(location, classLoader, "log4j2.xml.temp", "log4j2.xml");
        String log4j2ConfigFile = logFilePath.toString();
        System.setProperty("log4j.configurationFile", log4j2ConfigFile);
        log = LogManager.getLogger(SummerApplication.class);
        log.info("Logging initialized from {}", (Object)this.userSpecifiedConfigDir);
        Locale userSpecifiedResourceBundle = null;
        this.memo.append(BootConstant.BR).append("\t- ").append(I18n.info.launchingLog.format(userSpecifiedResourceBundle, System.getProperty("log4j.configurationFile")));
    }

    protected void scanPluginJars(File pluginDir, boolean failOnUndefinedClasses) throws IOException {
        log.trace("{}, {}", (Object)pluginDir, (Object)failOnUndefinedClasses);
        pluginDir.mkdirs();
        if (!pluginDir.canRead() || !pluginDir.isDirectory()) {
            this.memo.append(BootConstant.BR).append("\t- loadPluginJars: invalid dir ").append(pluginDir);
            return;
        }
        FileFilter fileFilter = file -> !file.isDirectory() && file.getName().endsWith(".jar");
        File[] jarFiles = pluginDir.listFiles(fileFilter);
        if (jarFiles == null || jarFiles.length < 1) {
            this.memo.append(BootConstant.BR).append("\t- loadPluginJars: no jar files found at ").append(pluginDir);
            return;
        }
        HashSet pluginClasses = new HashSet();
        for (File jarFile : jarFiles) {
            this.memo.append(BootConstant.BR).append("\t- loadPluginJars: loading jar file ").append(jarFile.getAbsolutePath());
            Set<Class<?>> classes = ApplicationUtil.loadClassFromJarFile(jarFile, failOnUndefinedClasses);
            this.memo.append(BootConstant.BR).append("\t- loadPluginJars: loaded ").append(classes.size()).append(" classes from jar file ").append(jarFile.getAbsolutePath());
            pluginClasses.addAll(classes);
        }
        ReflectionUtil.setPluginClasses(pluginClasses);
        this.memo.append(BootConstant.BR).append("\t- loadPluginJars: loaded ").append(pluginClasses.size()).append(" classes from ").append(jarFiles.length).append(" jar files in ").append(pluginDir);
    }

    protected String scanAnnotation_Unique(String[] rootPackageNames, StringBuilder sb, String ... displayByTags) {
        log.trace("");
        StringBuilder errors = new StringBuilder();
        boolean error2 = false;
        Set<Class<?>> classes = ReflectionUtil.getAllImplementationsByAnnotation(Unique.class, false, rootPackageNames);
        for (Class<?> classWithUniqueValues : classes) {
            if (!classWithUniqueValues.isInterface()) {
                error2 = true;
                errors.append(BootConstant.BR).append("\t @Unique can only apply on interfaces, ").append(classWithUniqueValues).append(" is not an interface");
                continue;
            }
            Unique u = classWithUniqueValues.getAnnotation(Unique.class);
            String tag = u.name();
            this.availableUniqueTagOptions.add(tag);
            Class uniqueType = u.type();
            List<String> tags = List.of(displayByTags);
            try {
                Map<Object, Set<String>> duplicated = ApplicationUtil.checkDuplicateFields(classWithUniqueValues, uniqueType);
                if (!duplicated.isEmpty()) {
                    String report = BeanUtil.toJson(duplicated, true, false);
                    return "Duplicated " + uniqueType.getSimpleName() + " values in " + classWithUniqueValues.getSimpleName() + " " + report;
                }
                if (!tags.contains(tag)) continue;
                HashMap results = new HashMap();
                ReflectionUtil.loadFields(classWithUniqueValues, uniqueType, results, false);
                Map sorted = results.entrySet().stream().sorted(Map.Entry.comparingByValue()).collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey, (e1, e2) -> e1, LinkedHashMap::new));
                String json = BeanUtil.toJson(sorted, true, false);
                sb.append(BootConstant.BR).append(tag).append("=").append(json);
            }
            catch (Throwable ex) {
                throw new RuntimeException("check unique failed on " + classWithUniqueValues.getName(), ex);
            }
        }
        if (error2) {
            throw new RuntimeException(errors.toString());
        }
        return null;
    }

    protected void scanAnnotation_JExpressConfigImportResource(String ... rootPackageNames) {
        log.trace("");
        Set<String> pakcages = Set.copyOf(List.of(rootPackageNames));
        Set<Class<JExpressConfig>> jExpressConfigClasses = ReflectionUtil.getAllImplementationsByInterface(JExpressConfig.class, pakcages);
        for (Class<JExpressConfig> jExpressConfigClass : jExpressConfigClasses) {
            String key;
            int mod = jExpressConfigClass.getModifiers();
            if (mod == 0 || Modifier.isAbstract(mod) || Modifier.isInterface(mod) || this.scanedJExpressConfigs.containsKey(key = jExpressConfigClass.getSimpleName())) continue;
            String configFileName = null;
            String[] checkImplTagUsed = new String[]{};
            boolean loadWhenImplTagUsed = false;
            ImportResource ir = jExpressConfigClass.getAnnotation(ImportResource.class);
            if (ir != null) {
                configFileName = ir.value();
                checkImplTagUsed = ir.whenUseAlternative();
                loadWhenImplTagUsed = ir.thenLoadConfig();
            } else if (jExpressConfigClass.equals(AuthConfig.class)) {
                configFileName = BootConstant.FILE_CFG_AUTH;
            } else if (this.hasControllers && jExpressConfigClass.equals(NioConfig.class)) {
                configFileName = BootConstant.FILE_CFG_NIO;
            } else if (this.hasGRPCImpl && jExpressConfigClass.equals(GRPCServerConfig.class)) {
                configFileName = BootConstant.FILE_CFG_GRPC;
            } else {
                if (!jExpressConfigClass.equals(SMTPClientConfig.class)) continue;
                configFileName = BootConstant.FILE_CFG_SMTP;
            }
            ConfigMetadata metadata = new ConfigMetadata(configFileName, jExpressConfigClass, null, checkImplTagUsed, loadWhenImplTagUsed);
            this.scanedJExpressConfigs.put(key, metadata);
            this.memo.append(BootConstant.BR).append("\t- scan.JExpressConfig.ImportResource:").append(key).append("=").append(metadata);
            this.memo.append(BootConstant.BR).append("\t- cfg.scaned=").append(jExpressConfigClass.getName()).append(", file=").append(configFileName);
        }
    }

    protected void scanImplementation_gRPC(String ... pakcages) {
        log.trace("");
        Set<Class<?>> gRPCServerClasses = ReflectionUtil.getAllImplementationsByAnnotation(GrpcService.class, false, pakcages);
        for (Class<?> gRPCServerClass : gRPCServerClasses) {
            if (BindableService.class.isAssignableFrom(gRPCServerClass)) {
                this.gRPCBindableServiceImplClasses.add(gRPCServerClass);
                continue;
            }
            if (!ServerServiceDefinition.class.equals(gRPCServerClass)) continue;
            this.gRPCServerServiceDefinitionImplClasses.add(gRPCServerClass);
        }
        this.hasGRPCImpl = !this.gRPCServerServiceDefinitionImplClasses.isEmpty() || !this.gRPCBindableServiceImplClasses.isEmpty();
    }

    protected void scanAnnotation_Controller(String ... rootPackageNames) {
        log.trace("");
        Set<Class<?>> classes = ReflectionUtil.getAllImplementationsByAnnotation(Controller.class, false, rootPackageNames);
        ArrayList<String> tags = new ArrayList<String>();
        for (Class<?> c : classes) {
            Controller a = c.getAnnotation(Controller.class);
            if (a == null) continue;
            String implTag = a.AlternativeName();
            tags.add(implTag);
        }
        List serviceImplTags = tags.stream().distinct().collect(Collectors.toList());
        serviceImplTags.removeAll(Collections.singleton(null));
        serviceImplTags.removeAll(Collections.singleton(""));
        serviceImplTags.removeAll(Collections.singleton(""));
        this.availableImplTagOptions.addAll(serviceImplTags);
    }

    protected List<String> scanAnnotation_Service(String ... rootPackageNames) {
        log.trace("");
        Set<Class<?>> classes = ReflectionUtil.getAllImplementationsByAnnotation(Service.class, false, rootPackageNames);
        return this.scanAnnotation_Service(classes);
    }

    protected List<String> scanAnnotation_Service(Set<Class<?>> classesAll) {
        log.trace("");
        ArrayList<String> tags = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        for (Class<?> serviceImplClass : classesAll) {
            Service serviceAnnotation = serviceImplClass.getAnnotation(Service.class);
            if (serviceAnnotation == null) continue;
            String named = serviceAnnotation.named().trim();
            String implTag = serviceAnnotation.AlternativeName().trim();
            tags.add(implTag);
            String uniqueKey = "named=" + named + ", implTag=" + implTag;
            Class[] bindingClasses = serviceAnnotation.binding();
            Service.ChannelHandlerType ChannelHandlerType2 = serviceAnnotation.type();
            if (bindingClasses != null && bindingClasses.length > 0) {
                for (Class bindingClass : bindingClasses) {
                    if (!bindingClass.isAssignableFrom(serviceImplClass)) {
                        List<Class> interfaces = ReflectionUtil.getAllInterfaces(serviceImplClass, true);
                        List<Class> superclasses = ReflectionUtil.getAllSuperClasses(serviceImplClass);
                        interfaces.addAll(superclasses);
                        interfaces.remove(Object.class);
                        sb.append(BootConstant.BR).append("\t").append(serviceImplClass).append(" specifies @").append(Service.class.getSimpleName()).append("(binding=").append(bindingClass.getSimpleName()).append(".class), which is not in its Interfaces:").append(interfaces);
                        continue;
                    }
                    this.scanAnnotation_Service_Add2BindingMap(bindingClass, uniqueKey, new ServiceMetadata(serviceImplClass, named, implTag, ChannelHandlerType2), sb);
                }
                continue;
            }
            List<Class> declaredInterfaces = ReflectionUtil.getAllInterfaces(serviceImplClass, false);
            if (declaredInterfaces.isEmpty()) {
                List<Class> superInterfaces = ReflectionUtil.getAllInterfaces(serviceImplClass.getSuperclass(), true);
                if (superInterfaces.isEmpty()) {
                    sb.append(BootConstant.BR).append("\t").append(serviceImplClass).append(" does not implement any interfaces.");
                    continue;
                }
                sb.append(BootConstant.BR).append("\t").append(serviceImplClass).append(" needs to specify the binding interface @").append(Service.class.getSimpleName()).append("(binding=TheMissingInterface.class), which implemented by supper class: ").append(superInterfaces);
                continue;
            }
            for (Class bindingClass : declaredInterfaces) {
                this.scanAnnotation_Service_Add2BindingMap(bindingClass, uniqueKey, new ServiceMetadata(serviceImplClass, named, implTag, ChannelHandlerType2), sb);
            }
        }
        this.scanAnnotation_Service_ValidateBindingMap(sb);
        String error2 = sb.toString();
        if (!error2.isBlank()) {
            String msg = "@Service IOC Code error:" + String.valueOf(sb);
            ApplicationUtil.RTO(BootErrorCode.RTO_CODING_ERROR_SERVICE_IOC, msg, null);
        }
        List<String> serviceImplTags = tags.stream().distinct().collect(Collectors.toList());
        serviceImplTags.removeAll(Collections.singleton(null));
        serviceImplTags.removeAll(Collections.singleton(""));
        serviceImplTags.removeAll(Collections.singleton(""));
        this.availableImplTagOptions.addAll(serviceImplTags);
        return serviceImplTags;
    }

    protected void scanAnnotation_Service_Add2BindingMap(Class bindingClass, String uniqueKey, ServiceMetadata service, StringBuilder sb) {
        Service.ChannelHandlerType channelHandlerType;
        List<ServiceMetadata> serviceImplList;
        log.trace("");
        this.memo.append(BootConstant.BR).append("\t- scan.taggedservice.add to guiceModule.bind(").append(bindingClass.getName()).append(").to(").append(service).append("), uniqueKey=").append(uniqueKey);
        Map<String, List<ServiceMetadata>> taggeServicedMap = this.scanedServiceBindingMap.get(bindingClass);
        if (taggeServicedMap == null) {
            taggeServicedMap = new HashMap<String, List<ServiceMetadata>>();
            this.scanedServiceBindingMap.put(bindingClass, taggeServicedMap);
        }
        if ((serviceImplList = taggeServicedMap.get(uniqueKey)) == null) {
            serviceImplList = new ArrayList<ServiceMetadata>();
            taggeServicedMap.put(uniqueKey, serviceImplList);
        }
        if (bindingClass.equals(ChannelHandler.class) && ((channelHandlerType = service.getChannelHandlerType()) == null || channelHandlerType == Service.ChannelHandlerType.nptspecified)) {
            sb.append(BootConstant.BR).append("\t").append(service.getServiceImplClass()).append(" needs to specify type @").append(Service.class.getSimpleName()).append("(binding=ChannelHandler.class, type=?), when binding=ChannelHandler.class");
        }
        serviceImplList.add(service);
    }

    protected void scanAnnotation_Service_ValidateBindingMap(StringBuilder sb) {
        log.trace("");
        for (Class keyBindingClass : this.scanedServiceBindingMap.keySet()) {
            Map<String, List<ServiceMetadata>> taggeServicedMap = this.scanedServiceBindingMap.get(keyBindingClass);
            for (String keyImplTag : taggeServicedMap.keySet()) {
                List<ServiceMetadata> serviceImplList = taggeServicedMap.get(keyImplTag);
                int size = serviceImplList.size();
                if (size == 1) continue;
                sb.append(BootConstant.BR).append("IOC ").append(keyBindingClass).append(" required a single bean, but ").append(size).append(" were found with the same named+implTag(").append(keyImplTag).append("): ").append(serviceImplList);
            }
        }
    }

    protected void scanAnnotation_DeclareRoles(String ... rootPackageNames) {
        log.trace("");
        TreeSet<String> declareRoles = new TreeSet<String>();
        Set<Class<?>> classes = ReflectionUtil.getAllImplementationsByAnnotation(Controller.class, false, rootPackageNames);
        this.hasControllers = !classes.isEmpty();
        for (Class<?> c : classes) {
            DeclareRoles drs = c.getAnnotation(DeclareRoles.class);
            if (drs != null) {
                String[] roles = drs.value();
                declareRoles.addAll(Arrays.asList(roles));
            }
            List<Method> methods = ReflectionUtil.getDeclaredAndSuperClassesMethods(c, true);
            for (Method javaMethod : methods) {
                RolesAllowed ra = javaMethod.getAnnotation(RolesAllowed.class);
                if (ra == null) continue;
                String[] roles = ra.value();
                declareRoles.addAll(Arrays.asList(roles));
            }
        }
        AuthConfig authCfg = AuthConfig.cfg;
        authCfg.addDeclareRoles(declareRoles);
        this.memo.append(BootConstant.BR).append("\t- scan.DeclareRoles=").append(declareRoles);
        this.hasAuthImpl = !authCfg.getDeclareRoles().isEmpty();
    }

    static {
        DEFAULT_CFG_DIR = new File(BootConstant.DIR_CONFIGURATION).getAbsoluteFile();
        CURRENT_DIR = new File("").getAbsoluteFile();
    }

    protected static class ConfigMetadata {
        final Class cfgClass;
        final String configFileName;
        final JExpressConfig instance;
        final String[] whenUseAlternative;
        final boolean thenLoadConfig;

        ConfigMetadata(String configFileName, Class cfgClass, JExpressConfig instance, String[] whenUseAlternative, boolean thenLoadConfig) {
            this.configFileName = configFileName;
            this.cfgClass = cfgClass;
            this.instance = instance;
            this.whenUseAlternative = whenUseAlternative;
            this.thenLoadConfig = thenLoadConfig;
        }

        public String toString() {
            return "ConfigMetadata{cfgClass=" + this.cfgClass.getName() + ", configFileName=" + this.configFileName + ", instance=" + String.valueOf(this.instance) + ", whenUseAlternative=" + Arrays.toString(this.whenUseAlternative) + ", thenLoadConfig=" + this.thenLoadConfig + "}";
        }
    }

    public static class ServiceMetadata {
        final Class serviceImplClass;
        final String named;
        final String implTag;
        final Service.ChannelHandlerType channelHandlerType;

        public ServiceMetadata(Class serviceImplClass, String named, String implTag, Service.ChannelHandlerType channelHandlerType) {
            this.serviceImplClass = serviceImplClass;
            this.named = named;
            this.implTag = implTag;
            this.channelHandlerType = channelHandlerType;
        }

        public String toString() {
            return "ServiceImpl{" + this.serviceImplClass.getName() + ", named=" + this.named + ", implTag=" + this.implTag + "}";
        }

        public Class getServiceImplClass() {
            return this.serviceImplClass;
        }

        public String getNamed() {
            return this.named;
        }

        public String getImplTag() {
            return this.implTag;
        }

        public Service.ChannelHandlerType getChannelHandlerType() {
            return this.channelHandlerType;
        }
    }
}

