/*
 * Decompiled with CFR 0.152.
 */
package org.summerboot.jexpress.nio;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.summerboot.jexpress.util.TimeUtil;

public class IdleEventMonitor {
    private final AtomicLong lastTimestamp = new AtomicLong(0L);
    private final AtomicReference<String> lastTransactionId = new AtomicReference();
    private final String name;
    protected static final Logger log = LogManager.getLogger((String)IdleEventMonitor.class.getName());
    private static final Map<IdleEventMonitor, Boolean> statusMap = new ConcurrentHashMap<IdleEventMonitor, Boolean>();

    public IdleEventMonitor(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void update(String transactionId) {
        this.lastTimestamp.set(System.currentTimeMillis());
        this.lastTransactionId.set(transactionId);
    }

    public void update(long timestamp, String transactionId) {
        this.lastTimestamp.set(timestamp);
        this.lastTransactionId.set(transactionId);
    }

    public String getLastTransactionId() {
        return this.lastTransactionId.get();
    }

    public long getLastTimestamp() {
        return this.lastTimestamp.get();
    }

    public long getTTLMillis(long threshold, TimeUnit timeUnit) {
        long thresholdMillis = timeUnit.toMillis(threshold);
        return this.getTTLMillis(thresholdMillis);
    }

    public long getTTLMillis(long thresholdMillis) {
        return thresholdMillis - (System.currentTimeMillis() - this.lastTimestamp.get());
    }

    public boolean isTimeout(long threshold, TimeUnit timeUnit) {
        long thresholdMillis = timeUnit.toMillis(threshold);
        return this.isTimeout(thresholdMillis);
    }

    public boolean isTimeout(long thresholdMillis) {
        return System.currentTimeMillis() - this.lastTimestamp.get() > thresholdMillis;
    }

    public static void start(IdleEventMonitor idleEventMonitor, IdleEventListener idleEventListener, long threshold, TimeUnit timeUnit) throws Exception {
        if (idleEventMonitor == null) {
            throw new IllegalArgumentException("Request tracker cannot be null");
        }
        idleEventListener.onIdle(idleEventMonitor);
        Thread vThread = Thread.startVirtualThread(() -> {
            log.info("IdleEventMonitor.start: " + idleEventMonitor.getName());
            do {
                try {
                    long ttlMillis = idleEventMonitor.getTTLMillis(threshold, timeUnit);
                    if (ttlMillis >= 0L) {
                        Thread.sleep(ttlMillis);
                        continue;
                    }
                    log.info("IdleEventMonitor.onIdle: " + idleEventMonitor.getName() + ", lastTxId=" + idleEventMonitor.getLastTransactionId() + ", lastTS=" + String.valueOf(TimeUtil.toOffsetDateTime(idleEventMonitor.getLastTimestamp(), null)));
                    idleEventListener.onIdle(idleEventMonitor);
                    idleEventMonitor.update(idleEventMonitor.getName());
                }
                catch (InterruptedException ex) {
                    log.error("IdleEventMonitor.interrupted: " + idleEventMonitor.getName(), (Throwable)ex);
                }
                catch (Throwable ex) {
                    log.error("IdleEventMonitor.exception: " + idleEventMonitor.getName(), ex);
                }
            } while (statusMap.getOrDefault(idleEventMonitor, true).booleanValue());
            log.info("IdleEventMonitor.shutdown: " + idleEventMonitor.getName());
        });
    }

    public static void stop(IdleEventMonitor idleEventMonitor) {
        if (idleEventMonitor == null) {
            return;
        }
        statusMap.put(idleEventMonitor, false);
    }

    public static void stop() {
        for (IdleEventMonitor tracker : statusMap.keySet()) {
            IdleEventMonitor.stop(tracker);
        }
        statusMap.clear();
    }

    public static interface IdleEventListener {
        public void onIdle(IdleEventMonitor var1) throws Exception;
    }
}

