/*
 * Decompiled with CFR 0.152.
 */
package org.summerboot.jexpress.nio.grpc;

import io.grpc.Context;
import io.grpc.ForwardingServerCall;
import io.grpc.ForwardingServerCallListener;
import io.grpc.Grpc;
import io.grpc.Metadata;
import io.grpc.ServerCall;
import io.grpc.ServerCallHandler;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMethod;
import java.net.SocketAddress;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.util.List;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.summerboot.jexpress.boot.BootConstant;
import org.summerboot.jexpress.nio.grpc.GRPCServer;
import org.summerboot.jexpress.nio.server.NioServerHttpRequestHandler;
import org.summerboot.jexpress.nio.server.SessionContext;
import org.summerboot.jexpress.nio.server.domain.ProcessorSettings;
import org.summerboot.jexpress.nio.server.domain.ServiceError;
import org.summerboot.jexpress.security.SecurityUtil;
import org.summerboot.jexpress.security.auth.Caller;
import org.summerboot.jexpress.util.FormatterUtil;
import org.summerboot.jexpress.util.TimeUtil;

public class ContextualizedServerCallListenerEx<ReqT>
extends ForwardingServerCallListener.SimpleForwardingServerCallListener<ReqT> {
    protected final Logger log = LogManager.getLogger((Object)((Object)this));
    protected ZoneId zoneId = ZoneId.systemDefault();
    protected static String protectedContectReplaceWith = "***";
    private final Context context;
    private final SessionContext sessionContext;
    private String httpPostRequestBody;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <ReqT, RespT> ServerCall.Listener<ReqT> interceptCall(long startTs, Caller caller, String jti, Context context, ServerCall<ReqT, RespT> call, Metadata headers, ServerCallHandler<ReqT, RespT> next) {
        ContextualizedServerCallListenerEx<ReqT> listener;
        Context previous;
        SessionContext sessionContext;
        GRPCServer.getServiceCounter().incrementHit();
        Object serverCall = call;
        try {
            String methodName = call.getMethodDescriptor().getFullMethodName();
            if (ContextualizedServerCallListenerEx.isPing(methodName)) {
                GRPCServer.getServiceCounter().incrementPing();
                sessionContext = null;
            } else {
                long hitIndex = GRPCServer.getServiceCounter().incrementBiz();
                final String txId = BootConstant.APP_ID + "-" + hitIndex;
                GRPCServer.IDLE_EVENT_MONITOR.update(txId);
                DefaultHttpHeaders httpHeaders = new DefaultHttpHeaders();
                for (String key : headers.keys()) {
                    httpHeaders.add(key, headers.get(Metadata.Key.of((String)key, (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER)));
                }
                String methodType = call.getMethodDescriptor().getType().name();
                SocketAddress remoteAddr = (SocketAddress)call.getAttributes().get(Grpc.TRANSPORT_ATTR_REMOTE_ADDR);
                SocketAddress localAddr = (SocketAddress)call.getAttributes().get(Grpc.TRANSPORT_ATTR_LOCAL_ADDR);
                sessionContext = new SessionContext(localAddr, remoteAddr, txId, hitIndex, startTs, (HttpHeaders)httpHeaders, "gRPC HTTP/2", HttpMethod.POST, methodName, null);
                sessionContext.caller(caller).callerId(jti).sessionAttribute("MethodType", methodType);
                context = context.withValue(GRPCServer.SessionContext, (Object)sessionContext);
                serverCall = new ForwardingServerCall.SimpleForwardingServerCall<ReqT, RespT>(call){

                    public void sendHeaders(Metadata responseHeaders) {
                        String headerKey_serverTimestamp;
                        String headerKey_reference;
                        ProcessorSettings processorSettings = sessionContext.processorSettings();
                        if (processorSettings == null) {
                            headerKey_reference = "X-Reference";
                            headerKey_serverTimestamp = "X-ServerTs";
                        } else {
                            headerKey_reference = processorSettings.getHttpServiceResponseHeaderName_Reference();
                            headerKey_serverTimestamp = processorSettings.getHttpServiceResponseHeaderName_ServerTimestamp();
                        }
                        responseHeaders.put(Metadata.Key.of((String)headerKey_reference, (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER), (Object)txId);
                        responseHeaders.put(Metadata.Key.of((String)headerKey_serverTimestamp, (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER), (Object)OffsetDateTime.now().format(TimeUtil.ISO_ZONED_DATE_TIME3));
                        DefaultHttpHeaders httpHeaders = new DefaultHttpHeaders();
                        for (String key : responseHeaders.keys()) {
                            httpHeaders.add(key, responseHeaders.get(Metadata.Key.of((String)key, (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER)));
                        }
                        sessionContext.responseHeaders((HttpHeaders)httpHeaders);
                        super.sendHeaders(responseHeaders);
                    }

                    public void sendMessage(RespT message) {
                        if (message != null) {
                            sessionContext.response(message.toString());
                        }
                        super.sendMessage(message);
                    }
                };
            }
        }
        finally {
            previous = context.attach();
        }
        try {
            listener = new ContextualizedServerCallListenerEx<ReqT>(next.startCall(serverCall, headers), context, sessionContext);
        }
        finally {
            context.detach(previous);
        }
        return listener;
    }

    public static boolean isPing(String methodName) {
        return methodName.endsWith("/ping");
    }

    public ContextualizedServerCallListenerEx(ServerCall.Listener<ReqT> delegate, Context context, SessionContext sessionContext) {
        super(delegate);
        this.context = context;
        this.sessionContext = sessionContext;
    }

    public void onReady() {
        Context previous = this.context.attach();
        try {
            super.onReady();
        }
        finally {
            this.context.detach(previous);
        }
    }

    public void onMessage(ReqT message) {
        Context previous = this.context.attach();
        if (message != null) {
            this.httpPostRequestBody = message.toString();
        }
        try {
            super.onMessage(message);
        }
        finally {
            this.context.detach(previous);
        }
    }

    public void onHalfClose() {
        Context previous = this.context.attach();
        try {
            super.onHalfClose();
        }
        finally {
            this.context.detach(previous);
        }
    }

    public void onCancel() {
        GRPCServer.getServiceCounter().incrementCancelled();
        GRPCServer.getServiceCounter().incrementProcessed();
        Context previous = this.context.attach();
        try {
            super.onCancel();
        }
        finally {
            this.context.detach(previous);
        }
        this.report();
    }

    public void onComplete() {
        GRPCServer.getServiceCounter().incrementProcessed();
        Context previous = this.context.attach();
        try {
            super.onComplete();
        }
        finally {
            this.context.detach(previous);
        }
        this.report();
    }

    protected void report() {
        List<String> protectedDataFields;
        ProcessorSettings.LogSettings logSettings;
        if (this.sessionContext == null) {
            return;
        }
        Level level = this.sessionContext.level();
        if (!this.log.isEnabled(level)) {
            return;
        }
        long responseTime = System.currentTimeMillis() - this.sessionContext.startTimestamp();
        boolean isTraceAll = BootConstant.isDebugMode();
        HttpHeaders requestHeaders = this.sessionContext.requestHeaders();
        if (!isTraceAll && requestHeaders.contains((CharSequence)HttpHeaderNames.AUTHORIZATION)) {
            requestHeaders.set((CharSequence)HttpHeaderNames.AUTHORIZATION, (Object)"***");
        }
        Object caller = this.sessionContext.caller();
        ServiceError error2 = this.sessionContext.error();
        int errorCount = 0;
        if (error2 != null) {
            errorCount = error2.getErrors() == null ? 1 : Math.max(1, error2.getErrors().size());
        }
        StringBuilder sb = new StringBuilder();
        String txId = this.sessionContext.txId();
        String methodType = (String)this.sessionContext.sessionAttribute("MethodType");
        sb.append("request_").append(txId).append(".caller=").append((Object)(caller == null ? this.sessionContext.callerId() : caller));
        sb.append("\n\t").append("gRPC").append("_request_").append(this.sessionContext.hit()).append("=").append(methodType).append(" ").append(this.sessionContext.uri()).append(", remoteAddr=").append(this.sessionContext.remoteIP()).append(", localAddr=").append(this.sessionContext.localIP()).append("\n\tresponse_").append(txId).append("=").append(this.sessionContext.status()).append(", error=").append(errorCount).append(", FullHttpRequest.t0=").append(TimeUtil.toOffsetDateTime(this.sessionContext.startTimestamp(), this.zoneId)).append(", response=").append(responseTime).append("ms");
        this.sessionContext.reportPOI(null, sb);
        String sanitizedUserInput = SecurityUtil.sanitizeCRLF(this.httpPostRequestBody);
        long requestDataBytes = 0L;
        long responseDataBytes = 0L;
        NioServerHttpRequestHandler.verboseClientServerCommunication(null, requestHeaders, requestDataBytes, sanitizedUserInput, responseDataBytes, this.sessionContext, sb, isTraceAll);
        this.sessionContext.reportMemo(sb);
        this.sessionContext.reportError(sb);
        sb.append(BootConstant.BR);
        String report = sb.toString();
        ProcessorSettings processorSettings = this.sessionContext.processorSettings();
        if (!isTraceAll && processorSettings != null && (logSettings = processorSettings.getLogSettings()) != null && (protectedDataFields = logSettings.getProtectDataFieldsFromLogging()) != null) {
            for (String protectedDataField : protectedDataFields) {
                report = FormatterUtil.replaceDataField(report, protectedDataField, protectedContectReplaceWith);
            }
        }
        this.log.log(level, report);
    }
}

