/*
 * Decompiled with CFR 0.152.
 */
package org.summerboot.jexpress.nio.grpc;

import io.grpc.BindableService;
import io.grpc.NameResolverProvider;
import io.grpc.ServerBuilder;
import io.grpc.StatusRuntimeException;
import io.grpc.netty.shaded.io.grpc.netty.NettyChannelBuilder;
import io.grpc.netty.shaded.io.netty.handler.ssl.SslProvider;
import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.security.GeneralSecurityException;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.ThreadPoolExecutor;
import javax.naming.NamingException;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLException;
import javax.net.ssl.TrustManagerFactory;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.summerboot.jexpress.boot.config.BootConfig;
import org.summerboot.jexpress.nio.grpc.BootLoadBalancerProvider;
import org.summerboot.jexpress.nio.grpc.GRPCClientConfig;
import org.summerboot.jexpress.nio.grpc.GRPCServer;
import org.summerboot.jexpress.nio.server.SessionContext;
import org.summerboot.jexpress.security.SSLUtil;
import org.summerboot.jexpress.security.auth.AuthenticatorListener;
import org.summerboot.jexpress.security.auth.BootAuthenticator;
import org.summerboot.jexpress.security.auth.Caller;
import org.summerboot.jexpress.util.ApplicationUtil;

public abstract class GRPCTestHelper {
    public static GRPCServer buildGRPCServer(GRPCSimpleClient config, BindableService ... serviceImps) throws GeneralSecurityException, IOException {
        if (serviceImps == null || serviceImps.length == 0) {
            return null;
        }
        String host = config.getHost();
        int port = config.getPort();
        File keyStore = config.getKeyStore();
        File serverTrustStore = config.getServerTrustStore();
        String serverKeyAlias = config.getServerKeyAlias();
        String keyStorePassword = config.getKeyStorePassword();
        String keyPassword = config.getKeyPassword();
        String trustStorePassword = config.getTrustStorePassword();
        KeyManagerFactory kmfServer = SSLUtil.buildKeyManagerFactory(keyStore.getAbsolutePath(), keyStorePassword.toCharArray(), serverKeyAlias, keyPassword.toCharArray());
        TrustManagerFactory tmfServer = SSLUtil.buildTrustManagerFactory(serverTrustStore.getAbsolutePath(), trustStorePassword.toCharArray());
        return GRPCTestHelper.buildGRPCServer(host, port, kmfServer, tmfServer, serviceImps);
    }

    public static GRPCServer buildGRPCServer(String host, int port, KeyManagerFactory kmfServer, TrustManagerFactory tmfServer, BindableService ... serviceImps) throws IOException {
        if (serviceImps == null || serviceImps.length == 0) {
            return null;
        }
        ThreadPoolExecutor tpe = BootConfig.buildThreadPoolExecutor("");
        BootAuthenticator<Object> serverInterceptor = new BootAuthenticator<Object>(){

            @Override
            protected Caller authenticate(String usename, String password, Object metaData, AuthenticatorListener listener, SessionContext context) throws NamingException {
                return null;
            }
        };
        GRPCServer gRPCServer = new GRPCServer(host, port, kmfServer, tmfServer, tpe, true, false, null, serverInterceptor);
        ServerBuilder serverBuilder = gRPCServer.getServerBuilder();
        for (BindableService serviceImpl : serviceImps) {
            serverBuilder.addService(serviceImpl);
        }
        StringBuilder startingMemo = new StringBuilder();
        gRPCServer.start(false, startingMemo);
        return gRPCServer;
    }

    public static NettyChannelBuilder buildGRPCClient(GRPCSimpleClient config) throws IOException, GeneralSecurityException {
        String host = config.getHost();
        int port = config.getPort();
        String loadBalancingPolicy = config.getLoadBalancingPolicy();
        String loadBalancingTargetScheme = config.getLoadBalancingTargetScheme();
        File keyStore = config.getKeyStore();
        File clientTrustStore = config.getClientTrustStore();
        String clientKeyAlias = config.getClientKeyAlias();
        String overrideAuthority = config.getOverrideAuthority();
        String keyStorePassword = config.getKeyStorePassword();
        String keyPassword = config.getKeyPassword();
        String trustStorePassword = config.getTrustStorePassword();
        KeyManagerFactory kmfClient = SSLUtil.buildKeyManagerFactory(keyStore.getAbsolutePath(), keyStorePassword.toCharArray(), clientKeyAlias, keyPassword.toCharArray());
        TrustManagerFactory tmfClient = SSLUtil.buildTrustManagerFactory(clientTrustStore.getAbsolutePath(), trustStorePassword.toCharArray());
        String tlsProtocal = config.getTlsProtocalClient();
        return GRPCTestHelper.buildGRPCClient(tlsProtocal, host, port, loadBalancingPolicy, loadBalancingTargetScheme, kmfClient, tmfClient, overrideAuthority);
    }

    public static NettyChannelBuilder buildGRPCClient(String tlsProtocal, String host, int port, KeyManagerFactory kmfClient, TrustManagerFactory tmfClient, String overrideAuthority) throws SSLException {
        String loadBalancingPolicy = GRPCClientConfig.LoadBalancingPolicy.PICK_FIRST.getValue();
        String loadBalancingTargetScheme = "grpc";
        return GRPCTestHelper.buildGRPCClient(tlsProtocal, host, port, loadBalancingPolicy, loadBalancingTargetScheme, kmfClient, tmfClient, overrideAuthority);
    }

    public static NettyChannelBuilder buildGRPCClient(String tlsProtocal, String host, int port, String loadBalancingPolicy, String loadBalancingTargetScheme, KeyManagerFactory kmfClient, TrustManagerFactory tmfClient, String overrideAuthority) throws SSLException {
        int priority = 0;
        List<InetSocketAddress> loadBalancingServers = List.of(new InetSocketAddress(host, port));
        BootLoadBalancerProvider nameResolverProvider = new BootLoadBalancerProvider(loadBalancingTargetScheme, ++priority, loadBalancingServers);
        return GRPCClientConfig.initNettyChannelBuilder((NameResolverProvider)nameResolverProvider, loadBalancingPolicy, null, kmfClient, tmfClient, overrideAuthority, null, SslProvider.OPENSSL, tlsProtocal);
    }

    public void test2WayTLS() throws GeneralSecurityException, IOException {
        GRPCSimpleClient[] testConfigs;
        for (GRPCSimpleClient config : testConfigs = this.buildDefaultTestConfigs()) {
            System.out.println("Testing with config: " + String.valueOf(config));
            this.test2WayTLS(config);
        }
    }

    protected GRPCSimpleClient[] buildDefaultTestConfigs() throws GeneralSecurityException, IOException {
        return new GRPCSimpleClient[]{new GRPCSimpleClient(2048), new GRPCSimpleClient(4096)};
    }

    protected abstract BindableService[] getServerImpls();

    public void test2WayTLS(GRPCSimpleClient config) throws IOException {
        String tlsProtocalClient;
        BindableService[] serviceImpls;
        TrustManagerFactory tmfEmpty;
        TrustManagerFactory tmfClient;
        KeyManagerFactory kmfClient;
        TrustManagerFactory tmfServer;
        KeyManagerFactory kmfServer;
        String overrideAuthority;
        String loadBalancingTargetScheme;
        int port;
        String host;
        block7: {
            host = config.getHost();
            port = config.getPort();
            String loadBalancingPolicy = config.getLoadBalancingPolicy();
            loadBalancingTargetScheme = config.getLoadBalancingTargetScheme();
            overrideAuthority = config.getOverrideAuthority();
            kmfServer = config.getKmfServer();
            tmfServer = config.getTmfServer();
            kmfClient = config.getKmfClient();
            tmfClient = config.getTmfClient();
            tmfEmpty = config.getTmfEmpty();
            serviceImpls = this.getServerImpls();
            tlsProtocalClient = "TLSv1.3";
            this.test2WayTLS(host, port, kmfServer, tmfServer, serviceImpls, loadBalancingTargetScheme, tlsProtocalClient, kmfClient, tmfClient, overrideAuthority);
            this.test2WayTLS(host, port, kmfServer, null, serviceImpls, loadBalancingTargetScheme, tlsProtocalClient, kmfClient, tmfClient, overrideAuthority);
            this.test2WayTLS(host, port, kmfServer, null, serviceImpls, loadBalancingTargetScheme, tlsProtocalClient, null, tmfClient, overrideAuthority);
            this.test2WayTLS(host, port, null, null, serviceImpls, loadBalancingTargetScheme, null, null, null, overrideAuthority);
            try {
                this.test2WayTLS(host, port, kmfServer, null, serviceImpls, loadBalancingTargetScheme, tlsProtocalClient, kmfClient, null, overrideAuthority);
            }
            catch (StatusRuntimeException ex) {
                Throwable cause = ExceptionUtils.getRootCause((Throwable)ex);
                if ($assertionsDisabled || cause.getMessage().equals("unable to find valid certification path to requested target")) break block7;
                throw new AssertionError();
            }
        }
        try {
            this.test2WayTLS(host, port, kmfServer, tmfEmpty, serviceImpls, loadBalancingTargetScheme, tlsProtocalClient, kmfClient, tmfClient, overrideAuthority);
            throw new RuntimeException("Expected exception not thrown");
        }
        catch (StatusRuntimeException ex) {
            block8: {
                System.out.println("server does NOT trust client certificate - Expected exception: " + String.valueOf((Object)ex));
                assert (ex.getMessage().equals("UNAVAILABLE: ssl exception"));
                try {
                    this.test2WayTLS(host, port, kmfServer, tmfServer, serviceImpls, loadBalancingTargetScheme, tlsProtocalClient, kmfClient, tmfEmpty, overrideAuthority);
                }
                catch (StatusRuntimeException ex2) {
                    System.out.println("client does NOT trust server certificate - Expected exception: " + String.valueOf((Object)ex2));
                    String receivedMessage = ex2.getMessage();
                    if ($assertionsDisabled || receivedMessage.equals("UNAVAILABLE: io exception\nChannel Pipeline: [SslHandler#0, ProtocolNegotiators$ClientTlsHandler#0, WriteBufferingAndExceptionHandler#0, DefaultChannelPipeline$TailContext#0]")) break block8;
                    throw new AssertionError();
                }
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test2WayTLS(String host, int port, KeyManagerFactory kmfServer, TrustManagerFactory tmfServer, BindableService[] serviceImpls, String loadBalancingTargetScheme, String tlsProtocalClient, KeyManagerFactory kmfClient, TrustManagerFactory tmfClient, String overrideAuthority) throws IOException {
        GRPCServer gRPCServer = GRPCTestHelper.buildGRPCServer(host, port, kmfServer, tmfServer, serviceImpls);
        if (gRPCServer != null) {
            StringBuilder startingMemo = new StringBuilder();
            gRPCServer.start(false, startingMemo);
            System.out.println("gRPC Server started on " + host + ":" + port + " with " + String.valueOf(startingMemo));
        }
        try {
            String loadBalancingPolicy = GRPCClientConfig.LoadBalancingPolicy.PICK_FIRST.getValue();
            NettyChannelBuilder channelBuilder = GRPCTestHelper.buildGRPCClient(tlsProtocalClient, host, port, loadBalancingPolicy, loadBalancingTargetScheme, kmfClient, tmfClient, overrideAuthority);
            this.runClient(channelBuilder);
        }
        finally {
            if (gRPCServer != null) {
                gRPCServer.shutdown();
            }
        }
    }

    protected abstract void runClient(NettyChannelBuilder var1);

    public static class GRPCSimpleClient {
        private final String testName;
        private final int length;
        private String configDir;
        private File keyStore;
        private File serverTrustStore;
        private File clientTrustStore;
        private File emptyTrustStore;
        private String serverKeyAlias;
        private String clientKeyAlias;
        private String overrideAuthority;
        private String keyStorePassword;
        private String keyPassword;
        private String trustStorePassword;
        private KeyManagerFactory kmfServer;
        private TrustManagerFactory tmfServer;
        private KeyManagerFactory kmfClient;
        private TrustManagerFactory tmfClient;
        private TrustManagerFactory tmfEmpty;
        private String host = "localhost";
        private int port = 8425;
        private String loadBalancingPolicy = GRPCClientConfig.LoadBalancingPolicy.PICK_FIRST.getValue();
        private String loadBalancingTargetScheme = "grpc";
        private String tlsProtocalClient = "TLSv1.3";

        public GRPCSimpleClient(int length) throws GeneralSecurityException, IOException {
            this("GRPCTestHelper " + length, length, "src/test/resources/config/");
        }

        public GRPCSimpleClient(String testName, int length) throws GeneralSecurityException, IOException {
            this(testName, length, "src/test/resources/config/");
        }

        public GRPCSimpleClient(String testName, int length, String configDir) throws GeneralSecurityException, IOException {
            String defaultPassword;
            this.testName = testName;
            this.length = length;
            this.configDir = configDir;
            this.serverKeyAlias = "server2_" + length + ".jexpress.org";
            this.clientKeyAlias = "server3_" + length + ".jexpress.org";
            this.overrideAuthority = "server2." + length + ".jexpress.org";
            ClassLoader classLoader = this.getClass().getClassLoader();
            Properties testProp = ApplicationUtil.getPropertiesFromResource("application-test.properties", classLoader);
            this.keyStorePassword = defaultPassword = testProp.getProperty("test.p12.password");
            this.keyPassword = defaultPassword;
            this.trustStorePassword = defaultPassword;
            this.updateTLS(configDir);
        }

        public void updateTLS(String configDir) throws GeneralSecurityException, IOException {
            this.keyStore = new File(configDir + "keystore.p12").getAbsoluteFile();
            this.createIfNotExist("keystore.p12", this.keyStore);
            this.serverTrustStore = new File(configDir + "truststore_server.p12").getAbsoluteFile();
            this.createIfNotExist("truststore.p12", this.serverTrustStore);
            this.clientTrustStore = new File(configDir + "truststore_client.p12").getAbsoluteFile();
            this.createIfNotExist("truststore.p12", this.clientTrustStore);
            this.emptyTrustStore = new File(configDir + "truststore_empty.p12").getAbsoluteFile();
            this.createIfNotExist("truststore_empty.p12", this.emptyTrustStore);
            this.kmfServer = SSLUtil.buildKeyManagerFactory(this.keyStore.getAbsolutePath(), this.keyStorePassword.toCharArray(), this.serverKeyAlias, this.keyPassword.toCharArray());
            this.tmfServer = SSLUtil.buildTrustManagerFactory(this.serverTrustStore.getAbsolutePath(), this.trustStorePassword.toCharArray());
            this.kmfClient = SSLUtil.buildKeyManagerFactory(this.keyStore.getAbsolutePath(), this.keyStorePassword.toCharArray(), this.clientKeyAlias, this.keyPassword.toCharArray());
            this.tmfClient = SSLUtil.buildTrustManagerFactory(this.clientTrustStore.getAbsolutePath(), this.trustStorePassword.toCharArray());
            this.tmfEmpty = SSLUtil.buildTrustManagerFactory(this.emptyTrustStore.getAbsolutePath(), this.trustStorePassword.toCharArray());
        }

        public void createIfNotExist(String srcFileName, File destFile) {
            File parentDir = destFile.getParentFile();
            String location = destFile.getParent();
            String destFileName = destFile.getName();
            ClassLoader classLoader = this.getClass().getClassLoader();
            ApplicationUtil.createIfNotExist(location, classLoader, srcFileName, destFileName);
        }

        public String toString() {
            return "GRPCSimpleClient{name=" + this.testName + "length=" + this.length + ", configDir='" + this.configDir + "', port=" + this.port + ", host='" + this.host + "'}";
        }

        public String getConfigDir() {
            return this.configDir;
        }

        public void setConfigDir(String configDir) throws GeneralSecurityException, IOException {
            this.configDir = configDir;
            this.updateTLS(configDir);
        }

        public File getKeyStore() {
            return this.keyStore;
        }

        public void setKeyStore(File keyStore) {
            this.keyStore = keyStore;
        }

        public File getServerTrustStore() {
            return this.serverTrustStore;
        }

        public void setServerTrustStore(File serverTrustStore) {
            this.serverTrustStore = serverTrustStore;
        }

        public File getClientTrustStore() {
            return this.clientTrustStore;
        }

        public void setClientTrustStore(File clientTrustStore) {
            this.clientTrustStore = clientTrustStore;
        }

        public File getEmptyTrustStore() {
            return this.emptyTrustStore;
        }

        public void setEmptyTrustStore(File emptyTrustStore) {
            this.emptyTrustStore = emptyTrustStore;
        }

        public String getServerKeyAlias() {
            return this.serverKeyAlias;
        }

        public void setServerKeyAlias(String serverKeyAlias) {
            this.serverKeyAlias = serverKeyAlias;
        }

        public String getClientKeyAlias() {
            return this.clientKeyAlias;
        }

        public void setClientKeyAlias(String clientKeyAlias) {
            this.clientKeyAlias = clientKeyAlias;
        }

        public String getOverrideAuthority() {
            return this.overrideAuthority;
        }

        public void setOverrideAuthority(String overrideAuthority) {
            this.overrideAuthority = overrideAuthority;
        }

        public String getKeyStorePassword() {
            return this.keyStorePassword;
        }

        public void setKeyStorePassword(String keyStorePassword) {
            this.keyStorePassword = keyStorePassword;
        }

        public String getKeyPassword() {
            return this.keyPassword;
        }

        public void setKeyPassword(String keyPassword) {
            this.keyPassword = keyPassword;
        }

        public String getTrustStorePassword() {
            return this.trustStorePassword;
        }

        public void setTrustStorePassword(String trustStorePassword) {
            this.trustStorePassword = trustStorePassword;
        }

        public String getHost() {
            return this.host;
        }

        public void setHost(String host) {
            this.host = host;
        }

        public int getPort() {
            return this.port;
        }

        public void setPort(int port) {
            this.port = port;
        }

        public String getLoadBalancingPolicy() {
            return this.loadBalancingPolicy;
        }

        public void setLoadBalancingPolicy(String loadBalancingPolicy) {
            this.loadBalancingPolicy = loadBalancingPolicy;
        }

        public String getLoadBalancingTargetScheme() {
            return this.loadBalancingTargetScheme;
        }

        public void setLoadBalancingTargetScheme(String loadBalancingTargetScheme) {
            this.loadBalancingTargetScheme = loadBalancingTargetScheme;
        }

        public KeyManagerFactory getKmfServer() {
            return this.kmfServer;
        }

        public TrustManagerFactory getTmfServer() {
            return this.tmfServer;
        }

        public KeyManagerFactory getKmfClient() {
            return this.kmfClient;
        }

        public TrustManagerFactory getTmfClient() {
            return this.tmfClient;
        }

        public TrustManagerFactory getTmfEmpty() {
            return this.tmfEmpty;
        }

        public String getTlsProtocalClient() {
            return this.tlsProtocalClient;
        }

        public void setTlsProtocalClient(String tlsProtocalClient) {
            this.tlsProtocalClient = tlsProtocalClient;
        }
    }
}

