/*
 * Decompiled with CFR 0.152.
 */
package org.summerboot.jexpress.nio.server;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.group.ChannelGroup;
import io.netty.channel.group.DefaultChannelGroup;
import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.netty.handler.codec.http.websocketx.ContinuationWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.netty.util.AttributeKey;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.GlobalEventExecutor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.summerboot.jexpress.nio.server.NioConfig;
import org.summerboot.jexpress.nio.server.NioHttpUtil;
import org.summerboot.jexpress.security.auth.Caller;

public abstract class BootWebSocketHandler
extends SimpleChannelInboundHandler<WebSocketFrame> {
    protected Logger log = LogManager.getLogger(((Object)((Object)this)).getClass());
    protected static final TextWebSocketFrame MSG_AUTH_FAILED = new TextWebSocketFrame("401 Unauthorized");
    protected static final ChannelGroup clients = new DefaultChannelGroup((EventExecutor)GlobalEventExecutor.INSTANCE);
    protected static final AttributeKey KEY_CALLER = AttributeKey.valueOf((String)"caller");

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        clients.remove((Object)ctx.channel());
        NioHttpUtil.onExceptionCaught(ctx, cause, this.log);
    }

    protected void channelRead0(ChannelHandlerContext ctx, WebSocketFrame msg) throws Exception {
        if (msg instanceof TextWebSocketFrame) {
            this.channelRead0(ctx, (TextWebSocketFrame)msg);
        } else if (msg instanceof BinaryWebSocketFrame) {
            this.channelRead0(ctx, (BinaryWebSocketFrame)msg);
        } else if (msg instanceof ContinuationWebSocketFrame) {
            this.channelRead0(ctx, (ContinuationWebSocketFrame)msg);
        }
    }

    protected void channelRead0(ChannelHandlerContext ctx, BinaryWebSocketFrame msg) throws Exception {
        ByteBuf bb = msg.content();
        byte[] data = ByteBufUtil.getBytes((ByteBuf)bb);
        Runnable asyncTask = () -> {
            Caller caller = (Caller)ctx.channel().attr(KEY_CALLER).get();
            if (caller == null) {
                clients.remove((Object)ctx.channel());
                ctx.writeAndFlush((Object)MSG_AUTH_FAILED.retainedDuplicate());
                ctx.close();
                this.log.warn("Binary auth failed " + String.valueOf(ctx.channel().remoteAddress()));
                return;
            }
            String responseText = this.onMessage(ctx, caller, data);
            if (responseText != null) {
                BootWebSocketHandler.sendToChannel(ctx, responseText);
            }
        };
        NioConfig.cfg.getBizExecutor().execute(asyncTask);
    }

    protected void channelRead0(ChannelHandlerContext ctx, TextWebSocketFrame msg) throws Exception {
        String txt = msg.text();
        Runnable asyncTask = () -> {
            Caller caller = (Caller)ctx.channel().attr(KEY_CALLER).get();
            if (caller == null) {
                caller = this.auth(txt);
                if (caller == null) {
                    clients.remove((Object)ctx.channel());
                    ctx.writeAndFlush((Object)MSG_AUTH_FAILED.retainedDuplicate());
                    ctx.close();
                    this.log.warn("Text auth failed " + String.valueOf(ctx.channel().remoteAddress()) + ": " + txt);
                    return;
                }
                ctx.channel().attr(KEY_CALLER).set((Object)caller);
                String message = this.onCallerConnected(ctx, caller);
                if (message != null) {
                    BootWebSocketHandler.sendToAllChannels(message, true);
                }
                return;
            }
            String responseText = this.onMessage(ctx, caller, txt);
            if (responseText != null) {
                BootWebSocketHandler.sendToChannel(ctx, responseText);
            }
        };
        NioConfig.cfg.getBizExecutor().execute(asyncTask);
    }

    protected void channelRead0(ChannelHandlerContext ctx, ContinuationWebSocketFrame msg) throws Exception {
    }

    protected abstract Caller auth(String var1);

    protected abstract String onCallerConnected(ChannelHandlerContext var1, Caller var2);

    protected abstract String onMessage(ChannelHandlerContext var1, Caller var2, String var3);

    protected abstract String onMessage(ChannelHandlerContext var1, Caller var2, byte[] var3);

    public static void sendToChannel(ChannelHandlerContext ctx, String message) {
        ctx.writeAndFlush((Object)new TextWebSocketFrame(message));
    }

    public static void sendToChannel(ChannelHandlerContext ctx, byte[] data) {
        ctx.writeAndFlush((Object)new BinaryWebSocketFrame(Unpooled.copiedBuffer((byte[])data)));
    }

    public static void sendToAllChannels(String text, boolean auth) {
        TextWebSocketFrame message = new TextWebSocketFrame(text);
        BootWebSocketHandler.sendToAllChannels((WebSocketFrame)message, auth);
    }

    public static void sendToAllChannels(byte[] data, boolean auth) {
        BinaryWebSocketFrame message = new BinaryWebSocketFrame(Unpooled.copiedBuffer((byte[])data));
        BootWebSocketHandler.sendToAllChannels((WebSocketFrame)message, auth);
    }

    public static void sendToAllChannels(WebSocketFrame message, boolean auth) {
        if (auth) {
            clients.stream().filter(channel -> channel.attr(KEY_CALLER).get() != null).forEach(channel -> channel.writeAndFlush((Object)message.retainedDuplicate()));
        } else {
            clients.stream().forEach(channel -> channel.writeAndFlush((Object)message.retainedDuplicate()));
        }
    }

    public void handlerAdded(ChannelHandlerContext ctx) {
        clients.add((Object)ctx.channel());
        this.log.trace(() -> "handlerAdded: " + String.valueOf(ctx.channel().remoteAddress()));
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        this.log.trace(() -> "channelActive: " + String.valueOf(ctx.channel().remoteAddress()));
    }

    public void handlerRemoved(ChannelHandlerContext ctx) {
        clients.remove((Object)ctx.channel());
        this.log.trace(() -> "handlerRemoved: " + String.valueOf(ctx.channel().remoteAddress()));
    }
}

