/*
 * Decompiled with CFR 0.152.
 */
package org.summerboot.jexpress.nio.server;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.SocketAddress;
import java.net.URLEncoder;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.logging.log4j.Level;
import org.summerboot.jexpress.boot.BootConstant;
import org.summerboot.jexpress.nio.server.NioConfig;
import org.summerboot.jexpress.nio.server.NioHttpUtil;
import org.summerboot.jexpress.nio.server.ResponseEncoder;
import org.summerboot.jexpress.nio.server.domain.Err;
import org.summerboot.jexpress.nio.server.domain.ProcessorSettings;
import org.summerboot.jexpress.nio.server.domain.ServiceError;
import org.summerboot.jexpress.security.SecurityUtil;
import org.summerboot.jexpress.security.auth.Caller;
import org.summerboot.jexpress.util.BeanUtil;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
public class SessionContext {
    protected final SocketAddress localIP;
    protected final SocketAddress remoteIP;
    protected final String protocol;
    protected final HttpMethod requestMethod;
    protected final String requestURI;
    protected final HttpHeaders requestHeaders;
    protected final String requestBody;
    protected final String txId;
    protected final long hit;
    protected final long startTs;
    protected final OffsetDateTime startDateTime;
    protected Caller caller;
    protected String callerId;
    protected HttpResponseStatus status = HttpResponseStatus.OK;
    protected boolean autoConvertBlank200To204 = true;
    protected HttpHeaders responseHeaders;
    protected ResponseEncoder responseEncoder = null;
    protected String contentType;
    protected String clientAcceptContentType;
    protected String charsetName;
    protected byte[] data;
    protected String txt = "";
    protected File file;
    protected boolean downloadMode = true;
    protected String redirect;
    protected final List<POI> poi = new ArrayList<POI>();
    protected List<Memo> memo;
    protected Map<Object, Object> sessionAttributes;
    protected ProcessorSettings processorSettings;
    protected ServiceError serviceError;
    protected Throwable cause;
    protected Level level = Level.INFO;
    protected boolean logRequestHeader = true;
    protected boolean logResponseHeader = true;
    protected boolean logRequestBody = true;
    protected boolean logResponseBody = true;

    public static SessionContext build(long hit) {
        return SessionContext.build(BootConstant.APP_ID + "-" + hit, hit);
    }

    public static SessionContext build(String txId, long hit) {
        return new SessionContext(null, txId, hit, System.currentTimeMillis(), null, null, null, null, null);
    }

    public static SessionContext build(ChannelHandlerContext ctx, String txId, long hit, long startTs, HttpHeaders requestHeaders, String protocol, HttpMethod requestMethod, String requestURI, String requestBody) {
        return new SessionContext(ctx, txId, hit, startTs, requestHeaders, protocol, requestMethod, requestURI, requestBody);
    }

    public String toString() {
        return "SessionContext{status=" + String.valueOf(this.status) + ", responseHeaders=" + String.valueOf(this.responseHeaders) + ", contentType=" + this.contentType + ", data=" + String.valueOf(this.data) + ", txt=" + this.txt + ", errors=" + String.valueOf(this.serviceError) + ", level=" + String.valueOf(this.level) + ", logReqHeader=" + this.logRequestHeader + ", logRespHeader=" + this.logResponseHeader + ", logReqContent=" + this.logRequestBody + ", logRespContent=" + this.logResponseBody + "}";
    }

    protected SessionContext(ChannelHandlerContext ctx, String txId, long hit, long startTs, HttpHeaders requestHeaders, String protocol, HttpMethod requestMethod, String requestURI, String requestBody) {
        if (ctx != null && ctx.channel() != null) {
            this.localIP = ctx.channel().localAddress();
            this.remoteIP = ctx.channel().remoteAddress();
        } else {
            this.localIP = null;
            this.remoteIP = null;
        }
        this.txId = txId;
        this.hit = hit;
        this.startTs = startTs;
        this.startDateTime = OffsetDateTime.ofInstant(Instant.ofEpochMilli(startTs), ZoneId.systemDefault());
        this.requestHeaders = requestHeaders;
        this.protocol = protocol;
        this.requestMethod = requestMethod;
        this.requestURI = requestURI;
        this.requestBody = requestBody;
        this.poi.add(new POI("service.begin"));
    }

    public SessionContext(SocketAddress localIP, SocketAddress remoteIP, String txId, long hit, long startTs, HttpHeaders requestHeaders, String protocol, HttpMethod requestMethod, String requestURI, String requestBody) {
        this.localIP = localIP;
        this.remoteIP = remoteIP;
        this.txId = txId;
        this.hit = hit;
        this.startTs = startTs;
        this.startDateTime = OffsetDateTime.ofInstant(Instant.ofEpochMilli(startTs), ZoneId.systemDefault());
        this.requestHeaders = requestHeaders;
        this.protocol = protocol;
        this.requestMethod = requestMethod;
        this.requestURI = requestURI;
        this.requestBody = requestBody;
        this.poi.add(new POI("service.begin"));
    }

    public Map<Object, Object> session() {
        return this.session(true);
    }

    public Map<Object, Object> session(boolean create) {
        if (this.sessionAttributes == null && create) {
            this.sessionAttributes = new HashMap<Object, Object>();
        }
        return this.sessionAttributes;
    }

    public <T> T sessionAttribute(Object key) {
        return (T)(this.sessionAttributes == null ? null : this.sessionAttributes.get(key));
    }

    public SessionContext sessionAttribute(Object key, Object value) {
        if (this.sessionAttributes == null) {
            this.sessionAttributes = new HashMap<Object, Object>();
        }
        if (key == null && value == null) {
            this.sessionAttributes.clear();
            return this;
        }
        if (value == null) {
            this.sessionAttributes.remove(key);
        } else {
            this.sessionAttributes.put(key, value);
        }
        return this;
    }

    public SocketAddress localIP() {
        return this.localIP;
    }

    public SocketAddress remoteIP() {
        return this.remoteIP;
    }

    public long startTimestamp() {
        return this.startTs;
    }

    public OffsetDateTime startDateTime() {
        return this.startDateTime;
    }

    public SessionContext resetResponseData() {
        this.txt = "";
        this.file = null;
        this.redirect = null;
        this.data = null;
        this.serviceError = null;
        this.cause = null;
        this.status = HttpResponseStatus.OK;
        this.level(Level.INFO);
        return this;
    }

    public String txId() {
        return this.txId;
    }

    public long hit() {
        return this.hit;
    }

    public HttpMethod method() {
        return this.requestMethod;
    }

    public String uri() {
        return this.requestURI;
    }

    public String requestBody() {
        return this.requestBody;
    }

    public HttpResponseStatus status() {
        return this.status;
    }

    public SessionContext status(HttpResponseStatus status) {
        return this.status(status, null);
    }

    public SessionContext status(HttpResponseStatus status, Boolean autoConvertBlank200To204) {
        this.status = status;
        if (autoConvertBlank200To204 != null) {
            this.autoConvertBlank200To204 = autoConvertBlank200To204;
        }
        return this;
    }

    public HttpHeaders requestHeaders() {
        return this.requestHeaders;
    }

    public HttpHeaders responseHeaders() {
        return this.responseHeaders;
    }

    public SessionContext responseHeaders(HttpHeaders headers) {
        if (headers == null || headers.isEmpty()) {
            return this;
        }
        if (this.responseHeaders == null) {
            this.responseHeaders = new DefaultHttpHeaders();
        }
        this.responseHeaders.set(headers);
        return this;
    }

    public SessionContext responseHeader(String key, Object value) {
        if (StringUtils.isBlank((CharSequence)key)) {
            return this;
        }
        if (this.responseHeaders == null) {
            this.responseHeaders = new DefaultHttpHeaders();
        }
        if (value == null) {
            this.responseHeaders.remove(key);
        } else {
            this.responseHeaders.set(key, value);
        }
        return this;
    }

    public SessionContext responseHeader(String key, Iterable<?> values) {
        if (StringUtils.isBlank((CharSequence)key)) {
            return this;
        }
        if (this.responseHeaders == null) {
            this.responseHeaders = new DefaultHttpHeaders();
        }
        if (values == null) {
            this.responseHeaders.remove(key);
        } else {
            this.responseHeaders.set(key, values);
        }
        return this;
    }

    public SessionContext responseHeaders(Map<String, ? extends Iterable<?>> hs) {
        if (hs == null) {
            return this;
        }
        if (this.responseHeaders == null) {
            this.responseHeaders = new DefaultHttpHeaders();
        }
        hs.keySet().stream().filter(key -> StringUtils.isNotBlank((CharSequence)key)).forEachOrdered(key -> {
            Iterable values = (Iterable)hs.get(key);
            if (values == null) {
                this.responseHeaders.remove(key);
            } else {
                this.responseHeaders.set(key, values);
            }
        });
        return this;
    }

    public ResponseEncoder responseEncoder() {
        return this.responseEncoder;
    }

    public SessionContext responseEncoder(ResponseEncoder responseEncoder) {
        this.responseEncoder = responseEncoder;
        return this;
    }

    public String contentType() {
        return this.contentType;
    }

    public SessionContext contentType(String contentType) {
        this.contentType = contentType;
        return this;
    }

    public String clientAcceptContentType() {
        return this.clientAcceptContentType;
    }

    public SessionContext clientAcceptContentType(String clientAcceptContentType) {
        this.clientAcceptContentType = clientAcceptContentType;
        return this;
    }

    public String charsetName() {
        return this.charsetName;
    }

    public SessionContext charsetName(String charsetName) {
        this.charsetName = charsetName;
        return this;
    }

    public String redirect() {
        return this.redirect;
    }

    public SessionContext redirect(String redirect) {
        return this.redirect(redirect, HttpResponseStatus.TEMPORARY_REDIRECT);
    }

    public SessionContext redirect(String redirect, HttpResponseStatus status) {
        this.redirect = redirect;
        this.txt = null;
        this.file = null;
        this.status = status;
        this.responseHeader(HttpHeaderNames.LOCATION.toString(), redirect);
        return this;
    }

    public String txt() {
        return this.txt;
    }

    public SessionContext response(String txt) {
        this.txt = txt;
        return this;
    }

    public byte[] data() {
        return this.data;
    }

    public SessionContext data(byte[] data) {
        this.data = data;
        return this;
    }

    public File file() {
        return this.file;
    }

    public boolean isDownloadMode() {
        return this.downloadMode;
    }

    public SessionContext downloadMode(boolean downloadMode) {
        this.downloadMode = downloadMode;
        return this;
    }

    public SessionContext response(String fileName, boolean isDownloadMode) {
        Object targetFileName = NioConfig.cfg.getDocrootDir() + File.separator + fileName;
        targetFileName = ((String)targetFileName).replace('/', File.separatorChar);
        File targetFile = new File((String)targetFileName).getAbsoluteFile();
        return this.response(targetFile, isDownloadMode);
    }

    public SessionContext response(File file, boolean isDownloadMode) {
        long fileLength;
        this.downloadMode = isDownloadMode;
        this.file = null;
        this.memo("file." + (isDownloadMode ? "download" : "view"), file.getAbsolutePath());
        if (!SecurityUtil.precheckFile(file, this)) {
            file = NioHttpUtil.buildErrorFile(this);
        }
        this.txt = null;
        this.redirect = null;
        this.file = file;
        this.contentType = NioHttpUtil.getFileContentType(file);
        if (this.responseHeaders == null) {
            this.responseHeaders = new DefaultHttpHeaders();
        }
        if ((fileLength = file.length()) > Integer.MAX_VALUE) {
            this.responseHeaders.set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)String.valueOf(fileLength));
        } else {
            this.responseHeaders.setInt((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (int)fileLength);
        }
        this.responseHeaders.set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)this.contentType);
        if (this.downloadMode) {
            String fileName = file.getName();
            try {
                fileName = URLEncoder.encode(fileName, "UTF-8").replace("+", "%20");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            this.responseHeaders.set((CharSequence)HttpHeaderNames.CONTENT_DISPOSITION, (Object)("attachment;filename=" + fileName + ";filename*=UTF-8''" + fileName));
        }
        return this;
    }

    public SessionContext response(Object ret) throws JsonProcessingException {
        if (ret == null) {
            return this;
        }
        if (ret instanceof File) {
            this.response((File)ret, true);
        } else {
            String responseContentType = this.clientAcceptContentType == null ? "application/json" : (this.clientAcceptContentType.contains("json") ? "application/json" : (this.clientAcceptContentType.contains("xml") ? "application/xml" : (this.clientAcceptContentType.contains("txt") ? "text/html" : "application/json")));
            if (ret instanceof String) {
                this.response((String)ret);
            } else {
                switch (responseContentType) {
                    case "application/json": {
                        this.response(BeanUtil.toJson(ret));
                        break;
                    }
                    case "application/xml": 
                    case "text/xml": {
                        this.response(BeanUtil.toXML(ret));
                        break;
                    }
                    case "text/html": 
                    case "text/plain": {
                        this.response(ret.toString());
                    }
                }
            }
            if (this.contentType() == null) {
                this.contentType(responseContentType);
            }
        }
        return this;
    }

    public <T extends Caller> T caller() {
        return (T)this.caller;
    }

    public <T extends Caller> SessionContext caller(T caller) {
        this.caller = caller;
        return this;
    }

    public String callerId() {
        return this.callerId;
    }

    public SessionContext callerId(String callerId) {
        this.callerId = callerId;
        return this;
    }

    public boolean isCallerInRole(String role) {
        if (this.caller == null || StringUtils.isBlank((CharSequence)role)) {
            return false;
        }
        return this.caller.isInRole(role);
    }

    public boolean hasError() {
        return this.serviceError != null && this.serviceError.getErrors() != null && !this.serviceError.getErrors().isEmpty();
    }

    public List<Err> errors() {
        return this.hasError() ? this.serviceError.getErrors() : null;
    }

    public ServiceError error() {
        return this.serviceError;
    }

    public SessionContext error(Err error2) {
        if (this.serviceError == null) {
            this.serviceError = new ServiceError(this.txId);
        }
        if (error2 == null) {
            return this;
        }
        this.serviceError.addError(error2);
        Throwable t = error2.getCause();
        if (t != null) {
            this.cause = t;
        }
        if (error2.getCause() != null) {
            this.level(Level.ERROR);
        }
        return this;
    }

    public SessionContext errors(Collection<Err> es) {
        if (es == null || es.isEmpty()) {
            if (this.serviceError != null && this.serviceError.getErrors() != null) {
                this.serviceError.getErrors().clear();
                this.serviceError = null;
            }
            return this;
        }
        if (this.serviceError == null) {
            this.serviceError = new ServiceError(this.txId);
        }
        this.serviceError.addErrors(es);
        for (Err e : es) {
            Throwable t = e.getCause();
            if (t != null) {
                this.cause = t;
            }
            if (this.cause == null) continue;
            this.level(Level.ERROR);
        }
        return this;
    }

    public SessionContext cause(Throwable cause) {
        this.cause = cause;
        if (cause != null) {
            Throwable root = ExceptionUtils.getRootCause((Throwable)cause);
            if (root == null || root.equals(cause)) {
                if (this.level().isLessSpecificThan(Level.WARN)) {
                    this.level(Level.WARN);
                }
            } else if (this.level().isLessSpecificThan(Level.ERROR)) {
                this.level(Level.ERROR);
            }
        }
        return this;
    }

    public Throwable cause() {
        return this.cause;
    }

    public Level level() {
        return this.level;
    }

    public SessionContext level(Level level) {
        this.level = level;
        return this;
    }

    public SessionContext logRequestHeader(boolean enabled) {
        this.logRequestHeader = enabled;
        return this;
    }

    public boolean logRequestHeader() {
        return this.logRequestHeader;
    }

    public SessionContext logRequestBody(boolean enabled) {
        this.logRequestBody = enabled;
        return this;
    }

    public boolean logRequestBody() {
        return this.logRequestBody;
    }

    public SessionContext logResponseHeader(boolean enabled) {
        this.logResponseHeader = enabled;
        return this;
    }

    public boolean logResponseHeader() {
        return this.logResponseHeader;
    }

    public SessionContext logResponseBody(boolean enabled) {
        this.logResponseBody = enabled;
        return this;
    }

    public boolean logResponseBody() {
        return this.logResponseBody;
    }

    public ProcessorSettings processorSettings() {
        return this.processorSettings;
    }

    public SessionContext processorSettings(ProcessorSettings processorSettings) {
        this.processorSettings = processorSettings;
        return this;
    }

    public SessionContext poi(String marker) {
        this.poi.add(new POI(marker));
        return this;
    }

    public List<POI> poi() {
        return this.poi;
    }

    public SessionContext memo(String desc) {
        return this.memo(null, desc);
    }

    public SessionContext memo(String id, String desc) {
        if (this.memo == null) {
            this.memo = new ArrayList<Memo>();
        }
        this.memo.add(new Memo(id, desc));
        return this;
    }

    public List<Memo> memo() {
        return this.memo;
    }

    public boolean autoConvertBlank200To204() {
        return this.autoConvertBlank200To204;
    }

    public StringBuilder report() {
        StringBuilder sb = new StringBuilder();
        this.report(sb);
        return sb;
    }

    public SessionContext report(StringBuilder sb) {
        this.reportPOI(sb);
        this.reportMemo(sb);
        this.reportError(sb);
        return this;
    }

    public SessionContext reportOverall(long queuingTime, long processTime, long responseTime, StringBuilder sb) {
        int errorCount = this.serviceError != null ? (this.serviceError.getErrors() == null ? 1 : Math.max(1, this.serviceError.getErrors().size())) : 0;
        sb.append("[").append(this.txId).append(" ").append(this.localIP).append("] [").append(this.status).append(", error=").append(errorCount).append(", queuing=").append(queuingTime).append("ms, process=").append(processTime).append("ms, response=").append(responseTime).append("ms] ").append(this.protocol).append(" ").append(this.requestMethod).append(" ").append(this.requestURI).append(", ").append(this.remoteIP).append("=").append(this.caller == null ? this.callerId : this.caller);
        return this;
    }

    public SessionContext reportPOI(StringBuilder sb) {
        return this.reportPOI(null, sb);
    }

    public SessionContext reportPOI(NioConfig cfg, StringBuilder sb) {
        if (this.poi == null || this.poi.isEmpty()) {
            sb.append(BootConstant.BR + "\tPOI: n/a");
            return this;
        }
        NioConfig.VerboseTargetPOIType filterType = cfg == null ? NioConfig.VerboseTargetPOIType.all : cfg.getFilterPOIType();
        sb.append(BootConstant.BR + "\tPOI.t0=").append(this.startDateTime).append(" ");
        switch (filterType) {
            case all: {
                this.poi.forEach(p -> sb.append(p.name).append("=").append(p.ts - this.startTs).append("ms, "));
                break;
            }
            case filter: {
                Set<String> poiSet = cfg.getFilterPOISet();
                this.poi.stream().filter(p -> poiSet.contains(p.name)).forEachOrdered(p -> sb.append(p.name).append("=").append(p.ts - this.startTs).append("ms, "));
                break;
            }
            case ignore: {
                sb.append("off");
            }
        }
        return this;
    }

    public SessionContext reportMemo(StringBuilder sb) {
        if (this.memo == null || this.memo.isEmpty()) {
            return this;
        }
        sb.append(BootConstant.BR + BootConstant.BR + "\tMemo: ");
        this.memo.forEach(m -> {
            if (m.id == null || m.id.isEmpty()) {
                sb.append(BootConstant.BR + "\t\t").append(m.desc);
            } else {
                sb.append(BootConstant.BR + "\t\t").append(m.id).append(BootConstant.MEMO_DELIMITER).append(m.desc);
            }
        });
        return this;
    }

    public SessionContext reportError(StringBuilder sb) {
        if (this.serviceError == null) {
            return this;
        }
        sb.append(BootConstant.BR + BootConstant.BR + "\t");
        this.serviceError.toStringWithStackTrace(sb);
        return this;
    }

    public static class POI {
        public final String name;
        public final long ts = System.currentTimeMillis();

        public POI(String name) {
            this.name = name;
        }
    }

    public static class Memo {
        public final String id;
        public final String desc;

        public Memo(String id, String desc) {
            this.id = id;
            this.desc = desc;
        }
    }
}

