/*
 * Decompiled with CFR 0.152.
 */
package org.summerboot.jexpress.security;

import jakarta.annotation.Nullable;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.ProviderException;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.time.LocalDateTime;
import java.util.Base64;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.pkcs.EncryptedPrivateKeyInfo;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.bouncycastle.openssl.jcajce.JceOpenSSLPKCS8DecryptorProviderBuilder;
import org.bouncycastle.operator.InputDecryptorProvider;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.pkcs.PKCS8EncryptedPrivateKeyInfo;
import org.bouncycastle.pkcs.PKCSException;
import org.summerboot.jexpress.boot.BackOffice;
import org.summerboot.jexpress.boot.BootErrorCode;
import org.summerboot.jexpress.util.ApplicationUtil;
import org.summerboot.jexpress.util.FormatterUtil;

public class EncryptorUtil {
    public static final String KEYSTORE_TYPE = BackOffice.agent.getKeystoreType();
    public static final String KEYSTORE_PROVIDER = BackOffice.agent.getKeystoreSecurityProvider();
    public static final String ALGORITHM_MESSAGEDIGEST = BackOffice.agent.getAlgorithmMessagedigest();
    public static final String ALGORITHM_ASYMMETRIC_KEY = BackOffice.agent.getAlgorithmAsymmetricKey();
    public static final String CIPHERS_TRANSFORMATION_ASYMMETRIC = BackOffice.agent.getCiphersTransformationAsymmetric();
    public static final String ALGORITHM_SYMMETRIC_KEY = BackOffice.agent.getAlgorithmSymmetricKey();
    public static final int ALGORITHM_SYMMETRIC_KEY_BITS = BackOffice.agent.getAlgorithmSymmetricKeyBits();
    public static final String CIPHERS_TRANSFORMATION_SYMMETRIC = BackOffice.agent.getCiphersTransformationSymmetric();
    public static final int SYMMETRIC_KEY_AUTHENTICATION_TAG_BITS = BackOffice.agent.getSymmetricKeyAuthenticationTagBits();
    public static final int SYMMETRIC_KEY_IV_BYTES = BackOffice.agent.getSymmetricKeyInitializationVectorBytes();
    public static final String ALGORITHM_SECRET_KEY = BackOffice.agent.getAlgorithmSecretKey();
    public static final int ALGORITHM_SECRET_KEY_BITS = BackOffice.agent.getAlgorithmSecretKeyBits();
    public static final int ALGORITHM_SECRET_KEY_SALT_BYTES = BackOffice.agent.getAlgorithmSecretKeySaltBytes();
    public static final int ALGORITHM_SECRET_KEY_ITERATION_COUNT = BackOffice.agent.getAlgorithmSecretKeyIterationCount();
    public static final BouncyCastleProvider PROVIDER = new BouncyCastleProvider();
    private static char[] MASTER_PASSWORD;
    protected static SecureRandom RANDOM;

    public static KeyStore getKeystoreInstance() throws KeyStoreException, NoSuchProviderException {
        if (KEYSTORE_PROVIDER == null) {
            return KeyStore.getInstance(KEYSTORE_TYPE);
        }
        return KeyStore.getInstance(KEYSTORE_TYPE, KEYSTORE_PROVIDER);
    }

    public static String base64Decode(String base64Text) {
        byte[] dec = Base64.getDecoder().decode(base64Text);
        return new String(dec, StandardCharsets.UTF_8);
    }

    public static String base64Encode(String plain) {
        return Base64.getEncoder().encodeToString(plain.getBytes(StandardCharsets.UTF_8));
    }

    public static String keyToString(Key signingKey) {
        byte[] secretBytes = signingKey.getEncoded();
        return Base64.getEncoder().encodeToString(secretBytes);
    }

    public static Key keyFromString(String encodedKey, String algorithm) {
        byte[] decodedKey = Base64.getDecoder().decode(encodedKey);
        return new SecretKeySpec(decodedKey, algorithm);
    }

    public static void setMasterPassword(String masterPassword) {
        MASTER_PASSWORD = masterPassword.toCharArray();
    }

    private static char[] getMasterPassword() {
        return MASTER_PASSWORD;
    }

    public static byte[] randomBytes(int len) {
        byte[] b = new byte[len];
        RANDOM.nextBytes(b);
        return b;
    }

    public static SecretKey buildSecretKey(String password, byte[] salt) {
        return EncryptorUtil.buildSecretKey(password.toCharArray(), salt);
    }

    public static SecretKey buildSecretKey(char[] password, byte[] salt) {
        try {
            PBEKeySpec spec = new PBEKeySpec(password, salt, ALGORITHM_SECRET_KEY_ITERATION_COUNT, ALGORITHM_SECRET_KEY_BITS);
            SecretKeyFactory factory = SecretKeyFactory.getInstance(ALGORITHM_SECRET_KEY);
            byte[] keyBytes = factory.generateSecret(spec).getEncoded();
            return new SecretKeySpec(keyBytes, "AES");
        }
        catch (Throwable ex) {
            throw new RuntimeException("Failed to build secret key", ex);
        }
    }

    public static byte[] md5(File filename) throws NoSuchAlgorithmException, IOException {
        return EncryptorUtil.md5(filename, ALGORITHM_MESSAGEDIGEST);
    }

    public static byte[] md5(File filename, String algorithm) throws NoSuchAlgorithmException, IOException {
        MessageDigest complete = MessageDigest.getInstance(algorithm);
        try (FileInputStream fis = new FileInputStream(filename);){
            int numRead;
            byte[] buffer = new byte[1024];
            do {
                if ((numRead = ((InputStream)fis).read(buffer)) <= 0) continue;
                complete.update(buffer, 0, numRead);
            } while (numRead != -1);
        }
        return complete.digest();
    }

    public static byte[] md5(String text) throws UnsupportedEncodingException, NoSuchAlgorithmException {
        return EncryptorUtil.md5(text.getBytes(StandardCharsets.UTF_8), ALGORITHM_MESSAGEDIGEST);
    }

    public static byte[] md5(byte[] data) throws NoSuchAlgorithmException {
        MessageDigest md = MessageDigest.getInstance(ALGORITHM_MESSAGEDIGEST);
        md.update(data);
        byte[] digest = md.digest();
        return digest;
    }

    public static byte[] md5(byte[] data, String algorithm) throws NoSuchAlgorithmException {
        MessageDigest md = MessageDigest.getInstance(algorithm);
        md.update(data);
        byte[] digest = md.digest();
        return digest;
    }

    public static String md5ToString(byte[] md5) {
        StringBuilder sb = new StringBuilder();
        if (md5 != null) {
            for (byte b : md5) {
                sb.append(String.format("%02X", b));
            }
        }
        return sb.toString();
    }

    public static SecretKey generateSymmetricKey() throws NoSuchAlgorithmException {
        KeyGenerator keyGen = KeyGenerator.getInstance(ALGORITHM_SYMMETRIC_KEY);
        keyGen.init(ALGORITHM_SYMMETRIC_KEY_BITS, SecureRandom.getInstanceStrong());
        return keyGen.generateKey();
    }

    public static SecretKey loadSymmetricKey(String symmetricKeyFile, String symmetricKeyAlgorithm) throws IOException {
        byte[] symmetricKeyBytes = Files.readAllBytes(Paths.get(symmetricKeyFile, new String[0]));
        return EncryptorUtil.loadSymmetricKey(symmetricKeyBytes, symmetricKeyAlgorithm);
    }

    public static SecretKey loadSymmetricKey(byte[] symmetricKeyBytes, String symmetricKeyAlgorithm) throws IOException {
        if (symmetricKeyAlgorithm == null) {
            symmetricKeyAlgorithm = ALGORITHM_SYMMETRIC_KEY;
        }
        SecretKeySpec symmetricKey = new SecretKeySpec(symmetricKeyBytes, symmetricKeyAlgorithm);
        return symmetricKey;
    }

    public static byte[] encrypt(SecretKey symmetricKey, byte[] iv, byte[] plainData) throws IOException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException {
        Cipher cipher = EncryptorUtil.buildCypher_GCM(true, symmetricKey, iv);
        byte[] encryptedData = cipher.doFinal(plainData);
        return encryptedData;
    }

    public static byte[] decrypt(SecretKey symmetricKey, byte[] iv, byte[] encryptedData) throws IOException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException {
        Cipher cipher = EncryptorUtil.buildCypher_GCM(false, symmetricKey, iv);
        byte[] plainData = cipher.doFinal(encryptedData);
        return plainData;
    }

    public static Cipher buildCypher_GCM(boolean encrypt, SecretKey symmetricKey, byte[] iv) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException {
        Cipher cipher = Cipher.getInstance(CIPHERS_TRANSFORMATION_SYMMETRIC);
        if (encrypt) {
            cipher.init(1, (Key)symmetricKey, new GCMParameterSpec(SYMMETRIC_KEY_AUTHENTICATION_TAG_BITS, iv));
        } else {
            cipher.init(2, (Key)symmetricKey, new GCMParameterSpec(SYMMETRIC_KEY_AUTHENTICATION_TAG_BITS, iv));
        }
        return cipher;
    }

    public static String encrypt(String plainData, boolean warped) throws GeneralSecurityException {
        if (warped) {
            plainData = FormatterUtil.getInsideParenthesesValue(plainData);
        }
        char[] password = EncryptorUtil.getMasterPassword();
        byte[] utf8 = plainData.getBytes(StandardCharsets.UTF_8);
        byte[] encryptedDataPackage = EncryptorUtil.encrypt(password, utf8);
        return Base64.getEncoder().encodeToString(encryptedDataPackage);
    }

    public static byte[] encrypt(String password, byte[] plainData) throws GeneralSecurityException {
        return EncryptorUtil.encrypt(password.toCharArray(), plainData);
    }

    public static byte[] encrypt(char[] password, byte[] plainData) throws GeneralSecurityException {
        int i;
        byte[] salt = EncryptorUtil.randomBytes(ALGORITHM_SECRET_KEY_SALT_BYTES);
        SecretKey key = EncryptorUtil.buildSecretKey(password, salt);
        byte[] iv = EncryptorUtil.randomBytes(SYMMETRIC_KEY_IV_BYTES);
        Cipher cipher = EncryptorUtil.buildCypher_GCM(true, key, iv);
        byte[] encryptedData = cipher.doFinal(plainData);
        ByteBuffer buffer = ByteBuffer.allocate(salt.length + iv.length + encryptedData.length);
        buffer.put(salt).put(iv).put(encryptedData);
        byte[] encryptedDataPackage = buffer.array();
        for (i = 0; i < plainData.length; ++i) {
            plainData[i] = 0;
        }
        for (i = 0; i < encryptedData.length; ++i) {
            encryptedData[i] = 0;
        }
        return encryptedDataPackage;
    }

    public static String decrypt(String encodedData, boolean warped) throws GeneralSecurityException {
        if (warped) {
            encodedData = FormatterUtil.getInsideParenthesesValue(encodedData);
        }
        char[] password = EncryptorUtil.getMasterPassword();
        byte[] encryptedDataPackage = Base64.getDecoder().decode(encodedData);
        byte[] decryptedData = EncryptorUtil.decrypt(password, encryptedDataPackage);
        return new String(decryptedData, StandardCharsets.UTF_8);
    }

    public static byte[] decrypt(String password, byte[] encryptedDataPackage) throws GeneralSecurityException {
        return EncryptorUtil.decrypt(password.toCharArray(), encryptedDataPackage);
    }

    public static byte[] decrypt(char[] password, byte[] encryptedDataPackage) throws GeneralSecurityException {
        byte[] salt = new byte[ALGORITHM_SECRET_KEY_SALT_BYTES];
        byte[] iv = new byte[SYMMETRIC_KEY_IV_BYTES];
        byte[] encryptedData = new byte[encryptedDataPackage.length - ALGORITHM_SECRET_KEY_SALT_BYTES - SYMMETRIC_KEY_IV_BYTES];
        ByteBuffer buffer = ByteBuffer.wrap(encryptedDataPackage);
        buffer.get(salt);
        buffer.get(iv);
        buffer.get(encryptedData);
        SecretKey key = EncryptorUtil.buildSecretKey(password, salt);
        Cipher cipher = EncryptorUtil.buildCypher_GCM(false, key, iv);
        byte[] decryptedData = cipher.doFinal(encryptedData);
        return decryptedData;
    }

    public static void encrypt(SecretKey symmetricKey, String plainDataFileName, String encryptedFileName) throws IOException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException {
        byte[] iv = EncryptorUtil.randomBytes(SYMMETRIC_KEY_IV_BYTES);
        Cipher cipher = EncryptorUtil.buildCypher_GCM(true, symmetricKey, iv);
        try (FileInputStream plainDataInputStream = new FileInputStream(plainDataFileName);
             FileOutputStream fos = new FileOutputStream(encryptedFileName);
             DataOutputStream output = new DataOutputStream(fos);
             CipherOutputStream cos = new CipherOutputStream(output, cipher);){
            int byteRead;
            output.write(iv);
            int BUFF_SIZE = 102400;
            byte[] buffer = new byte[102400];
            while ((byteRead = ((InputStream)plainDataInputStream).read(buffer)) != -1) {
                cos.write(buffer, 0, byteRead);
            }
        }
    }

    /*
     * Exception decompiling
     */
    public static byte[] decrypt(SecretKey symmetricKey, byte[] encryptedLibraryBytes) throws IOException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static KeyPair generateKeyPairRSA() throws NoSuchAlgorithmException, InvalidKeySpecException, InvalidAlgorithmParameterException, NoSuchProviderException {
        return EncryptorUtil.generateKeyPair("RSA", 4096);
    }

    public static KeyPair generateKeyPairEC() throws NoSuchAlgorithmException, InvalidKeySpecException, InvalidAlgorithmParameterException, NoSuchProviderException {
        return EncryptorUtil.generateKeyPair("EC", 256);
    }

    public static KeyPair generateKeyPair(String keyfactoryAlgorithm, int size) throws NoSuchAlgorithmException, InvalidKeySpecException, InvalidAlgorithmParameterException, NoSuchProviderException {
        KeyPairGenerator kpg;
        if (keyfactoryAlgorithm == null) {
            keyfactoryAlgorithm = "EC";
            size = 256;
        }
        switch (keyfactoryAlgorithm = keyfactoryAlgorithm.toUpperCase()) {
            case "RSA": 
            case "DSA": 
            case "DH": {
                if (size < 2048) {
                    throw new InvalidAlgorithmParameterException("RSA key size must be at least 2048 bits.");
                }
                kpg = KeyPairGenerator.getInstance(keyfactoryAlgorithm);
                kpg.initialize(size);
                break;
            }
            case "EDSA": {
                kpg = KeyPairGenerator.getInstance(keyfactoryAlgorithm, "BC");
                break;
            }
            case "EC": {
                if (size < 256) {
                    throw new InvalidAlgorithmParameterException("EC key size must be at least 256 bits.");
                }
                kpg = KeyPairGenerator.getInstance(keyfactoryAlgorithm);
                ECGenParameterSpec spec = EncryptorUtil.getECCurveName(size);
                kpg.initialize(spec);
                break;
            }
            default: {
                throw new NoSuchAlgorithmException(keyfactoryAlgorithm);
            }
        }
        return kpg.generateKeyPair();
    }

    private static ECGenParameterSpec getECCurveName(int size) {
        return new ECGenParameterSpec(switch (size) {
            case 256 -> "secp256r1";
            case 384 -> "secp384r1";
            case 521 -> "secp521r1";
            default -> "secp256r1";
        });
    }

    public static void secureMem(char[] pwd) {
        if (pwd == null) {
            return;
        }
        for (int i = 0; i < pwd.length; ++i) {
            pwd[i] = '\u0000';
        }
    }

    public static KeyPair loadKeyPair(KeyFileType fileType, File keystoreFile, char[] keyStorePwd, String alias, char[] privateKeyPwd) throws NoSuchAlgorithmException, KeyStoreException, IOException, CertificateException, UnrecoverableKeyException {
        KeyStore keystore = KeyStore.getInstance(switch (fileType.ordinal()) {
            case 2 -> "PKCS12";
            case 3 -> KeyStore.getDefaultType();
            default -> throw new NoSuchAlgorithmException(fileType.name());
        });
        try (FileInputStream is = new FileInputStream(keystoreFile);){
            keystore.load(is, keyStorePwd);
        }
        EncryptorUtil.secureMem(keyStorePwd);
        PrivateKey privateKey = (PrivateKey)keystore.getKey(alias, privateKeyPwd);
        EncryptorUtil.secureMem(keyStorePwd);
        if (privateKey == null) {
            throw new KeyStoreException("private key of alias(" + alias + ") not found");
        }
        X509Certificate cert = (X509Certificate)keystore.getCertificate(alias);
        if (cert == null) {
            throw new KeyStoreException("certificate of alias(" + alias + ") not found");
        }
        PublicKey publicKey = cert.getPublicKey();
        KeyPair keyPair = new KeyPair(publicKey, privateKey);
        return keyPair;
    }

    public static PublicKey loadPublicKey(KeyFileType fileType, File publicKeyFile) throws IOException, NoSuchAlgorithmException, InvalidKeySpecException, CertificateException {
        return EncryptorUtil.loadPublicKey(fileType, publicKeyFile, ALGORITHM_ASYMMETRIC_KEY);
    }

    public static PublicKey loadPublicKey(KeyFileType fileType, File publicKeyFile, String algorithm) throws IOException, NoSuchAlgorithmException, InvalidKeySpecException, CertificateException {
        PublicKey publicKey;
        switch (fileType.ordinal()) {
            case 0: 
            case 2: 
            case 3: 
            case 4: {
                byte[] encoded = EncryptorUtil.loadPermKey(publicKeyFile);
                publicKey = EncryptorUtil.loadX509EncodedPublicKey(encoded, algorithm);
                break;
            }
            case 1: {
                try (FileInputStream fin = new FileInputStream(publicKeyFile);){
                    CertificateFactory f = CertificateFactory.getInstance("X.509");
                    X509Certificate certificate = (X509Certificate)f.generateCertificate(fin);
                    publicKey = certificate.getPublicKey();
                    break;
                }
            }
            default: {
                throw new NoSuchAlgorithmException(fileType.name());
            }
        }
        return publicKey;
    }

    public static PublicKey loadX509EncodedPublicKey(byte[] permData, String algorithm) throws NoSuchAlgorithmException, InvalidKeySpecException {
        X509EncodedKeySpec keySpec = new X509EncodedKeySpec(permData);
        KeyFactory keyFactory = KeyFactory.getInstance(algorithm);
        return keyFactory.generatePublic(keySpec);
    }

    public static PrivateKey loadPrivateKey(File pemFile) throws IOException, InvalidKeySpecException, NoSuchAlgorithmException {
        return EncryptorUtil.loadPrivateKey(pemFile, ALGORITHM_ASYMMETRIC_KEY);
    }

    public static PrivateKey loadPrivateKey(File pemFile, String algorithm) throws IOException, InvalidKeySpecException, NoSuchAlgorithmException {
        byte[] pkcs8Data = EncryptorUtil.loadPermKey(pemFile);
        return EncryptorUtil.loadPrivateKey(pkcs8Data, algorithm);
    }

    public static PrivateKey loadPrivateKey(byte[] pkcs8Data, String algorithm) throws InvalidKeySpecException, NoSuchAlgorithmException {
        KeyFactory keyFactory = KeyFactory.getInstance(algorithm);
        PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(pkcs8Data);
        PrivateKey privateKey = keyFactory.generatePrivate(keySpec);
        return privateKey;
    }

    public static PrivateKey loadPrivateKey(File pemFile, char ... password) throws IOException, OperatorCreationException, GeneralSecurityException {
        PrivateKeyInfo privateKeyInfo;
        if (password == null || password.length < 1) {
            return EncryptorUtil.loadPrivateKey(pemFile);
        }
        byte[] pkcs8Data = EncryptorUtil.loadPermKey(pemFile);
        ASN1Sequence derseq = ASN1Sequence.getInstance((Object)pkcs8Data);
        PKCS8EncryptedPrivateKeyInfo encobj = new PKCS8EncryptedPrivateKeyInfo(EncryptedPrivateKeyInfo.getInstance((Object)derseq));
        JceOpenSSLPKCS8DecryptorProviderBuilder jce = new JceOpenSSLPKCS8DecryptorProviderBuilder();
        InputDecryptorProvider decryptionProv = jce.build(password);
        try {
            privateKeyInfo = encobj.decryptPrivateKeyInfo(decryptionProv);
        }
        catch (PKCSException ex) {
            try {
                throw new GeneralSecurityException("Invalid private key password", ex);
            }
            catch (Throwable throwable) {
                for (int i = 0; i < password.length; ++i) {
                    password[i] = '\u0000';
                }
                throw throwable;
            }
        }
        for (int i = 0; i < password.length; ++i) {
            password[i] = '\u0000';
        }
        JcaPEMKeyConverter converter = new JcaPEMKeyConverter();
        PrivateKey privateKey = converter.getPrivateKey(privateKeyInfo);
        return privateKey;
    }

    public static byte[] loadPermKey(File pemFile) throws InvalidKeySpecException, IOException {
        byte[] keyBytes = Files.readAllBytes(Paths.get(pemFile.getAbsolutePath(), new String[0]));
        String pemFileContent = new String(keyBytes, Charset.defaultCharset());
        return EncryptorUtil.loadPermKey(pemFileContent);
    }

    public static byte[] loadPermKey(String pemFileContent) throws InvalidKeySpecException {
        int begin = pemFileContent.indexOf("-----");
        if (begin < 0) {
            throw new InvalidKeySpecException("missing key header");
        }
        pemFileContent = pemFileContent.substring(begin);
        pemFileContent = pemFileContent.replace("-----BEGIN PRIVATE KEY-----", "").replace("-----END PRIVATE KEY-----", "").replace("-----BEGIN ENCRYPTED PRIVATE KEY-----", "").replace("-----END ENCRYPTED PRIVATE KEY-----", "").replace("-----BEGIN RSA PRIVATE KEY-----", "").replace("-----END RSA PRIVATE KEY-----", "").replace("-----BEGIN EC PRIVATE KEY-----", "").replace("-----END EC PRIVATE KEY-----", "").replace("-----BEGIN PUBLIC KEY-----", "").replace("-----END PUBLIC KEY-----", "").replaceAll("\\s+", "");
        byte[] pkcs8Data = Base64.getDecoder().decode(pemFileContent);
        return pkcs8Data;
    }

    protected static byte[] asymmetric(int cipherMode, Key asymmetricKey, byte[] in) throws NoSuchAlgorithmException, InvalidKeyException, NoSuchPaddingException, IllegalBlockSizeException, BadPaddingException {
        Cipher rsaCipher = Cipher.getInstance(CIPHERS_TRANSFORMATION_ASYMMETRIC);
        rsaCipher.init(cipherMode, asymmetricKey);
        byte[] out = rsaCipher.doFinal(in);
        return out;
    }

    public static byte[] encrypt(Key asymmetricKey, byte[] in) throws NoSuchAlgorithmException, InvalidKeyException, NoSuchPaddingException, IllegalBlockSizeException, BadPaddingException {
        return EncryptorUtil.asymmetric(1, asymmetricKey, in);
    }

    public static byte[] decrypt(Key asymmetricKey, byte[] in) throws NoSuchAlgorithmException, InvalidKeyException, NoSuchPaddingException, IllegalBlockSizeException, BadPaddingException {
        return EncryptorUtil.asymmetric(2, asymmetricKey, in);
    }

    public static void encrypt(Key asymmetricKey, SecretKey symmetricKey, String plainDataFileName, String encryptedFileName, Key digitalSignatureKey) throws IOException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException {
        EncryptorUtil.encrypt(asymmetricKey, symmetricKey, plainDataFileName, encryptedFileName, digitalSignatureKey, ALGORITHM_MESSAGEDIGEST);
    }

    public static void encrypt(Key asymmetricKey, SecretKey symmetricKey, String plainDataFileName, String encryptedFileName, Key digitalSignatureKey, String md5Algorithm) throws IOException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException {
        boolean randomSymmetricKey;
        String metaInfo = System.currentTimeMillis() + ", " + System.getProperty("hostName");
        byte[] metadata = metaInfo.getBytes(StandardCharsets.UTF_8);
        if (digitalSignatureKey != null) {
            metadata = EncryptorUtil.encrypt(digitalSignatureKey, metadata);
        }
        boolean bl = randomSymmetricKey = symmetricKey == null;
        if (randomSymmetricKey) {
            symmetricKey = EncryptorUtil.generateSymmetricKey();
        }
        byte[] iv = EncryptorUtil.randomBytes(SYMMETRIC_KEY_IV_BYTES);
        Cipher cipher = EncryptorUtil.buildCypher_GCM(true, symmetricKey, iv);
        byte[] asymmetricEncryptedMD5 = null;
        byte[] asymmetricEncryptedIV = iv;
        byte[] asymmetricEncryptedSessionKey = null;
        byte[] asymmetricEncryptedSymmetricKeyAlgorithm = null;
        if (asymmetricKey != null) {
            byte[] md5 = EncryptorUtil.md5(new File(plainDataFileName), md5Algorithm);
            asymmetricEncryptedMD5 = EncryptorUtil.encrypt(asymmetricKey, md5);
            asymmetricEncryptedIV = EncryptorUtil.encrypt(asymmetricKey, iv);
            if (randomSymmetricKey) {
                asymmetricEncryptedSymmetricKeyAlgorithm = symmetricKey.getAlgorithm().getBytes(StandardCharsets.ISO_8859_1);
                asymmetricEncryptedSymmetricKeyAlgorithm = EncryptorUtil.encrypt(asymmetricKey, asymmetricEncryptedSymmetricKeyAlgorithm);
                asymmetricEncryptedSessionKey = EncryptorUtil.encrypt(asymmetricKey, symmetricKey.getEncoded());
            }
        }
        try (FileInputStream plainDataInputStream = new FileInputStream(plainDataFileName);
             FileOutputStream fos = new FileOutputStream(encryptedFileName);
             DataOutputStream output = new DataOutputStream(fos);
             CipherOutputStream cos = new CipherOutputStream(output, cipher);){
            int byteRead;
            output.writeInt(metadata.length);
            output.write(metadata);
            if (asymmetricEncryptedMD5 != null) {
                output.writeInt(asymmetricEncryptedMD5.length);
                output.write(asymmetricEncryptedMD5);
            }
            output.writeInt(asymmetricEncryptedIV.length);
            output.write(asymmetricEncryptedIV);
            if (asymmetricEncryptedSymmetricKeyAlgorithm != null) {
                output.writeInt(asymmetricEncryptedSymmetricKeyAlgorithm.length);
                output.write(asymmetricEncryptedSymmetricKeyAlgorithm);
            }
            if (asymmetricEncryptedSessionKey != null) {
                output.writeInt(asymmetricEncryptedSessionKey.length);
                output.write(asymmetricEncryptedSessionKey);
            }
            int BUFF_SIZE = 102400;
            byte[] buffer = new byte[102400];
            while ((byteRead = ((InputStream)plainDataInputStream).read(buffer)) != -1) {
                cos.write(buffer, 0, byteRead);
            }
        }
    }

    public static byte[] encrypt(Key asymmetricKey, SecretKey symmetricKey, byte[] plainData, Key digitalSignatureKey) throws IOException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException {
        return EncryptorUtil.encrypt(asymmetricKey, symmetricKey, plainData, digitalSignatureKey, ALGORITHM_MESSAGEDIGEST);
    }

    public static byte[] encrypt(Key asymmetricKey, SecretKey symmetricKey, byte[] plainData, Key digitalSignatureKey, String md5Algorithm) throws IOException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException {
        byte[] ret;
        boolean randomSymmetricKey;
        String metaInfo = String.valueOf(LocalDateTime.now()) + ", " + System.getProperty("hostName");
        byte[] metadata = metaInfo.getBytes(StandardCharsets.UTF_8);
        if (digitalSignatureKey != null) {
            metadata = EncryptorUtil.encrypt(digitalSignatureKey, metadata);
        }
        boolean bl = randomSymmetricKey = symmetricKey == null;
        if (randomSymmetricKey) {
            symmetricKey = EncryptorUtil.generateSymmetricKey();
        }
        byte[] iv = EncryptorUtil.randomBytes(SYMMETRIC_KEY_IV_BYTES);
        Cipher cipher = EncryptorUtil.buildCypher_GCM(true, symmetricKey, iv);
        byte[] asymmetricEncryptedMD5 = null;
        byte[] asymmetricEncryptedIV = iv;
        byte[] asymmetricEncryptedSessionKey = null;
        byte[] asymmetricEncryptedSymmetricKeyAlgorithm = null;
        if (asymmetricKey != null) {
            byte[] md5 = EncryptorUtil.md5(plainData, md5Algorithm);
            asymmetricEncryptedMD5 = EncryptorUtil.encrypt(asymmetricKey, md5);
            asymmetricEncryptedIV = EncryptorUtil.encrypt(asymmetricKey, iv);
            if (randomSymmetricKey) {
                asymmetricEncryptedSymmetricKeyAlgorithm = symmetricKey.getAlgorithm().getBytes(StandardCharsets.ISO_8859_1);
                asymmetricEncryptedSymmetricKeyAlgorithm = EncryptorUtil.encrypt(asymmetricKey, asymmetricEncryptedSymmetricKeyAlgorithm);
                asymmetricEncryptedSessionKey = EncryptorUtil.encrypt(asymmetricKey, symmetricKey.getEncoded());
            }
        }
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();
             DataOutputStream output = new DataOutputStream(bos);){
            output.writeInt(metadata.length);
            output.write(metadata);
            if (asymmetricEncryptedMD5 != null) {
                output.writeInt(asymmetricEncryptedMD5.length);
                output.write(asymmetricEncryptedMD5);
            }
            output.writeInt(asymmetricEncryptedIV.length);
            output.write(asymmetricEncryptedIV);
            if (asymmetricEncryptedSymmetricKeyAlgorithm != null) {
                output.writeInt(asymmetricEncryptedSymmetricKeyAlgorithm.length);
                output.write(asymmetricEncryptedSymmetricKeyAlgorithm);
            }
            if (asymmetricEncryptedSessionKey != null) {
                output.writeInt(asymmetricEncryptedSessionKey.length);
                output.write(asymmetricEncryptedSessionKey);
            }
            byte[] encryptedData = cipher.doFinal(plainData);
            output.write(encryptedData);
            ret = bos.toByteArray();
        }
        return ret;
    }

    public static void decrypt(Key asymmetricKey, SecretKey symmetricKey, String encryptedFileName, String plainDataFileName, Key digitalSignatureKey, @Nullable EncryptionMeta meta) throws IOException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException {
        EncryptorUtil.decrypt(asymmetricKey, symmetricKey, encryptedFileName, plainDataFileName, digitalSignatureKey, meta, ALGORITHM_MESSAGEDIGEST);
    }

    public static void decrypt(Key asymmetricKey, SecretKey symmetricKey, String encryptedFileName, String plainDataFileName, Key digitalSignatureKey, @Nullable EncryptionMeta meta, String md5Algorithm) throws IOException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException {
        try (DataInputStream dis = new DataInputStream(new FileInputStream(encryptedFileName));){
            byte[] iv;
            byte[] metadata = new byte[dis.readInt()];
            dis.readFully(metadata);
            if (digitalSignatureKey != null) {
                try {
                    metadata = EncryptorUtil.decrypt(digitalSignatureKey, metadata);
                    if (meta != null) {
                        meta.setInfo(new String(metadata, StandardCharsets.UTF_8));
                    }
                }
                catch (Throwable ex) {
                    throw new ProviderException("Digital Signature verification failed", ex);
                }
            }
            byte[] decryptedMD5 = null;
            if (asymmetricKey != null) {
                byte[] encryptedMD5 = new byte[dis.readInt()];
                dis.readFully(encryptedMD5);
                decryptedMD5 = EncryptorUtil.decrypt(asymmetricKey, encryptedMD5);
            }
            byte[] asymmetricEncryptedIV = new byte[dis.readInt()];
            dis.readFully(asymmetricEncryptedIV);
            if (asymmetricKey == null) {
                iv = asymmetricEncryptedIV;
            } else {
                iv = EncryptorUtil.decrypt(asymmetricKey, asymmetricEncryptedIV);
                if (symmetricKey == null) {
                    byte[] asymmetricEncryptedSymmetricKeyAlgorithm = new byte[dis.readInt()];
                    dis.readFully(asymmetricEncryptedSymmetricKeyAlgorithm);
                    byte[] symmetricKeyAlgorithm = EncryptorUtil.decrypt(asymmetricKey, asymmetricEncryptedSymmetricKeyAlgorithm);
                    String keyAlgorithm = new String(symmetricKeyAlgorithm, StandardCharsets.ISO_8859_1);
                    byte[] asymmetricEncryptedSessionKey = new byte[dis.readInt()];
                    dis.readFully(asymmetricEncryptedSessionKey);
                    byte[] sessionKey = EncryptorUtil.decrypt(asymmetricKey, asymmetricEncryptedSessionKey);
                    symmetricKey = EncryptorUtil.loadSymmetricKey(sessionKey, keyAlgorithm);
                }
            }
            Cipher cipher = EncryptorUtil.buildCypher_GCM(false, symmetricKey, iv);
            try (CipherInputStream cis = new CipherInputStream(dis, cipher);
                 FileOutputStream fos = new FileOutputStream(plainDataFileName);){
                int byteRead;
                int BUFF_SIZE = 102400;
                byte[] buffer = new byte[102400];
                while ((byteRead = cis.read(buffer)) != -1) {
                    fos.write(buffer, 0, byteRead);
                }
            }
            byte[] md5 = EncryptorUtil.md5(new File(plainDataFileName), md5Algorithm);
            if (meta != null) {
                meta.setMd5(EncryptorUtil.md5ToString(md5));
            }
            if (decryptedMD5 != null) {
                boolean isMatch;
                boolean bl = isMatch = md5 != null && decryptedMD5.length == md5.length;
                if (isMatch) {
                    for (int i = 0; i < md5.length; ++i) {
                        if (md5[i] == decryptedMD5[i]) continue;
                        isMatch = false;
                        break;
                    }
                }
                if (!isMatch) {
                    throw new IOException("MD5 verification failed");
                }
            }
        }
    }

    public static byte[] decrypt(Key asymmetricKey, SecretKey symmetricKey, byte[] encryptedData, Key digitalSignatureKey, @Nullable EncryptionMeta meta) throws IOException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException {
        return EncryptorUtil.decrypt(asymmetricKey, symmetricKey, encryptedData, digitalSignatureKey, meta, ALGORITHM_MESSAGEDIGEST);
    }

    public static byte[] decrypt(Key asymmetricKey, SecretKey symmetricKey, byte[] encryptedData, Key digitalSignatureKey, @Nullable EncryptionMeta meta, String md5Algorithm) throws IOException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException {
        byte[] ret;
        try (DataInputStream dis = new DataInputStream(new ByteArrayInputStream(encryptedData));){
            byte[] iv;
            byte[] metadata = new byte[dis.readInt()];
            dis.readFully(metadata);
            if (digitalSignatureKey != null) {
                try {
                    metadata = EncryptorUtil.decrypt(digitalSignatureKey, metadata);
                    if (meta != null) {
                        meta.setInfo(new String(metadata, StandardCharsets.UTF_8));
                    }
                }
                catch (Throwable ex) {
                    throw new ProviderException("Digital Signature verification failed", ex);
                }
            }
            byte[] decryptedMD5 = null;
            if (asymmetricKey != null) {
                byte[] encryptedMD5 = new byte[dis.readInt()];
                dis.readFully(encryptedMD5);
                decryptedMD5 = EncryptorUtil.decrypt(asymmetricKey, encryptedMD5);
            }
            byte[] asymmetricEncryptedIV = new byte[dis.readInt()];
            dis.readFully(asymmetricEncryptedIV);
            if (asymmetricKey == null) {
                iv = asymmetricEncryptedIV;
            } else {
                iv = EncryptorUtil.decrypt(asymmetricKey, asymmetricEncryptedIV);
                if (symmetricKey == null) {
                    byte[] asymmetricEncryptedSymmetricKeyAlgorithm = new byte[dis.readInt()];
                    dis.readFully(asymmetricEncryptedSymmetricKeyAlgorithm);
                    byte[] symmetricKeyAlgorithm = EncryptorUtil.decrypt(asymmetricKey, asymmetricEncryptedSymmetricKeyAlgorithm);
                    String keyAlgorithm = new String(symmetricKeyAlgorithm, StandardCharsets.ISO_8859_1);
                    byte[] asymmetricEncryptedSessionKey = new byte[dis.readInt()];
                    dis.readFully(asymmetricEncryptedSessionKey);
                    byte[] sessionKey = EncryptorUtil.decrypt(asymmetricKey, asymmetricEncryptedSessionKey);
                    symmetricKey = EncryptorUtil.loadSymmetricKey(sessionKey, keyAlgorithm);
                }
            }
            Cipher cipher = EncryptorUtil.buildCypher_GCM(false, symmetricKey, iv);
            try (CipherInputStream cis = new CipherInputStream(dis, cipher);
                 ByteArrayOutputStream bos = new ByteArrayOutputStream();){
                int byteRead;
                int BUFF_SIZE = 102400;
                byte[] buffer = new byte[102400];
                while ((byteRead = cis.read(buffer)) != -1) {
                    bos.write(buffer, 0, byteRead);
                }
                ret = bos.toByteArray();
            }
            byte[] md5 = EncryptorUtil.md5(ret, md5Algorithm);
            if (meta != null) {
                meta.setMd5(EncryptorUtil.md5ToString(md5));
            }
            if (decryptedMD5 != null) {
                boolean isMatch;
                boolean bl = isMatch = md5 != null && decryptedMD5.length == md5.length;
                if (isMatch) {
                    for (int i = 0; i < md5.length; ++i) {
                        if (md5[i] == decryptedMD5[i]) continue;
                        isMatch = false;
                        break;
                    }
                }
                if (!isMatch) {
                    throw new IOException("MD5 verification failed");
                }
            }
        }
        return ret;
    }

    static {
        try {
            Security.addProvider((Provider)PROVIDER);
            System.setProperty("hostName", InetAddress.getLocalHost().getHostName());
        }
        catch (UnknownHostException ex) {
            ApplicationUtil.RTO(BootErrorCode.RTO_UNKNOWN_HOST_ERROR, null, ex);
        }
        MASTER_PASSWORD = "".toCharArray();
        RANDOM = new SecureRandom();
    }

    public static enum KeyFileType {
        X509,
        Certificate,
        PKCS12,
        JKS,
        PKCS8;

    }

    public static class EncryptionMeta {
        protected String info;
        protected String md5;

        public String getInfo() {
            return this.info;
        }

        public void setInfo(String info2) {
            this.info = info2;
        }

        public String getMd5() {
            return this.md5;
        }

        public void setMd5(String md5) {
            this.md5 = md5;
        }

        public String toString() {
            return this.info + " (md5: " + this.md5 + ")";
        }
    }
}

