/*
 * Decompiled with CFR 0.152.
 */
package org.summerboot.jexpress.security;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.security.GeneralSecurityException;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.summerboot.jexpress.security.SSLUtil;

public class SSLConnectionFactory
extends SSLSocketFactory {
    protected final SSLSocketFactory sf;

    public SSLConnectionFactory(KeyManagerFactory kmf, TrustManagerFactory tmf, String protocol) throws GeneralSecurityException, IOException {
        this(kmf == null ? null : kmf.getKeyManagers(), tmf == null ? null : tmf.getTrustManagers(), protocol);
    }

    public SSLConnectionFactory(KeyManager[] kms, TrustManager[] tms, String protocol) throws GeneralSecurityException, IOException {
        SSLContext sslCtx = SSLUtil.buildSSLContext(kms, tms, protocol == null ? "TLSv1.3" : protocol);
        this.sf = sslCtx.getSocketFactory();
    }

    public SSLConnectionFactory(SSLSocketFactory sf) {
        this.sf = sf;
    }

    public SSLSocketFactory getSSLSocketFactory() {
        return this.sf;
    }

    @Override
    public Socket createSocket() throws IOException {
        return this.sf.createSocket();
    }

    @Override
    public Socket createSocket(String host, int port) throws IOException {
        return this.sf.createSocket(host, port);
    }

    @Override
    public Socket createSocket(String host, int port, InetAddress localHost, int localPort) throws IOException {
        return this.sf.createSocket(host, port, localHost, localPort);
    }

    @Override
    public Socket createSocket(InetAddress host, int port) throws IOException {
        return this.sf.createSocket(host, port);
    }

    @Override
    public Socket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) throws IOException {
        return this.sf.createSocket(address, port, localAddress, localPort);
    }

    @Override
    public String[] getDefaultCipherSuites() {
        return this.sf.getDefaultCipherSuites();
    }

    @Override
    public String[] getSupportedCipherSuites() {
        return this.sf.getSupportedCipherSuites();
    }

    @Override
    public Socket createSocket(Socket s, String host, int port, boolean autoClose) throws IOException {
        return this.sf.createSocket(s, host, port, autoClose);
    }
}

