/*
 * Decompiled with CFR 0.152.
 */
package org.summerboot.jexpress.security;

import com.veracode.annotation.CRLFCleanser;
import com.veracode.annotation.FilePathCleanser;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import org.apache.commons.lang3.RegExUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.summerboot.jexpress.boot.BootErrorCode;
import org.summerboot.jexpress.nio.server.SessionContext;
import org.summerboot.jexpress.nio.server.domain.Err;
import org.summerboot.jexpress.security.EncryptorUtil;

public class SecurityUtil {
    public static final HostnameVerifier DO_NOT_VERIFY_REMOTE_IP = (hostname, session) -> true;
    public static final HostnameVerifier hostnameVerifier = (hostname, session) -> {
        HostnameVerifier hv = HttpsURLConnection.getDefaultHostnameVerifier();
        return hv.verify("hostname", session);
    };
    public static final String[] CIPHER_SUITES = new String[]{"TLS_RSA_WITH_AES_256_CBC_SHA", "TLS_RSA_WITH_AES_128_CBC_SHA", "TLS_DHE_DSS_WITH_AES_256_CBC_SHA256", "TLS_DHE_DSS_WITH_AES_256_CBC_SHA", "TLS_DHE_DSS_WITH_AES_128_CBC_SHA256", "TLS_DHE_DSS_WITH_AES_128_CBC_SHA", "TLS_DHE_DSS_WITH_AES_256_GCM_SHA384", "TLS_DHE_DSS_WITH_AES_128_GCM_SHA256", "TLS_ECDH_ECDSA_WITH_AES_256_CBC_SHA384", "TLS_ECDH_RSA_WITH_AES_256_CBC_SHA384", "TLS_ECDH_ECDSA_WITH_AES_256_CBC_SHA", "TLS_ECDH_RSA_WITH_AES_256_CBC_SHA", "TLS_ECDH_ECDSA_WITH_AES_128_CBC_SHA256", "TLS_ECDH_RSA_WITH_AES_128_CBC_SHA256", "TLS_ECDH_ECDSA_WITH_AES_128_CBC_SHA", "TLS_ECDH_RSA_WITH_AES_128_CBC_SHA", "TLS_ECDH_ECDSA_WITH_AES_256_GCM_SHA384", "TLS_ECDH_RSA_WITH_AES_256_GCM_SHA384", "TLS_ECDH_ECDSA_WITH_AES_128_GCM_SHA256", "TLS_ECDH_RSA_WITH_AES_128_GCM_SHA256", "TLS_ECDH_anon_WITH_AES_256_CBC_SHA", "TLS_ECDH_anon_WITH_AES_128_CBC_SHA", "TLS_ECDH_ECDSA_WITH_NULL_SHA", "TLS_ECDH_RSA_WITH_NULL_SHA", "TLS_ECDH_anon_WITH_NULL_SHA", "TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA384", "TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA384", "TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA", "TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA", "TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256", "TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256", "TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA", "TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA", "TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384", "TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256", "TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384", "TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256,TLS_ECDHE_ECDSA_WITH_NULL_SHA,TLS_ECDHE_RSA_WITH_NULL_SHA"};
    public static final Pattern PATTERN_UNPRINTABLE = Pattern.compile("\\p{C}");
    public static final Pattern PATTERN_UNPRINTABLE_CRLFTAB = Pattern.compile("\\p{C}&&[^\\r\\n\\t]");
    public static final Pattern Pattern_HasUppercase = Pattern.compile("[A-Z]");
    public static final Pattern Pattern_HasLowercase = Pattern.compile("[a-z]");
    public static final Pattern Pattern_HasNumber = Pattern.compile("\\d");
    public static final Pattern Pattern_HasSpecialChar = Pattern.compile("[^a-zA-Z0-9 ]");
    public static final Pattern INSECURE_URI = Pattern.compile(".*[<>&\"].*");

    public static String stripControls(String input, String substitute) {
        if (StringUtils.isEmpty((CharSequence)input)) {
            return input;
        }
        return PATTERN_UNPRINTABLE.matcher(input).replaceAll(substitute);
    }

    public static boolean validatePassword(String pwd, int length) {
        if (StringUtils.isBlank((CharSequence)pwd)) {
            return false;
        }
        if (pwd.length() < length) {
            return false;
        }
        if (!Pattern_HasUppercase.matcher(pwd).find()) {
            return false;
        }
        if (!Pattern_HasLowercase.matcher(pwd).find()) {
            return false;
        }
        if (!Pattern_HasNumber.matcher(pwd).find()) {
            return false;
        }
        return Pattern_HasSpecialChar.matcher(pwd).find();
    }

    public static String randomAlphanumeric(int count) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < count; ++i) {
            int randomIndex = EncryptorUtil.RANDOM.nextInt(33, 126);
            sb.append((char)randomIndex);
        }
        return sb.toString();
    }

    @CRLFCleanser
    public static String sanitizeCRLF(String userInput) {
        if (StringUtils.isEmpty((CharSequence)userInput)) {
            return userInput;
        }
        return StringEscapeUtils.escapeJava((String)userInput);
    }

    @FilePathCleanser
    public static String sanitizeFilePath(String plainText) {
        if (StringUtils.isEmpty((CharSequence)plainText)) {
            return plainText;
        }
        String str = RegExUtils.replaceAll((String)plainText, (String)"\\.\\./", (String)"/");
        return str.chars().mapToObj(i -> Character.valueOf((char)i)).map(c -> Character.valueOf(Character.isWhitespace(c.charValue()) ? (char)'_' : (char)c.charValue())).filter(c -> Character.isLetterOrDigit(c.charValue()) || c.charValue() == '-' || c.charValue() == '_' || c.charValue() == ':' || c.charValue() == '/' || c.charValue() == '\\' || c.charValue() == '@' || c.charValue() == '.').map(String::valueOf).collect(Collectors.joining());
    }

    @FilePathCleanser
    public static String sanitizeFilePath(File file) {
        return SecurityUtil.sanitizeFilePath(file.getAbsolutePath());
    }

    @FilePathCleanser
    public static boolean sanitizePath(String path) {
        return !path.contains(File.separator + ".") && !path.contains("." + File.separator);
    }

    @FilePathCleanser
    public static boolean precheckFile(File file, SessionContext context) {
        String realPath;
        String filePath = file.getAbsolutePath();
        try {
            realPath = file.getAbsoluteFile().toPath().normalize().toString();
        }
        catch (Throwable ex) {
            Err e = new Err(BootErrorCode.NIO_REQUEST_BAD_DOWNLOAD, null, "Invalid file path", ex, (Object)("Invalid file path: " + filePath));
            context.status(HttpResponseStatus.BAD_REQUEST).error(e);
            return false;
        }
        if (!file.exists()) {
            Err e = new Err(BootErrorCode.FILE_NOT_FOUND, null, "Invalid file path", null, (Object)("File not exists: " + filePath));
            context.status(HttpResponseStatus.NOT_FOUND).error(e);
            return false;
        }
        if (!SecurityUtil.sanitizePath(filePath) || !filePath.equals(realPath) || file.isDirectory() || !file.isFile() || file.isHidden() || !file.canRead()) {
            Err e = new Err(BootErrorCode.FILE_NOT_ACCESSABLE, null, "Invalid file path", null, (Object)("Malicious file request: " + filePath));
            context.status(HttpResponseStatus.FORBIDDEN).error(e);
            return false;
        }
        return true;
    }

    public static boolean sanitizeUri(String uri) {
        try {
            uri = URLDecoder.decode(uri, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            try {
                uri = URLDecoder.decode(uri, "ISO-8859-1");
            }
            catch (UnsupportedEncodingException e1) {
                return false;
            }
        }
        uri = uri.replace('/', File.separatorChar);
        return !uri.contains(File.separator + ".") && !uri.contains("." + File.separator) && uri.charAt(0) != '.' && uri.charAt(uri.length() - 1) != '.' && !INSECURE_URI.matcher(uri).matches();
    }

    @Deprecated
    public static String sanitizeDocRootUri(String uri, String docroot) {
        try {
            uri = URLDecoder.decode(uri, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            try {
                uri = URLDecoder.decode(uri, "ISO-8859-1");
            }
            catch (UnsupportedEncodingException e1) {
                throw new Error(e);
            }
        }
        uri = uri.replace('/', File.separatorChar);
        if (uri.contains(File.separator + ".") || uri.contains("." + File.separator) || uri.charAt(0) == '.' || uri.charAt(uri.length() - 1) == '.' || INSECURE_URI.matcher(uri).matches()) {
            return null;
        }
        if (!uri.startsWith(docroot)) {
            return null;
        }
        return System.getProperty("user.dir") + uri;
    }

    public static final String escapeDN(String dnName) {
        if (dnName == null) {
            return dnName;
        }
        StringBuilder sb = new StringBuilder();
        if (dnName.length() > 0 && (dnName.charAt(0) == ' ' || dnName.charAt(0) == '#')) {
            sb.append('\\');
        }
        block3: for (int i = 0; i < dnName.length(); ++i) {
            char curChar = dnName.charAt(i);
            switch (curChar) {
                case '\"': 
                case '#': 
                case '+': 
                case ',': 
                case ';': 
                case '<': 
                case '=': 
                case '>': 
                case '\\': {
                    continue block3;
                }
                default: {
                    sb.append(curChar);
                }
            }
        }
        if (dnName.length() > 1 && dnName.charAt(dnName.length() - 1) == ' ') {
            sb.insert(sb.length() - 1, '\\');
        }
        return sb.toString().trim();
    }

    public static final String escapeLDAPSearchFilter(String filter) {
        if (filter == null) {
            return filter;
        }
        StringBuilder sb = new StringBuilder();
        block3: for (int i = 0; i < filter.length(); ++i) {
            char curChar = filter.charAt(i);
            switch (curChar) {
                case '\u0000': 
                case '(': 
                case ')': 
                case '*': 
                case '\\': {
                    continue block3;
                }
                default: {
                    sb.append(curChar);
                }
            }
        }
        return sb.toString().trim();
    }
}

