/*
 * Decompiled with CFR 0.152.
 */
package org.swiftsms.io.net;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.CookieHandler;
import java.net.CookiePolicy;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.Map;
import org.swiftsms.io.net.NoInternetAccessException;
import org.swiftsms.io.net.cookies.MyCookieManager;

public class ConnectionManager {
    private final boolean doOutput;
    private final String method;
    private HttpURLConnection connection;
    private String webpageUrl;
    private Map<String, String> requestHeaders;
    private StringBuilder requestOutput;

    public ConnectionManager(String webpageUrl, String requestMethod, boolean doOutput) {
        this.webpageUrl = webpageUrl;
        this.method = requestMethod;
        this.doOutput = doOutput;
        this.initalize();
    }

    public ConnectionManager(String webpageUrl) {
        this(webpageUrl, "POST", true);
    }

    private void initalize() {
        try {
            URL url = new URL(this.webpageUrl);
            this.requestHeaders = new LinkedHashMap<String, String>();
            this.requestOutput = new StringBuilder();
            this.connection = (HttpURLConnection)url.openConnection();
            this.connection.setRequestMethod(this.method);
            this.connection.setDoOutput(this.doOutput);
            this.connection.setUseCaches(false);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void addPostHeader(String key, String value) {
        this.requestHeaders.put(key, value);
    }

    public void addRequestBody(String text) {
        this.requestOutput.append(text);
    }

    public void setRequestHeader(String field, String value) {
        this.connection.setRequestProperty(field, value);
    }

    public String connect() {
        String responseHtml = this.doConnection();
        while (this.getResponseStatus() == 302 || this.getResponseStatus() == 301) {
            this.webpageUrl = this.connection.getHeaderField("Location");
            this.initalize();
            responseHtml = this.doConnection();
        }
        return responseHtml;
    }

    private String doConnection() {
        StringBuilder result = new StringBuilder();
        try {
            if (this.connection.getDoOutput()) {
                BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(this.connection.getOutputStream()));
                if (this.requestHeaders.size() > 0) {
                    this.writeHeaders(writer);
                }
                if (this.requestOutput.length() > 0) {
                    writer.write(this.requestOutput.toString());
                }
                ((Writer)writer).close();
            }
            result.append(this.readStream(this.connection.getInputStream()));
        }
        catch (IOException e) {
            throw new NoInternetAccessException();
        }
        return result.toString();
    }

    private void writeHeaders(Writer writer) throws IOException {
        boolean firstHeader = true;
        for (String key : this.requestHeaders.keySet()) {
            if (!firstHeader) {
                writer.write("&");
            }
            writer.write(key + "=" + this.requestHeaders.get(key));
            firstHeader = false;
        }
    }

    public int getResponseStatus() {
        try {
            return this.connection.getResponseCode();
        }
        catch (IOException e) {
            e.printStackTrace();
            return -1;
        }
    }

    private String readStream(InputStream is) throws IOException {
        String line;
        StringBuilder result = new StringBuilder();
        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
        while ((line = reader.readLine()) != null) {
            result.append(line);
        }
        reader.close();
        return result.toString();
    }

    static {
        CookieHandler.setDefault(new MyCookieManager(null, CookiePolicy.ACCEPT_ALL));
    }
}

