/*
 * Decompiled with CFR 0.152.
 */
package org.swiftsms.io.net;

import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;
import org.swiftsms.io.net.ConnectionManager;
import org.swiftsms.io.net.Operator;
import org.swiftsms.model.Account;
import org.swiftsms.tasks.results.Fail;
import org.swiftsms.tasks.results.OperationResult;
import org.swiftsms.tasks.results.Success;

public class EMobile
extends Operator {
    private static final String HOST_URL = "https://myaccount.emobile.ie";
    private static final String LOGIN_URL = "/go/myemobile-login-manager";
    private static final String POST_USER = "username";
    private static final String POST_PASS = "userpass";
    private static final String SUCCESS_LOGIN = "Log out";
    private static final String SMS_REMAINING_URL = "https://myaccount.emobile.ie/cfusion/meteor/Meteor_REST/service/freeSMS";
    private static final String SMS_CONSOLE = "/go/common/message-centre/web-sms/free-web-text";
    private static final String SMS_CHARS_LIMIT = "id=\"charsLeft\"  value=\"";
    private static final String AJAX_API = "/myemobileapi/index.cfm";
    private static final String AJAX_EVENT = "event";
    private static final String AJAX_REQUEST = "ajaxRequest";
    private static final String AJAX_FUNCTION = "func";
    private static final String AJAX_SMS_FUNCTION = "sendSMS";
    private static final String AJAX_MSISDNS_FUNCTION = "addEnteredMsisdns";
    private static final String POST_VALUE_ADD_RECIPIENT = "addEnteredMSISDNs";
    private static final String AJAX_SMS = "smsAjax";
    private static final String POST_MESSAGE_TEXT = "messageText";
    private static final String POST_ADD = "add";
    private static final String POST_REMOVE = "remove";
    private static final String POST_VALUE_NO_ID = "0%7C";
    private static final String GET_REQUEST_METHOD = "GET";
    private static final String JSON_REMAINING_FREE_SMS = "remainingFreeSMS";
    private static final String JSON_FREE_SMS = "FreeSMS";
    private int localRemainingSmsCount = -1;

    public EMobile(Account account) {
        super(account);
    }

    @Override
    OperationResult doLogin() {
        ConnectionManager loginManager = new ConnectionManager("https://myaccount.emobile.ie/go/myemobile-login-manager");
        loginManager.addPostHeader(POST_USER, this.getAccount().getMobileNumber());
        loginManager.addPostHeader(POST_PASS, this.getAccount().getPassword());
        String loginHtml = loginManager.connect();
        boolean isSuccess = loginHtml.contains(SUCCESS_LOGIN);
        return isSuccess ? Success.LOGGED_IN : Fail.LOGIN_FAILED;
    }

    @Override
    int doGetRemainingSMS() {
        ConnectionManager manager = new ConnectionManager(SMS_REMAINING_URL, GET_REQUEST_METHOD, false);
        String smsHtml = manager.connect();
        try {
            JSONObject smsJson = new JSONObject(smsHtml);
            JSONObject freeSmsJson = smsJson.getJSONObject(JSON_FREE_SMS);
            this.localRemainingSmsCount = freeSmsJson.getInt(JSON_REMAINING_FREE_SMS);
            return this.localRemainingSmsCount;
        }
        catch (JSONException e) {
            e.printStackTrace();
            return -1;
        }
    }

    @Override
    OperationResult doSend(List<String> list, String message) {
        int expectedRemainingSms = this.localRemainingSmsCount - list.size();
        this.addEnteredMSISDNs(list);
        this.sendMessage(message);
        boolean isSent = this.hasRemainingSmsDecremented(expectedRemainingSms);
        return isSent ? Success.MESSAGE_SENT : Fail.MESSAGE_FAILED;
    }

    private void addEnteredMSISDNs(List<String> recipients) {
        StringBuilder sb = new StringBuilder();
        for (String recipient : recipients) {
            sb.append(POST_VALUE_NO_ID);
            sb.append(recipient);
            sb.append(",");
        }
        sb.deleteCharAt(sb.length() - 1);
        ConnectionManager addNumberRequest = new ConnectionManager("https://myaccount.emobile.ie/myemobileapi/index.cfm");
        addNumberRequest.addPostHeader(AJAX_EVENT, AJAX_SMS);
        addNumberRequest.addPostHeader(AJAX_FUNCTION, AJAX_MSISDNS_FUNCTION);
        addNumberRequest.addPostHeader(AJAX_REQUEST, POST_VALUE_ADD_RECIPIENT);
        addNumberRequest.addPostHeader(POST_ADD, sb.toString());
        addNumberRequest.addPostHeader(POST_REMOVE, "-");
        addNumberRequest.connect();
    }

    private void sendMessage(String message) {
        ConnectionManager sendMessageRequest = new ConnectionManager("https://myaccount.emobile.ie/myemobileapi/index.cfm");
        sendMessageRequest.addPostHeader(AJAX_EVENT, AJAX_SMS);
        sendMessageRequest.addPostHeader(AJAX_FUNCTION, AJAX_SMS_FUNCTION);
        sendMessageRequest.addPostHeader(AJAX_REQUEST, AJAX_SMS_FUNCTION);
        sendMessageRequest.addPostHeader(POST_MESSAGE_TEXT, message);
        sendMessageRequest.connect();
    }

    @Override
    int doGetCharacterLimit() {
        ConnectionManager smsConsole = new ConnectionManager("https://myaccount.emobile.ie/go/common/message-centre/web-sms/free-web-text");
        String smsConsoleHtml = smsConsole.connect();
        return this.getCharLimit(smsConsoleHtml);
    }

    private int getCharLimit(String html) {
        int charLimit = -1;
        String startText = SMS_CHARS_LIMIT;
        int index = html.indexOf(SMS_CHARS_LIMIT) + SMS_CHARS_LIMIT.length();
        int endPos = index + 4;
        try {
            String remainingCharsStr = html.substring(index, endPos).replaceAll("[</span>\"]", "");
            charLimit = Integer.parseInt(remainingCharsStr.trim());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return charLimit;
    }

    private boolean hasRemainingSmsDecremented(int expectedSmsRemaining) {
        for (int x = 0; x < 5; ++x) {
            if (this.getRemainingSMS() == expectedSmsRemaining) {
                return true;
            }
            try {
                Thread.sleep(100L);
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        return false;
    }
}

