/*
 * Decompiled with CFR 0.152.
 */
package org.swiftsms.io.net;

import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;
import org.swiftsms.io.net.ConnectionManager;
import org.swiftsms.io.net.Operator;
import org.swiftsms.model.Account;
import org.swiftsms.tasks.results.Fail;
import org.swiftsms.tasks.results.OperationResult;
import org.swiftsms.tasks.results.Success;

public class Meteor
extends Operator {
    private static final String SEND_SUCCESS_TEXT = "showEl(\"sentTrue\")";
    private static final String LOGIN_SUCCESS_TEXT = "Log Out";
    private static final String HOSTNAME = "https://www.mymeteor.ie/";
    private static final String LOGIN_URL = "https://www.mymeteor.ie/go/mymeteor-login-manager";
    private static final String REMAINING_SMS_URL = "https://www.mymeteor.ie/cfusion/meteor/Meteor_REST/service/freeSMS";
    private static final String CHARACTER_COUNT_URL = "https://www.mymeteor.ie/go/freewebtext";
    private static final String SMS_URL = "https://www.mymeteor.ie/mymeteorapi/index.cfm?event=smsAjax";
    private static final String GET_REQUEST_METHOD = "GET";
    private static final String JSON_REMAINING_FREE_SMS = "remainingFreeSMS";
    private static final String JSON_FREE_SMS = "FreeSMS";
    private static final String POST_ADD = "add";
    private static final String POST_AJAX_REQUEST = "ajaxRequest";
    private static final String POST_MESSAGE_TEXT = "messageText";
    private static final String POST_PASSWORD = "userpass";
    private static final String POST_REMOVE = "remove";
    private static final String POST_USERNAME = "username";
    private static final String POST_VALUE_ADD_RECIPIENT = "addEnteredMSISDNs";
    private static final String POST_VALUE_NO_ID = "0%7C";
    private static final String POST_VALUE_NONE = "-";
    private static final String POST_VALUE_SEND_SMS = "sendSMS";

    public Meteor(Account account) {
        super(account);
    }

    @Override
    OperationResult doLogin() {
        ConnectionManager loginManager = new ConnectionManager(LOGIN_URL);
        loginManager.addPostHeader(POST_USERNAME, this.getAccount().getMobileNumber());
        loginManager.addPostHeader(POST_PASSWORD, this.getAccount().getPassword());
        String loginHtml = loginManager.connect();
        boolean isSuccess = loginHtml.contains(LOGIN_SUCCESS_TEXT);
        return isSuccess ? Success.LOGGED_IN : Fail.LOGIN_FAILED;
    }

    @Override
    int doGetRemainingSMS() {
        ConnectionManager manager = new ConnectionManager(REMAINING_SMS_URL, GET_REQUEST_METHOD, false);
        String smsHtml = manager.connect();
        try {
            JSONObject smsJson = new JSONObject(smsHtml);
            JSONObject freeSmsJson = smsJson.getJSONObject(JSON_FREE_SMS);
            return freeSmsJson.getInt(JSON_REMAINING_FREE_SMS);
        }
        catch (JSONException e) {
            e.printStackTrace();
            return -1;
        }
    }

    @Override
    OperationResult doSend(List<String> recipients, String message) {
        int smsBefore = this.doGetRemainingSMS();
        this.addRecipients(recipients);
        ConnectionManager sendManager = new ConnectionManager(SMS_URL);
        sendManager.addPostHeader(POST_AJAX_REQUEST, POST_VALUE_SEND_SMS);
        sendManager.addPostHeader(POST_MESSAGE_TEXT, message);
        boolean isSent = sendManager.connect().contains(SEND_SUCCESS_TEXT);
        if (isSent) {
            int smsAfter = this.doGetRemainingSMS();
            return smsAfter < smsBefore ? Success.MESSAGE_SENT : Fail.MESSAGE_FAILED;
        }
        return Fail.MESSAGE_FAILED;
    }

    private void addRecipients(List<String> recipients) {
        StringBuilder sb = new StringBuilder();
        for (String recipient : recipients) {
            sb.append(POST_VALUE_NO_ID);
            sb.append(recipient);
            sb.append(",");
        }
        if (sb.length() > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        ConnectionManager addManager = new ConnectionManager(SMS_URL);
        addManager.addPostHeader(POST_AJAX_REQUEST, POST_VALUE_ADD_RECIPIENT);
        addManager.addPostHeader(POST_REMOVE, POST_VALUE_NONE);
        addManager.addPostHeader(POST_ADD, sb.toString());
        addManager.connect();
    }

    @Override
    int doGetCharacterLimit() {
        ConnectionManager manager = new ConnectionManager(CHARACTER_COUNT_URL, GET_REQUEST_METHOD, false);
        String html = manager.connect();
        String charsText = "charsLeft\" value='";
        int startPos = html.indexOf("charsLeft\" value='") + "charsLeft\" value='".length();
        int endPos = html.indexOf("'", startPos);
        if (startPos > "charsLeft\" value='".length()) {
            String characterCount = html.substring(startPos, endPos);
            return Integer.valueOf(characterCount);
        }
        return -1;
    }
}

