/*
 * Decompiled with CFR 0.152.
 */
package org.swiftsms.io.net;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.EncoderException;
import org.apache.commons.codec.net.URLCodec;
import org.swiftsms.io.net.NoInternetAccessException;
import org.swiftsms.model.Account;
import org.swiftsms.tasks.Status;
import org.swiftsms.tasks.results.Fail;
import org.swiftsms.tasks.results.OperationResult;

public abstract class Operator {
    public static final int DEFAULT_CHAR_LIMIT = 160;
    protected final URLCodec encoder = new URLCodec();
    private final Account account;
    private int characterLimit = -1;

    public Operator(Account account) {
        this.account = account;
    }

    public final OperationResult login() {
        try {
            return this.doLogin();
        }
        catch (NoInternetAccessException e) {
            return Fail.NO_INTERNET_CONNECTION;
        }
    }

    abstract OperationResult doLogin();

    public final int getRemainingSMS() {
        try {
            int smsCount = this.doGetRemainingSMS();
            if (smsCount == -1) {
                this.login();
                return this.doGetRemainingSMS();
            }
            return smsCount;
        }
        catch (NoInternetAccessException e) {
            return -1;
        }
    }

    abstract int doGetRemainingSMS();

    public final OperationResult send(List<String> list, String message) {
        List<String> msgParts = this.getParts(message, this.getCharacterLimit());
        OperationResult sendStatus = Fail.MESSAGE_FAILED;
        try {
            for (String msgToSend : msgParts) {
                String encodedMsg = this.uriEncode(msgToSend);
                sendStatus = this.doSend(list, encodedMsg);
                if (sendStatus.getStatus() != Status.FAILED) continue;
                this.login();
                sendStatus = this.doSend(list, encodedMsg);
            }
            return sendStatus;
        }
        catch (NoInternetAccessException e) {
            return Fail.NO_INTERNET_CONNECTION;
        }
    }

    private List<String> getParts(String string, int partitionSize) {
        ArrayList<String> parts = new ArrayList<String>();
        int len = string.length();
        for (int i = 0; i < len; i += partitionSize) {
            parts.add(string.substring(i, Math.min(len, i + partitionSize)));
        }
        return parts;
    }

    abstract OperationResult doSend(List<String> var1, String var2);

    public final int getCharacterLimit() {
        try {
            if (this.characterLimit == -1) {
                this.characterLimit = this.doGetCharacterLimit();
                if (this.characterLimit == -1) {
                    this.login();
                    this.characterLimit = this.doGetCharacterLimit();
                }
            }
            return this.characterLimit == -1 ? 160 : this.characterLimit;
        }
        catch (NoInternetAccessException e) {
            return 160;
        }
    }

    abstract int doGetCharacterLimit();

    public Account getAccount() {
        return this.account;
    }

    protected String uriEncode(String message) {
        try {
            return this.encoder.encode(message);
        }
        catch (EncoderException e) {
            e.printStackTrace();
            return null;
        }
    }

    protected String uriDecode(String message) {
        try {
            return this.encoder.decode(message);
        }
        catch (DecoderException e) {
            e.printStackTrace();
            return null;
        }
    }
}

