/*
 * Decompiled with CFR 0.152.
 */
package org.swiftsms.io.net;

import java.util.LinkedHashMap;
import java.util.List;
import org.apache.commons.codec.binary.Base64;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.swiftsms.io.net.ConnectionManager;
import org.swiftsms.io.net.Operator;
import org.swiftsms.model.Account;
import org.swiftsms.tasks.results.Fail;
import org.swiftsms.tasks.results.OperationResult;
import org.swiftsms.tasks.results.Success;

public class Tesco
extends Operator {
    private static final String LOGIN_URL = "https://app.tescomobile.ie/MyTM/restws/user/permissions/";
    private static final String BASE_URL = "https://app.tescomobile.ie/MyTM/restws/webtext/";
    private static final String SEND_URL_POSTFIX = "/send";
    private static final String REMAIN_URL_POSTFIX = "/balance";
    private static final String JSON_MSISDN = "msisdn";
    private static final String JSON_NATIONAL_REMAINING = "nationalRemaining";
    private static final String JSON_TEXT = "text";
    private static final String JSON_MSISDNS = "msisdns";
    private static final String JSON_GROUPIDS = "groupIds";
    private static final String JSON_CONTACTIDS = "contactIds";
    private static final String GET = "GET";
    private static final String ACCEPT = "Accept";
    private static final String USER_AGENT = "User-Agent";
    private static final String AUTHORIZATION = "Authorization";
    private static final String ACCEPT_VALUE = "application/json";
    private static final String USER_AGENT_VALUE = "MyTescoApp/1.1";
    private final String auth;

    public Tesco(Account account) {
        super(account);
        String userPass = this.getAccount().getMobileNumber() + ":" + this.getAccount().getPassword();
        String authUserPass = Base64.encodeBase64String((byte[])userPass.getBytes());
        this.auth = "Basic " + authUserPass;
    }

    @Override
    OperationResult doLogin() {
        ConnectionManager manager = new ConnectionManager(LOGIN_URL + this.getAccount().getMobileNumber(), GET, false);
        manager.setRequestHeader(USER_AGENT, USER_AGENT_VALUE);
        manager.setRequestHeader(ACCEPT, ACCEPT_VALUE);
        manager.setRequestHeader(AUTHORIZATION, this.auth);
        String html = manager.connect();
        boolean isSuccess = html.contains(JSON_MSISDN);
        return isSuccess ? Success.LOGGED_IN : Fail.LOGIN_FAILED;
    }

    @Override
    int doGetRemainingSMS() {
        ConnectionManager manager = new ConnectionManager(BASE_URL + this.getAccount().getMobileNumber() + REMAIN_URL_POSTFIX, GET, false);
        manager.setRequestHeader(USER_AGENT, USER_AGENT_VALUE);
        manager.setRequestHeader(ACCEPT, ACCEPT_VALUE);
        manager.setRequestHeader(AUTHORIZATION, this.auth);
        String rawJson = manager.connect();
        try {
            JSONObject json = new JSONObject(rawJson);
            return json.getInt(JSON_NATIONAL_REMAINING);
        }
        catch (JSONException e) {
            e.printStackTrace();
            return -1;
        }
    }

    @Override
    OperationResult doSend(List<String> list, String message) {
        ConnectionManager manager = new ConnectionManager(BASE_URL + this.getAccount().getMobileNumber() + SEND_URL_POSTFIX);
        manager.setRequestHeader(USER_AGENT, USER_AGENT_VALUE);
        manager.setRequestHeader(ACCEPT, ACCEPT_VALUE);
        manager.setRequestHeader("Accept-Encoding", null);
        manager.setRequestHeader("Content-Type", ACCEPT_VALUE);
        manager.setRequestHeader(AUTHORIZATION, this.auth);
        LinkedHashMap<String, String> copyFrom = new LinkedHashMap<String, String>();
        copyFrom.put(JSON_TEXT, this.uriDecode(message));
        copyFrom.put(JSON_CONTACTIDS, (String)new JSONArray());
        copyFrom.put(JSON_GROUPIDS, (String)new JSONArray());
        copyFrom.put(JSON_MSISDNS, (String)new JSONArray(list));
        JSONObject requestJson = new JSONObject(copyFrom);
        manager.addRequestBody(requestJson.toString());
        String rawJson = manager.connect();
        try {
            JSONObject json = new JSONObject(rawJson);
            boolean isSent = json.length() == 0;
            return isSent ? Success.MESSAGE_SENT : Fail.MESSAGE_FAILED;
        }
        catch (JSONException e) {
            e.printStackTrace();
            return Fail.OPERATOR_CHANGED;
        }
    }

    @Override
    int doGetCharacterLimit() {
        return 160;
    }
}

