/*
 * Decompiled with CFR 0.152.
 */
package org.swiftsms.io.net;

import java.util.List;
import org.swiftsms.io.net.ConnectionManager;
import org.swiftsms.io.net.Operator;
import org.swiftsms.model.Account;
import org.swiftsms.tasks.results.Fail;
import org.swiftsms.tasks.results.OperationResult;
import org.swiftsms.tasks.results.Success;
import org.swiftsms.utils.ContactUtils;

public class Three
extends Operator {
    private static final String LOGIN_URL = "https://webtexts.three.ie/webtext/users/login";
    private static final String POST_USER = "data[User][telephoneNo]";
    private static final String POST_PASS = "data[User][pin]";
    private static final String SUCCESS_LOGIN = "Logout";
    private static final String SMS_URL = "https://webtexts.three.ie/webtext/messages/send";
    private static final String POST_MESSAGE_TEXT = "data[Message][message]";
    private static final String POST_RECIPIENT_INDIVIDUAL = "data[Message][recipients_individual]";
    private static final String SMS_SEND_SUCCESS_TEXT = "Message sent!";
    private static final String SMS_REMAINING_END_TEXT = "(of 333)</p>";
    private static final String SMS_REMAINING_CHARS_START_TEXT = "'characterNumber'>";
    private static final String GET_REQUEST_METHOD = "GET";
    private static final int MAX_MSG_RECIPIENTS = 3;

    public Three(Account account) {
        super(account);
    }

    @Override
    OperationResult doLogin() {
        ConnectionManager loginManager = new ConnectionManager(LOGIN_URL);
        loginManager.addPostHeader(POST_USER, this.getAccount().getMobileNumber());
        loginManager.addPostHeader(POST_PASS, this.getAccount().getPassword());
        String loginHtml = loginManager.connect();
        boolean isSuccess = loginHtml.contains(SUCCESS_LOGIN);
        return isSuccess ? Success.LOGGED_IN : Fail.LOGIN_FAILED;
    }

    @Override
    OperationResult doSend(List<String> recipients, String message) {
        OperationResult isSent = Fail.MESSAGE_FAILED;
        List<List<String>> splitRecipients = ContactUtils.chopped(recipients, 3);
        for (List<String> sendableRecipients : splitRecipients) {
            isSent = this.sendMessage(sendableRecipients, message);
        }
        return isSent;
    }

    private OperationResult sendMessage(List<String> recipients, String message) {
        ConnectionManager sendMessageManager = this.createMessageManager(recipients, message);
        boolean isSent = sendMessageManager.connect().contains(SMS_SEND_SUCCESS_TEXT);
        return isSent ? Success.MESSAGE_SENT : Fail.MESSAGE_FAILED;
    }

    private ConnectionManager createMessageManager(List<String> recipients, String message) {
        ConnectionManager manager = new ConnectionManager(SMS_URL);
        manager.addPostHeader(POST_MESSAGE_TEXT, message);
        for (int i = 0; i < recipients.size(); ++i) {
            String key = this.uriEncode("data[Message][recipients_individual][" + i + "]");
            String value = this.uriEncode(recipients.get(i));
            manager.addPostHeader(key, value);
        }
        return manager;
    }

    @Override
    int doGetRemainingSMS() {
        ConnectionManager manager = new ConnectionManager(SMS_URL, GET_REQUEST_METHOD, false);
        String html = manager.connect();
        return this.getRemainingSmsFromHTML(html);
    }

    @Override
    int doGetCharacterLimit() {
        ConnectionManager manager = new ConnectionManager(SMS_URL, GET_REQUEST_METHOD, false);
        String html = manager.connect();
        return this.getRemainingCharactersHTML(html);
    }

    private int getRemainingCharactersHTML(String html) {
        int index;
        int remainingChars = -1;
        String startText = SMS_REMAINING_CHARS_START_TEXT;
        int startPos = index = html.indexOf(SMS_REMAINING_CHARS_START_TEXT);
        int endPos = index + 5;
        try {
            String remainingCharsStr = html.substring(startPos, endPos).replaceAll("[</span>]", "");
            remainingChars = Integer.parseInt(remainingCharsStr.trim());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return remainingChars;
    }

    private int getRemainingSmsFromHTML(String html) {
        int remainingTexts = -1;
        String endText = SMS_REMAINING_END_TEXT;
        int index = html.indexOf(SMS_REMAINING_END_TEXT);
        int startPos = index - 4;
        int endPos = index;
        if (startPos > SMS_REMAINING_END_TEXT.length()) {
            try {
                String remainingSmsString = html.substring(startPos, endPos).replaceAll("[<p>]", "");
                remainingTexts = Integer.parseInt(remainingSmsString.trim());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return remainingTexts;
    }
}

