/*
 * Decompiled with CFR 0.152.
 */
package org.swiftsms.io.net.cookies;

import java.io.IOException;
import java.net.CookieManager;
import java.net.CookiePolicy;
import java.net.CookieStore;
import java.net.HttpCookie;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MyCookieManager
extends CookieManager {
    public MyCookieManager(CookieStore store, CookiePolicy cookiePolicy) {
        super(store, cookiePolicy);
    }

    @Override
    public void put(URI uri, Map<String, List<String>> responseHeaders) throws IOException {
        HashMap<String, List<String>> headers = new HashMap<String, List<String>>(responseHeaders);
        ArrayList<String> validCookies = new ArrayList<String>();
        for (Map.Entry<String, List<String>> entry : headers.entrySet()) {
            String headerName = entry.getKey();
            if (!"Set-Cookie".equals(headerName)) continue;
            for (String headerValue : entry.getValue()) {
                List<HttpCookie> cookies = HttpCookie.parse(headerValue);
                for (HttpCookie cookie : cookies) {
                    if (cookie.hasExpired()) continue;
                    validCookies.add(this.toRFC2965HeaderString(cookie));
                }
            }
            entry.setValue(validCookies);
        }
        super.put(uri, headers);
    }

    private String toRFC2965HeaderString(HttpCookie cookie) {
        StringBuilder sb = new StringBuilder();
        sb.append(cookie.getName()).append("=").append(cookie.getValue());
        sb.append("; Path=").append("/");
        if (cookie.getDomain() != null) {
            sb.append("; Domain=").append(cookie.getDomain());
        }
        if (cookie.getPortlist() != null) {
            sb.append("; Port=").append(cookie.getPortlist());
        }
        return sb.toString();
    }
}

