/*
 * Decompiled with CFR 0.152.
 */
package org.swiftsms.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.swiftsms.InternalString;

public class ContactUtils {
    private static final String NON_NUMBER_PATTERN = "[^\\d\\+]";
    private static final String SEPARATOR_PATTERN;
    private static final String IRISH_PREFIXS = "^(\\+353|00353|353)";
    private static final String ZERO = "0";

    public static <T> List<List<T>> chopped(List<T> list, int length) {
        ArrayList<List<T>> parts = new ArrayList<List<T>>();
        int N = list.size();
        for (int i = 0; i < N; i += length) {
            List<T> sublist = list.subList(i, Math.min(N, i + length));
            parts.add(new ArrayList<T>(sublist));
        }
        return parts;
    }

    public static boolean hasMultipleContacts(String recipients) {
        return ContactUtils.getPositionOfLastSeparator(recipients) != -1;
    }

    public static String getAllButLastContacts(String recipients) {
        if (ContactUtils.hasMultipleContacts(recipients)) {
            int lastComma = ContactUtils.getPositionOfLastSeparator(recipients);
            return recipients.substring(0, lastComma + 1) + " ";
        }
        return "";
    }

    public static String getLastContact(String recipients) {
        if (ContactUtils.hasMultipleContacts(recipients)) {
            int lastComma = ContactUtils.getPositionOfLastSeparator(recipients);
            return recipients.substring(lastComma + 1).trim();
        }
        return recipients;
    }

    public static List<String> getContactsAsList(String recipients) {
        String[] tokens;
        ArrayList<String> listOfRecip = new ArrayList<String>();
        for (String unformattedRecipient : tokens = ContactUtils.trimSeparators(recipients).split(SEPARATOR_PATTERN)) {
            String recipientNumber = ContactUtils.stripRecipientName(unformattedRecipient);
            String recipient = recipientNumber.replaceAll(NON_NUMBER_PATTERN, "");
            if (recipient.isEmpty()) continue;
            listOfRecip.add(recipient);
        }
        return ContactUtils.removeIrishPrefixFromRecipients(listOfRecip);
    }

    private static String stripRecipientName(String unformattedRecipient) {
        int startOfNumber = unformattedRecipient.lastIndexOf(40) + 1;
        int endOfNumber = unformattedRecipient.lastIndexOf(41);
        if (startOfNumber != 0 && endOfNumber != -1) {
            return unformattedRecipient.substring(startOfNumber, endOfNumber);
        }
        return unformattedRecipient;
    }

    private static int getPositionOfLastSeparator(String recipients) {
        Pattern pattern = Pattern.compile(".*" + SEPARATOR_PATTERN);
        Matcher matcher = pattern.matcher(recipients);
        if (matcher.find()) {
            return matcher.end() - 1;
        }
        return -1;
    }

    public static String trimSeparators(String recipients) {
        String[] tokens;
        StringBuilder result = new StringBuilder();
        for (String token : tokens = recipients.trim().split(SEPARATOR_PATTERN)) {
            String recipient = token.trim();
            if (recipient.equals("")) continue;
            if (result.length() > 0) {
                result.append(", ");
            }
            result.append(recipient);
        }
        return result.toString();
    }

    public static String removeIrishPrefix(String recipient) {
        if (recipient == null) {
            return null;
        }
        return recipient.replaceAll(IRISH_PREFIXS, ZERO);
    }

    public static List<String> removeIrishPrefixFromRecipients(List<String> recipients) {
        ArrayList<String> newRecipients = new ArrayList<String>();
        for (String recipient : recipients) {
            newRecipients.add(ContactUtils.removeIrishPrefix(recipient));
        }
        return newRecipients;
    }

    public static boolean isNumber(String number) {
        if (number == null) {
            return false;
        }
        return number.matches("\\+?\\d{7,}");
    }

    static {
        StringBuilder pattern = new StringBuilder();
        pattern.append("[");
        for (String s : InternalString.CONTACT_SEPARATOR) {
            pattern.append(s);
        }
        pattern.append("]");
        SEPARATOR_PATTERN = pattern.toString();
    }
}

