/*
 * Decompiled with CFR 0.152.
 */
package swim.actor;

import java.net.InetSocketAddress;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import swim.api.auth.Authenticator;
import swim.api.auth.AuthenticatorContext;
import swim.concurrent.MainStage;
import swim.concurrent.Schedule;
import swim.concurrent.Stage;
import swim.io.IpService;
import swim.io.IpServiceRef;
import swim.io.IpSettings;
import swim.io.IpSocket;
import swim.io.IpSocketRef;
import swim.kernel.KernelContext;
import swim.runtime.AuthenticatorAddress;
import swim.runtime.CellAddress;
import swim.util.Log;

public class ActorAuthenticator
implements AuthenticatorContext {
    protected static final int STARTED = 1;
    protected static final AtomicIntegerFieldUpdater<ActorAuthenticator> STATUS = AtomicIntegerFieldUpdater.newUpdater(ActorAuthenticator.class, "status");
    final String authenticatorName;
    final KernelContext kernel;
    Authenticator authenticator;
    volatile int status;
    Log log;
    Stage stage;

    public ActorAuthenticator(String authenticatorName, KernelContext kernel) {
        this.authenticatorName = authenticatorName;
        this.kernel = kernel;
    }

    public final String authenticatorName() {
        return this.authenticatorName;
    }

    public Schedule schedule() {
        return this.stage;
    }

    public final Stage stage() {
        return this.stage;
    }

    public final KernelContext kernel() {
        return this.kernel;
    }

    public final Authenticator authenticator() {
        return this.authenticator;
    }

    public void setAuthenticator(Authenticator authenticator) {
        this.authenticator = authenticator;
    }

    public IpSettings ipSettings() {
        return this.kernel.ipSettings();
    }

    public IpServiceRef bindTcp(InetSocketAddress localAddress, IpService service, IpSettings ipSettings) {
        return this.kernel.bindTcp(localAddress, service, ipSettings);
    }

    public IpServiceRef bindTls(InetSocketAddress localAddress, IpService service, IpSettings ipSettings) {
        return this.kernel.bindTls(localAddress, service, ipSettings);
    }

    public IpSocketRef connectTcp(InetSocketAddress remoteAddress, IpSocket socket, IpSettings ipSettings) {
        return this.kernel.connectTcp(remoteAddress, socket, ipSettings);
    }

    public IpSocketRef connectTls(InetSocketAddress remoteAddress, IpSocket socket, IpSettings ipSettings) {
        return this.kernel.connectTls(remoteAddress, socket, ipSettings);
    }

    public void start() {
        int newStatus;
        int oldStatus;
        while ((oldStatus = this.status) != (newStatus = oldStatus | 1) && !STATUS.compareAndSet(this, oldStatus, newStatus)) {
        }
        if ((oldStatus & 1) == 0) {
            this.willStart();
            this.didStart();
        }
    }

    public void stop() {
        int newStatus;
        int oldStatus;
        while ((oldStatus = this.status) != (newStatus = oldStatus & 0xFFFFFFFE) && !STATUS.compareAndSet(this, oldStatus, newStatus)) {
        }
        if ((oldStatus & 1) != 0) {
            this.willStop();
            this.didStop();
        }
    }

    protected void willStart() {
        AuthenticatorAddress authenticatorAddress = new AuthenticatorAddress(this.authenticatorName);
        this.log = this.kernel.createLog((CellAddress)authenticatorAddress);
        this.stage = this.kernel.createStage((CellAddress)authenticatorAddress);
        this.authenticator.willStart();
    }

    protected void didStart() {
        this.authenticator.didStart();
    }

    protected void willStop() {
        this.authenticator.willStop();
    }

    protected void didStop() {
        this.authenticator.didStop();
        Stage stage = this.stage;
        if (stage instanceof MainStage) {
            ((MainStage)stage).stop();
        }
        this.stage = null;
        this.log = null;
    }

    public void trace(Object message) {
        Log log = this.log;
        if (log != null) {
            log.trace(message);
        } else {
            this.kernel.trace(message);
        }
    }

    public void debug(Object message) {
        Log log = this.log;
        if (log != null) {
            log.debug(message);
        } else {
            this.kernel.debug(message);
        }
    }

    public void info(Object message) {
        Log log = this.log;
        if (log != null) {
            log.info(message);
        } else {
            this.kernel.info(message);
        }
    }

    public void warn(Object message) {
        Log log = this.log;
        if (log != null) {
            log.warn(message);
        } else {
            this.kernel.warn(message);
        }
    }

    public void error(Object message) {
        Log log = this.log;
        if (log != null) {
            log.error(message);
        } else {
            this.kernel.error(message);
        }
    }

    public void fail(Object message) {
        Log log = this.log;
        if (log != null) {
            log.fail(message);
        } else {
            this.kernel.fail(message);
        }
    }
}

