/*
 * Decompiled with CFR 0.152.
 */
package swim.actor;

import swim.actor.ActorNode;
import swim.actor.ActorPart;
import swim.actor.ActorTier;
import swim.api.agent.Agent;
import swim.api.agent.AgentDef;
import swim.api.agent.AgentFactory;
import swim.api.auth.Credentials;
import swim.api.auth.Identity;
import swim.api.policy.Policy;
import swim.api.policy.PolicyDirective;
import swim.concurrent.Stage;
import swim.concurrent.StageDef;
import swim.runtime.CellAddress;
import swim.runtime.CellBinding;
import swim.runtime.CellContext;
import swim.runtime.HostAddress;
import swim.runtime.HostBinding;
import swim.runtime.HostContext;
import swim.runtime.HostDef;
import swim.runtime.LaneAddress;
import swim.runtime.LaneBinding;
import swim.runtime.LaneDef;
import swim.runtime.LinkBinding;
import swim.runtime.LogDef;
import swim.runtime.NodeAddress;
import swim.runtime.NodeBinding;
import swim.runtime.NodeDef;
import swim.runtime.PartBinding;
import swim.runtime.PolicyDef;
import swim.runtime.agent.AgentModel;
import swim.store.StoreBinding;
import swim.store.StoreDef;
import swim.structure.Item;
import swim.structure.Record;
import swim.structure.Value;
import swim.uri.Uri;
import swim.uri.UriMapper;
import swim.util.Log;

public class ActorHost
extends ActorTier
implements HostBinding,
HostContext {
    final HostBinding hostBinding;
    HostContext hostContext;
    HostDef hostDef;

    public ActorHost(HostBinding hostBinding, HostDef hostDef) {
        this.hostBinding = hostBinding;
        this.hostDef = hostDef;
    }

    public final HostDef hostDef() {
        return this.hostDef;
    }

    public final ActorPart actorPart() {
        return (ActorPart)this.part().unwrapPart(ActorPart.class);
    }

    public final PartBinding part() {
        return this.hostContext.part();
    }

    public final HostBinding hostWrapper() {
        return this.hostBinding.hostWrapper();
    }

    public final HostBinding hostBinding() {
        return this.hostBinding;
    }

    public final HostContext hostContext() {
        return this.hostContext;
    }

    public void setHostContext(HostContext hostContext) {
        this.hostContext = hostContext;
        this.hostBinding.setHostContext((HostContext)this);
    }

    public <T> T unwrapHost(Class<T> hostClass) {
        if (hostClass.isAssignableFrom(this.getClass())) {
            return (T)this;
        }
        return (T)this.hostContext.unwrapHost(hostClass);
    }

    @Override
    public final CellBinding cellBinding() {
        return this.hostBinding;
    }

    @Override
    public final CellContext cellContext() {
        return this.hostContext;
    }

    public final HostAddress cellAddress() {
        return this.hostContext.cellAddress();
    }

    public Value partKey() {
        return this.hostContext.partKey();
    }

    public Uri hostUri() {
        return this.hostContext.hostUri();
    }

    public boolean isConnected() {
        return this.hostBinding.isConnected();
    }

    public boolean isRemote() {
        return this.hostBinding.isRemote();
    }

    public boolean isSecure() {
        return this.hostBinding.isSecure();
    }

    public boolean isPrimary() {
        return this.hostBinding.isPrimary();
    }

    public void setPrimary(boolean isPrimary) {
        this.hostBinding.setPrimary(isPrimary);
    }

    public boolean isReplica() {
        return this.hostBinding.isReplica();
    }

    public void setReplica(boolean isReplica) {
        this.hostBinding.setReplica(isReplica);
    }

    public boolean isMaster() {
        return this.hostBinding.isMaster();
    }

    public boolean isSlave() {
        return this.hostBinding.isSlave();
    }

    public void didBecomeMaster() {
        this.hostBinding.didBecomeMaster();
    }

    public void didBecomeSlave() {
        this.hostBinding.didBecomeSlave();
    }

    public UriMapper<NodeBinding> nodes() {
        return this.hostBinding.nodes();
    }

    public NodeBinding getNode(Uri nodeUri) {
        return this.hostBinding.getNode(nodeUri);
    }

    public NodeBinding openNode(Uri nodeUri) {
        return this.hostBinding.openNode(nodeUri);
    }

    public NodeBinding openNode(Uri nodeUri, NodeBinding node) {
        return this.hostBinding.openNode(nodeUri, node);
    }

    public Log createLog(LogDef logDef) {
        ActorPart part = this.actorPart();
        return part != null ? part.createLog(logDef) : null;
    }

    public Log createLog(CellAddress cellAddress) {
        ActorPart part = this.actorPart();
        return part != null ? part.createLog(cellAddress) : null;
    }

    public Log injectLog(Log log) {
        ActorPart part = this.actorPart();
        return part != null ? part.injectLog(log) : log;
    }

    @Override
    protected Log openLog() {
        Log log = this.hostDef != null && this.hostDef.logDef() != null ? this.createLog(this.hostDef.logDef()) : this.createLog((CellAddress)this.cellAddress());
        if (log != null) {
            log = this.injectLog(log);
        }
        return log;
    }

    public Policy createPolicy(PolicyDef policyDef) {
        ActorPart part = this.actorPart();
        return part != null ? part.createPolicy(policyDef) : null;
    }

    public Policy createPolicy(CellAddress cellAddress) {
        ActorPart part = this.actorPart();
        return part != null ? part.createPolicy(cellAddress) : null;
    }

    public Policy injectPolicy(Policy policy) {
        ActorPart part = this.actorPart();
        return part != null ? part.injectPolicy(policy) : policy;
    }

    @Override
    protected Policy openPolicy() {
        Policy policy = this.hostDef != null && this.hostDef.policyDef() != null ? this.createPolicy(this.hostDef.policyDef()) : this.createPolicy((CellAddress)this.cellAddress());
        if (policy != null) {
            policy = this.injectPolicy(policy);
        }
        return policy;
    }

    public Stage createStage(StageDef stageDef) {
        ActorPart part = this.actorPart();
        return part != null ? part.createStage(stageDef) : null;
    }

    public Stage createStage(CellAddress cellAddress) {
        ActorPart part = this.actorPart();
        return part != null ? part.createStage(cellAddress) : null;
    }

    public Stage injectStage(Stage stage) {
        ActorPart part = this.actorPart();
        return part != null ? part.injectStage(stage) : stage;
    }

    @Override
    protected Stage openStage() {
        Stage stage = this.hostDef != null && this.hostDef.stageDef() != null ? this.createStage(this.hostDef.stageDef()) : this.createStage((CellAddress)this.cellAddress());
        if (stage != null) {
            stage = this.injectStage(stage);
        }
        return stage;
    }

    public StoreBinding createStore(StoreDef storeDef) {
        ActorPart part = this.actorPart();
        return part != null ? part.createStore(storeDef) : null;
    }

    public StoreBinding createStore(CellAddress cellAddress) {
        ActorPart part = this.actorPart();
        return part != null ? part.createStore(cellAddress) : null;
    }

    public StoreBinding injectStore(StoreBinding store) {
        ActorPart part = this.actorPart();
        return part != null ? part.injectStore(store) : store;
    }

    @Override
    protected StoreBinding openStore() {
        StoreBinding store = null;
        store = this.hostDef != null && this.hostDef.storeDef() != null ? this.createStore(this.hostDef.storeDef()) : this.createStore((CellAddress)this.cellAddress());
        if (store != null) {
            store = this.injectStore(store);
        }
        return store;
    }

    public void openMetaHost(HostBinding host, NodeBinding metaHost) {
        ActorPart part = this.actorPart();
        if (part != null) {
            part.openMetaHost(host, metaHost);
        }
    }

    public NodeDef getNodeDef(NodeAddress nodeAddress) {
        NodeDef nodeDef;
        HostDef hostDef = this.hostDef;
        NodeDef nodeDef2 = nodeDef = hostDef != null ? hostDef.getNodeDef(nodeAddress.nodeUri()) : null;
        if (nodeDef == null) {
            ActorPart part = this.actorPart();
            nodeDef = part != null ? part.getNodeDef(nodeAddress) : null;
        }
        return nodeDef;
    }

    public NodeBinding createNode(NodeAddress nodeAddress) {
        NodeBinding node = this.hostContext.createNode(nodeAddress);
        if (node == null && !this.meshUri().isDefined()) {
            NodeDef nodeDef;
            HostDef hostDef = this.hostDef;
            NodeDef nodeDef2 = nodeDef = hostDef != null ? hostDef.getNodeDef(nodeAddress.nodeUri()) : null;
            if (nodeDef != null) {
                Value props = nodeDef.props(nodeAddress.nodeUri());
                node = new AgentModel(props);
            }
        }
        return node;
    }

    public NodeBinding injectNode(NodeAddress nodeAddress, NodeBinding node) {
        NodeDef nodeDef = this.getNodeDef(nodeAddress);
        return new ActorNode(this.hostContext.injectNode(nodeAddress, node), nodeDef);
    }

    public void openMetaNode(NodeBinding node, NodeBinding metaNode) {
        ActorPart part = this.actorPart();
        if (part != null) {
            part.openMetaNode(node, metaNode);
        }
    }

    public LaneDef getLaneDef(LaneAddress laneAddress) {
        LaneDef laneDef;
        HostDef hostDef = this.hostDef;
        LaneDef laneDef2 = laneDef = hostDef != null ? hostDef.getLaneDef(laneAddress.laneUri()) : null;
        if (laneDef == null) {
            ActorPart part = this.actorPart();
            laneDef = part != null ? part.getLaneDef(laneAddress) : null;
        }
        return laneDef;
    }

    public LaneBinding createLane(LaneAddress laneAddress) {
        return this.hostContext.createLane(laneAddress);
    }

    public LaneBinding injectLane(LaneAddress laneAddress, LaneBinding lane) {
        return this.hostContext.injectLane(laneAddress, lane);
    }

    public void openMetaLane(LaneBinding lane, NodeBinding metaLane) {
        ActorPart part = this.actorPart();
        if (part != null) {
            part.openMetaLane(lane, metaLane);
        }
    }

    public void openMetaUplink(LinkBinding uplink, NodeBinding metaUplink) {
        ActorPart part = this.actorPart();
        if (part != null) {
            part.openMetaUplink(uplink, metaUplink);
        }
    }

    public void openMetaDownlink(LinkBinding downlink, NodeBinding metaDownlink) {
        ActorPart part = this.actorPart();
        if (part != null) {
            part.openMetaDownlink(downlink, metaDownlink);
        }
    }

    public LaneBinding createLane(NodeBinding node, LaneDef laneDef) {
        return this.hostContext.createLane(node, laneDef);
    }

    public void openLanes(NodeBinding node) {
        this.hostContext.openLanes(node);
    }

    public AgentFactory<?> createAgentFactory(NodeBinding node, AgentDef agentDef) {
        return this.hostContext.createAgentFactory(node, agentDef);
    }

    public <A extends Agent> AgentFactory<A> createAgentFactory(NodeBinding node, Class<? extends A> agentClass) {
        return this.hostContext.createAgentFactory(node, agentClass);
    }

    public void openAgents(NodeBinding node) {
        this.hostContext.openAgents(node);
        if (!this.meshUri().isDefined()) {
            NodeDef nodeDef;
            HostDef hostDef = this.hostDef;
            NodeDef nodeDef2 = nodeDef = hostDef != null ? hostDef.getNodeDef(node.nodeUri()) : null;
            if (nodeDef != null && node instanceof AgentModel) {
                AgentModel agentModel = (AgentModel)node;
                for (AgentDef agentDef : nodeDef.agentDefs()) {
                    AgentFactory<?> agentFactory = this.createAgentFactory(node, agentDef);
                    if (agentDef == null) continue;
                    Value id = agentDef.id();
                    Record props = agentModel.props().concat((Item)agentDef.props());
                    agentModel.addAgentView(agentModel.createAgent(agentFactory, id, (Value)props));
                }
            }
        }
    }

    public PolicyDirective<Identity> authenticate(Credentials credentials) {
        return this.hostContext.authenticate(credentials);
    }

    public void didConnect() {
        this.hostContext.didConnect();
    }

    public void didDisconnect() {
        this.hostContext.didDisconnect();
    }

    public void didClose() {
        this.hostBinding.didClose();
    }

    public void didFail(Throwable error) {
        this.hostBinding.didFail(error);
    }
}

