/*
 * Decompiled with CFR 0.152.
 */
package swim.actor;

import swim.actor.ActorPart;
import swim.actor.ActorSpace;
import swim.actor.ActorTier;
import swim.api.agent.Agent;
import swim.api.agent.AgentDef;
import swim.api.agent.AgentFactory;
import swim.api.auth.Credentials;
import swim.api.auth.Identity;
import swim.api.policy.Policy;
import swim.api.policy.PolicyDirective;
import swim.collections.FingerTrieSeq;
import swim.concurrent.Stage;
import swim.concurrent.StageDef;
import swim.runtime.CellAddress;
import swim.runtime.CellBinding;
import swim.runtime.CellContext;
import swim.runtime.EdgeBinding;
import swim.runtime.HostAddress;
import swim.runtime.HostBinding;
import swim.runtime.HostDef;
import swim.runtime.LaneAddress;
import swim.runtime.LaneBinding;
import swim.runtime.LaneDef;
import swim.runtime.LinkBinding;
import swim.runtime.LogDef;
import swim.runtime.MeshAddress;
import swim.runtime.MeshBinding;
import swim.runtime.MeshContext;
import swim.runtime.MeshDef;
import swim.runtime.NodeAddress;
import swim.runtime.NodeBinding;
import swim.runtime.NodeDef;
import swim.runtime.PartAddress;
import swim.runtime.PartBinding;
import swim.runtime.PartDef;
import swim.runtime.PolicyDef;
import swim.runtime.agent.AgentModel;
import swim.store.StoreBinding;
import swim.store.StoreDef;
import swim.structure.Item;
import swim.structure.Record;
import swim.structure.Value;
import swim.uri.Uri;
import swim.util.Log;

public class ActorMesh
extends ActorTier
implements MeshBinding,
MeshContext {
    final MeshBinding meshBinding;
    MeshContext meshContext;
    MeshDef meshDef;

    public ActorMesh(MeshBinding meshBinding, MeshDef meshDef) {
        this.meshBinding = meshBinding;
        this.meshDef = meshDef;
    }

    public final MeshDef meshDef() {
        return this.meshDef;
    }

    public final ActorSpace actorEdge() {
        return (ActorSpace)((Object)this.edge().unwrapEdge(ActorSpace.class));
    }

    public final EdgeBinding edge() {
        return this.meshContext.edge();
    }

    public final MeshBinding meshWrapper() {
        return this.meshBinding.meshWrapper();
    }

    public final MeshBinding meshBinding() {
        return this.meshBinding;
    }

    public final MeshContext meshContext() {
        return this.meshContext;
    }

    public void setMeshContext(MeshContext meshContext) {
        this.meshContext = meshContext;
        this.meshBinding.setMeshContext((MeshContext)this);
    }

    public <T> T unwrapMesh(Class<T> meshClass) {
        if (meshClass.isAssignableFrom(this.getClass())) {
            return (T)this;
        }
        return (T)this.meshContext.unwrapMesh(meshClass);
    }

    @Override
    public final CellBinding cellBinding() {
        return this.meshBinding;
    }

    @Override
    public final CellContext cellContext() {
        return this.meshContext;
    }

    public final MeshAddress cellAddress() {
        return this.meshContext.cellAddress();
    }

    public PartBinding gateway() {
        return this.meshBinding.gateway();
    }

    public void setGateway(PartBinding gateway) {
        this.meshBinding.setGateway(gateway);
    }

    public PartBinding ourself() {
        return this.meshBinding.ourself();
    }

    public void setOurself(PartBinding ourself) {
        this.meshBinding.setOurself(ourself);
    }

    public FingerTrieSeq<PartBinding> parts() {
        return this.meshBinding.parts();
    }

    public PartBinding getPart(Uri nodeUri) {
        return this.meshBinding.getPart(nodeUri);
    }

    public PartBinding getPart(Value partKey) {
        return this.meshBinding.getPart(partKey);
    }

    public PartBinding openPart(Uri nodeUri) {
        return this.meshBinding.openPart(nodeUri);
    }

    public PartBinding openGateway() {
        return this.meshBinding.openGateway();
    }

    public PartBinding addPart(Value partKey, PartBinding part) {
        return this.meshBinding.addPart(partKey, part);
    }

    public Log createLog(LogDef logDef) {
        ActorSpace edge = this.actorEdge();
        return edge != null ? edge.createLog(logDef) : null;
    }

    public Log createLog(CellAddress cellAddress) {
        ActorSpace edge = this.actorEdge();
        return edge != null ? edge.createLog(cellAddress) : null;
    }

    public Log injectLog(Log log) {
        ActorSpace edge = this.actorEdge();
        return edge != null ? edge.injectLog(log) : log;
    }

    @Override
    protected Log openLog() {
        Log log = this.meshDef != null && this.meshDef.logDef() != null ? this.createLog(this.meshDef.logDef()) : this.createLog((CellAddress)this.cellAddress());
        if (log != null) {
            log = this.injectLog(log);
        }
        return log;
    }

    public Policy createPolicy(PolicyDef policyDef) {
        ActorSpace edge = this.actorEdge();
        return edge != null ? edge.createPolicy(policyDef) : null;
    }

    public Policy createPolicy(CellAddress cellAddress) {
        ActorSpace edge = this.actorEdge();
        return edge != null ? edge.createPolicy(cellAddress) : null;
    }

    public Policy injectPolicy(Policy policy) {
        ActorSpace edge = this.actorEdge();
        return edge != null ? edge.injectPolicy(policy) : policy;
    }

    @Override
    protected Policy openPolicy() {
        Policy policy = this.meshDef != null && this.meshDef.policyDef() != null ? this.createPolicy(this.meshDef.policyDef()) : this.createPolicy((CellAddress)this.cellAddress());
        if (policy != null) {
            policy = this.injectPolicy(policy);
        }
        return policy;
    }

    public Stage createStage(StageDef stageDef) {
        ActorSpace edge = this.actorEdge();
        return edge != null ? edge.createStage(stageDef) : null;
    }

    public Stage createStage(CellAddress cellAddress) {
        ActorSpace edge = this.actorEdge();
        return edge != null ? edge.createStage(cellAddress) : null;
    }

    public Stage injectStage(Stage stage) {
        ActorSpace edge = this.actorEdge();
        return edge != null ? edge.injectStage(stage) : stage;
    }

    @Override
    protected Stage openStage() {
        Stage stage = this.meshDef != null && this.meshDef.stageDef() != null ? this.createStage(this.meshDef.stageDef()) : this.createStage((CellAddress)this.cellAddress());
        if (stage != null) {
            stage = this.injectStage(stage);
        }
        return stage;
    }

    public StoreBinding createStore(StoreDef storeDef) {
        ActorSpace edge = this.actorEdge();
        return edge != null ? edge.createStore(storeDef) : null;
    }

    public StoreBinding createStore(CellAddress cellAddress) {
        ActorSpace edge = this.actorEdge();
        return edge != null ? edge.createStore(cellAddress) : null;
    }

    public StoreBinding injectStore(StoreBinding store) {
        ActorSpace edge = this.actorEdge();
        return edge != null ? edge.injectStore(store) : store;
    }

    @Override
    protected StoreBinding openStore() {
        StoreBinding store = null;
        store = this.meshDef != null && this.meshDef.storeDef() != null ? this.createStore(this.meshDef.storeDef()) : this.createStore((CellAddress)this.cellAddress());
        if (store != null) {
            store = this.injectStore(store);
        }
        return store;
    }

    public void openMetaMesh(MeshBinding mesh, NodeBinding metaMesh) {
        ActorSpace edge = this.actorEdge();
        if (edge != null) {
            edge.openMetaMesh(mesh, metaMesh);
        }
    }

    public PartDef getPartDef(PartAddress partAddress) {
        PartDef partDef;
        MeshDef meshDef = this.meshDef;
        PartDef partDef2 = partDef = meshDef != null ? meshDef.getPartDef(partAddress.partKey()) : null;
        if (partDef == null) {
            ActorSpace edge = this.actorEdge();
            partDef = edge != null ? edge.getPartDef(partAddress) : null;
        }
        return partDef;
    }

    public PartBinding createPart(PartAddress partAddress) {
        return this.meshContext.createPart(partAddress);
    }

    public PartBinding injectPart(PartAddress partAddress, PartBinding part) {
        PartDef partDef = this.getPartDef(partAddress);
        return new ActorPart(this.meshContext.injectPart(partAddress, part), partDef);
    }

    public void openMetaPart(PartBinding part, NodeBinding metaPart) {
        ActorSpace edge = this.actorEdge();
        if (edge != null) {
            edge.openMetaPart(part, metaPart);
        }
    }

    public HostDef getHostDef(HostAddress hostAddress) {
        HostDef hostDef;
        MeshDef meshDef = this.meshDef;
        HostDef hostDef2 = hostDef = meshDef != null ? meshDef.getHostDef(hostAddress.hostUri()) : null;
        if (hostDef == null) {
            ActorSpace edge = this.actorEdge();
            hostDef = edge != null ? edge.getHostDef(hostAddress) : null;
        }
        return hostDef;
    }

    public HostBinding createHost(HostAddress hostAddress) {
        return this.meshContext.createHost(hostAddress);
    }

    public HostBinding injectHost(HostAddress hostAddress, HostBinding host) {
        return this.meshContext.injectHost(hostAddress, host);
    }

    public void openMetaHost(HostBinding host, NodeBinding metaHost) {
        ActorSpace edge = this.actorEdge();
        if (edge != null) {
            edge.openMetaHost(host, metaHost);
        }
    }

    public NodeDef getNodeDef(NodeAddress nodeAddress) {
        NodeDef nodeDef;
        MeshDef meshDef = this.meshDef;
        NodeDef nodeDef2 = nodeDef = meshDef != null ? meshDef.getNodeDef(nodeAddress.nodeUri()) : null;
        if (nodeDef == null) {
            ActorSpace edge = this.actorEdge();
            nodeDef = edge != null ? edge.getNodeDef(nodeAddress) : null;
        }
        return nodeDef;
    }

    public NodeBinding createNode(NodeAddress nodeAddress) {
        NodeBinding node = this.meshContext.createNode(nodeAddress);
        if (node == null && !this.meshUri().isDefined()) {
            NodeDef nodeDef;
            MeshDef meshDef = this.meshDef;
            NodeDef nodeDef2 = nodeDef = meshDef != null ? meshDef.getNodeDef(nodeAddress.nodeUri()) : null;
            if (nodeDef != null) {
                Value props = nodeDef.props(nodeAddress.nodeUri());
                node = new AgentModel(props);
            }
        }
        return node;
    }

    public NodeBinding injectNode(NodeAddress nodeAddress, NodeBinding node) {
        return this.meshContext.injectNode(nodeAddress, node);
    }

    public void openMetaNode(NodeBinding node, NodeBinding metaNode) {
        ActorSpace edge = this.actorEdge();
        if (edge != null) {
            edge.openMetaNode(node, metaNode);
        }
    }

    public LaneDef getLaneDef(LaneAddress laneAddress) {
        LaneDef laneDef;
        MeshDef meshDef = this.meshDef;
        LaneDef laneDef2 = laneDef = meshDef != null ? meshDef.getLaneDef(laneAddress.laneUri()) : null;
        if (laneDef == null) {
            ActorSpace edge = this.actorEdge();
            laneDef = edge != null ? edge.getLaneDef(laneAddress) : null;
        }
        return laneDef;
    }

    public LaneBinding createLane(LaneAddress laneAddress) {
        return this.meshContext.createLane(laneAddress);
    }

    public LaneBinding injectLane(LaneAddress laneAddress, LaneBinding lane) {
        return this.meshContext.injectLane(laneAddress, lane);
    }

    public void openMetaLane(LaneBinding lane, NodeBinding metaLane) {
        ActorSpace edge = this.actorEdge();
        if (edge != null) {
            edge.openMetaLane(lane, metaLane);
        }
    }

    public void openMetaUplink(LinkBinding uplink, NodeBinding metaUplink) {
        ActorSpace edge = this.actorEdge();
        if (edge != null) {
            edge.openMetaUplink(uplink, metaUplink);
        }
    }

    public void openMetaDownlink(LinkBinding downlink, NodeBinding metaDownlink) {
        ActorSpace edge = this.actorEdge();
        if (edge != null) {
            edge.openMetaDownlink(downlink, metaDownlink);
        }
    }

    public LaneBinding createLane(NodeBinding node, LaneDef laneDef) {
        return this.meshContext.createLane(node, laneDef);
    }

    public void openLanes(NodeBinding node) {
        this.meshContext.openLanes(node);
    }

    public AgentFactory<?> createAgentFactory(NodeBinding node, AgentDef agentDef) {
        return this.meshContext.createAgentFactory(node, agentDef);
    }

    public <A extends Agent> AgentFactory<A> createAgentFactory(NodeBinding node, Class<? extends A> agentClass) {
        return this.meshContext.createAgentFactory(node, agentClass);
    }

    public void openAgents(NodeBinding node) {
        this.meshContext.openAgents(node);
        if (!this.meshUri().isDefined()) {
            NodeDef nodeDef;
            MeshDef meshDef = this.meshDef;
            NodeDef nodeDef2 = nodeDef = meshDef != null ? meshDef.getNodeDef(node.nodeUri()) : null;
            if (nodeDef != null && node instanceof AgentModel) {
                AgentModel agentModel = (AgentModel)node;
                for (AgentDef agentDef : nodeDef.agentDefs()) {
                    AgentFactory<?> agentFactory = this.createAgentFactory(node, agentDef);
                    if (agentDef == null) continue;
                    Value id = agentDef.id();
                    Record props = agentModel.props().concat((Item)agentDef.props());
                    agentModel.addAgentView(agentModel.createAgent(agentFactory, id, (Value)props));
                }
            }
        }
    }

    public PolicyDirective<Identity> authenticate(Credentials credentials) {
        return this.meshContext.authenticate(credentials);
    }

    public void didClose() {
        this.meshBinding.didClose();
    }

    public void didFail(Throwable error) {
        this.meshBinding.didFail(error);
    }
}

