/*
 * Decompiled with CFR 0.152.
 */
package swim.actor;

import swim.actor.ActorHost;
import swim.actor.ActorLane;
import swim.actor.ActorTier;
import swim.api.agent.Agent;
import swim.api.agent.AgentDef;
import swim.api.agent.AgentFactory;
import swim.api.auth.Identity;
import swim.api.policy.Policy;
import swim.collections.FingerTrieSeq;
import swim.collections.HashTrieMap;
import swim.concurrent.Stage;
import swim.concurrent.StageDef;
import swim.runtime.CellAddress;
import swim.runtime.CellBinding;
import swim.runtime.CellContext;
import swim.runtime.HostBinding;
import swim.runtime.LaneAddress;
import swim.runtime.LaneBinding;
import swim.runtime.LaneDef;
import swim.runtime.LinkBinding;
import swim.runtime.LogDef;
import swim.runtime.NodeAddress;
import swim.runtime.NodeBinding;
import swim.runtime.NodeContext;
import swim.runtime.NodeDef;
import swim.runtime.PolicyDef;
import swim.store.StoreBinding;
import swim.store.StoreDef;
import swim.structure.Record;
import swim.structure.Value;
import swim.uri.Uri;
import swim.util.Log;

public class ActorNode
extends ActorTier
implements NodeBinding,
NodeContext {
    final NodeBinding nodeBinding;
    NodeContext nodeContext;
    NodeDef nodeDef;

    public ActorNode(NodeBinding nodeBinding, NodeDef nodeDef) {
        this.nodeBinding = nodeBinding;
        this.nodeDef = nodeDef;
    }

    public final NodeDef nodeDef() {
        return this.nodeDef;
    }

    public final ActorHost actorHost() {
        return (ActorHost)this.host().unwrapHost(ActorHost.class);
    }

    public final HostBinding host() {
        return this.nodeContext.host();
    }

    public final NodeBinding nodeWrapper() {
        return this.nodeBinding.nodeWrapper();
    }

    public final NodeBinding nodeBinding() {
        return this.nodeBinding;
    }

    public final NodeContext nodeContext() {
        return this.nodeContext;
    }

    public void setNodeContext(NodeContext nodeContext) {
        this.nodeContext = nodeContext;
        this.nodeBinding.setNodeContext((NodeContext)this);
    }

    public <T> T unwrapNode(Class<T> nodeClass) {
        if (nodeClass.isAssignableFrom(this.getClass())) {
            return (T)this;
        }
        return (T)this.nodeContext.unwrapNode(nodeClass);
    }

    @Override
    public final CellBinding cellBinding() {
        return this.nodeBinding;
    }

    @Override
    public final CellContext cellContext() {
        return this.nodeContext;
    }

    public final NodeAddress cellAddress() {
        return this.nodeContext.cellAddress();
    }

    public Value partKey() {
        return this.nodeContext.partKey();
    }

    public Uri hostUri() {
        return this.nodeContext.hostUri();
    }

    public Uri nodeUri() {
        return this.nodeContext.nodeUri();
    }

    public long createdTime() {
        return this.nodeBinding.createdTime();
    }

    public Identity identity() {
        return this.nodeContext.identity();
    }

    public HashTrieMap<Uri, LaneBinding> lanes() {
        return this.nodeBinding.lanes();
    }

    public LaneBinding getLane(Uri laneUri) {
        return this.nodeBinding.getLane(laneUri);
    }

    public Log createLog(LogDef logDef) {
        ActorHost host = this.actorHost();
        return host != null ? host.createLog(logDef) : null;
    }

    public Log createLog(CellAddress cellAddress) {
        ActorHost host = this.actorHost();
        return host != null ? host.createLog(cellAddress) : null;
    }

    public Log injectLog(Log log) {
        ActorHost host = this.actorHost();
        return host != null ? host.injectLog(log) : log;
    }

    @Override
    protected Log openLog() {
        Log log = this.nodeDef != null && this.nodeDef.logDef() != null ? this.createLog(this.nodeDef.logDef()) : this.createLog((CellAddress)this.cellAddress());
        if (log != null) {
            log = this.injectLog(log);
        }
        return log;
    }

    public Policy createPolicy(PolicyDef policyDef) {
        ActorHost host = this.actorHost();
        return host != null ? host.createPolicy(policyDef) : null;
    }

    public Policy createPolicy(CellAddress cellAddress) {
        ActorHost host = this.actorHost();
        return host != null ? host.createPolicy(cellAddress) : null;
    }

    public Policy injectPolicy(Policy policy) {
        ActorHost host = this.actorHost();
        return host != null ? host.injectPolicy(policy) : policy;
    }

    @Override
    protected Policy openPolicy() {
        Policy policy = this.nodeDef != null && this.nodeDef.policyDef() != null ? this.createPolicy(this.nodeDef.policyDef()) : this.createPolicy((CellAddress)this.cellAddress());
        if (policy != null) {
            policy = this.injectPolicy(policy);
        }
        return policy;
    }

    public Stage createStage(StageDef stageDef) {
        ActorHost host = this.actorHost();
        return host != null ? host.createStage(stageDef) : null;
    }

    public Stage createStage(CellAddress cellAddress) {
        ActorHost host = this.actorHost();
        return host != null ? host.createStage(cellAddress) : null;
    }

    public Stage injectStage(Stage stage) {
        ActorHost host = this.actorHost();
        return host != null ? host.injectStage(stage) : stage;
    }

    @Override
    protected Stage openStage() {
        Stage stage = this.nodeDef != null && this.nodeDef.stageDef() != null ? this.createStage(this.nodeDef.stageDef()) : this.createStage((CellAddress)this.cellAddress());
        if (stage != null) {
            stage = this.injectStage(stage);
        }
        return stage;
    }

    public StoreBinding createStore(StoreDef storeDef) {
        ActorHost host = this.actorHost();
        return host != null ? host.createStore(storeDef) : null;
    }

    public StoreBinding createStore(CellAddress cellAddress) {
        ActorHost host = this.actorHost();
        return host != null ? host.createStore(cellAddress) : null;
    }

    public StoreBinding injectStore(StoreBinding store) {
        ActorHost host = this.actorHost();
        return host != null ? host.injectStore(store) : store;
    }

    @Override
    protected StoreBinding openStore() {
        StoreBinding hostStore;
        StoreBinding store = null;
        store = this.nodeDef != null && this.nodeDef.storeDef() != null ? this.createStore(this.nodeDef.storeDef()) : this.createStore((CellAddress)this.cellAddress());
        if (store == null && (hostStore = this.host().hostContext().store()) != null) {
            store = hostStore.storeContext().openStore((Value)Record.create((int)1).slot("node", this.nodeUri().toString()));
        }
        if (store != null) {
            store = this.injectStore(store);
        }
        return store;
    }

    public void openMetaNode(NodeBinding node, NodeBinding metaNode) {
        ActorHost host = this.actorHost();
        if (host != null) {
            host.openMetaNode(node, metaNode);
        }
    }

    public LaneDef getLaneDef(LaneAddress laneAddress) {
        LaneDef laneDef;
        NodeDef nodeDef = this.nodeDef;
        LaneDef laneDef2 = laneDef = nodeDef != null ? nodeDef.getLaneDef(laneAddress.laneUri()) : null;
        if (laneDef == null) {
            ActorHost host = this.actorHost();
            laneDef = host != null ? host.getLaneDef(laneAddress) : null;
        }
        return laneDef;
    }

    public LaneBinding openLane(Uri laneUri) {
        return this.nodeBinding.openLane(laneUri);
    }

    public LaneBinding openLane(Uri laneUri, LaneBinding lane) {
        return this.nodeBinding.openLane(laneUri, lane);
    }

    public LaneBinding createLane(LaneAddress laneAddress) {
        return this.nodeContext.createLane(laneAddress);
    }

    public LaneBinding injectLane(LaneAddress laneAddress, LaneBinding lane) {
        LaneDef laneDef = this.getLaneDef(laneAddress);
        return new ActorLane(this.nodeContext.injectLane(laneAddress, lane), laneDef);
    }

    public void openMetaLane(LaneBinding lane, NodeBinding metaLane) {
        ActorHost host = this.actorHost();
        if (host != null) {
            host.openMetaLane(lane, metaLane);
        }
    }

    public void openMetaUplink(LinkBinding uplink, NodeBinding metaUplink) {
        ActorHost host = this.actorHost();
        if (host != null) {
            host.openMetaUplink(uplink, metaUplink);
        }
    }

    public void openMetaDownlink(LinkBinding downlink, NodeBinding metaDownlink) {
        ActorHost host = this.actorHost();
        if (host != null) {
            host.openMetaDownlink(downlink, metaDownlink);
        }
    }

    public LaneBinding createLane(NodeBinding node, LaneDef laneDef) {
        return this.nodeContext.createLane(node, laneDef);
    }

    public void openLanes(NodeBinding node) {
        this.nodeContext.openLanes(node);
        NodeDef nodeDef = this.nodeDef;
        if (nodeDef != null) {
            for (LaneDef laneDef : nodeDef.laneDefs()) {
                Uri laneUri = laneDef.laneUri();
                LaneBinding lane = this.createLane(node, laneDef);
                if (laneDef == null) continue;
                node.openLane(laneUri, lane);
            }
        }
    }

    public FingerTrieSeq<Value> agentIds() {
        return this.nodeBinding.agentIds();
    }

    public FingerTrieSeq<Agent> agents() {
        return this.nodeBinding.agents();
    }

    public void openAgents(NodeBinding node) {
        this.nodeContext.openAgents(node);
    }

    public AgentFactory<?> createAgentFactory(NodeBinding node, AgentDef agentDef) {
        return this.nodeContext.createAgentFactory(node, agentDef);
    }

    public <A extends Agent> AgentFactory<A> createAgentFactory(NodeBinding node, Class<? extends A> agentClass) {
        return this.nodeContext.createAgentFactory(node, agentClass);
    }

    public void didClose() {
        this.nodeBinding.didClose();
    }

    public void didFail(Throwable error) {
        this.nodeBinding.didFail(error);
    }
}

