/*
 * Decompiled with CFR 0.152.
 */
package swim.actor;

import swim.actor.ActorHost;
import swim.actor.ActorMesh;
import swim.actor.ActorTier;
import swim.api.agent.Agent;
import swim.api.agent.AgentDef;
import swim.api.agent.AgentFactory;
import swim.api.auth.Credentials;
import swim.api.auth.Identity;
import swim.api.policy.Policy;
import swim.api.policy.PolicyDirective;
import swim.collections.HashTrieMap;
import swim.concurrent.Stage;
import swim.concurrent.StageDef;
import swim.runtime.CellAddress;
import swim.runtime.CellBinding;
import swim.runtime.CellContext;
import swim.runtime.HostAddress;
import swim.runtime.HostBinding;
import swim.runtime.HostDef;
import swim.runtime.LaneAddress;
import swim.runtime.LaneBinding;
import swim.runtime.LaneDef;
import swim.runtime.LinkBinding;
import swim.runtime.LogDef;
import swim.runtime.MeshBinding;
import swim.runtime.NodeAddress;
import swim.runtime.NodeBinding;
import swim.runtime.NodeDef;
import swim.runtime.PartAddress;
import swim.runtime.PartBinding;
import swim.runtime.PartContext;
import swim.runtime.PartDef;
import swim.runtime.PartPredicate;
import swim.runtime.PolicyDef;
import swim.runtime.agent.AgentModel;
import swim.store.StoreBinding;
import swim.store.StoreDef;
import swim.structure.Item;
import swim.structure.Record;
import swim.structure.Value;
import swim.uri.Uri;
import swim.util.Log;

public class ActorPart
extends ActorTier
implements PartBinding,
PartContext {
    final PartBinding partBinding;
    PartContext partContext;
    PartDef partDef;

    public ActorPart(PartBinding partBinding, PartDef partDef) {
        this.partBinding = partBinding;
        this.partDef = partDef;
    }

    public final PartDef partDef() {
        return this.partDef;
    }

    public final ActorMesh actorMesh() {
        return (ActorMesh)this.mesh().unwrapMesh(ActorMesh.class);
    }

    public final MeshBinding mesh() {
        return this.partContext.mesh();
    }

    public final PartBinding partWrapper() {
        return this.partBinding.partWrapper();
    }

    public final PartBinding partBinding() {
        return this.partBinding;
    }

    public final PartContext partContext() {
        return this.partContext;
    }

    public void setPartContext(PartContext partContext) {
        this.partContext = partContext;
        this.partBinding.setPartContext((PartContext)this);
    }

    public <T> T unwrapPart(Class<T> partClass) {
        if (partClass.isAssignableFrom(this.getClass())) {
            return (T)this;
        }
        return (T)this.partContext.unwrapPart(partClass);
    }

    @Override
    public final CellBinding cellBinding() {
        return this.partBinding;
    }

    @Override
    public final CellContext cellContext() {
        return this.partContext;
    }

    public final PartAddress cellAddress() {
        return this.partContext.cellAddress();
    }

    public Value partKey() {
        return this.partContext.partKey();
    }

    public PartPredicate predicate() {
        return this.partBinding.predicate();
    }

    public HostBinding master() {
        return this.partBinding.master();
    }

    public void setMaster(HostBinding master) {
        this.partBinding.setMaster(master);
    }

    public HashTrieMap<Uri, HostBinding> hosts() {
        return this.partBinding.hosts();
    }

    public HostBinding getHost(Uri hostUri) {
        return this.partBinding.getHost(hostUri);
    }

    public HostBinding openHost(Uri hostUri) {
        return this.partBinding.openHost(hostUri);
    }

    public HostBinding openHost(Uri hostUri, HostBinding host) {
        return this.partBinding.openHost(hostUri, host);
    }

    public void hostDidConnect(Uri hostUri) {
        this.partContext.hostDidConnect(hostUri);
    }

    public void hostDidDisconnect(Uri hostUri) {
        this.partContext.hostDidDisconnect(hostUri);
    }

    public void reopenUplinks() {
        this.partBinding.reopenUplinks();
    }

    public Log createLog(LogDef logDef) {
        ActorMesh mesh = this.actorMesh();
        return mesh != null ? mesh.createLog(logDef) : null;
    }

    public Log createLog(CellAddress cellAddress) {
        ActorMesh mesh = this.actorMesh();
        return mesh != null ? mesh.createLog(cellAddress) : null;
    }

    public Log injectLog(Log log) {
        ActorMesh mesh = this.actorMesh();
        return mesh != null ? mesh.injectLog(log) : log;
    }

    @Override
    protected Log openLog() {
        Log log = this.partDef != null && this.partDef.logDef() != null ? this.createLog(this.partDef.logDef()) : this.createLog((CellAddress)this.cellAddress());
        if (log != null) {
            log = this.injectLog(log);
        }
        return log;
    }

    public Policy createPolicy(PolicyDef policyDef) {
        ActorMesh mesh = this.actorMesh();
        return mesh != null ? mesh.createPolicy(policyDef) : null;
    }

    public Policy createPolicy(CellAddress cellAddress) {
        ActorMesh mesh = this.actorMesh();
        return mesh != null ? mesh.createPolicy(cellAddress) : null;
    }

    public Policy injectPolicy(Policy policy) {
        ActorMesh mesh = this.actorMesh();
        return mesh != null ? mesh.injectPolicy(policy) : policy;
    }

    @Override
    protected Policy openPolicy() {
        Policy policy = this.partDef != null && this.partDef.policyDef() != null ? this.createPolicy(this.partDef.policyDef()) : this.createPolicy((CellAddress)this.cellAddress());
        if (policy != null) {
            policy = this.injectPolicy(policy);
        }
        return policy;
    }

    public Stage createStage(StageDef stageDef) {
        ActorMesh mesh = this.actorMesh();
        return mesh != null ? mesh.createStage(stageDef) : null;
    }

    public Stage createStage(CellAddress cellAddress) {
        ActorMesh mesh = this.actorMesh();
        return mesh != null ? mesh.createStage(cellAddress) : null;
    }

    public Stage injectStage(Stage stage) {
        ActorMesh mesh = this.actorMesh();
        return mesh != null ? mesh.injectStage(stage) : stage;
    }

    @Override
    protected Stage openStage() {
        Stage stage = this.partDef != null && this.partDef.stageDef() != null ? this.createStage(this.partDef.stageDef()) : this.createStage((CellAddress)this.cellAddress());
        if (stage != null) {
            stage = this.injectStage(stage);
        }
        return stage;
    }

    public StoreBinding createStore(StoreDef storeDef) {
        ActorMesh mesh = this.actorMesh();
        return mesh != null ? mesh.createStore(storeDef) : null;
    }

    public StoreBinding createStore(CellAddress cellAddress) {
        ActorMesh mesh = this.actorMesh();
        return mesh != null ? mesh.createStore(cellAddress) : null;
    }

    public StoreBinding injectStore(StoreBinding store) {
        ActorMesh mesh = this.actorMesh();
        return mesh != null ? mesh.injectStore(store) : store;
    }

    @Override
    protected StoreBinding openStore() {
        StoreBinding store = null;
        store = this.partDef != null && this.partDef.storeDef() != null ? this.createStore(this.partDef.storeDef()) : this.createStore((CellAddress)this.cellAddress());
        if (store != null) {
            store = this.injectStore(store);
        }
        return store;
    }

    public void openMetaPart(PartBinding part, NodeBinding metaPart) {
        ActorMesh mesh = this.actorMesh();
        if (mesh != null) {
            mesh.openMetaPart(part, metaPart);
        }
    }

    public HostDef getHostDef(HostAddress hostAddress) {
        HostDef hostDef;
        PartDef partDef = this.partDef;
        HostDef hostDef2 = hostDef = partDef != null ? partDef.getHostDef(hostAddress.hostUri()) : null;
        if (hostDef == null) {
            ActorMesh mesh = this.actorMesh();
            hostDef = mesh != null ? mesh.getHostDef(hostAddress) : null;
        }
        return hostDef;
    }

    public HostBinding createHost(HostAddress hostAddress) {
        return this.partContext.createHost(hostAddress);
    }

    public HostBinding injectHost(HostAddress hostAddress, HostBinding host) {
        HostDef hostDef = this.getHostDef(hostAddress);
        return new ActorHost(this.partContext.injectHost(hostAddress, host), hostDef);
    }

    public void openMetaHost(HostBinding host, NodeBinding metaHost) {
        ActorMesh mesh = this.actorMesh();
        if (mesh != null) {
            mesh.openMetaHost(host, metaHost);
        }
    }

    public NodeDef getNodeDef(NodeAddress nodeAddress) {
        NodeDef nodeDef;
        PartDef partDef = this.partDef;
        NodeDef nodeDef2 = nodeDef = partDef != null ? partDef.getNodeDef(nodeAddress.nodeUri()) : null;
        if (nodeDef == null) {
            ActorMesh mesh = this.actorMesh();
            nodeDef = mesh != null ? mesh.getNodeDef(nodeAddress) : null;
        }
        return nodeDef;
    }

    public NodeBinding createNode(NodeAddress nodeAddress) {
        NodeBinding node = this.partContext.createNode(nodeAddress);
        if (node == null && !this.meshUri().isDefined()) {
            NodeDef nodeDef;
            PartDef partDef = this.partDef;
            NodeDef nodeDef2 = nodeDef = partDef != null ? partDef.getNodeDef(nodeAddress.nodeUri()) : null;
            if (nodeDef != null) {
                Value props = nodeDef.props(nodeAddress.nodeUri());
                node = new AgentModel(props);
            }
        }
        return node;
    }

    public NodeBinding injectNode(NodeAddress nodeAddress, NodeBinding node) {
        return this.partContext.injectNode(nodeAddress, node);
    }

    public void openMetaNode(NodeBinding node, NodeBinding metaNode) {
        ActorMesh mesh = this.actorMesh();
        if (mesh != null) {
            mesh.openMetaNode(node, metaNode);
        }
    }

    public LaneDef getLaneDef(LaneAddress laneAddress) {
        LaneDef laneDef;
        PartDef partDef = this.partDef;
        LaneDef laneDef2 = laneDef = partDef != null ? partDef.getLaneDef(laneAddress.laneUri()) : null;
        if (laneDef == null) {
            ActorMesh mesh = this.actorMesh();
            laneDef = mesh != null ? mesh.getLaneDef(laneAddress) : null;
        }
        return laneDef;
    }

    public LaneBinding createLane(LaneAddress laneAddress) {
        return this.partContext.createLane(laneAddress);
    }

    public LaneBinding injectLane(LaneAddress laneAddress, LaneBinding lane) {
        return this.partContext.injectLane(laneAddress, lane);
    }

    public void openMetaLane(LaneBinding lane, NodeBinding metaLane) {
        ActorMesh mesh = this.actorMesh();
        if (mesh != null) {
            mesh.openMetaLane(lane, metaLane);
        }
    }

    public void openMetaUplink(LinkBinding uplink, NodeBinding metaUplink) {
        ActorMesh mesh = this.actorMesh();
        if (mesh != null) {
            mesh.openMetaUplink(uplink, metaUplink);
        }
    }

    public void openMetaDownlink(LinkBinding downlink, NodeBinding metaDownlink) {
        ActorMesh mesh = this.actorMesh();
        if (mesh != null) {
            mesh.openMetaDownlink(downlink, metaDownlink);
        }
    }

    public LaneBinding createLane(NodeBinding node, LaneDef laneDef) {
        return this.partContext.createLane(node, laneDef);
    }

    public void openLanes(NodeBinding node) {
        this.partContext.openLanes(node);
    }

    public AgentFactory<?> createAgentFactory(NodeBinding node, AgentDef agentDef) {
        return this.partContext.createAgentFactory(node, agentDef);
    }

    public <A extends Agent> AgentFactory<A> createAgentFactory(NodeBinding node, Class<? extends A> agentClass) {
        return this.partContext.createAgentFactory(node, agentClass);
    }

    public void openAgents(NodeBinding node) {
        this.partContext.openAgents(node);
        if (!this.meshUri().isDefined()) {
            NodeDef nodeDef;
            PartDef partDef = this.partDef;
            NodeDef nodeDef2 = nodeDef = partDef != null ? partDef.getNodeDef(node.nodeUri()) : null;
            if (nodeDef != null && node instanceof AgentModel) {
                AgentModel agentModel = (AgentModel)node;
                for (AgentDef agentDef : nodeDef.agentDefs()) {
                    AgentFactory<?> agentFactory = this.createAgentFactory(node, agentDef);
                    if (agentDef == null) continue;
                    Value id = agentDef.id();
                    Record props = agentModel.props().concat((Item)agentDef.props());
                    agentModel.addAgentView(agentModel.createAgent(agentFactory, id, (Value)props));
                }
            }
        }
    }

    public PolicyDirective<Identity> authenticate(Credentials credentials) {
        return this.partContext.authenticate(credentials);
    }

    public void didClose() {
        this.partBinding.didClose();
    }

    public void didFail(Throwable error) {
        this.partBinding.didFail(error);
    }
}

