/*
 * Decompiled with CFR 0.152.
 */
package swim.actor;

import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import swim.actor.ActorAgentRoute;
import swim.actor.ActorAuthenticator;
import swim.actor.ActorIdentity;
import swim.actor.ActorMesh;
import swim.actor.ActorSpaceDef;
import swim.api.Downlink;
import swim.api.SwimContext;
import swim.api.agent.Agent;
import swim.api.agent.AgentDef;
import swim.api.agent.AgentFactory;
import swim.api.agent.AgentRoute;
import swim.api.agent.AgentRouteContext;
import swim.api.auth.Authenticator;
import swim.api.auth.AuthenticatorContext;
import swim.api.auth.Credentials;
import swim.api.auth.Identity;
import swim.api.plane.Plane;
import swim.api.plane.PlaneContext;
import swim.api.plane.PlaneFactory;
import swim.api.policy.PlanePolicy;
import swim.api.policy.Policy;
import swim.api.policy.PolicyDirective;
import swim.api.space.Space;
import swim.collections.HashTrieMap;
import swim.concurrent.MainStage;
import swim.concurrent.Schedule;
import swim.concurrent.Stage;
import swim.concurrent.StageDef;
import swim.kernel.KernelContext;
import swim.runtime.AbstractTierBinding;
import swim.runtime.CellAddress;
import swim.runtime.EdgeAddress;
import swim.runtime.EdgeBinding;
import swim.runtime.EdgeContext;
import swim.runtime.HostAddress;
import swim.runtime.HostBinding;
import swim.runtime.HostDef;
import swim.runtime.LaneAddress;
import swim.runtime.LaneBinding;
import swim.runtime.LaneDef;
import swim.runtime.LinkBinding;
import swim.runtime.LogDef;
import swim.runtime.MeshAddress;
import swim.runtime.MeshBinding;
import swim.runtime.MeshDef;
import swim.runtime.Metric;
import swim.runtime.NodeAddress;
import swim.runtime.NodeBinding;
import swim.runtime.NodeDef;
import swim.runtime.PartAddress;
import swim.runtime.PartBinding;
import swim.runtime.PartDef;
import swim.runtime.PolicyDef;
import swim.runtime.Push;
import swim.runtime.TierContext;
import swim.runtime.agent.AgentModel;
import swim.store.StoreBinding;
import swim.store.StoreDef;
import swim.structure.Item;
import swim.structure.Record;
import swim.structure.Value;
import swim.uri.Uri;
import swim.uri.UriMapper;
import swim.uri.UriPattern;
import swim.util.Log;

public class ActorSpace
extends AbstractTierBinding
implements EdgeContext,
PlaneContext,
Space {
    static final AtomicReferenceFieldUpdater<ActorSpace, HashTrieMap<String, Plane>> PLANES = AtomicReferenceFieldUpdater.newUpdater(ActorSpace.class, HashTrieMap.class, "planes");
    static final AtomicReferenceFieldUpdater<ActorSpace, HashTrieMap<String, AgentRoute<?>>> AGENT_ROUTES = AtomicReferenceFieldUpdater.newUpdater(ActorSpace.class, HashTrieMap.class, "agentRoutes");
    static final AtomicReferenceFieldUpdater<ActorSpace, UriMapper<AgentFactory<?>>> AGENT_FACTORIES = AtomicReferenceFieldUpdater.newUpdater(ActorSpace.class, UriMapper.class, "agentFactories");
    static final AtomicReferenceFieldUpdater<ActorSpace, HashTrieMap<String, Authenticator>> AUTHENTICATORS = AtomicReferenceFieldUpdater.newUpdater(ActorSpace.class, HashTrieMap.class, "authenticators");
    final EdgeAddress edgeAddress;
    final ActorSpaceDef spaceDef;
    final KernelContext kernel;
    final EdgeBinding edge;
    Log log;
    PlanePolicy policy;
    Stage stage;
    StoreBinding store;
    volatile HashTrieMap<String, Plane> planes;
    volatile HashTrieMap<String, AgentRoute<?>> agentRoutes;
    volatile UriMapper<AgentFactory<?>> agentFactories;
    volatile HashTrieMap<String, Authenticator> authenticators;

    public ActorSpace(EdgeAddress edgeAddress, ActorSpaceDef spaceDef, KernelContext kernel) {
        this.edgeAddress = edgeAddress;
        this.spaceDef = spaceDef;
        this.kernel = kernel;
        EdgeBinding edge = this.createEdge();
        edge.setEdgeContext((EdgeContext)this);
        this.edge = edge = edge.edgeWrapper();
        this.planes = HashTrieMap.empty();
        this.agentRoutes = HashTrieMap.empty();
        this.agentFactories = UriMapper.empty();
        this.authenticators = HashTrieMap.empty();
    }

    public final ActorSpaceDef spaceDef() {
        return this.spaceDef;
    }

    public final TierContext tierContext() {
        return null;
    }

    public final EdgeBinding edgeWrapper() {
        return this.edge.edgeWrapper();
    }

    public <T> T unwrapEdge(Class<T> edgeClass) {
        if (edgeClass.isAssignableFrom(((Object)((Object)this)).getClass())) {
            return (T)((Object)this);
        }
        return null;
    }

    public final EdgeAddress cellAddress() {
        return this.edgeAddress;
    }

    public final String edgeName() {
        return this.edgeAddress.edgeName();
    }

    public final Uri meshUri() {
        return Uri.empty();
    }

    public final PlanePolicy policy() {
        return this.policy;
    }

    public void setPolicy(PlanePolicy policy) {
        this.policy = policy;
    }

    public Schedule schedule() {
        return this.stage;
    }

    public final Stage stage() {
        return this.stage;
    }

    public final StoreBinding store() {
        return this.store;
    }

    public final KernelContext kernel() {
        return this.kernel;
    }

    public final EdgeBinding edge() {
        return this.edge;
    }

    public Authenticator getAuthenticator(String authenticatorName) {
        return (Authenticator)this.authenticators.get((Object)authenticatorName);
    }

    public void addAuthenticator(String authenticatorName, Authenticator authenticator) {
        HashTrieMap newAuthenticators;
        HashTrieMap<String, Authenticator> oldAuthenticators;
        ActorAuthenticator authenticatorContext = new ActorAuthenticator(authenticatorName, this.kernel);
        authenticator.setAuthenticatorContext((AuthenticatorContext)authenticatorContext);
        while (!AUTHENTICATORS.compareAndSet(this, oldAuthenticators = this.authenticators, (HashTrieMap<String, Authenticator>)(newAuthenticators = oldAuthenticators.updated((Object)authenticatorName, (Object)authenticator)))) {
        }
    }

    public Collection<? extends Plane> planes() {
        return this.planes.values();
    }

    public Plane getPlane(String planeName) {
        return (Plane)this.planes.get((Object)planeName);
    }

    public <P extends Plane> P getPlane(Class<? extends P> planeClass) {
        for (Plane plane : this.planes.values()) {
            if (!planeClass.isAssignableFrom(plane.getClass())) continue;
            return (P)plane;
        }
        return null;
    }

    public <P extends Plane> P openPlane(String planeName, PlaneFactory<P> planeFactory) {
        Object plane;
        block2: {
            HashTrieMap<String, Plane> oldPlanes;
            Plane oldPlane;
            plane = null;
            while ((oldPlane = (Plane)(oldPlanes = this.planes).get((Object)planeName)) == null) {
                HashTrieMap newPlanes;
                if (plane == null) {
                    plane = this.createPlane(planeFactory);
                    plane = this.kernel.injectPlane(plane);
                }
                if (!PLANES.compareAndSet(this, oldPlanes, (HashTrieMap<String, Plane>)(newPlanes = oldPlanes.updated((Object)planeName, plane)))) continue;
                break block2;
            }
            plane = oldPlane;
        }
        return (P)plane;
    }

    public <P extends Plane> P openPlane(String planeName, Class<? extends P> planeClass) {
        PlaneFactory planeFactory;
        Object plane = this.getPlane(planeName);
        if (plane == null && (planeFactory = this.kernel.createPlaneFactory(planeClass)) != null) {
            plane = this.openPlane(planeName, planeFactory);
        }
        return (P)plane;
    }

    protected <P extends Plane> P createPlane(PlaneFactory<P> planeFactory) {
        try {
            SwimContext.setPlaneContext((PlaneContext)this);
            Plane plane = planeFactory.createPlane((PlaneContext)this);
            return (P)plane;
        }
        finally {
            SwimContext.clear();
        }
    }

    public <A extends Agent> AgentRoute<A> getAgentRoute(String routeName) {
        return (AgentRoute)this.agentRoutes.get((Object)routeName);
    }

    public <A extends Agent> AgentRoute<A> createAgentRoute(Class<? extends A> agentClass) {
        return this.kernel.createAgentRoute(this.edge, agentClass);
    }

    public void addAgentRoute(String routeName, UriPattern pattern, AgentRoute<?> agentRoute) {
        UriMapper newAgentFactories;
        UriMapper<AgentFactory<?>> oldAgentFactories;
        HashTrieMap newAgentRoutes;
        HashTrieMap<String, AgentRoute<?>> oldAgentRoutes;
        ActorAgentRoute agentRouteContext = new ActorAgentRoute(routeName, pattern);
        agentRoute.setAgentRouteContext((AgentRouteContext)agentRouteContext);
        while ((oldAgentRoutes = this.agentRoutes) != (newAgentRoutes = oldAgentRoutes.updated((Object)routeName, agentRoute)) && !AGENT_ROUTES.compareAndSet(this, oldAgentRoutes, newAgentRoutes)) {
        }
        while ((oldAgentFactories = this.agentFactories) != (newAgentFactories = oldAgentFactories.updated(pattern, agentRoute)) && !AGENT_FACTORIES.compareAndSet(this, oldAgentFactories, newAgentFactories)) {
        }
    }

    public void addAgentRoute(String routeName, String pattern, AgentRoute<?> agentRoute) {
        this.addAgentRoute(routeName, UriPattern.parse((String)pattern), agentRoute);
    }

    public void removeAgentRoute(String routeName) {
        HashTrieMap newAgentRoutes;
        HashTrieMap<String, AgentRoute<?>> oldAgentRoutes;
        while ((oldAgentRoutes = this.agentRoutes) != (newAgentRoutes = oldAgentRoutes.removed((Object)routeName)) && !AGENT_ROUTES.compareAndSet(this, oldAgentRoutes, newAgentRoutes)) {
        }
        AgentRoute agentRoute = (AgentRoute)oldAgentRoutes.get((Object)routeName);
        if (agentRoute != null) {
            UriMapper newAgentFactories;
            UriMapper<AgentFactory<?>> oldAgentFactories;
            while ((oldAgentFactories = this.agentFactories) != (newAgentFactories = oldAgentFactories.removed(agentRoute.pattern())) && !AGENT_FACTORIES.compareAndSet(this, oldAgentFactories, newAgentFactories)) {
            }
        }
    }

    public AgentFactory<?> getAgentFactory(Uri nodeUri) {
        return (AgentFactory)this.agentFactories.get(nodeUri);
    }

    public AgentFactory<?> createAgentFactory(NodeBinding node, AgentDef agentDef) {
        return this.kernel.createAgentFactory(node, agentDef);
    }

    public <A extends Agent> AgentFactory<A> createAgentFactory(NodeBinding node, Class<? extends A> agentClass) {
        return this.kernel.createAgentFactory(node, agentClass);
    }

    public void openAgents(NodeBinding node) {
        this.kernel.openAgents(node);
        if (!node.meshUri().isDefined()) {
            AgentFactory agentFactory;
            Uri nodeUri = node.nodeUri();
            NodeDef nodeDef = this.spaceDef.getNodeDef(nodeUri);
            if (nodeDef != null && node instanceof AgentModel) {
                AgentModel agentModel = (AgentModel)node;
                for (AgentDef agentDef : nodeDef.agentDefs()) {
                    AgentFactory<?> agentFactory2 = this.createAgentFactory(node, agentDef);
                    if (agentDef == null) continue;
                    Value id = agentDef.id();
                    Record props = agentModel.props().concat((Item)agentDef.props());
                    agentModel.addAgentView(agentModel.createAgent(agentFactory2, id, (Value)props));
                }
            }
            if ((agentFactory = (AgentFactory)this.agentFactories.get(nodeUri)) != null && node instanceof AgentModel) {
                AgentModel agentModel = (AgentModel)node;
                Value id = agentFactory.id(nodeUri);
                Record props = agentModel.props().concat((Item)agentFactory.props(nodeUri));
                agentModel.addAgentView(agentModel.createAgent(agentFactory, id, (Value)props));
            }
        }
    }

    public Log createLog(LogDef logDef) {
        return this.kernel.createLog(logDef);
    }

    public Log createLog(CellAddress cellAddress) {
        return this.kernel.createLog(cellAddress);
    }

    public Log injectLog(Log log) {
        return this.kernel.injectLog(log);
    }

    protected Log openLog() {
        Log log = this.spaceDef.logDef != null ? this.createLog(this.spaceDef.logDef) : this.createLog((CellAddress)this.cellAddress());
        if (log != null) {
            log = this.injectLog(log);
        }
        return log;
    }

    protected void closeLog() {
        this.log = null;
    }

    public Policy createPolicy(PolicyDef policyDef) {
        return this.kernel.createPolicy(policyDef);
    }

    public Policy createPolicy(CellAddress cellAddress) {
        return this.kernel.createPolicy(cellAddress);
    }

    public Policy injectPolicy(Policy policy) {
        return this.kernel.injectPolicy(policy);
    }

    protected PlanePolicy openPolicy() {
        Policy policy = this.spaceDef.policyDef != null ? this.createPolicy(this.spaceDef.policyDef) : this.createPolicy((CellAddress)this.cellAddress());
        if (policy != null) {
            policy = this.injectPolicy(policy);
        }
        return (PlanePolicy)policy;
    }

    protected void closePolicy() {
        this.policy = null;
    }

    public Stage createStage(StageDef stageDef) {
        return this.kernel.createStage(stageDef);
    }

    public Stage createStage(CellAddress cellAddress) {
        return this.kernel.createStage(cellAddress);
    }

    public Stage injectStage(Stage stage) {
        return this.kernel.injectStage(stage);
    }

    protected Stage openStage() {
        Stage stage = this.spaceDef.stageDef != null ? this.createStage(this.spaceDef.stageDef) : this.createStage((CellAddress)this.cellAddress());
        if (stage != null) {
            stage = this.injectStage(stage);
        }
        return stage;
    }

    protected void closeStage() {
        Stage stage = this.stage;
        if (stage instanceof MainStage) {
            ((MainStage)stage).stop();
        }
        this.stage = null;
    }

    public StoreBinding createStore(StoreDef storeDef) {
        return this.kernel.createStore(storeDef, null);
    }

    public StoreBinding createStore(CellAddress cellAddress) {
        return this.kernel.createStore(cellAddress);
    }

    public StoreBinding injectStore(StoreBinding store) {
        return this.kernel.injectStore(store);
    }

    protected StoreBinding openStore() {
        StoreBinding store = null;
        store = this.spaceDef.storeDef != null ? this.createStore(this.spaceDef.storeDef) : this.createStore((CellAddress)this.cellAddress());
        if (store != null) {
            store = this.injectStore(store);
        }
        return store;
    }

    protected void closeStore() {
        StoreBinding store = this.store;
        if (store != null) {
            store.close();
        }
        this.store = null;
    }

    protected EdgeBinding createEdge() {
        EdgeAddress edgeAddress = this.cellAddress();
        EdgeBinding edge = this.kernel.createEdge(edgeAddress);
        if (edge != null) {
            edge = this.injectEdge(edgeAddress, edge);
        }
        return edge;
    }

    protected void seedEdge(EdgeBinding edge) {
        MeshBinding mesh;
        for (MeshDef meshDef : this.spaceDef.meshDefs()) {
            this.seedMesh(edge, meshDef);
        }
        if (edge.network() == null) {
            MeshBinding network = edge.openMesh(Uri.empty());
            edge.setNetwork(network);
            PartBinding partBinding = network.openGateway();
            HostBinding hostBinding = partBinding.openHost(Uri.empty());
            partBinding.setMaster(hostBinding);
        }
        if ((mesh = edge.network()) != null) {
            for (PartDef partDef : this.spaceDef.partDefs()) {
                this.seedPart(mesh, partDef);
            }
            for (NodeDef nodeDef : this.spaceDef.nodeDefs()) {
                HostBinding host;
                PartBinding part;
                Uri nodeUri = nodeDef.nodeUri();
                if (nodeUri == null || (part = mesh.openPart(nodeUri)) == null || (host = part.master()) == null) continue;
                this.seedNode(host, nodeDef);
            }
        }
    }

    protected MeshBinding seedMesh(EdgeBinding edge, MeshDef meshDef) {
        Uri meshUri = meshDef.meshUri();
        MeshBinding mesh = this.kernel.createMesh(edge, meshDef);
        if (mesh != null && (mesh = edge.openMesh(meshUri, mesh)) != null) {
            if (!meshUri.isDefined()) {
                edge.setNetwork(mesh);
            }
            for (PartDef partDef : meshDef.partDefs()) {
                this.seedPart(mesh, partDef);
            }
            for (NodeDef nodeDef : meshDef.nodeDefs()) {
                HostBinding host;
                PartBinding part;
                Uri nodeUri = nodeDef.nodeUri();
                if (nodeUri == null || (part = mesh.openPart(nodeUri)) == null || (host = part.master()) == null) continue;
                this.seedNode(host, nodeDef);
            }
        }
        return mesh;
    }

    protected PartBinding seedPart(MeshBinding mesh, PartDef partDef) {
        Value partKey = partDef.partKey();
        PartBinding part = this.kernel.createPart(mesh, partDef);
        if (part != null && (part = mesh.addPart(partKey, part)) != null) {
            if (partDef.isGateway()) {
                mesh.setGateway(part);
            }
            for (HostDef hostDef : partDef.hostDefs()) {
                this.seedHost(part, hostDef);
            }
            for (NodeDef nodeDef : partDef.nodeDefs()) {
                HostBinding host;
                Uri nodeUri = nodeDef.nodeUri();
                if (nodeUri == null || (host = part.master()) == null) continue;
                this.seedNode(host, nodeDef);
            }
        }
        return part;
    }

    protected HostBinding seedHost(PartBinding part, HostDef hostDef) {
        Uri hostUri = hostDef.hostUri();
        HostBinding host = null;
        if (hostUri != null && (host = this.kernel.createHost(part, hostDef)) != null && (host = part.openHost(hostUri, host)) != null) {
            host.setReplica(hostDef.isReplica());
            if (hostDef.isPrimary()) {
                host.setPrimary(true);
                part.setMaster(host);
                host.didBecomeMaster();
            } else if (hostDef.isReplica()) {
                host.didBecomeSlave();
            }
            for (NodeDef nodeDef : hostDef.nodeDefs()) {
                this.seedNode(host, nodeDef);
            }
        }
        return host;
    }

    protected NodeBinding seedNode(HostBinding host, NodeDef nodeDef) {
        Uri nodeUri = nodeDef.nodeUri();
        NodeBinding node = null;
        if (nodeUri != null) {
            node = this.kernel.createNode(host, nodeDef);
            if (node == null) {
                Value props = nodeDef.props(nodeUri);
                node = new AgentModel(props);
            }
            if (node != null && (node = host.openNode(nodeUri, node)) != null) {
                for (LaneDef laneDef : nodeDef.laneDefs()) {
                    this.seedLane(node, laneDef);
                }
            }
        }
        return node;
    }

    protected LaneBinding seedLane(NodeBinding node, LaneDef laneDef) {
        Uri laneUri = laneDef.laneUri();
        LaneBinding lane = null;
        if (laneUri != null && (lane = this.kernel.createLane(node, laneDef)) != null) {
            lane = node.openLane(laneUri, lane);
        }
        return lane;
    }

    protected EdgeBinding injectEdge(EdgeAddress edgeAddress, EdgeBinding edge) {
        return this.kernel.injectEdge(edgeAddress, edge);
    }

    public void openMetaEdge(EdgeBinding edge, NodeBinding metaEdge) {
        this.kernel.openMetaEdge(edge, metaEdge);
    }

    public MeshDef getMeshDef(MeshAddress meshAddress) {
        MeshDef meshDef = this.spaceDef.getMeshDef(meshAddress.meshUri());
        if (meshDef == null) {
            meshDef = this.kernel.getMeshDef(meshAddress);
        }
        return meshDef;
    }

    public MeshBinding createMesh(MeshAddress meshAddress) {
        return this.kernel.createMesh(meshAddress);
    }

    public MeshBinding injectMesh(MeshAddress meshAddress, MeshBinding mesh) {
        MeshDef meshDef = this.getMeshDef(meshAddress);
        return new ActorMesh(this.kernel.injectMesh(meshAddress, mesh), meshDef);
    }

    public void openMetaMesh(MeshBinding mesh, NodeBinding metaMesh) {
        this.kernel.openMetaMesh(mesh, metaMesh);
    }

    public PartDef getPartDef(PartAddress partAddress) {
        PartDef partDef = this.spaceDef.getPartDef(partAddress.partKey());
        if (partDef == null) {
            partDef = this.kernel.getPartDef(partAddress);
        }
        return partDef;
    }

    public PartBinding createPart(PartAddress partAddress) {
        return this.kernel.createPart(partAddress);
    }

    public PartBinding injectPart(PartAddress partAddress, PartBinding part) {
        return this.kernel.injectPart(partAddress, part);
    }

    public void openMetaPart(PartBinding part, NodeBinding metaPart) {
        this.kernel.openMetaPart(part, metaPart);
    }

    public HostDef getHostDef(HostAddress hostAddress) {
        HostDef hostDef = this.spaceDef.getHostDef(hostAddress.hostUri());
        if (hostDef == null) {
            hostDef = this.kernel.getHostDef(hostAddress);
        }
        return hostDef;
    }

    public HostBinding createHost(HostAddress hostAddress) {
        return this.kernel.createHost(hostAddress);
    }

    public HostBinding injectHost(HostAddress hostAddress, HostBinding host) {
        return this.kernel.injectHost(hostAddress, host);
    }

    public void openMetaHost(HostBinding host, NodeBinding metaHost) {
        this.kernel.openMetaHost(host, metaHost);
    }

    public NodeDef getNodeDef(NodeAddress nodeAddress) {
        NodeDef nodeDef = this.spaceDef.getNodeDef(nodeAddress.nodeUri());
        if (nodeDef == null) {
            nodeDef = this.kernel.getNodeDef(nodeAddress);
        }
        return nodeDef;
    }

    public NodeBinding createNode(NodeAddress nodeAddress) {
        NodeDef nodeDef;
        Value props;
        AgentFactory agentFactory;
        Uri meshUri = nodeAddress.meshUri();
        Uri nodeUri = nodeAddress.nodeUri();
        NodeBinding node = null;
        if (!meshUri.isDefined() && (agentFactory = (AgentFactory)this.agentFactories.get(nodeUri)) != null) {
            props = agentFactory.props(nodeUri);
            node = new AgentModel(props);
        }
        if (node == null) {
            node = this.kernel.createNode(nodeAddress);
        }
        if (node == null && !meshUri.isDefined() && (nodeDef = this.spaceDef.getNodeDef(nodeUri)) != null) {
            props = nodeDef.props(nodeUri);
            node = new AgentModel(props);
        }
        return node;
    }

    public NodeBinding injectNode(NodeAddress nodeAddress, NodeBinding node) {
        return this.kernel.injectNode(nodeAddress, node);
    }

    public void openMetaNode(NodeBinding node, NodeBinding metaNode) {
        this.kernel.openMetaNode(node, metaNode);
    }

    public LaneDef getLaneDef(LaneAddress laneAddress) {
        LaneDef laneDef = this.spaceDef.getLaneDef(laneAddress.laneUri());
        if (laneDef == null) {
            laneDef = this.kernel.getLaneDef(laneAddress);
        }
        return laneDef;
    }

    public LaneBinding createLane(LaneAddress laneAddress) {
        return this.kernel.createLane(laneAddress);
    }

    public LaneBinding injectLane(LaneAddress laneAddress, LaneBinding lane) {
        return this.kernel.injectLane(laneAddress, lane);
    }

    public void openMetaLane(LaneBinding lane, NodeBinding metaLane) {
        this.kernel.openMetaLane(lane, metaLane);
    }

    public void openMetaUplink(LinkBinding uplink, NodeBinding metaUplink) {
        this.kernel.openMetaUplink(uplink, metaUplink);
    }

    public void openMetaDownlink(LinkBinding downlink, NodeBinding metaDownlink) {
        this.kernel.openMetaDownlink(downlink, metaDownlink);
    }

    public LaneBinding createLane(NodeBinding node, LaneDef laneDef) {
        return this.kernel.createLane(node, laneDef);
    }

    public void openLanes(NodeBinding node) {
        this.kernel.openLanes(node);
    }

    public PolicyDirective<Identity> authenticate(Credentials credentials) {
        PolicyDirective directive = null;
        HashTrieMap<String, Authenticator> authenticators = this.authenticators;
        if (!authenticators.isEmpty()) {
            Authenticator authenticator;
            Iterator iterator = authenticators.values().iterator();
            while (iterator.hasNext() && (directive = (authenticator = (Authenticator)iterator.next()).authenticate(credentials)) == null) {
            }
        } else {
            ActorIdentity identity = new ActorIdentity(credentials.requestUri(), credentials.fromUri(), Value.absent());
            directive = PolicyDirective.allow((Object)identity);
        }
        return directive;
    }

    public LinkBinding bindDownlink(Downlink downlink) {
        return this.edge.bindDownlink(downlink);
    }

    public void openDownlink(LinkBinding link) {
        this.edge.openDownlink(link);
    }

    public void closeDownlink(LinkBinding link) {
    }

    public void pushDown(Push<?> push) {
        this.edge.pushDown(push);
    }

    public void reportDown(Metric metric) {
        this.kernel.reportDown(metric);
    }

    public void trace(Object message) {
        Log log = this.log;
        if (log != null) {
            log.trace(message);
        } else {
            this.kernel.trace(message);
        }
    }

    public void debug(Object message) {
        Log log = this.log;
        if (log != null) {
            log.debug(message);
        } else {
            this.kernel.debug(message);
        }
    }

    public void info(Object message) {
        Log log = this.log;
        if (log != null) {
            log.info(message);
        } else {
            this.kernel.info(message);
        }
    }

    public void warn(Object message) {
        Log log = this.log;
        if (log != null) {
            log.warn(message);
        } else {
            this.kernel.warn(message);
        }
    }

    public void error(Object message) {
        Log log = this.log;
        if (log != null) {
            log.error(message);
        } else {
            this.kernel.error(message);
        }
    }

    public void fail(Object message) {
        Log log = this.log;
        if (log != null) {
            log.fail(message);
        } else {
            this.kernel.fail(message);
        }
    }

    public void open() {
        this.seedEdge(this.edge);
        this.edge.open();
    }

    public void load() {
        this.edge.load();
    }

    public void start() {
        this.edge.start();
    }

    public void stop() {
        this.edge.stop();
    }

    public void unload() {
        this.edge.unload();
    }

    public void close() {
        this.edge.close();
    }

    public void willOpen() {
        if (this.log == null) {
            this.log = this.openLog();
        }
        if (this.policy == null) {
            this.policy = this.openPolicy();
        }
        if (this.stage == null) {
            this.stage = this.openStage();
        }
        if (this.store == null) {
            this.store = this.openStore();
        }
        this.open();
    }

    public void didOpen() {
    }

    public void willLoad() {
        this.load();
    }

    public void didLoad() {
    }

    public void willStart() {
        for (Plane plane : this.planes.values()) {
            plane.willStart();
        }
        this.start();
    }

    public void didStart() {
        for (Plane plane : this.planes.values()) {
            plane.didStart();
        }
    }

    public void willStop() {
        for (Plane plane : this.planes.values()) {
            plane.willStop();
        }
        this.stop();
    }

    public void didStop() {
        for (Plane plane : this.planes.values()) {
            plane.didStop();
        }
    }

    public void willUnload() {
        this.unload();
    }

    public void didUnload() {
    }

    public void willClose() {
        for (Plane plane : this.planes.values()) {
            plane.willClose();
        }
        this.close();
    }

    public void didClose() {
        for (Plane plane : this.planes.values()) {
            plane.didClose();
        }
        this.closeStore();
        this.closeStage();
        this.closePolicy();
        this.closeLog();
    }

    public void didFail(Throwable error) {
        for (Plane plane : this.planes.values()) {
            plane.didFail(error);
        }
    }
}

