/*
 * Decompiled with CFR 0.152.
 */
package swim.actor;

import swim.api.Downlink;
import swim.api.policy.Policy;
import swim.concurrent.Schedule;
import swim.concurrent.Stage;
import swim.runtime.CellAddress;
import swim.runtime.CellBinding;
import swim.runtime.CellContext;
import swim.runtime.LinkBinding;
import swim.runtime.Metric;
import swim.runtime.Push;
import swim.store.StoreBinding;
import swim.uri.Uri;
import swim.util.Log;

public abstract class ActorCell
implements CellBinding,
CellContext {
    Log log;
    Policy policy;

    public abstract CellBinding cellBinding();

    public abstract CellContext cellContext();

    public abstract CellAddress cellAddress();

    public String edgeName() {
        return this.cellContext().edgeName();
    }

    public Uri meshUri() {
        return this.cellContext().meshUri();
    }

    public Policy policy() {
        Policy policy = this.policy;
        return policy != null ? policy : this.cellContext().policy();
    }

    public Schedule schedule() {
        return this.cellContext().schedule();
    }

    public Stage stage() {
        return this.cellContext().stage();
    }

    public StoreBinding store() {
        return this.cellContext().store();
    }

    protected Log openLog() {
        return null;
    }

    protected void closeLog() {
        this.log = null;
    }

    protected Policy openPolicy() {
        return null;
    }

    protected void closePolicy() {
        this.policy = null;
    }

    public LinkBinding bindDownlink(Downlink downlink) {
        return this.cellContext().bindDownlink(downlink);
    }

    public void openDownlink(LinkBinding link) {
        this.cellContext().openDownlink(link);
    }

    public void closeDownlink(LinkBinding link) {
        this.cellContext().closeDownlink(link);
    }

    public void pushDown(Push<?> push) {
        this.cellContext().pushDown(push);
    }

    public void reportDown(Metric metric) {
        this.cellContext().reportDown(metric);
    }

    public void openUplink(LinkBinding link) {
        this.cellBinding().openUplink(link);
    }

    public void pushUp(Push<?> push) {
        this.cellBinding().pushUp(push);
    }

    public void trace(Object message) {
        Log log = this.log;
        if (log != null) {
            log.trace(message);
        } else {
            this.cellContext().trace(message);
        }
    }

    public void debug(Object message) {
        Log log = this.log;
        if (log != null) {
            log.debug(message);
        } else {
            this.cellContext().debug(message);
        }
    }

    public void info(Object message) {
        Log log = this.log;
        if (log != null) {
            log.info(message);
        } else {
            this.cellContext().info(message);
        }
    }

    public void warn(Object message) {
        Log log = this.log;
        if (log != null) {
            log.warn(message);
        } else {
            this.cellContext().warn(message);
        }
    }

    public void error(Object message) {
        Log log = this.log;
        if (log != null) {
            log.error(message);
        } else {
            this.cellContext().error(message);
        }
    }

    public void fail(Object message) {
        Log log = this.log;
        if (log != null) {
            log.fail(message);
        } else {
            this.cellContext().fail(message);
        }
    }
}

