/*
 * Decompiled with CFR 0.152.
 */
package swim.actor;

import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import swim.actor.ActorHostDef;
import swim.actor.ActorLaneDef;
import swim.actor.ActorMeshDef;
import swim.actor.ActorNodeDef;
import swim.actor.ActorPartDef;
import swim.actor.ActorSpace;
import swim.actor.ActorSpaceDef;
import swim.api.agent.AgentDef;
import swim.api.auth.Authenticator;
import swim.api.auth.AuthenticatorDef;
import swim.api.plane.PlaneDef;
import swim.api.plane.PlaneException;
import swim.api.plane.PlaneFactory;
import swim.api.space.Space;
import swim.api.space.SpaceDef;
import swim.collections.FingerTrieSeq;
import swim.collections.HashTrieMap;
import swim.concurrent.StageDef;
import swim.kernel.KernelContext;
import swim.kernel.KernelProxy;
import swim.runtime.EdgeAddress;
import swim.runtime.HostDef;
import swim.runtime.LaneDef;
import swim.runtime.LogDef;
import swim.runtime.MeshDef;
import swim.runtime.NodeDef;
import swim.runtime.PartDef;
import swim.runtime.PartPredicate;
import swim.runtime.PolicyDef;
import swim.store.StoreDef;
import swim.structure.Item;
import swim.structure.Value;
import swim.uri.Uri;
import swim.uri.UriMapper;
import swim.uri.UriPattern;

public class ActorKernel
extends KernelProxy {
    static final AtomicReferenceFieldUpdater<ActorKernel, HashTrieMap<String, ActorSpace>> SPACES = AtomicReferenceFieldUpdater.newUpdater(ActorKernel.class, HashTrieMap.class, "spaces");
    private static final double KERNEL_PRIORITY = 1.0;
    final double kernelPriority;
    volatile HashTrieMap<String, ActorSpace> spaces;

    public ActorKernel(double kernelPriority) {
        this.kernelPriority = kernelPriority;
        this.spaces = HashTrieMap.empty();
    }

    public ActorKernel() {
        this(1.0);
    }

    public static ActorKernel fromValue(Value moduleConfig) {
        Value header = moduleConfig.getAttr("kernel");
        String kernelClassName = header.get("class").stringValue(null);
        if (kernelClassName == null || ActorKernel.class.getName().equals(kernelClassName)) {
            double kernelPriority = header.get("priority").doubleValue(1.0);
            return new ActorKernel(kernelPriority);
        }
        return null;
    }

    public final double kernelPriority() {
        return this.kernelPriority;
    }

    public SpaceDef defineSpace(Item spaceConfig) {
        ActorSpaceDef spaceDef = this.defineActorSpace(spaceConfig);
        return spaceDef != null ? spaceDef : super.defineSpace(spaceConfig);
    }

    public ActorSpaceDef defineActorSpace(Item spaceConfig) {
        String fabricProvider;
        Value value = spaceConfig.toValue();
        Value header = value.getAttr("fabric");
        if (header.isDefined() && ((fabricProvider = header.get("provider").stringValue(null)) == null || ActorKernel.class.getName().equals(fabricProvider))) {
            KernelContext kernel = (KernelContext)this.kernelWrapper().unwrapKernel(KernelContext.class);
            String spaceName = spaceConfig.key().stringValue(null);
            FingerTrieSeq planeDefs = FingerTrieSeq.empty();
            HashTrieMap authenticatorDefs = HashTrieMap.empty();
            HashTrieMap meshDefs = HashTrieMap.empty();
            HashTrieMap partDefs = HashTrieMap.empty();
            UriMapper hostDefs = UriMapper.empty();
            UriMapper nodeDefs = UriMapper.empty();
            UriMapper laneDefs = UriMapper.empty();
            LogDef logDef = null;
            PolicyDef policyDef = null;
            StageDef stageDef = null;
            StoreDef storeDef = null;
            int n = value.length();
            for (int i = 0; i < n; ++i) {
                Item item = value.getItem(i);
                PlaneDef planeDef = kernel.definePlane(item);
                if (planeDef != null) {
                    planeDefs = planeDefs.appended((Object)planeDef);
                    continue;
                }
                AuthenticatorDef authenticatorDef = kernel.defineAuthenticator(item);
                if (authenticatorDef != null) {
                    authenticatorDefs = authenticatorDefs.updated((Object)authenticatorDef.authenticatorName(), (Object)authenticatorDef);
                    continue;
                }
                MeshDef meshDef = kernel.defineMesh(item);
                if (meshDef != null) {
                    meshDefs = meshDefs.updated((Object)meshDef.meshUri(), (Object)meshDef);
                    continue;
                }
                PartDef partDef = kernel.definePart(item);
                if (partDef != null) {
                    partDefs = partDefs.updated((Object)partDef.partKey(), (Object)partDef);
                    continue;
                }
                HostDef hostDef = kernel.defineHost(item);
                if (hostDef != null) {
                    hostDefs = hostDefs.updated(hostDef.hostPattern(), (Object)hostDef);
                    continue;
                }
                NodeDef nodeDef = kernel.defineNode(item);
                if (nodeDef != null) {
                    nodeDefs = nodeDefs.updated(nodeDef.nodePattern(), (Object)nodeDef);
                    continue;
                }
                LaneDef laneDef = kernel.defineLane(item);
                if (laneDef != null) {
                    laneDefs = laneDefs.updated(laneDef.lanePattern(), (Object)laneDef);
                    continue;
                }
                LogDef newLogDef = kernel.defineLog(item);
                if (newLogDef != null) {
                    logDef = newLogDef;
                    continue;
                }
                PolicyDef newPolicyDef = kernel.definePolicy(item);
                if (newPolicyDef != null) {
                    policyDef = newPolicyDef;
                    continue;
                }
                StageDef newStageDef = kernel.defineStage(item);
                if (newStageDef != null) {
                    stageDef = newStageDef;
                    continue;
                }
                StoreDef newStoreDef = kernel.defineStore(item);
                if (newStoreDef == null) continue;
                storeDef = newStoreDef;
            }
            return new ActorSpaceDef(spaceName, (FingerTrieSeq<PlaneDef>)planeDefs, (HashTrieMap<String, AuthenticatorDef>)authenticatorDefs, (HashTrieMap<Uri, MeshDef>)meshDefs, (HashTrieMap<Value, PartDef>)partDefs, (UriMapper<HostDef>)hostDefs, (UriMapper<NodeDef>)nodeDefs, (UriMapper<LaneDef>)laneDefs, logDef, policyDef, stageDef, storeDef);
        }
        return null;
    }

    public Space openSpace(SpaceDef spaceDef) {
        if (spaceDef instanceof ActorSpaceDef) {
            return this.openActorSpace((ActorSpaceDef)spaceDef);
        }
        return super.openSpace(spaceDef);
    }

    public ActorSpace openActorSpace(ActorSpaceDef spaceDef) {
        ActorSpace space;
        block2: {
            HashTrieMap<String, ActorSpace> oldSpaces;
            ActorSpace oldSpace;
            String spaceName = spaceDef.spaceName;
            space = null;
            while ((oldSpace = (ActorSpace)((Object)(oldSpaces = this.spaces).get((Object)spaceName))) == null) {
                HashTrieMap newSpaces;
                if (space == null) {
                    space = this.createActorSpace(spaceName, spaceDef);
                }
                if (!SPACES.compareAndSet(this, oldSpaces, (HashTrieMap<String, ActorSpace>)(newSpaces = oldSpaces.updated((Object)spaceName, (Object)space)))) continue;
                if (!this.isStarted()) break block2;
                space.start();
                break block2;
            }
            space = oldSpace;
        }
        return space;
    }

    protected ActorSpace createActorSpace(String spaceName, ActorSpaceDef spaceDef) {
        KernelContext kernel = (KernelContext)this.kernelWrapper().unwrapKernel(KernelContext.class);
        EdgeAddress edgeAddress = new EdgeAddress(spaceName);
        ActorSpace space = new ActorSpace(edgeAddress, spaceDef, kernel);
        this.createAuthenticators(space, spaceDef);
        this.createPlanes(space, spaceDef);
        return space;
    }

    protected void createAuthenticators(ActorSpace space, ActorSpaceDef spaceDef) {
        for (AuthenticatorDef authenticatorDef : spaceDef.authenticatorDefs()) {
            if (space.getAuthenticator(authenticatorDef.authenticatorName()) != null) continue;
            this.createAuthenticator(space, authenticatorDef);
        }
    }

    protected void createAuthenticator(ActorSpace space, AuthenticatorDef authenticatorDef) {
        KernelContext kernel = (KernelContext)this.kernelWrapper().unwrapKernel(KernelContext.class);
        Authenticator authenticator = kernel.createAuthenticator(authenticatorDef, null);
        if (authenticator != null) {
            authenticator = kernel.injectAuthenticator(authenticator);
        }
        if (authenticator != null) {
            space.addAuthenticator(authenticatorDef.authenticatorName(), authenticator);
        }
    }

    protected void createPlanes(ActorSpace space, ActorSpaceDef spaceDef) {
        for (PlaneDef planeDef : spaceDef.planeDefs()) {
            if (space.getPlane(planeDef.planeName()) != null) continue;
            this.createPlane(space, planeDef);
        }
    }

    protected void createPlane(ActorSpace space, PlaneDef planeDef) {
        KernelContext kernel = (KernelContext)this.kernelWrapper().unwrapKernel(KernelContext.class);
        PlaneFactory planeFactory = kernel.createPlaneFactory(planeDef, null);
        if (planeFactory == null) {
            throw new PlaneException("No factory for plane: " + planeDef.planeName());
        }
        space.openPlane(planeDef.planeName(), planeFactory);
    }

    public Space getSpace(String spaceName) {
        ActorSpace space = this.getActorSpace(spaceName);
        if (space == null) {
            space = super.getSpace(spaceName);
        }
        return space;
    }

    public ActorSpace getActorSpace(String spaceName) {
        return (ActorSpace)((Object)this.spaces.get((Object)spaceName));
    }

    public MeshDef defineMesh(Item meshConfig) {
        ActorMeshDef meshDef = this.defineActorMesh(meshConfig);
        return meshDef != null ? meshDef : super.defineMesh(meshConfig);
    }

    public ActorMeshDef defineActorMesh(Item meshConfig) {
        String fabricProvider;
        Value value = meshConfig.toValue();
        Value header = value.getAttr("mesh");
        if (header.isDefined() && ((fabricProvider = header.get("provider").stringValue(null)) == null || ActorKernel.class.getName().equals(fabricProvider))) {
            KernelContext kernel = (KernelContext)this.kernelWrapper().unwrapKernel(KernelContext.class);
            Uri meshUri = Uri.empty();
            HashTrieMap partDefs = HashTrieMap.empty();
            UriMapper hostDefs = UriMapper.empty();
            UriMapper nodeDefs = UriMapper.empty();
            UriMapper laneDefs = UriMapper.empty();
            LogDef logDef = null;
            PolicyDef policyDef = null;
            StageDef stageDef = null;
            StoreDef storeDef = null;
            int n = value.length();
            for (int i = 0; i < n; ++i) {
                Item item = value.getItem(i);
                if (item.keyEquals((Object)"uri")) {
                    meshUri = (Uri)item.toValue().cast(Uri.form(), (Object)meshUri);
                    continue;
                }
                PartDef partDef = kernel.definePart(item);
                if (partDef != null) {
                    partDefs = partDefs.updated((Object)partDef.partKey(), (Object)partDef);
                    continue;
                }
                HostDef hostDef = kernel.defineHost(item);
                if (hostDef != null) {
                    hostDefs = hostDefs.updated(hostDef.hostPattern(), (Object)hostDef);
                    continue;
                }
                NodeDef nodeDef = kernel.defineNode(item);
                if (nodeDef != null) {
                    nodeDefs = nodeDefs.updated(nodeDef.nodePattern(), (Object)nodeDef);
                    continue;
                }
                LaneDef laneDef = kernel.defineLane(item);
                if (laneDef != null) {
                    laneDefs = laneDefs.updated(laneDef.lanePattern(), (Object)laneDef);
                    continue;
                }
                LogDef newLogDef = kernel.defineLog(item);
                if (newLogDef != null) {
                    logDef = newLogDef;
                    continue;
                }
                PolicyDef newPolicyDef = kernel.definePolicy(item);
                if (newPolicyDef != null) {
                    policyDef = newPolicyDef;
                    continue;
                }
                StageDef newStageDef = kernel.defineStage(item);
                if (newStageDef != null) {
                    stageDef = newStageDef;
                    continue;
                }
                StoreDef newStoreDef = kernel.defineStore(item);
                if (newStoreDef == null) continue;
                storeDef = newStoreDef;
            }
            return new ActorMeshDef(meshUri, (HashTrieMap<Value, PartDef>)partDefs, (UriMapper<HostDef>)hostDefs, (UriMapper<NodeDef>)nodeDefs, (UriMapper<LaneDef>)laneDefs, logDef, policyDef, stageDef, storeDef);
        }
        return null;
    }

    public PartDef definePart(Item partConfig) {
        ActorPartDef partDef = this.defineActorPart(partConfig);
        return partDef != null ? partDef : super.definePart(partConfig);
    }

    public ActorPartDef defineActorPart(Item partConfig) {
        String fabricProvider;
        Value value = partConfig.toValue();
        Value header = value.getAttr("part");
        if (header.isDefined() && ((fabricProvider = header.get("provider").stringValue(null)) == null || ActorKernel.class.getName().equals(fabricProvider))) {
            KernelContext kernel = (KernelContext)this.kernelWrapper().unwrapKernel(KernelContext.class);
            Value partKey = Value.extant();
            PartPredicate predicate = PartPredicate.any();
            boolean isGateway = false;
            UriMapper hostDefs = UriMapper.empty();
            UriMapper nodeDefs = UriMapper.empty();
            UriMapper laneDefs = UriMapper.empty();
            LogDef logDef = null;
            PolicyDef policyDef = null;
            StageDef stageDef = null;
            StoreDef storeDef = null;
            int n = value.length();
            for (int i = 0; i < n; ++i) {
                Item item = value.getItem(i);
                if (item.keyEquals((Object)"key")) {
                    partKey = item.toValue();
                    continue;
                }
                if (item.keyEquals((Object)"predicate")) {
                    predicate = PartPredicate.fromValue((Value)item.toValue());
                    continue;
                }
                if (item.keyEquals((Object)"gateway")) {
                    isGateway = item.toValue().booleanValue(isGateway);
                    continue;
                }
                HostDef hostDef = kernel.defineHost(item);
                if (hostDef != null) {
                    hostDefs = hostDefs.updated(hostDef.hostPattern(), (Object)hostDef);
                    continue;
                }
                NodeDef nodeDef = kernel.defineNode(item);
                if (nodeDef != null) {
                    nodeDefs = nodeDefs.updated(nodeDef.nodePattern(), (Object)nodeDef);
                    continue;
                }
                LaneDef laneDef = kernel.defineLane(item);
                if (laneDef != null) {
                    laneDefs = laneDefs.updated(laneDef.lanePattern(), (Object)laneDef);
                    continue;
                }
                LogDef newLogDef = kernel.defineLog(item);
                if (newLogDef != null) {
                    logDef = newLogDef;
                    continue;
                }
                PolicyDef newPolicyDef = kernel.definePolicy(item);
                if (newPolicyDef != null) {
                    policyDef = newPolicyDef;
                    continue;
                }
                StageDef newStageDef = kernel.defineStage(item);
                if (newStageDef != null) {
                    stageDef = newStageDef;
                    continue;
                }
                StoreDef newStoreDef = kernel.defineStore(item);
                if (newStoreDef == null) continue;
                storeDef = newStoreDef;
            }
            return new ActorPartDef(partKey, predicate, isGateway, (UriMapper<HostDef>)hostDefs, (UriMapper<NodeDef>)nodeDefs, (UriMapper<LaneDef>)laneDefs, logDef, policyDef, stageDef, storeDef);
        }
        return null;
    }

    public HostDef defineHost(Item hostConfig) {
        ActorHostDef hostDef = this.defineActorHost(hostConfig);
        return hostDef != null ? hostDef : super.defineHost(hostConfig);
    }

    public ActorHostDef defineActorHost(Item hostConfig) {
        String fabricProvider;
        Value value = hostConfig.toValue();
        Value header = value.getAttr("host");
        if (header.isDefined() && ((fabricProvider = header.get("provider").stringValue(null)) == null || ActorKernel.class.getName().equals(fabricProvider))) {
            KernelContext kernel = (KernelContext)this.kernelWrapper().unwrapKernel(KernelContext.class);
            UriPattern hostPattern = UriPattern.empty();
            boolean isPrimary = false;
            boolean isReplica = false;
            UriMapper nodeDefs = UriMapper.empty();
            UriMapper laneDefs = UriMapper.empty();
            LogDef logDef = null;
            PolicyDef policyDef = null;
            StageDef stageDef = null;
            StoreDef storeDef = null;
            int n = value.length();
            for (int i = 0; i < n; ++i) {
                Item item = value.getItem(i);
                if (item.keyEquals((Object)"uri") || item.keyEquals((Object)"pattern")) {
                    hostPattern = (UriPattern)item.toValue().cast(UriPattern.form(), (Object)hostPattern);
                    continue;
                }
                if (item.keyEquals((Object)"primary") || item.keyEquals((Object)"isPrimary")) {
                    isPrimary = item.toValue().booleanValue(isPrimary);
                    continue;
                }
                if (item.keyEquals((Object)"replica") || item.keyEquals((Object)"isReplica")) {
                    isReplica = item.toValue().booleanValue(isReplica);
                    continue;
                }
                NodeDef nodeDef = kernel.defineNode(item);
                if (nodeDef != null) {
                    nodeDefs = nodeDefs.updated(nodeDef.nodePattern(), (Object)nodeDef);
                    continue;
                }
                LaneDef laneDef = kernel.defineLane(item);
                if (laneDef != null) {
                    laneDefs = laneDefs.updated(laneDef.lanePattern(), (Object)laneDef);
                    continue;
                }
                LogDef newLogDef = kernel.defineLog(item);
                if (newLogDef != null) {
                    logDef = newLogDef;
                    continue;
                }
                PolicyDef newPolicyDef = kernel.definePolicy(item);
                if (newPolicyDef != null) {
                    policyDef = newPolicyDef;
                    continue;
                }
                StageDef newStageDef = kernel.defineStage(item);
                if (newStageDef != null) {
                    stageDef = newStageDef;
                    continue;
                }
                StoreDef newStoreDef = kernel.defineStore(item);
                if (newStoreDef == null) continue;
                storeDef = newStoreDef;
            }
            return new ActorHostDef(hostPattern, isPrimary, isReplica, (UriMapper<NodeDef>)nodeDefs, (UriMapper<LaneDef>)laneDefs, logDef, policyDef, stageDef, storeDef);
        }
        return null;
    }

    public NodeDef defineNode(Item nodeConfig) {
        ActorNodeDef nodeDef = this.defineActorNode(nodeConfig);
        return nodeDef != null ? nodeDef : super.defineNode(nodeConfig);
    }

    public ActorNodeDef defineActorNode(Item nodeConfig) {
        String fabricProvider;
        Value value = nodeConfig.toValue();
        Value header = value.getAttr("node");
        if (header.isDefined() && ((fabricProvider = header.get("provider").stringValue(null)) == null || ActorKernel.class.getName().equals(fabricProvider))) {
            KernelContext kernel = (KernelContext)this.kernelWrapper().unwrapKernel(KernelContext.class);
            UriPattern nodePattern = null;
            FingerTrieSeq agentDefs = FingerTrieSeq.empty();
            UriMapper laneDefs = UriMapper.empty();
            LogDef logDef = null;
            PolicyDef policyDef = null;
            StageDef stageDef = null;
            StoreDef storeDef = null;
            int n = value.length();
            for (int i = 0; i < n; ++i) {
                Item item = value.getItem(i);
                if (item.keyEquals((Object)"uri") || item.keyEquals((Object)"pattern")) {
                    nodePattern = (UriPattern)item.toValue().cast(UriPattern.form(), nodePattern);
                    continue;
                }
                AgentDef agentDef = kernel.defineAgent(item);
                if (agentDef != null) {
                    agentDefs = agentDefs.appended((Object)agentDef);
                    continue;
                }
                LaneDef laneDef = kernel.defineLane(item);
                if (laneDef != null) {
                    laneDefs = laneDefs.updated(laneDef.lanePattern(), (Object)laneDef);
                    continue;
                }
                LogDef newLogDef = kernel.defineLog(item);
                if (newLogDef != null) {
                    logDef = newLogDef;
                    continue;
                }
                PolicyDef newPolicyDef = kernel.definePolicy(item);
                if (newPolicyDef != null) {
                    policyDef = newPolicyDef;
                    continue;
                }
                StageDef newStageDef = kernel.defineStage(item);
                if (newStageDef != null) {
                    stageDef = newStageDef;
                    continue;
                }
                StoreDef newStoreDef = kernel.defineStore(item);
                if (newStoreDef == null) continue;
                storeDef = newStoreDef;
            }
            if (nodePattern != null) {
                return new ActorNodeDef(nodePattern, (FingerTrieSeq<AgentDef>)agentDefs, (UriMapper<LaneDef>)laneDefs, logDef, policyDef, stageDef, storeDef);
            }
        }
        return null;
    }

    public LaneDef defineLane(Item laneConfig) {
        ActorLaneDef laneDef = this.defineActorLane(laneConfig);
        return laneDef != null ? laneDef : super.defineLane(laneConfig);
    }

    public ActorLaneDef defineActorLane(Item laneConfig) {
        String fabricProvider;
        Value value = laneConfig.toValue();
        Value header = value.getAttr("lane");
        if (header.isDefined() && ((fabricProvider = header.get("provider").stringValue(null)) == null || ActorKernel.class.getName().equals(fabricProvider))) {
            KernelContext kernel = (KernelContext)this.kernelWrapper().unwrapKernel(KernelContext.class);
            String laneType = header.get("type").stringValue(null);
            UriPattern lanePattern = null;
            LogDef logDef = null;
            PolicyDef policyDef = null;
            StageDef stageDef = null;
            StoreDef storeDef = null;
            int n = value.length();
            for (int i = 0; i < n; ++i) {
                Item item = value.getItem(i);
                if (item.keyEquals((Object)"uri") || item.keyEquals((Object)"pattern")) {
                    lanePattern = (UriPattern)item.toValue().cast(UriPattern.form(), lanePattern);
                    continue;
                }
                LogDef newLogDef = kernel.defineLog(item);
                if (newLogDef != null) {
                    logDef = newLogDef;
                    continue;
                }
                PolicyDef newPolicyDef = kernel.definePolicy(item);
                if (newPolicyDef != null) {
                    policyDef = newPolicyDef;
                    continue;
                }
                StageDef newStageDef = kernel.defineStage(item);
                if (newStageDef != null) {
                    stageDef = newStageDef;
                    continue;
                }
                StoreDef newStoreDef = kernel.defineStore(item);
                if (newStoreDef == null) continue;
                storeDef = newStoreDef;
            }
            if (lanePattern != null) {
                return new ActorLaneDef(lanePattern, laneType, logDef, policyDef, stageDef, storeDef);
            }
        }
        return null;
    }

    public void didStart() {
        for (ActorSpace space : this.spaces.values()) {
            space.start();
        }
    }

    public void willStop() {
        for (ActorSpace space : this.spaces.values()) {
            space.stop();
        }
    }
}

