/*
 * Decompiled with CFR 0.152.
 */
package swim.actor;

import swim.actor.ActorNode;
import swim.actor.ActorTier;
import swim.api.Lane;
import swim.api.agent.AgentContext;
import swim.api.auth.Identity;
import swim.api.policy.Policy;
import swim.collections.FingerTrieSeq;
import swim.concurrent.Stage;
import swim.concurrent.StageDef;
import swim.runtime.CellAddress;
import swim.runtime.CellBinding;
import swim.runtime.CellContext;
import swim.runtime.LaneAddress;
import swim.runtime.LaneBinding;
import swim.runtime.LaneContext;
import swim.runtime.LaneDef;
import swim.runtime.LinkBinding;
import swim.runtime.LinkContext;
import swim.runtime.LogDef;
import swim.runtime.NodeBinding;
import swim.runtime.PolicyDef;
import swim.runtime.Push;
import swim.store.StoreBinding;
import swim.store.StoreDef;
import swim.structure.Value;
import swim.uri.Uri;
import swim.util.Log;
import swim.warp.CommandMessage;

public class ActorLane
extends ActorTier
implements LaneBinding,
LaneContext {
    final LaneBinding laneBinding;
    LaneContext laneContext;
    LaneDef laneDef;

    public ActorLane(LaneBinding laneBinding, LaneDef laneDef) {
        this.laneBinding = laneBinding;
        this.laneDef = laneDef;
    }

    public final LaneDef laneDef() {
        return this.laneDef;
    }

    public final ActorNode actorNode() {
        return (ActorNode)this.node().unwrapNode(ActorNode.class);
    }

    public final NodeBinding node() {
        return this.laneContext.node();
    }

    public final LaneBinding laneWrapper() {
        return this.laneBinding.laneWrapper();
    }

    public final LaneBinding laneBinding() {
        return this.laneBinding;
    }

    public final LaneContext laneContext() {
        return this.laneContext;
    }

    public void setLaneContext(LaneContext laneContext) {
        this.laneContext = laneContext;
        this.laneBinding.setLaneContext((LaneContext)this);
    }

    public <T> T unwrapLane(Class<T> laneClass) {
        if (laneClass.isAssignableFrom(this.getClass())) {
            return (T)this;
        }
        return (T)this.laneContext.unwrapLane(laneClass);
    }

    public <T> T bottomLane(Class<T> laneClass) {
        Object lane = this.laneContext.bottomLane(laneClass);
        if (lane == null && laneClass.isAssignableFrom(this.getClass())) {
            lane = this;
        }
        return (T)lane;
    }

    @Override
    public final CellBinding cellBinding() {
        return this.laneBinding;
    }

    @Override
    public final CellContext cellContext() {
        return this.laneContext;
    }

    public final LaneAddress cellAddress() {
        return this.laneContext.cellAddress();
    }

    public Value partKey() {
        return this.laneContext.partKey();
    }

    public Uri hostUri() {
        return this.laneContext.hostUri();
    }

    public Uri nodeUri() {
        return this.laneContext.nodeUri();
    }

    public Uri laneUri() {
        return this.laneContext.laneUri();
    }

    public String laneType() {
        return this.laneBinding.laneType();
    }

    public Identity identity() {
        return this.laneContext.identity();
    }

    public Lane getLaneView(AgentContext agentContext) {
        return this.laneBinding.getLaneView(agentContext);
    }

    public void openLaneView(Lane lane) {
        this.laneBinding.openLaneView(lane);
    }

    public void closeLaneView(Lane lane) {
        this.laneBinding.closeLaneView(lane);
    }

    public boolean isLinked() {
        return this.laneBinding.isLinked();
    }

    public FingerTrieSeq<LinkContext> uplinks() {
        return this.laneBinding.uplinks();
    }

    public LinkContext getUplink(Value linkKey) {
        return this.laneBinding.getUplink(linkKey);
    }

    public void closeUplink(Value linkKey) {
        this.laneBinding.closeUplink(linkKey);
    }

    public void pushUpCommand(Push<CommandMessage> push) {
        this.laneBinding.pushUpCommand(push);
    }

    public Log createLog(LogDef logDef) {
        ActorNode node = this.actorNode();
        return node != null ? node.createLog(logDef) : null;
    }

    public Log createLog(CellAddress cellAddress) {
        ActorNode node = this.actorNode();
        return node != null ? node.createLog(cellAddress) : null;
    }

    public Log injectLog(Log log) {
        ActorNode node = this.actorNode();
        return node != null ? node.injectLog(log) : log;
    }

    @Override
    protected Log openLog() {
        Log log = this.laneDef != null && this.laneDef.logDef() != null ? this.createLog(this.laneDef.logDef()) : this.createLog((CellAddress)this.cellAddress());
        if (log != null) {
            log = this.injectLog(log);
        }
        return log;
    }

    public Policy createPolicy(PolicyDef policyDef) {
        ActorNode node = this.actorNode();
        return node != null ? node.createPolicy(policyDef) : null;
    }

    public Policy createPolicy(CellAddress cellAddress) {
        ActorNode node = this.actorNode();
        return node != null ? node.createPolicy(cellAddress) : null;
    }

    public Policy injectPolicy(Policy policy) {
        ActorNode node = this.actorNode();
        return node != null ? node.injectPolicy(policy) : policy;
    }

    @Override
    protected Policy openPolicy() {
        Policy policy = this.laneDef != null && this.laneDef.policyDef() != null ? this.createPolicy(this.laneDef.policyDef()) : this.createPolicy((CellAddress)this.cellAddress());
        if (policy != null) {
            policy = this.injectPolicy(policy);
        }
        return policy;
    }

    public Stage createStage(StageDef stageDef) {
        ActorNode node = this.actorNode();
        return node != null ? node.createStage(stageDef) : null;
    }

    public Stage createStage(CellAddress cellAddress) {
        ActorNode node = this.actorNode();
        return node != null ? node.createStage(cellAddress) : null;
    }

    public Stage injectStage(Stage stage) {
        ActorNode node = this.actorNode();
        return node != null ? node.injectStage(stage) : stage;
    }

    @Override
    protected Stage openStage() {
        Stage stage = this.laneDef != null && this.laneDef.stageDef() != null ? this.createStage(this.laneDef.stageDef()) : this.createStage((CellAddress)this.cellAddress());
        if (stage != null) {
            stage = this.injectStage(stage);
        }
        return stage;
    }

    public StoreBinding createStore(StoreDef storeDef) {
        ActorNode node = this.actorNode();
        return node != null ? node.createStore(storeDef) : null;
    }

    public StoreBinding createStore(CellAddress cellAddress) {
        ActorNode node = this.actorNode();
        return node != null ? node.createStore(cellAddress) : null;
    }

    public StoreBinding injectStore(StoreBinding store) {
        ActorNode node = this.actorNode();
        return node != null ? node.injectStore(store) : store;
    }

    @Override
    protected StoreBinding openStore() {
        StoreBinding store = null;
        store = this.laneDef != null && this.laneDef.storeDef() != null ? this.createStore(this.laneDef.storeDef()) : this.createStore((CellAddress)this.cellAddress());
        if (store != null) {
            store = this.injectStore(store);
        }
        return store;
    }

    public void openMetaLane(LaneBinding lane, NodeBinding metaLane) {
        this.laneContext.openMetaLane(lane, metaLane);
    }

    public void openMetaUplink(LinkBinding uplink, NodeBinding metaUplink) {
        this.laneContext.openMetaUplink(uplink, metaUplink);
    }

    public void openMetaDownlink(LinkBinding downlink, NodeBinding metaDownlink) {
        this.laneContext.openMetaDownlink(downlink, metaDownlink);
    }

    public void didClose() {
        this.laneBinding.didClose();
    }

    public void didFail(Throwable error) {
        this.laneBinding.didFail(error);
    }
}

