/*
 * Decompiled with CFR 0.152.
 */
package swim.actor;

import java.util.Collection;
import swim.api.auth.AuthenticatorDef;
import swim.api.plane.PlaneDef;
import swim.api.space.SpaceDef;
import swim.codec.Debug;
import swim.codec.Format;
import swim.codec.Output;
import swim.collections.FingerTrieSeq;
import swim.collections.HashTrieMap;
import swim.concurrent.StageDef;
import swim.runtime.EdgeDef;
import swim.runtime.HostDef;
import swim.runtime.LaneDef;
import swim.runtime.LogDef;
import swim.runtime.MeshDef;
import swim.runtime.NodeDef;
import swim.runtime.PartDef;
import swim.runtime.PolicyDef;
import swim.store.StoreDef;
import swim.structure.Value;
import swim.uri.Uri;
import swim.uri.UriMapper;
import swim.util.Murmur3;

public class ActorSpaceDef
implements SpaceDef,
EdgeDef,
Debug {
    private static int hashSeed;
    final String spaceName;
    final FingerTrieSeq<PlaneDef> planeDefs;
    final HashTrieMap<String, AuthenticatorDef> authenticatorDefs;
    final HashTrieMap<Uri, MeshDef> meshDefs;
    final HashTrieMap<Value, PartDef> partDefs;
    final UriMapper<HostDef> hostDefs;
    final UriMapper<NodeDef> nodeDefs;
    final UriMapper<LaneDef> laneDefs;
    final LogDef logDef;
    final PolicyDef policyDef;
    final StageDef stageDef;
    final StoreDef storeDef;

    public ActorSpaceDef(String spaceName, FingerTrieSeq<PlaneDef> planeDefs, HashTrieMap<String, AuthenticatorDef> authenticatorDefs, HashTrieMap<Uri, MeshDef> meshDefs, HashTrieMap<Value, PartDef> partDefs, UriMapper<HostDef> hostDefs, UriMapper<NodeDef> nodeDefs, UriMapper<LaneDef> laneDefs, LogDef logDef, PolicyDef policyDef, StageDef stageDef, StoreDef storeDef) {
        this.spaceName = spaceName;
        this.planeDefs = planeDefs;
        this.authenticatorDefs = authenticatorDefs;
        this.meshDefs = meshDefs;
        this.partDefs = partDefs;
        this.hostDefs = hostDefs;
        this.nodeDefs = nodeDefs;
        this.laneDefs = laneDefs;
        this.logDef = logDef;
        this.policyDef = policyDef;
        this.stageDef = stageDef;
        this.storeDef = storeDef;
    }

    public static ActorSpaceDef fromName(String spaceName) {
        return new ActorSpaceDef(spaceName, (FingerTrieSeq<PlaneDef>)FingerTrieSeq.empty(), (HashTrieMap<String, AuthenticatorDef>)HashTrieMap.empty(), (HashTrieMap<Uri, MeshDef>)HashTrieMap.empty(), (HashTrieMap<Value, PartDef>)HashTrieMap.empty(), (UriMapper<HostDef>)UriMapper.empty(), (UriMapper<NodeDef>)UriMapper.empty(), (UriMapper<LaneDef>)UriMapper.empty(), null, null, null, null);
    }

    public static ActorSpaceDef fromPlaneDef(PlaneDef planeDef) {
        return new ActorSpaceDef(planeDef.planeName(), (FingerTrieSeq<PlaneDef>)FingerTrieSeq.of((Object[])new PlaneDef[]{planeDef}), (HashTrieMap<String, AuthenticatorDef>)HashTrieMap.empty(), (HashTrieMap<Uri, MeshDef>)HashTrieMap.empty(), (HashTrieMap<Value, PartDef>)HashTrieMap.empty(), (UriMapper<HostDef>)UriMapper.empty(), (UriMapper<NodeDef>)UriMapper.empty(), (UriMapper<LaneDef>)UriMapper.empty(), null, null, null, null);
    }

    public final String spaceName() {
        return this.spaceName;
    }

    public ActorSpaceDef spaceName(String spaceName) {
        return this.copy(spaceName, this.planeDefs, this.authenticatorDefs, this.meshDefs, this.partDefs, this.hostDefs, this.nodeDefs, this.laneDefs, this.logDef, this.policyDef, this.stageDef, this.storeDef);
    }

    public final Collection<? extends PlaneDef> planeDefs() {
        return this.planeDefs;
    }

    public final PlaneDef getPlaneDef(String planeName) {
        for (PlaneDef planeDef : this.planeDefs) {
            if (!planeName.equals(planeDef.planeName())) continue;
            return planeDef;
        }
        return null;
    }

    public ActorSpaceDef planeDef(PlaneDef planeDef) {
        return this.copy(this.spaceName, (FingerTrieSeq<PlaneDef>)this.planeDefs.appended((Object)planeDef), this.authenticatorDefs, this.meshDefs, this.partDefs, this.hostDefs, this.nodeDefs, this.laneDefs, this.logDef, this.policyDef, this.stageDef, this.storeDef);
    }

    public final Collection<? extends AuthenticatorDef> authenticatorDefs() {
        return this.authenticatorDefs.values();
    }

    public final AuthenticatorDef getAuthenticatorDef(String authenticatorDef) {
        return (AuthenticatorDef)this.authenticatorDefs.get((Object)authenticatorDef);
    }

    public ActorSpaceDef authenticatorDef(AuthenticatorDef authenticatorDef) {
        return this.copy(this.spaceName, this.planeDefs, (HashTrieMap<String, AuthenticatorDef>)this.authenticatorDefs.updated((Object)authenticatorDef.authenticatorName(), (Object)authenticatorDef), this.meshDefs, this.partDefs, this.hostDefs, this.nodeDefs, this.laneDefs, this.logDef, this.policyDef, this.stageDef, this.storeDef);
    }

    public final Collection<? extends MeshDef> meshDefs() {
        return this.meshDefs.values();
    }

    public final MeshDef getMeshDef(Uri meshUri) {
        return (MeshDef)this.meshDefs.get((Object)meshUri);
    }

    public ActorSpaceDef meshDef(MeshDef meshDef) {
        return this.copy(this.spaceName, this.planeDefs, this.authenticatorDefs, (HashTrieMap<Uri, MeshDef>)this.meshDefs.updated((Object)meshDef.meshUri(), (Object)meshDef), this.partDefs, this.hostDefs, this.nodeDefs, this.laneDefs, this.logDef, this.policyDef, this.stageDef, this.storeDef);
    }

    public final Collection<? extends PartDef> partDefs() {
        return this.partDefs.values();
    }

    public final PartDef getPartDef(Value partKey) {
        return (PartDef)this.partDefs.get((Object)partKey);
    }

    public ActorSpaceDef partDef(PartDef partDef) {
        return this.copy(this.spaceName, this.planeDefs, this.authenticatorDefs, this.meshDefs, (HashTrieMap<Value, PartDef>)this.partDefs.updated((Object)partDef.partKey(), (Object)partDef), this.hostDefs, this.nodeDefs, this.laneDefs, this.logDef, this.policyDef, this.stageDef, this.storeDef);
    }

    public final Collection<? extends HostDef> hostDefs() {
        return this.hostDefs.values();
    }

    public final HostDef getHostDef(Uri hostUri) {
        return (HostDef)this.hostDefs.get(hostUri);
    }

    public ActorSpaceDef hostDef(HostDef hostDef) {
        return this.copy(this.spaceName, this.planeDefs, this.authenticatorDefs, this.meshDefs, this.partDefs, (UriMapper<HostDef>)this.hostDefs.updated(hostDef.hostPattern(), (Object)hostDef), this.nodeDefs, this.laneDefs, this.logDef, this.policyDef, this.stageDef, this.storeDef);
    }

    public final Collection<? extends NodeDef> nodeDefs() {
        return this.nodeDefs.values();
    }

    public final NodeDef getNodeDef(Uri nodeUri) {
        return (NodeDef)this.nodeDefs.get(nodeUri);
    }

    public ActorSpaceDef nodeDef(NodeDef nodeDef) {
        return this.copy(this.spaceName, this.planeDefs, this.authenticatorDefs, this.meshDefs, this.partDefs, this.hostDefs, (UriMapper<NodeDef>)this.nodeDefs.updated(nodeDef.nodePattern(), (Object)nodeDef), this.laneDefs, this.logDef, this.policyDef, this.stageDef, this.storeDef);
    }

    public final Collection<? extends LaneDef> laneDefs() {
        return this.laneDefs.values();
    }

    public final LaneDef getLaneDef(Uri laneUri) {
        return (LaneDef)this.laneDefs.get(laneUri);
    }

    public ActorSpaceDef laneDef(LaneDef laneDef) {
        return this.copy(this.spaceName, this.planeDefs, this.authenticatorDefs, this.meshDefs, this.partDefs, this.hostDefs, this.nodeDefs, (UriMapper<LaneDef>)this.laneDefs.updated(laneDef.lanePattern(), (Object)laneDef), this.logDef, this.policyDef, this.stageDef, this.storeDef);
    }

    public final LogDef logDef() {
        return this.logDef;
    }

    public ActorSpaceDef logDef(LogDef logDef) {
        return this.copy(this.spaceName, this.planeDefs, this.authenticatorDefs, this.meshDefs, this.partDefs, this.hostDefs, this.nodeDefs, this.laneDefs, logDef, this.policyDef, this.stageDef, this.storeDef);
    }

    public final PolicyDef policyDef() {
        return this.policyDef;
    }

    public ActorSpaceDef policyDef(PolicyDef policyDef) {
        return this.copy(this.spaceName, this.planeDefs, this.authenticatorDefs, this.meshDefs, this.partDefs, this.hostDefs, this.nodeDefs, this.laneDefs, this.logDef, policyDef, this.stageDef, this.storeDef);
    }

    public final StageDef stageDef() {
        return this.stageDef;
    }

    public ActorSpaceDef stageDef(StageDef stageDef) {
        return this.copy(this.spaceName, this.planeDefs, this.authenticatorDefs, this.meshDefs, this.partDefs, this.hostDefs, this.nodeDefs, this.laneDefs, this.logDef, this.policyDef, stageDef, this.storeDef);
    }

    public final StoreDef storeDef() {
        return this.storeDef;
    }

    public ActorSpaceDef storeDef(StoreDef storeDef) {
        return this.copy(this.spaceName, this.planeDefs, this.authenticatorDefs, this.meshDefs, this.partDefs, this.hostDefs, this.nodeDefs, this.laneDefs, this.logDef, this.policyDef, this.stageDef, storeDef);
    }

    protected ActorSpaceDef copy(String spaceName, FingerTrieSeq<PlaneDef> planeDefs, HashTrieMap<String, AuthenticatorDef> authenticatorDefs, HashTrieMap<Uri, MeshDef> meshDefs, HashTrieMap<Value, PartDef> partDefs, UriMapper<HostDef> hostDefs, UriMapper<NodeDef> nodeDefs, UriMapper<LaneDef> laneDefs, LogDef logDef, PolicyDef policyDef, StageDef stageDef, StoreDef storeDef) {
        return new ActorSpaceDef(spaceName, planeDefs, authenticatorDefs, meshDefs, partDefs, hostDefs, nodeDefs, laneDefs, logDef, policyDef, stageDef, storeDef);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof ActorSpaceDef) {
            ActorSpaceDef that = (ActorSpaceDef)other;
            return (this.spaceName == null ? that.spaceName == null : this.spaceName.equals(that.spaceName)) && this.planeDefs.equals(that.planeDefs) && this.authenticatorDefs.equals(that.authenticatorDefs) && this.meshDefs.equals(that.meshDefs) && this.partDefs.equals(that.partDefs) && this.hostDefs.equals(that.hostDefs) && this.nodeDefs.equals(that.nodeDefs) && this.laneDefs.equals(that.laneDefs) && (this.logDef == null ? that.logDef == null : this.logDef.equals(that.logDef)) && (this.policyDef == null ? that.policyDef == null : this.policyDef.equals(that.policyDef)) && (this.stageDef == null ? that.stageDef == null : this.stageDef.equals(that.stageDef)) && (this.storeDef == null ? that.storeDef == null : this.storeDef.equals(that.storeDef));
        }
        return false;
    }

    public int hashCode() {
        if (hashSeed == 0) {
            hashSeed = Murmur3.seed(ActorSpaceDef.class);
        }
        return Murmur3.mash((int)Murmur3.mix((int)Murmur3.mix((int)Murmur3.mix((int)Murmur3.mix((int)Murmur3.mix((int)Murmur3.mix((int)Murmur3.mix((int)Murmur3.mix((int)Murmur3.mix((int)Murmur3.mix((int)Murmur3.mix((int)Murmur3.mix((int)hashSeed, (int)Murmur3.hash((Object)this.spaceName)), (int)this.planeDefs.hashCode()), (int)this.authenticatorDefs.hashCode()), (int)this.meshDefs.hashCode()), (int)this.partDefs.hashCode()), (int)this.hostDefs.hashCode()), (int)this.nodeDefs.hashCode()), (int)this.laneDefs.hashCode()), (int)Murmur3.hash((Object)this.logDef)), (int)Murmur3.hash((Object)this.policyDef)), (int)Murmur3.hash((Object)this.stageDef)), (int)Murmur3.hash((Object)this.storeDef)));
    }

    public void debug(Output<?> output) {
        output = output.write("ActorSpaceDef").write(46).write("fromName").write(40).debug((Object)this.spaceName).write(41);
        for (PlaneDef planeDef : this.planeDefs) {
            output = output.write(46).write("planeDef").write(40).debug((Object)planeDef).write(41);
        }
        for (AuthenticatorDef authenticatorDef : this.authenticatorDefs.values()) {
            output = output.write(46).write("authenticatorDef").write(40).debug((Object)authenticatorDef).write(41);
        }
        for (MeshDef meshDef : this.meshDefs.values()) {
            output = output.write(46).write("meshDef").write(40).debug((Object)meshDef).write(41);
        }
        for (PartDef partDef : this.partDefs.values()) {
            output = output.write(46).write("partDef").write(40).debug((Object)partDef).write(41);
        }
        for (HostDef hostDef : this.hostDefs.values()) {
            output = output.write(46).write("hostDef").write(40).debug((Object)hostDef).write(41);
        }
        for (NodeDef nodeDef : this.nodeDefs.values()) {
            output = output.write(46).write("nodeDef").write(40).debug((Object)nodeDef).write(41);
        }
        for (LaneDef laneDef : this.laneDefs.values()) {
            output = output.write(46).write("laneDef").write(40).debug((Object)laneDef).write(41);
        }
        if (this.logDef != null) {
            output = output.write(46).write("logDef").write(40).debug((Object)this.logDef).write(41);
        }
        if (this.policyDef != null) {
            output = output.write(46).write("policyDef").write(40).debug((Object)this.policyDef).write(41);
        }
        if (this.stageDef != null) {
            output = output.write(46).write("stageDef").write(40).debug((Object)this.stageDef).write(41);
        }
        if (this.storeDef != null) {
            output = output.write(46).write("storeDef").write(40).debug((Object)this.storeDef).write(41);
        }
    }

    public String toString() {
        return Format.debug((Object)this);
    }
}

