/*
 * Decompiled with CFR 0.152.
 */
package swim.actor;

import java.util.Collection;
import swim.codec.Debug;
import swim.codec.Format;
import swim.codec.Output;
import swim.concurrent.StageDef;
import swim.store.StoreDef;
import swim.system.HostDef;
import swim.system.LaneDef;
import swim.system.LogDef;
import swim.system.NodeDef;
import swim.system.PolicyDef;
import swim.uri.Uri;
import swim.uri.UriMapper;
import swim.uri.UriPattern;
import swim.util.Murmur3;

public class ActorHostDef
implements HostDef,
Debug {
    final UriPattern hostPattern;
    final boolean isPrimary;
    final boolean isReplica;
    final UriMapper<NodeDef> nodeDefs;
    final UriMapper<LaneDef> laneDefs;
    final LogDef logDef;
    final PolicyDef policyDef;
    final StageDef stageDef;
    final StoreDef storeDef;
    private static int hashSeed;

    public ActorHostDef(UriPattern hostPattern, boolean isPrimary, boolean isReplica, UriMapper<NodeDef> nodeDefs, UriMapper<LaneDef> laneDefs, LogDef logDef, PolicyDef policyDef, StageDef stageDef, StoreDef storeDef) {
        this.hostPattern = hostPattern;
        this.isPrimary = isPrimary;
        this.isReplica = isReplica;
        this.nodeDefs = nodeDefs;
        this.laneDefs = laneDefs;
        this.logDef = logDef;
        this.policyDef = policyDef;
        this.stageDef = stageDef;
        this.storeDef = storeDef;
    }

    public final Uri hostUri() {
        return this.hostPattern.isUri() ? this.hostPattern.toUri() : null;
    }

    public final UriPattern hostPattern() {
        return this.hostPattern;
    }

    public ActorHostDef hostPattern(UriPattern hostPattern) {
        return this.copy(hostPattern, this.isPrimary, this.isReplica, this.nodeDefs, this.laneDefs, this.logDef, this.policyDef, this.stageDef, this.storeDef);
    }

    public final boolean isPrimary() {
        return this.isPrimary;
    }

    public ActorHostDef isPrimary(boolean isPrimary) {
        return this.copy(this.hostPattern, isPrimary, this.isReplica, this.nodeDefs, this.laneDefs, this.logDef, this.policyDef, this.stageDef, this.storeDef);
    }

    public final boolean isReplica() {
        return this.isReplica;
    }

    public ActorHostDef isReplica(boolean isReplica) {
        return this.copy(this.hostPattern, this.isPrimary, isReplica, this.nodeDefs, this.laneDefs, this.logDef, this.policyDef, this.stageDef, this.storeDef);
    }

    public final Collection<? extends NodeDef> nodeDefs() {
        return this.nodeDefs.values();
    }

    public final NodeDef getNodeDef(Uri nodeUri) {
        return (NodeDef)this.nodeDefs.get(nodeUri);
    }

    public ActorHostDef nodeDef(NodeDef nodeDef) {
        return this.copy(this.hostPattern, this.isPrimary, this.isReplica, (UriMapper<NodeDef>)this.nodeDefs.updated(nodeDef.nodePattern(), (Object)nodeDef), this.laneDefs, this.logDef, this.policyDef, this.stageDef, this.storeDef);
    }

    public final Collection<? extends LaneDef> laneDefs() {
        return this.laneDefs.values();
    }

    public final LaneDef getLaneDef(Uri laneUri) {
        return (LaneDef)this.laneDefs.get(laneUri);
    }

    public ActorHostDef laneDef(LaneDef laneDef) {
        return this.copy(this.hostPattern, this.isPrimary, this.isReplica, this.nodeDefs, (UriMapper<LaneDef>)this.laneDefs.updated(laneDef.lanePattern(), (Object)laneDef), this.logDef, this.policyDef, this.stageDef, this.storeDef);
    }

    public final LogDef logDef() {
        return this.logDef;
    }

    public ActorHostDef logDef(LogDef logDef) {
        return this.copy(this.hostPattern, this.isPrimary, this.isReplica, this.nodeDefs, this.laneDefs, logDef, this.policyDef, this.stageDef, this.storeDef);
    }

    public final PolicyDef policyDef() {
        return this.policyDef;
    }

    public ActorHostDef policyDef(PolicyDef policyDef) {
        return this.copy(this.hostPattern, this.isPrimary, this.isReplica, this.nodeDefs, this.laneDefs, this.logDef, policyDef, this.stageDef, this.storeDef);
    }

    public final StageDef stageDef() {
        return this.stageDef;
    }

    public ActorHostDef stageDef(StageDef stageDef) {
        return this.copy(this.hostPattern, this.isPrimary, this.isReplica, this.nodeDefs, this.laneDefs, this.logDef, this.policyDef, stageDef, this.storeDef);
    }

    public final StoreDef storeDef() {
        return this.storeDef;
    }

    public ActorHostDef storeDef(StoreDef storeDef) {
        return this.copy(this.hostPattern, this.isPrimary, this.isReplica, this.nodeDefs, this.laneDefs, this.logDef, this.policyDef, this.stageDef, storeDef);
    }

    protected ActorHostDef copy(UriPattern hostPattern, boolean isPrimary, boolean isReplica, UriMapper<NodeDef> nodeDefs, UriMapper<LaneDef> laneDefs, LogDef logDef, PolicyDef policyDef, StageDef stageDef, StoreDef storeDef) {
        return new ActorHostDef(hostPattern, isPrimary, isReplica, nodeDefs, laneDefs, logDef, policyDef, stageDef, storeDef);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof ActorHostDef) {
            ActorHostDef that = (ActorHostDef)other;
            return this.hostPattern.equals((Object)that.hostPattern) && this.isPrimary == that.isPrimary && this.isReplica == that.isReplica && this.nodeDefs.equals(that.nodeDefs) && this.laneDefs.equals(that.laneDefs) && (this.logDef == null ? that.logDef == null : this.logDef.equals(that.logDef)) && (this.policyDef == null ? that.policyDef == null : this.policyDef.equals(that.policyDef)) && (this.stageDef == null ? that.stageDef == null : this.stageDef.equals(that.stageDef)) && (this.storeDef == null ? that.storeDef == null : this.storeDef.equals(that.storeDef));
        }
        return false;
    }

    public int hashCode() {
        if (hashSeed == 0) {
            hashSeed = Murmur3.seed(ActorHostDef.class);
        }
        return Murmur3.mash((int)Murmur3.mix((int)Murmur3.mix((int)Murmur3.mix((int)Murmur3.mix((int)Murmur3.mix((int)Murmur3.mix((int)Murmur3.mix((int)Murmur3.mix((int)Murmur3.mix((int)hashSeed, (int)this.hostPattern.hashCode()), (int)Murmur3.hash((boolean)this.isPrimary)), (int)Murmur3.hash((boolean)this.isReplica)), (int)this.nodeDefs.hashCode()), (int)this.laneDefs.hashCode()), (int)Murmur3.hash((Object)this.logDef)), (int)Murmur3.hash((Object)this.policyDef)), (int)Murmur3.hash((Object)this.stageDef)), (int)Murmur3.hash((Object)this.storeDef)));
    }

    public <T> Output<T> debug(Output<T> output) {
        output = output.write("ActorHostDef").write(46);
        output = this.hostPattern.isUri() ? output.write("fromHostUri").write(40).debug((Object)this.hostPattern.toUri()).write(41) : output.write("fromHostPattern").write(40).debug((Object)this.hostPattern).write(41);
        if (this.isPrimary) {
            output = output.write(46).write("isPrimary").write(40).debug((Object)this.isPrimary).write(41);
        }
        if (this.isReplica) {
            output = output.write(46).write("isReplica").write(40).debug((Object)this.isReplica).write(41);
        }
        for (NodeDef nodeDef : this.nodeDefs.values()) {
            output = output.write(46).write("nodeDef").write(40).debug((Object)nodeDef).write(41);
        }
        for (LaneDef laneDef : this.laneDefs.values()) {
            output = output.write(46).write("laneDef").write(40).debug((Object)laneDef).write(41);
        }
        if (this.logDef != null) {
            output = output.write(46).write("logDef").write(40).debug((Object)this.logDef).write(41);
        }
        if (this.policyDef != null) {
            output = output.write(46).write("policyDef").write(40).debug((Object)this.policyDef).write(41);
        }
        if (this.stageDef != null) {
            output = output.write(46).write("stageDef").write(40).debug((Object)this.stageDef).write(41);
        }
        if (this.storeDef != null) {
            output = output.write(46).write("storeDef").write(40).debug((Object)this.storeDef).write(41);
        }
        return output;
    }

    public String toString() {
        return Format.debug((Object)this);
    }

    public static ActorHostDef fromHostUri(Uri hostUri) {
        return new ActorHostDef(UriPattern.from((Uri)hostUri), false, false, (UriMapper<NodeDef>)UriMapper.empty(), (UriMapper<LaneDef>)UriMapper.empty(), null, null, null, null);
    }

    public static ActorHostDef fromHostUri(String hostUri) {
        return ActorHostDef.fromHostUri(Uri.parse((String)hostUri));
    }

    public static ActorHostDef fromHostPattern(UriPattern hostPattern) {
        return new ActorHostDef(hostPattern, false, false, (UriMapper<NodeDef>)UriMapper.empty(), (UriMapper<LaneDef>)UriMapper.empty(), null, null, null, null);
    }

    public static ActorHostDef fromHostPattern(String hostPattern) {
        return ActorHostDef.fromHostPattern(UriPattern.parse((String)hostPattern));
    }
}

