/*
 * Decompiled with CFR 0.152.
 */
package swim.actor;

import swim.codec.Debug;
import swim.codec.Format;
import swim.codec.Output;
import swim.concurrent.StageDef;
import swim.store.StoreDef;
import swim.system.LaneDef;
import swim.system.LogDef;
import swim.system.PolicyDef;
import swim.uri.Uri;
import swim.uri.UriPattern;
import swim.util.Murmur3;

public class ActorLaneDef
implements LaneDef,
Debug {
    final UriPattern lanePattern;
    final String laneType;
    final LogDef logDef;
    final PolicyDef policyDef;
    final StageDef stageDef;
    final StoreDef storeDef;
    private static int hashSeed;

    public ActorLaneDef(UriPattern lanePattern, String laneType, LogDef logDef, PolicyDef policyDef, StageDef stageDef, StoreDef storeDef) {
        this.lanePattern = lanePattern;
        this.laneType = laneType;
        this.logDef = logDef;
        this.policyDef = policyDef;
        this.stageDef = stageDef;
        this.storeDef = storeDef;
    }

    public final Uri laneUri() {
        return this.lanePattern.isUri() ? this.lanePattern.toUri() : null;
    }

    public final UriPattern lanePattern() {
        return this.lanePattern;
    }

    public ActorLaneDef lanePattern(UriPattern lanePattern) {
        return this.copy(lanePattern, this.laneType, this.logDef, this.policyDef, this.stageDef, this.storeDef);
    }

    public final String laneType() {
        return this.laneType;
    }

    public ActorLaneDef laneType(String laneType) {
        return this.copy(this.lanePattern, laneType, this.logDef, this.policyDef, this.stageDef, this.storeDef);
    }

    public final LogDef logDef() {
        return this.logDef;
    }

    public ActorLaneDef logDef(LogDef logDef) {
        return this.copy(this.lanePattern, this.laneType, logDef, this.policyDef, this.stageDef, this.storeDef);
    }

    public final PolicyDef policyDef() {
        return this.policyDef;
    }

    public ActorLaneDef policyDef(PolicyDef policyDef) {
        return this.copy(this.lanePattern, this.laneType, this.logDef, policyDef, this.stageDef, this.storeDef);
    }

    public final StageDef stageDef() {
        return this.stageDef;
    }

    public ActorLaneDef stageDef(StageDef stageDef) {
        return this.copy(this.lanePattern, this.laneType, this.logDef, this.policyDef, stageDef, this.storeDef);
    }

    public final StoreDef storeDef() {
        return this.storeDef;
    }

    public ActorLaneDef storeDef(StoreDef storeDef) {
        return this.copy(this.lanePattern, this.laneType, this.logDef, this.policyDef, this.stageDef, storeDef);
    }

    protected ActorLaneDef copy(UriPattern lanePattern, String laneType, LogDef logDef, PolicyDef policyDef, StageDef stageDef, StoreDef storeDef) {
        return new ActorLaneDef(lanePattern, laneType, logDef, policyDef, stageDef, storeDef);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof ActorLaneDef) {
            ActorLaneDef that = (ActorLaneDef)other;
            return this.lanePattern.equals((Object)that.lanePattern) && (this.laneType == null ? that.laneType == null : this.laneType.equals(that.laneType)) && (this.logDef == null ? that.logDef == null : this.logDef.equals(that.logDef)) && (this.policyDef == null ? that.policyDef == null : this.policyDef.equals(that.policyDef)) && (this.stageDef == null ? that.stageDef == null : this.stageDef.equals(that.stageDef)) && (this.storeDef == null ? that.storeDef == null : this.storeDef.equals(that.storeDef));
        }
        return false;
    }

    public int hashCode() {
        if (hashSeed == 0) {
            hashSeed = Murmur3.seed(ActorLaneDef.class);
        }
        return Murmur3.mash((int)Murmur3.mix((int)Murmur3.mix((int)Murmur3.mix((int)Murmur3.mix((int)Murmur3.mix((int)Murmur3.mix((int)hashSeed, (int)this.lanePattern.hashCode()), (int)Murmur3.hash((Object)this.laneType)), (int)Murmur3.hash((Object)this.logDef)), (int)Murmur3.hash((Object)this.policyDef)), (int)Murmur3.hash((Object)this.stageDef)), (int)Murmur3.hash((Object)this.storeDef)));
    }

    public <T> Output<T> debug(Output<T> output) {
        output = output.write("ActorLaneDef").write(46);
        output = this.lanePattern.isUri() ? output.write("fromLaneUri").write(40).debug((Object)this.lanePattern.toUri()).write(41) : output.write("fromLanePattern").write(40).debug((Object)this.lanePattern).write(41);
        if (this.laneType != null) {
            output = output.write(46).write("laneType").write(40).debug((Object)this.laneType).write(41);
        }
        if (this.logDef != null) {
            output = output.write(46).write("logDef").write(40).debug((Object)this.logDef).write(41);
        }
        if (this.policyDef != null) {
            output = output.write(46).write("policyDef").write(40).debug((Object)this.policyDef).write(41);
        }
        if (this.stageDef != null) {
            output = output.write(46).write("stageDef").write(40).debug((Object)this.stageDef).write(41);
        }
        if (this.storeDef != null) {
            output = output.write(46).write("storeDef").write(40).debug((Object)this.storeDef).write(41);
        }
        return output;
    }

    public String toString() {
        return Format.debug((Object)this);
    }

    public static ActorLaneDef fromLaneUri(Uri laneUri) {
        return new ActorLaneDef(UriPattern.from((Uri)laneUri), null, null, null, null, null);
    }

    public static ActorLaneDef fromLaneUri(String laneUri) {
        return ActorLaneDef.fromLaneUri(Uri.parse((String)laneUri));
    }

    public static ActorLaneDef fromLanePattern(UriPattern lanePattern) {
        return new ActorLaneDef(lanePattern, null, null, null, null, null);
    }

    public static ActorLaneDef fromLanePattern(String lanePattern) {
        return ActorLaneDef.fromLanePattern(UriPattern.parse((String)lanePattern));
    }
}

