/*
 * Decompiled with CFR 0.152.
 */
package swim.actor;

import java.util.Collection;
import swim.codec.Debug;
import swim.codec.Format;
import swim.codec.Output;
import swim.collections.HashTrieMap;
import swim.concurrent.StageDef;
import swim.store.StoreDef;
import swim.structure.Value;
import swim.system.HostDef;
import swim.system.LaneDef;
import swim.system.LogDef;
import swim.system.MeshDef;
import swim.system.NodeDef;
import swim.system.PartDef;
import swim.system.PolicyDef;
import swim.uri.Uri;
import swim.uri.UriMapper;
import swim.util.Murmur3;

public class ActorMeshDef
implements MeshDef,
Debug {
    final Uri meshUri;
    final HashTrieMap<Value, PartDef> partDefs;
    final UriMapper<HostDef> hostDefs;
    final UriMapper<NodeDef> nodeDefs;
    final UriMapper<LaneDef> laneDefs;
    final LogDef logDef;
    final PolicyDef policyDef;
    final StageDef stageDef;
    final StoreDef storeDef;
    private static int hashSeed;

    public ActorMeshDef(Uri meshUri, HashTrieMap<Value, PartDef> partDefs, UriMapper<HostDef> hostDefs, UriMapper<NodeDef> nodeDefs, UriMapper<LaneDef> laneDefs, LogDef logDef, PolicyDef policyDef, StageDef stageDef, StoreDef storeDef) {
        this.meshUri = meshUri;
        this.partDefs = partDefs;
        this.hostDefs = hostDefs;
        this.nodeDefs = nodeDefs;
        this.laneDefs = laneDefs;
        this.logDef = logDef;
        this.policyDef = policyDef;
        this.stageDef = stageDef;
        this.storeDef = storeDef;
    }

    public final Uri meshUri() {
        return this.meshUri;
    }

    public ActorMeshDef meshUri(Uri meshUri) {
        return this.copy(meshUri, this.partDefs, this.hostDefs, this.nodeDefs, this.laneDefs, this.logDef, this.policyDef, this.stageDef, this.storeDef);
    }

    public final Collection<? extends PartDef> partDefs() {
        return this.partDefs.values();
    }

    public final PartDef getPartDef(Value partKey) {
        return (PartDef)this.partDefs.get((Object)partKey);
    }

    public ActorMeshDef partDef(PartDef partDef) {
        return this.copy(this.meshUri, (HashTrieMap<Value, PartDef>)this.partDefs.updated((Object)partDef.partKey(), (Object)partDef), this.hostDefs, this.nodeDefs, this.laneDefs, this.logDef, this.policyDef, this.stageDef, this.storeDef);
    }

    public final Collection<? extends HostDef> hostDefs() {
        return this.hostDefs.values();
    }

    public final HostDef getHostDef(Uri hostUri) {
        return (HostDef)this.hostDefs.get(hostUri);
    }

    public ActorMeshDef hostDef(HostDef hostDef) {
        return this.copy(this.meshUri, this.partDefs, (UriMapper<HostDef>)this.hostDefs.updated(hostDef.hostPattern(), (Object)hostDef), this.nodeDefs, this.laneDefs, this.logDef, this.policyDef, this.stageDef, this.storeDef);
    }

    public final Collection<? extends NodeDef> nodeDefs() {
        return this.nodeDefs.values();
    }

    public final NodeDef getNodeDef(Uri nodeUri) {
        return (NodeDef)this.nodeDefs.get(nodeUri);
    }

    public ActorMeshDef nodeDef(NodeDef nodeDef) {
        return this.copy(this.meshUri, this.partDefs, this.hostDefs, (UriMapper<NodeDef>)this.nodeDefs.updated(nodeDef.nodePattern(), (Object)nodeDef), this.laneDefs, this.logDef, this.policyDef, this.stageDef, this.storeDef);
    }

    public final Collection<? extends LaneDef> laneDefs() {
        return this.laneDefs.values();
    }

    public final LaneDef getLaneDef(Uri laneUri) {
        return (LaneDef)this.laneDefs.get(laneUri);
    }

    public ActorMeshDef laneDef(LaneDef laneDef) {
        return this.copy(this.meshUri, this.partDefs, this.hostDefs, this.nodeDefs, (UriMapper<LaneDef>)this.laneDefs.updated(laneDef.lanePattern(), (Object)laneDef), this.logDef, this.policyDef, this.stageDef, this.storeDef);
    }

    public final LogDef logDef() {
        return this.logDef;
    }

    public ActorMeshDef logDef(LogDef logDef) {
        return this.copy(this.meshUri, this.partDefs, this.hostDefs, this.nodeDefs, this.laneDefs, logDef, this.policyDef, this.stageDef, this.storeDef);
    }

    public final PolicyDef policyDef() {
        return this.policyDef;
    }

    public ActorMeshDef policyDef(PolicyDef policyDef) {
        return this.copy(this.meshUri, this.partDefs, this.hostDefs, this.nodeDefs, this.laneDefs, this.logDef, policyDef, this.stageDef, this.storeDef);
    }

    public final StageDef stageDef() {
        return this.stageDef;
    }

    public ActorMeshDef stageDef(StageDef stageDef) {
        return this.copy(this.meshUri, this.partDefs, this.hostDefs, this.nodeDefs, this.laneDefs, this.logDef, this.policyDef, stageDef, this.storeDef);
    }

    public final StoreDef storeDef() {
        return this.storeDef;
    }

    public ActorMeshDef storeDef(StoreDef storeDef) {
        return this.copy(this.meshUri, this.partDefs, this.hostDefs, this.nodeDefs, this.laneDefs, this.logDef, this.policyDef, this.stageDef, storeDef);
    }

    protected ActorMeshDef copy(Uri meshUri, HashTrieMap<Value, PartDef> partDefs, UriMapper<HostDef> hostDefs, UriMapper<NodeDef> nodeDefs, UriMapper<LaneDef> laneDefs, LogDef logDef, PolicyDef policyDef, StageDef stageDef, StoreDef storeDef) {
        return new ActorMeshDef(meshUri, partDefs, hostDefs, nodeDefs, laneDefs, logDef, policyDef, stageDef, storeDef);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof ActorMeshDef) {
            ActorMeshDef that = (ActorMeshDef)other;
            return this.meshUri.equals((Object)that.meshUri) && this.partDefs.equals(that.partDefs) && this.hostDefs.equals(that.hostDefs) && this.nodeDefs.equals(that.nodeDefs) && this.laneDefs.equals(that.laneDefs) && (this.logDef == null ? that.logDef == null : this.logDef.equals(that.logDef)) && (this.policyDef == null ? that.policyDef == null : this.policyDef.equals(that.policyDef)) && (this.stageDef == null ? that.stageDef == null : this.stageDef.equals(that.stageDef)) && (this.storeDef == null ? that.storeDef == null : this.storeDef.equals(that.storeDef));
        }
        return false;
    }

    public int hashCode() {
        if (hashSeed == 0) {
            hashSeed = Murmur3.seed(ActorMeshDef.class);
        }
        return Murmur3.mash((int)Murmur3.mix((int)Murmur3.mix((int)Murmur3.mix((int)Murmur3.mix((int)Murmur3.mix((int)Murmur3.mix((int)Murmur3.mix((int)Murmur3.mix((int)Murmur3.mix((int)hashSeed, (int)Murmur3.hash((Object)this.meshUri)), (int)this.partDefs.hashCode()), (int)this.hostDefs.hashCode()), (int)this.nodeDefs.hashCode()), (int)this.laneDefs.hashCode()), (int)Murmur3.hash((Object)this.logDef)), (int)Murmur3.hash((Object)this.policyDef)), (int)Murmur3.hash((Object)this.stageDef)), (int)Murmur3.hash((Object)this.storeDef)));
    }

    public <T> Output<T> debug(Output<T> output) {
        output = output.write("ActorMeshDef").write(46).write("fromMeshUri").write(40).debug((Object)this.meshUri).write(41);
        for (PartDef partDef : this.partDefs.values()) {
            output = output.write(46).write("partDef").write(40).debug((Object)partDef).write(41);
        }
        for (HostDef hostDef : this.hostDefs.values()) {
            output = output.write(46).write("hostDef").write(40).debug((Object)hostDef).write(41);
        }
        for (NodeDef nodeDef : this.nodeDefs.values()) {
            output = output.write(46).write("nodeDef").write(40).debug((Object)nodeDef).write(41);
        }
        for (LaneDef laneDef : this.laneDefs.values()) {
            output = output.write(46).write("laneDef").write(40).debug((Object)laneDef).write(41);
        }
        if (this.logDef != null) {
            output = output.write(46).write("logDef").write(40).debug((Object)this.logDef).write(41);
        }
        if (this.policyDef != null) {
            output = output.write(46).write("policyDef").write(40).debug((Object)this.policyDef).write(41);
        }
        if (this.stageDef != null) {
            output = output.write(46).write("stageDef").write(40).debug((Object)this.stageDef).write(41);
        }
        if (this.storeDef != null) {
            output = output.write(46).write("storeDef").write(40).debug((Object)this.storeDef).write(41);
        }
        return output;
    }

    public String toString() {
        return Format.debug((Object)this);
    }

    public static ActorMeshDef fromMeshUri(Uri meshUri) {
        return new ActorMeshDef(meshUri, (HashTrieMap<Value, PartDef>)HashTrieMap.empty(), (UriMapper<HostDef>)UriMapper.empty(), (UriMapper<NodeDef>)UriMapper.empty(), (UriMapper<LaneDef>)UriMapper.empty(), null, null, null, null);
    }

    public static ActorMeshDef fromMeshUri(String meshUri) {
        return ActorMeshDef.fromMeshUri(Uri.parse((String)meshUri));
    }
}

