/*
 * Decompiled with CFR 0.152.
 */
package swim.api.policy;

import swim.api.Downlink;
import swim.api.Lane;
import swim.api.Uplink;
import swim.api.agent.Agent;
import swim.api.agent.AgentRoute;
import swim.api.auth.Identity;
import swim.api.policy.AgentPolicy;
import swim.api.policy.AgentRoutePolicy;
import swim.api.policy.DownlinkPolicy;
import swim.api.policy.LanePolicy;
import swim.api.policy.PlanePolicy;
import swim.api.policy.Policy;
import swim.api.policy.PolicyDirective;
import swim.api.policy.UplinkPolicy;
import swim.http.HttpMessage;
import swim.http.HttpRequest;
import swim.http.HttpResponse;
import swim.uri.Uri;
import swim.warp.CommandMessage;
import swim.warp.Envelope;
import swim.warp.EventMessage;
import swim.warp.LinkRequest;
import swim.warp.SyncRequest;

public class AbstractPolicy
implements Policy,
PlanePolicy,
AgentRoutePolicy,
AgentPolicy,
LanePolicy,
UplinkPolicy,
DownlinkPolicy {
    @Override
    public AgentRoutePolicy agentRoutePolicy(AgentRoute<?> agentRoute) {
        return this;
    }

    @Override
    public AgentPolicy agentPolicy(Agent agent) {
        return this;
    }

    @Override
    public LanePolicy lanePolicy(Lane lane) {
        return this;
    }

    @Override
    public UplinkPolicy uplinkPolicy(Uplink uplink) {
        return this;
    }

    @Override
    public DownlinkPolicy downlinkPolicy(Downlink downlink) {
        return this;
    }

    @Override
    public PolicyDirective<Object> canConnect(Uri requestUri) {
        return this.allow();
    }

    @Override
    public PolicyDirective<LinkRequest> canLink(LinkRequest request, Identity identity) {
        return this.authorize((Envelope)request, identity);
    }

    @Override
    public PolicyDirective<SyncRequest> canSync(SyncRequest request, Identity identity) {
        return this.authorize((Envelope)request, identity);
    }

    @Override
    public PolicyDirective<EventMessage> canUplink(EventMessage message, Identity identity) {
        return this.authorize((Envelope)message, identity);
    }

    @Override
    public PolicyDirective<CommandMessage> canDownlink(CommandMessage message, Identity identity) {
        return this.authorize((Envelope)message, identity);
    }

    @Override
    public PolicyDirective<HttpMessage<?>> canRequest(HttpRequest<?> request) {
        return this.allow();
    }

    @Override
    public PolicyDirective<HttpResponse<?>> canRespond(HttpRequest<?> request, HttpResponse<?> response) {
        return this.allow();
    }

    protected <T> PolicyDirective<T> authorize(Envelope envelope, Identity identity) {
        return this.allow();
    }

    public <T> PolicyDirective<T> allow(T value) {
        return PolicyDirective.allow(value);
    }

    public <T> PolicyDirective<T> allow() {
        return PolicyDirective.allow();
    }

    public <T> PolicyDirective<T> deny(Object reason) {
        return PolicyDirective.deny(this, reason);
    }

    public <T> PolicyDirective<T> deny() {
        return PolicyDirective.deny(this);
    }

    public <T> PolicyDirective<T> forbid(Object reason) {
        return PolicyDirective.forbid(this, reason);
    }

    public <T> PolicyDirective<T> forbid() {
        return PolicyDirective.forbid(this);
    }
}

