/*
 * Decompiled with CFR 0.152.
 */
package swim.api.downlink;

import swim.api.Downlink;
import swim.api.downlink.DownlinkRecord;
import swim.api.downlink.DownlinkReifier;
import swim.api.downlink.MapDownlink;
import swim.api.downlink.MapDownlinkRecord;
import swim.api.downlink.ValueDownlink;
import swim.api.ref.SwimRef;
import swim.api.warp.WarpDownlink;
import swim.dataflow.AbstractRecordStreamlet;
import swim.dataflow.Reifier;
import swim.streamlet.Inlet;
import swim.streamlet.Inout;
import swim.streamlet.Inoutlet;
import swim.streamlet.Out;
import swim.streamlet.Outlet;
import swim.streamlet.StreamletScope;
import swim.structure.Form;
import swim.structure.Value;

public class DownlinkStreamlet
extends AbstractRecordStreamlet<Value, Value> {
    @Inout
    public final Inoutlet<Value, Value> hostUri = this.inoutlet();
    @Inout
    public final Inoutlet<Value, Value> nodeUri = this.inoutlet();
    @Inout
    public final Inoutlet<Value, Value> laneUri = this.inoutlet();
    @Inout
    public final Inoutlet<Value, Value> prio = this.inoutlet();
    @Inout
    public final Inoutlet<Value, Value> rate = this.inoutlet();
    @Inout
    public final Inoutlet<Value, Value> body = this.inoutlet();
    @Inout
    public final Inoutlet<Value, Value> type = this.inoutlet();
    protected final SwimRef swim;
    @Out
    public Outlet<Value> state;
    protected Downlink downlink;
    protected DownlinkRecord downlinkRecord;
    protected String inputHostUri;
    protected String inputNodeUri;
    protected String inputLaneUri;
    protected float inputPrio;
    protected float inputRate;
    protected Value inputBody;
    protected String inputType;

    public DownlinkStreamlet(SwimRef swim, StreamletScope<? extends Value> scope) {
        super(scope);
        this.swim = swim;
    }

    public DownlinkStreamlet(SwimRef swim) {
        this(swim, null);
    }

    public static Reifier reifier(SwimRef swim) {
        return new DownlinkReifier(swim);
    }

    public Value getOutput(Outlet<? super Value> outlet) {
        if (outlet == this.state) {
            if (this.downlink instanceof ValueDownlink) {
                return (Value)((ValueDownlink)this.downlink).get();
            }
            if (this.downlinkRecord != null) {
                return this.downlinkRecord;
            }
        }
        return null;
    }

    protected void onRecohere(int version) {
        block20: {
            String type;
            Value body;
            float rate;
            float prio;
            String laneUri;
            String nodeUri;
            String hostUri;
            block19: {
                hostUri = (String)this.castInput((Inlet)this.hostUri, Form.forString());
                nodeUri = (String)this.castInput((Inlet)this.nodeUri, Form.forString());
                laneUri = (String)this.castInput((Inlet)this.laneUri, Form.forString());
                prio = ((Float)this.castInput((Inlet)this.prio, Form.forFloat(), Float.valueOf(0.0f))).floatValue();
                rate = ((Float)this.castInput((Inlet)this.rate, Form.forFloat(), Float.valueOf(0.0f))).floatValue();
                body = this.getInput((Inlet)this.body);
                type = (String)this.castInput((Inlet)this.type, Form.forString());
                if ((hostUri != null ? !hostUri.equals(this.inputHostUri) : this.inputHostUri != null) || (nodeUri != null ? !nodeUri.equals(this.inputNodeUri) : this.inputNodeUri != null) || (laneUri != null ? !laneUri.equals(this.inputLaneUri) : this.inputLaneUri != null)) break block19;
                if (prio == this.inputPrio && rate == this.inputRate && !(body != null ? !body.equals((Object)this.inputBody) : this.inputBody != null) && !(type == null ? this.inputType != null : !type.equals(this.inputType))) break block20;
            }
            if (this.downlink != null) {
                this.downlink.close();
                this.downlink = null;
                this.downlinkRecord = null;
            }
            this.inputHostUri = hostUri;
            this.inputNodeUri = nodeUri;
            this.inputLaneUri = laneUri;
            this.inputPrio = prio;
            this.inputRate = rate;
            this.inputBody = body;
            this.inputType = type;
            SwimRef swim = this.swim;
            if ("map".equals(type)) {
                WarpDownlink downlink = swim.downlinkMap();
                if (hostUri != null) {
                    downlink = downlink.hostUri(hostUri);
                }
                if (nodeUri != null) {
                    downlink = downlink.nodeUri(nodeUri);
                }
                if (laneUri != null) {
                    downlink = downlink.laneUri(laneUri);
                }
                if (prio != 0.0f) {
                    downlink = downlink.prio(prio);
                }
                if (rate != 0.0f) {
                    downlink = downlink.rate(rate);
                }
                if (body != null) {
                    downlink = downlink.body(body);
                }
                downlink = downlink.open();
                this.state = downlink;
                this.downlink = downlink;
                this.downlinkRecord = new MapDownlinkRecord((MapDownlink<Value, Value>)downlink);
            } else if ("value".equals(type)) {
                WarpDownlink downlink = swim.downlinkValue();
                if (hostUri != null) {
                    downlink = downlink.hostUri(hostUri);
                }
                if (nodeUri != null) {
                    downlink = downlink.nodeUri(nodeUri);
                }
                if (laneUri != null) {
                    downlink = downlink.laneUri(laneUri);
                }
                if (prio != 0.0f) {
                    downlink = downlink.prio(prio);
                }
                if (rate != 0.0f) {
                    downlink = downlink.rate(rate);
                }
                if (body != null) {
                    downlink = downlink.body(body);
                }
                downlink = downlink.open();
                this.state = downlink;
                this.downlink = downlink;
            }
        }
    }
}

