/*
 * Decompiled with CFR 0.152.
 */
package swim.api.client;

import swim.api.SwimContext;
import swim.api.client.Client;
import swim.api.client.ClientContext;
import swim.api.downlink.EventDownlink;
import swim.api.downlink.ListDownlink;
import swim.api.downlink.MapDownlink;
import swim.api.downlink.ValueDownlink;
import swim.api.http.HttpDownlink;
import swim.api.ref.HostRef;
import swim.api.ref.LaneRef;
import swim.api.ref.NodeRef;
import swim.api.ref.SwimRef;
import swim.api.router.Router;
import swim.structure.Value;
import swim.uri.Uri;
import swim.util.Log;

public abstract class AbstractClient
implements Client,
Log,
SwimRef {
    protected final ClientContext context;

    public AbstractClient(ClientContext context) {
        this.context = context;
    }

    public AbstractClient() {
        this(SwimContext.getClientContext());
    }

    @Override
    public ClientContext clientContext() {
        return this.context;
    }

    @Override
    public void willStart() {
    }

    @Override
    public void didStart() {
    }

    @Override
    public void willStop() {
    }

    @Override
    public void didStop() {
    }

    @Override
    public void didFail(Throwable error) {
        error.printStackTrace();
    }

    @Override
    public HostRef hostRef(Uri hostUri) {
        return this.context.hostRef(hostUri);
    }

    @Override
    public HostRef hostRef(String hostUri) {
        return this.context.hostRef(hostUri);
    }

    @Override
    public NodeRef nodeRef(Uri hostUri, Uri nodeUri) {
        return this.context.nodeRef(hostUri, nodeUri);
    }

    @Override
    public NodeRef nodeRef(String hostUri, String nodeUri) {
        return this.context.nodeRef(hostUri, nodeUri);
    }

    @Override
    public NodeRef nodeRef(Uri nodeUri) {
        return this.context.nodeRef(nodeUri);
    }

    @Override
    public NodeRef nodeRef(String nodeUri) {
        return this.context.nodeRef(nodeUri);
    }

    @Override
    public LaneRef laneRef(Uri hostUri, Uri nodeUri, Uri laneUri) {
        return this.context.laneRef(hostUri, nodeUri, laneUri);
    }

    @Override
    public LaneRef laneRef(String hostUri, String nodeUri, String laneUri) {
        return this.context.laneRef(hostUri, nodeUri, laneUri);
    }

    @Override
    public LaneRef laneRef(Uri nodeUri, Uri laneUri) {
        return this.context.laneRef(nodeUri, laneUri);
    }

    @Override
    public LaneRef laneRef(String nodeUri, String laneUri) {
        return this.context.laneRef(nodeUri, laneUri);
    }

    @Override
    public void command(Uri hostUri, Uri nodeUri, Uri laneUri, float prio, Value body) {
        this.context.command(hostUri, nodeUri, laneUri, prio, body);
    }

    @Override
    public void command(String hostUri, String nodeUri, String laneUri, float prio, Value body) {
        this.context.command(hostUri, nodeUri, laneUri, prio, body);
    }

    @Override
    public void command(Uri hostUri, Uri nodeUri, Uri laneUri, Value body) {
        this.context.command(hostUri, nodeUri, laneUri, body);
    }

    @Override
    public void command(String hostUri, String nodeUri, String laneUri, Value body) {
        this.context.command(hostUri, nodeUri, laneUri, body);
    }

    @Override
    public void command(Uri nodeUri, Uri laneUri, float prio, Value body) {
        this.context.command(nodeUri, laneUri, prio, body);
    }

    @Override
    public void command(String nodeUri, String laneUri, float prio, Value body) {
        this.context.command(nodeUri, laneUri, prio, body);
    }

    @Override
    public void command(Uri nodeUri, Uri laneUri, Value body) {
        this.context.command(nodeUri, laneUri, body);
    }

    @Override
    public void command(String nodeUri, String laneUri, Value body) {
        this.context.command(nodeUri, laneUri, body);
    }

    @Override
    public EventDownlink<Value> downlink() {
        return this.context.downlink();
    }

    @Override
    public ListDownlink<Value> downlinkList() {
        return this.context.downlinkList();
    }

    @Override
    public MapDownlink<Value, Value> downlinkMap() {
        return this.context.downlinkMap();
    }

    @Override
    public ValueDownlink<Value> downlinkValue() {
        return this.context.downlinkValue();
    }

    @Override
    public <T> HttpDownlink<T> downlinkHttp() {
        return this.context.downlinkHttp();
    }

    @Override
    public void close() {
    }

    public final Router router() {
        return this.context.router();
    }

    public void start() {
        this.context.start();
    }

    public void stop() {
        this.context.stop();
    }

    public void trace(Object message) {
        this.context.trace(message);
    }

    public void debug(Object message) {
        this.context.debug(message);
    }

    public void info(Object message) {
        this.context.info(message);
    }

    public void warn(Object message) {
        this.context.warn(message);
    }

    public void error(Object message) {
        this.context.error(message);
    }
}

