/*
 * Decompiled with CFR 0.152.
 */
package swim.api;

import swim.api.Lane;
import swim.api.Link;
import swim.api.agent.AgentContext;
import swim.api.plane.PlaneContext;
import swim.api.service.ServiceContext;

public final class SwimContext {
    private static final ThreadLocal<ServiceContext> SERVICE_CONTEXT = new ThreadLocal();
    private static final ThreadLocal<PlaneContext> PLANE_CONTEXT = new ThreadLocal();
    private static final ThreadLocal<AgentContext> AGENT_CONTEXT = new ThreadLocal();
    private static final ThreadLocal<Lane> LANE = new ThreadLocal();
    private static final ThreadLocal<Link> LINK = new ThreadLocal();

    private SwimContext() {
    }

    public static ServiceContext getServiceContext() {
        return SERVICE_CONTEXT.get();
    }

    public static void setServiceContext(ServiceContext serviceContext) {
        SERVICE_CONTEXT.set(serviceContext);
    }

    public static PlaneContext getPlaneContext() {
        return PLANE_CONTEXT.get();
    }

    public static void setPlaneContext(PlaneContext planeContext) {
        PLANE_CONTEXT.set(planeContext);
    }

    public static AgentContext getAgentContext() {
        return AGENT_CONTEXT.get();
    }

    public static void setAgentContext(AgentContext agentContext) {
        AGENT_CONTEXT.set(agentContext);
    }

    public static Lane getLane() {
        return LANE.get();
    }

    public static void setLane(Lane lane) {
        LANE.set(lane);
    }

    public static Link getLink() {
        return LINK.get();
    }

    public static void setLink(Link link) {
        LINK.set(link);
    }

    public static void clear() {
        SERVICE_CONTEXT.remove();
        PLANE_CONTEXT.remove();
        AGENT_CONTEXT.remove();
        LANE.remove();
        LINK.remove();
    }
}

