/*
 * Decompiled with CFR 0.152.
 */
package swim.api.downlink;

import java.util.Iterator;
import swim.api.downlink.DownlinkRecord;
import swim.api.downlink.ValueDownlink;
import swim.observable.function.DidSet;
import swim.structure.Field;
import swim.structure.Item;
import swim.structure.Record;
import swim.structure.Text;
import swim.structure.Value;
import swim.util.Cursor;

public class ValueDownlinkRecord
extends DownlinkRecord
implements DidSet<Value> {
    protected final ValueDownlink<Value> downlink;

    public ValueDownlinkRecord(ValueDownlink<Value> downlink) {
        this.downlink = downlink;
        this.downlink.observe((Object)this);
    }

    @Override
    public ValueDownlink<Value> downlink() {
        return this.downlink;
    }

    public boolean isEmpty() {
        Value value = this.downlink.get();
        if (value instanceof Record) {
            return ((Record)value).isEmpty();
        }
        return !value.isDefined();
    }

    public boolean isArray() {
        Value value = this.downlink.get();
        if (value instanceof Record) {
            return ((Record)value).isArray();
        }
        return true;
    }

    public boolean isObject() {
        Value value = this.downlink.get();
        if (value instanceof Record) {
            return ((Record)value).isObject();
        }
        return !value.isDefined();
    }

    public int size() {
        Value value = this.downlink.get();
        if (value instanceof Record) {
            return ((Record)value).size();
        }
        if (value.isDefined()) {
            return 1;
        }
        return 0;
    }

    public boolean containsKey(Value key) {
        Value value = this.downlink.get();
        if (value instanceof Record) {
            return ((Record)value).containsKey(key);
        }
        return false;
    }

    public boolean containsKey(String key) {
        Value value = this.downlink.get();
        if (value instanceof Record) {
            return ((Record)value).containsKey(key);
        }
        return false;
    }

    public Value get(Value key) {
        Value value = this.downlink.get();
        if (value instanceof Record) {
            return ((Record)value).get(key);
        }
        return Value.absent();
    }

    public Value get(String key) {
        Value value = this.downlink.get();
        if (value instanceof Record) {
            return ((Record)value).get(key);
        }
        return Value.absent();
    }

    public Value getAttr(Text key) {
        Value value = this.downlink.get();
        if (value instanceof Record) {
            return ((Record)value).getAttr(key);
        }
        return Value.absent();
    }

    public Value getAttr(String key) {
        Value value = this.downlink.get();
        if (value instanceof Record) {
            return ((Record)value).getAttr(key);
        }
        return Value.absent();
    }

    public Value getSlot(Value key) {
        Value value = this.downlink.get();
        if (value instanceof Record) {
            return ((Record)value).getSlot(key);
        }
        return Value.absent();
    }

    public Value getSlot(String key) {
        Value value = this.downlink.get();
        if (value instanceof Record) {
            return ((Record)value).getSlot(key);
        }
        return Value.absent();
    }

    public Field getField(Value key) {
        Value value = this.downlink.get();
        if (value instanceof Record) {
            return ((Record)value).getField(key);
        }
        return null;
    }

    public Field getField(String key) {
        Value value = this.downlink.get();
        if (value instanceof Record) {
            return ((Record)value).getField(key);
        }
        return null;
    }

    public Item get(int index) {
        Value value = this.downlink.get();
        if (value instanceof Record) {
            return ((Record)value).getItem(index);
        }
        throw new IndexOutOfBoundsException(Integer.toString(index));
    }

    public Item getItem(int index) {
        Value value = this.downlink.get();
        if (value instanceof Record) {
            return ((Record)value).getItem(index);
        }
        if (index == 0) {
            return value;
        }
        return Item.absent();
    }

    public Value put(Value key, Value newValue) {
        Value value = this.downlink.get();
        if (value instanceof Record) {
            return ((Record)value).put(key, newValue);
        }
        throw new UnsupportedOperationException();
    }

    public Value put(String key, Value newValue) {
        Value value = this.downlink.get();
        if (value instanceof Record) {
            return ((Record)value).put(key, newValue);
        }
        throw new UnsupportedOperationException();
    }

    public Value putAttr(Text key, Value newValue) {
        Value value = this.downlink.get();
        if (value instanceof Record) {
            return ((Record)value).putAttr(key, newValue);
        }
        throw new UnsupportedOperationException();
    }

    public Value putAttr(String key, Value newValue) {
        Value value = this.downlink.get();
        if (value instanceof Record) {
            return ((Record)value).putAttr(key, newValue);
        }
        throw new UnsupportedOperationException();
    }

    public Value putSlot(Value key, Value newValue) {
        Value value = this.downlink.get();
        if (value instanceof Record) {
            return ((Record)value).putSlot(key, newValue);
        }
        throw new UnsupportedOperationException();
    }

    public Value putSlot(String key, Value newValue) {
        Value value = this.downlink.get();
        if (value instanceof Record) {
            return ((Record)value).putSlot(key, newValue);
        }
        throw new UnsupportedOperationException();
    }

    public Item setItem(int index, Item newItem) {
        Value value = this.downlink.get();
        if (value instanceof Record) {
            return ((Record)value).setItem(index, newItem);
        }
        if (index == 0) {
            return (Item)this.downlink.set(newItem.toValue());
        }
        throw new IndexOutOfBoundsException(Integer.toString(index));
    }

    public boolean add(Item item) {
        Value value = this.downlink.get();
        if (value instanceof Record) {
            return ((Record)value).add(item);
        }
        throw new UnsupportedOperationException();
    }

    public void add(int index, Item item) {
        Value value = this.downlink.get();
        if (!(value instanceof Record)) {
            throw new UnsupportedOperationException();
        }
        ((Record)value).add(index, item);
    }

    public Item remove(int index) {
        Value value = this.downlink.get();
        if (value instanceof Record) {
            return ((Record)value).remove(index);
        }
        throw new IndexOutOfBoundsException(Integer.toString(index));
    }

    public boolean removeKey(Value key) {
        Value value = this.downlink.get();
        if (value instanceof Record) {
            return ((Record)value).removeKey(key);
        }
        return false;
    }

    public boolean removeKey(String key) {
        Value value = this.downlink.get();
        if (value instanceof Record) {
            return ((Record)value).removeKey(key);
        }
        return false;
    }

    public void clear() {
        Value value = this.downlink.get();
        if (!(value instanceof Record)) {
            throw new UnsupportedOperationException();
        }
        ((Record)value).clear();
    }

    public Iterator<Value> keyIterator() {
        Value value = this.downlink.get();
        if (value instanceof Record) {
            return ((Record)value).keyIterator();
        }
        return Cursor.empty();
    }

    public void didSet(Value newValue, Value oldValue) {
        this.decohereInput();
        this.recohereInput(0);
    }
}

