/*
 * Decompiled with CFR 0.152.
 */
package swim.api.downlink;

import swim.api.downlink.DownlinkStreamlet;
import swim.api.ref.WarpRef;
import swim.dataflow.RecordModel;
import swim.dataflow.Reifier;
import swim.streamlet.StreamletScope;
import swim.structure.Field;
import swim.structure.Item;
import swim.structure.Record;
import swim.structure.Value;

final class DownlinkReifier
extends Reifier {
    final WarpRef warp;

    DownlinkReifier(WarpRef warp) {
        this.warp = warp;
    }

    public Item reify(Item item) {
        if (item instanceof Field) {
            return this.reifyField((Field)item);
        }
        return this.reifyValue((Value)item);
    }

    public Field reifyField(Field field) {
        Value newValue;
        Value oldValue = field.value();
        if (oldValue != (newValue = this.reifyValue(oldValue))) {
            return field.updatedValue(newValue);
        }
        return field;
    }

    public Value reifyValue(Value value) {
        if (value instanceof RecordModel) {
            return this.reifyModel((RecordModel)value);
        }
        return value;
    }

    public Record reifyModel(RecordModel model) {
        if ("link".equals(model.tag())) {
            DownlinkStreamlet streamlet = new DownlinkStreamlet(this.warp, (StreamletScope<? extends Value>)model);
            streamlet.compile();
            return streamlet;
        }
        return model;
    }
}

