/*
 * Decompiled with CFR 0.152.
 */
package swim.api.policy;

import swim.api.policy.Policy;
import swim.codec.Debug;
import swim.codec.Format;
import swim.codec.Output;
import swim.util.Murmur3;

public abstract class PolicyDirective<T>
implements Debug {
    private static Allow<Object> allow;

    PolicyDirective() {
    }

    public boolean isAllowed() {
        return false;
    }

    public boolean isDenied() {
        return false;
    }

    public boolean isForbidden() {
        return false;
    }

    public boolean isDefined() {
        return false;
    }

    public T get() {
        throw null;
    }

    public Policy policy() {
        return null;
    }

    public Object reason() {
        return null;
    }

    public static <T> PolicyDirective<T> allow() {
        if (allow == null) {
            allow = new Allow<Object>(null);
        }
        return allow;
    }

    public static <T> PolicyDirective<T> allow(T value) {
        if (value != null) {
            return new Allow<T>(value);
        }
        return PolicyDirective.allow();
    }

    public static <T> PolicyDirective<T> deny(Policy policy, Object reason) {
        return new Deny(policy, reason);
    }

    public static <T> PolicyDirective<T> deny(Policy policy) {
        return new Deny(policy, null);
    }

    public static <T> PolicyDirective<T> deny(Object reason) {
        return new Deny(null, reason);
    }

    public static <T> PolicyDirective<T> deny() {
        return new Deny(null, null);
    }

    public static <T> PolicyDirective<T> forbid(Policy policy, Object reason) {
        return new Forbid(policy, reason);
    }

    public static <T> PolicyDirective<T> forbid(Policy policy) {
        return new Forbid(policy, null);
    }

    public static <T> PolicyDirective<T> forbid(Object reason) {
        return new Forbid(null, reason);
    }

    public static <T> PolicyDirective<T> forbid() {
        return new Forbid(null, null);
    }

    static final class Allow<T>
    extends PolicyDirective<T> {
        final T value;
        private static int hashSeed;

        Allow(T value) {
            this.value = value;
        }

        @Override
        public boolean isAllowed() {
            return true;
        }

        @Override
        public boolean isDefined() {
            return this.value != null;
        }

        @Override
        public T get() {
            return this.value;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other instanceof Allow) {
                Allow that = (Allow)other;
                return this.value == null ? that.value == null : this.value.equals(that.value);
            }
            return false;
        }

        public int hashCode() {
            if (hashSeed == 0) {
                hashSeed = Murmur3.seed(Allow.class);
            }
            return Murmur3.mash((int)Murmur3.mix((int)hashSeed, (int)Murmur3.hash(this.value)));
        }

        public <T> Output<T> debug(Output<T> output) {
            output = output.write("PolicyDirective").write(46).write("allow").write(40);
            if (this.value != null) {
                output = output.debug(this.value);
            }
            output = output.write(41);
            return output;
        }

        public String toString() {
            return Format.debug((Object)this);
        }
    }

    static final class Deny<T>
    extends PolicyDirective<T> {
        final Policy policy;
        final Object reason;
        private static int hashSeed;

        Deny(Policy policy, Object reason) {
            this.policy = policy;
            this.reason = reason;
        }

        @Override
        public boolean isDenied() {
            return true;
        }

        @Override
        public boolean isForbidden() {
            return true;
        }

        @Override
        public Policy policy() {
            return this.policy;
        }

        @Override
        public Object reason() {
            return this.reason;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other instanceof Deny) {
                Deny that = (Deny)other;
                return (this.policy == null ? that.policy == null : this.policy.equals(that.policy)) && (this.reason == null ? that.reason == null : this.reason.equals(that.reason));
            }
            return false;
        }

        public int hashCode() {
            if (hashSeed == 0) {
                hashSeed = Murmur3.seed(Deny.class);
            }
            return Murmur3.mash((int)Murmur3.mix((int)Murmur3.mix((int)hashSeed, (int)Murmur3.hash((Object)this.policy)), (int)Murmur3.hash((Object)this.reason)));
        }

        public <T> Output<T> debug(Output<T> output) {
            output = output.write("PolicyDirective").write(46).write("deny").write(40).debug((Object)this.policy);
            if (this.reason != null) {
                output = output.write(", ").debug(this.reason);
            }
            output = output.write(41);
            return output;
        }

        public String toString() {
            return Format.debug((Object)this);
        }
    }

    static final class Forbid<T>
    extends PolicyDirective<T> {
        final Policy policy;
        final Object reason;
        private static int hashSeed;

        Forbid(Policy policy, Object reason) {
            this.policy = policy;
            this.reason = reason;
        }

        @Override
        public boolean isDenied() {
            return true;
        }

        @Override
        public boolean isForbidden() {
            return true;
        }

        @Override
        public Policy policy() {
            return this.policy;
        }

        @Override
        public Object reason() {
            return this.reason;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other instanceof Forbid) {
                Forbid that = (Forbid)other;
                return (this.policy == null ? that.policy == null : this.policy.equals(that.policy)) && (this.reason == null ? that.reason == null : this.reason.equals(that.reason));
            }
            return false;
        }

        public int hashCode() {
            if (hashSeed == 0) {
                hashSeed = Murmur3.seed(Forbid.class);
            }
            return Murmur3.mash((int)Murmur3.mix((int)Murmur3.mix((int)hashSeed, (int)Murmur3.hash((Object)this.policy)), (int)Murmur3.hash((Object)this.reason)));
        }

        public <T> Output<T> debug(Output<T> output) {
            output = output.write("PolicyDirective").write(46).write("forbid").write(40).debug((Object)this.policy);
            if (this.reason != null) {
                output = output.write(", ").debug(this.reason);
            }
            output = output.write(41);
            return output;
        }

        public String toString() {
            return Format.debug((Object)this);
        }
    }
}

