/*
 * Decompiled with CFR 0.152.
 */
package swim.util;

import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceArray;
import swim.util.HashGenCacheMapBucket;

public class HashGenCacheMap<K, V> {
    final AtomicReferenceArray<HashGenCacheMapBucket<K, V>> buckets;
    volatile int gen4Hits;
    volatile int gen3Hits;
    volatile int gen2Hits;
    volatile int gen1Hits;
    volatile int misses;
    static final SoftReference<Object> NULL_REF = new SoftReference<Object>(null);
    static final AtomicIntegerFieldUpdater<HashGenCacheMapBucket<?, ?>> BUCKET_GEN4_WEIGHT = AtomicIntegerFieldUpdater.newUpdater(HashGenCacheMapBucket.class, "gen4Weight");
    static final AtomicIntegerFieldUpdater<HashGenCacheMapBucket<?, ?>> BUCKET_GEN3_WEIGHT = AtomicIntegerFieldUpdater.newUpdater(HashGenCacheMapBucket.class, "gen3Weight");
    static final AtomicIntegerFieldUpdater<HashGenCacheMapBucket<?, ?>> BUCKET_GEN2_WEIGHT = AtomicIntegerFieldUpdater.newUpdater(HashGenCacheMapBucket.class, "gen2Weight");
    static final AtomicIntegerFieldUpdater<HashGenCacheMapBucket<?, ?>> BUCKET_GEN1_WEIGHT = AtomicIntegerFieldUpdater.newUpdater(HashGenCacheMapBucket.class, "gen1Weight");
    static final AtomicIntegerFieldUpdater<HashGenCacheMap<?, ?>> GEN4_HITS = AtomicIntegerFieldUpdater.newUpdater(HashGenCacheMap.class, "gen4Hits");
    static final AtomicIntegerFieldUpdater<HashGenCacheMap<?, ?>> GEN3_HITS = AtomicIntegerFieldUpdater.newUpdater(HashGenCacheMap.class, "gen3Hits");
    static final AtomicIntegerFieldUpdater<HashGenCacheMap<?, ?>> GEN2_HITS = AtomicIntegerFieldUpdater.newUpdater(HashGenCacheMap.class, "gen2Hits");
    static final AtomicIntegerFieldUpdater<HashGenCacheMap<?, ?>> GEN1_HITS = AtomicIntegerFieldUpdater.newUpdater(HashGenCacheMap.class, "gen1Hits");
    static final AtomicIntegerFieldUpdater<HashGenCacheMap<?, ?>> MISSES = AtomicIntegerFieldUpdater.newUpdater(HashGenCacheMap.class, "misses");

    public HashGenCacheMap(int size) {
        this.buckets = new AtomicReferenceArray(size);
    }

    public V get(K key) {
        Object gen1Key;
        Object gen2Key;
        Object gen3Key;
        if (this.buckets.length() == 0) {
            return null;
        }
        int index = Math.abs(key.hashCode()) % this.buckets.length();
        HashGenCacheMapBucket<K, V> bucket = this.buckets.get(index);
        if (bucket == null) {
            return null;
        }
        Object gen4Key = bucket.gen4KeyRef.get();
        if (gen4Key != null && key.equals(gen4Key)) {
            Object gen4Val = bucket.gen4ValRef.get();
            if (gen4Val != null) {
                GEN4_HITS.incrementAndGet(this);
                BUCKET_GEN4_WEIGHT.incrementAndGet(bucket);
                return gen4Val;
            }
            bucket.gen4KeyRef.clear();
        }
        if ((gen3Key = bucket.gen3KeyRef.get()) != null && key.equals(gen3Key)) {
            Object gen3Val = bucket.gen3ValRef.get();
            if (gen3Val != null) {
                GEN3_HITS.incrementAndGet(this);
                if (BUCKET_GEN3_WEIGHT.incrementAndGet(bucket) > bucket.gen4Weight) {
                    this.buckets.set(index, new HashGenCacheMapBucket(bucket.gen3KeyRef, bucket.gen3ValRef, bucket.gen3Weight, bucket.gen4KeyRef, bucket.gen4ValRef, bucket.gen4Weight, bucket.gen2KeyRef, bucket.gen2ValRef, bucket.gen2Weight, bucket.gen1KeyRef, bucket.gen1ValRef, bucket.gen1Weight));
                }
                return gen3Val;
            }
            bucket.gen3KeyRef.clear();
        }
        if ((gen2Key = bucket.gen2KeyRef.get()) != null && key.equals(gen2Key)) {
            Object gen2Val = bucket.gen2ValRef.get();
            if (gen2Val != null) {
                GEN2_HITS.incrementAndGet(this);
                if (BUCKET_GEN2_WEIGHT.incrementAndGet(bucket) > bucket.gen3Weight) {
                    this.buckets.set(index, new HashGenCacheMapBucket(bucket.gen4KeyRef, bucket.gen4ValRef, bucket.gen4Weight, bucket.gen2KeyRef, bucket.gen2ValRef, bucket.gen2Weight, bucket.gen3KeyRef, bucket.gen3ValRef, bucket.gen3Weight, bucket.gen1KeyRef, bucket.gen1ValRef, bucket.gen1Weight));
                }
                return gen2Val;
            }
            bucket.gen2KeyRef.clear();
        }
        if ((gen1Key = bucket.gen1KeyRef.get()) != null && key.equals(gen1Key)) {
            Object gen1Val = bucket.gen1ValRef.get();
            if (gen1Val != null) {
                GEN1_HITS.incrementAndGet(this);
                if (BUCKET_GEN1_WEIGHT.incrementAndGet(bucket) > bucket.gen2Weight) {
                    this.buckets.set(index, new HashGenCacheMapBucket(bucket.gen4KeyRef, bucket.gen4ValRef, bucket.gen4Weight, bucket.gen3KeyRef, bucket.gen3ValRef, bucket.gen3Weight, bucket.gen1KeyRef, bucket.gen1ValRef, bucket.gen1Weight, bucket.gen2KeyRef, bucket.gen2ValRef, bucket.gen2Weight));
                }
                return gen1Val;
            }
            bucket.gen1KeyRef.clear();
        }
        MISSES.incrementAndGet(this);
        return null;
    }

    public V put(K key, V value) {
        Object gen1Key;
        Object gen2Key;
        Object gen3Key;
        Object gen4Key;
        if (this.buckets.length() == 0) {
            return value;
        }
        int index = Math.abs(key.hashCode()) % this.buckets.length();
        HashGenCacheMapBucket<K, V> bucket = this.buckets.get(index);
        if (bucket == null) {
            bucket = new HashGenCacheMapBucket();
        }
        if ((gen4Key = bucket.gen4KeyRef.get()) != null && key.equals(gen4Key)) {
            Object gen4Val = bucket.gen4ValRef.get();
            if (gen4Val != null) {
                GEN4_HITS.incrementAndGet(this);
                BUCKET_GEN4_WEIGHT.incrementAndGet(bucket);
                return gen4Val;
            }
            bucket.gen4KeyRef.clear();
            gen4Key = null;
        }
        if ((gen3Key = bucket.gen3KeyRef.get()) != null && key.equals(gen3Key)) {
            Object gen3Val = bucket.gen3ValRef.get();
            if (gen3Val != null) {
                GEN3_HITS.incrementAndGet(this);
                if (BUCKET_GEN3_WEIGHT.incrementAndGet(bucket) > bucket.gen4Weight) {
                    this.buckets.set(index, new HashGenCacheMapBucket(bucket.gen3KeyRef, bucket.gen3ValRef, bucket.gen3Weight, bucket.gen4KeyRef, bucket.gen4ValRef, bucket.gen4Weight, bucket.gen2KeyRef, bucket.gen2ValRef, bucket.gen2Weight, bucket.gen1KeyRef, bucket.gen1ValRef, bucket.gen1Weight));
                }
                return gen3Val;
            }
            bucket.gen3KeyRef.clear();
            gen3Key = null;
        }
        if ((gen2Key = bucket.gen2KeyRef.get()) != null && key.equals(gen2Key)) {
            Object gen2Val = bucket.gen2ValRef.get();
            if (gen2Val != null) {
                GEN2_HITS.incrementAndGet(this);
                if (BUCKET_GEN2_WEIGHT.incrementAndGet(bucket) > bucket.gen3Weight) {
                    this.buckets.set(index, new HashGenCacheMapBucket(bucket.gen4KeyRef, bucket.gen4ValRef, bucket.gen4Weight, bucket.gen2KeyRef, bucket.gen2ValRef, bucket.gen2Weight, bucket.gen3KeyRef, bucket.gen3ValRef, bucket.gen3Weight, bucket.gen1KeyRef, bucket.gen1ValRef, bucket.gen1Weight));
                }
                return gen2Val;
            }
            bucket.gen2KeyRef.clear();
            gen2Key = null;
        }
        if ((gen1Key = bucket.gen1KeyRef.get()) != null && key.equals(gen1Key)) {
            Object gen1Val = bucket.gen1ValRef.get();
            if (gen1Val != null) {
                GEN1_HITS.incrementAndGet(this);
                if (BUCKET_GEN1_WEIGHT.incrementAndGet(bucket) > bucket.gen2Weight) {
                    this.buckets.set(index, new HashGenCacheMapBucket(bucket.gen4KeyRef, bucket.gen4ValRef, bucket.gen4Weight, bucket.gen3KeyRef, bucket.gen3ValRef, bucket.gen3Weight, bucket.gen1KeyRef, bucket.gen1ValRef, bucket.gen1Weight, bucket.gen2KeyRef, bucket.gen2ValRef, bucket.gen2Weight));
                }
                return gen1Val;
            }
            bucket.gen1KeyRef.clear();
            gen1Key = null;
        }
        MISSES.incrementAndGet(this);
        if (gen4Key == null) {
            this.buckets.set(index, new HashGenCacheMapBucket(bucket.gen3KeyRef, bucket.gen3ValRef, bucket.gen3Weight, bucket.gen2KeyRef, bucket.gen2ValRef, bucket.gen2Weight, bucket.gen1KeyRef, bucket.gen1ValRef, bucket.gen1Weight, new SoftReference<K>(key), new SoftReference<V>(value), 1));
        } else if (gen3Key == null) {
            this.buckets.set(index, new HashGenCacheMapBucket(bucket.gen4KeyRef, bucket.gen4ValRef, bucket.gen4Weight, bucket.gen2KeyRef, bucket.gen2ValRef, bucket.gen2Weight, bucket.gen1KeyRef, bucket.gen1ValRef, bucket.gen1Weight, new SoftReference<K>(key), new SoftReference<V>(value), 1));
        } else if (gen2Key == null) {
            this.buckets.set(index, new HashGenCacheMapBucket(bucket.gen4KeyRef, bucket.gen4ValRef, bucket.gen4Weight, bucket.gen3KeyRef, bucket.gen3ValRef, bucket.gen3Weight, bucket.gen1KeyRef, bucket.gen1ValRef, bucket.gen1Weight, new SoftReference<K>(key), new SoftReference<V>(value), 1));
        } else if (gen1Key == null) {
            this.buckets.set(index, new HashGenCacheMapBucket(bucket.gen4KeyRef, bucket.gen4ValRef, bucket.gen4Weight, bucket.gen3KeyRef, bucket.gen3ValRef, bucket.gen3Weight, bucket.gen2KeyRef, bucket.gen2ValRef, bucket.gen2Weight, new SoftReference<K>(key), new SoftReference<V>(value), 1));
        } else {
            this.buckets.set(index, new HashGenCacheMapBucket(bucket.gen4KeyRef, bucket.gen4ValRef, bucket.gen4Weight - 1, bucket.gen3KeyRef, bucket.gen3ValRef, bucket.gen3Weight - 1, bucket.gen1KeyRef, bucket.gen1ValRef, bucket.gen1Weight, new SoftReference<K>(key), new SoftReference<V>(value), 1));
        }
        return value;
    }

    public boolean weaken(K key) {
        Object gen1Key;
        Object gen2Key;
        Object gen3Key;
        if (this.buckets.length() == 0) {
            return false;
        }
        int index = Math.abs(key.hashCode()) % this.buckets.length();
        HashGenCacheMapBucket<K, V> bucket = this.buckets.get(index);
        if (bucket == null) {
            return false;
        }
        Object gen4Key = bucket.gen4KeyRef.get();
        if (gen4Key != null && key.equals(gen4Key)) {
            Object gen4Val = bucket.gen4ValRef.get();
            if (gen4Val != null) {
                this.buckets.set(index, new HashGenCacheMapBucket(HashGenCacheMap.weakRef(bucket.gen4KeyRef), HashGenCacheMap.weakRef(bucket.gen4ValRef), bucket.gen4Weight, bucket.gen3KeyRef, bucket.gen3ValRef, bucket.gen3Weight, bucket.gen2KeyRef, bucket.gen2ValRef, bucket.gen2Weight, bucket.gen1KeyRef, bucket.gen1ValRef, bucket.gen1Weight));
                return true;
            }
            bucket.gen4KeyRef.clear();
            gen4Key = null;
        }
        if ((gen3Key = bucket.gen3KeyRef.get()) != null && key.equals(gen3Key)) {
            Object gen3Val = bucket.gen3ValRef.get();
            if (gen3Val != null) {
                this.buckets.set(index, new HashGenCacheMapBucket(bucket.gen4KeyRef, bucket.gen4ValRef, bucket.gen4Weight, HashGenCacheMap.weakRef(bucket.gen3KeyRef), HashGenCacheMap.weakRef(bucket.gen3ValRef), bucket.gen3Weight, bucket.gen2KeyRef, bucket.gen2ValRef, bucket.gen2Weight, bucket.gen1KeyRef, bucket.gen1ValRef, bucket.gen1Weight));
                return true;
            }
            bucket.gen3KeyRef.clear();
            gen3Key = null;
        }
        if ((gen2Key = bucket.gen2KeyRef.get()) != null && key.equals(gen2Key)) {
            Object gen2Val = bucket.gen2ValRef.get();
            if (gen2Val != null) {
                this.buckets.set(index, new HashGenCacheMapBucket(bucket.gen4KeyRef, bucket.gen4ValRef, bucket.gen4Weight, bucket.gen3KeyRef, bucket.gen3ValRef, bucket.gen3Weight, HashGenCacheMap.weakRef(bucket.gen2KeyRef), HashGenCacheMap.weakRef(bucket.gen2ValRef), bucket.gen2Weight, bucket.gen1KeyRef, bucket.gen1ValRef, bucket.gen1Weight));
                return true;
            }
            bucket.gen2KeyRef.clear();
            gen2Key = null;
        }
        if ((gen1Key = bucket.gen1KeyRef.get()) != null && key.equals(gen1Key)) {
            Object gen1Val = bucket.gen1ValRef.get();
            if (gen1Val != null) {
                this.buckets.set(index, new HashGenCacheMapBucket(bucket.gen4KeyRef, bucket.gen4ValRef, bucket.gen4Weight, bucket.gen3KeyRef, bucket.gen3ValRef, bucket.gen3Weight, bucket.gen2KeyRef, bucket.gen2ValRef, bucket.gen2Weight, HashGenCacheMap.weakRef(bucket.gen1KeyRef), HashGenCacheMap.weakRef(bucket.gen1ValRef), bucket.gen1Weight));
                return true;
            }
            bucket.gen1KeyRef.clear();
            gen1Key = null;
        }
        if (gen4Key == null) {
            this.buckets.set(index, new HashGenCacheMapBucket(bucket.gen3KeyRef, bucket.gen3ValRef, bucket.gen3Weight, bucket.gen2KeyRef, bucket.gen2ValRef, bucket.gen2Weight, bucket.gen1KeyRef, bucket.gen1ValRef, bucket.gen1Weight, HashGenCacheMap.nullRef(), HashGenCacheMap.nullRef(), 1));
        } else if (gen3Key == null) {
            this.buckets.set(index, new HashGenCacheMapBucket(bucket.gen4KeyRef, bucket.gen4ValRef, bucket.gen4Weight, bucket.gen2KeyRef, bucket.gen2ValRef, bucket.gen2Weight, bucket.gen1KeyRef, bucket.gen1ValRef, bucket.gen1Weight, HashGenCacheMap.nullRef(), HashGenCacheMap.nullRef(), 1));
        } else if (gen2Key == null) {
            this.buckets.set(index, new HashGenCacheMapBucket(bucket.gen4KeyRef, bucket.gen4ValRef, bucket.gen4Weight, bucket.gen3KeyRef, bucket.gen3ValRef, bucket.gen3Weight, bucket.gen1KeyRef, bucket.gen1ValRef, bucket.gen1Weight, HashGenCacheMap.nullRef(), HashGenCacheMap.nullRef(), 1));
        } else if (gen1Key == null) {
            this.buckets.set(index, new HashGenCacheMapBucket(bucket.gen4KeyRef, bucket.gen4ValRef, bucket.gen4Weight, bucket.gen3KeyRef, bucket.gen3ValRef, bucket.gen3Weight, bucket.gen2KeyRef, bucket.gen2ValRef, bucket.gen2Weight, HashGenCacheMap.nullRef(), HashGenCacheMap.nullRef(), 1));
        }
        return false;
    }

    public V remove(K key) {
        if (this.buckets.length() == 0) {
            return null;
        }
        int index = Math.abs(key.hashCode()) % this.buckets.length();
        HashGenCacheMapBucket<K, V> bucket = this.buckets.get(index);
        if (bucket == null) {
            return null;
        }
        Object gen4Key = bucket.gen4KeyRef.get();
        if (gen4Key != null && key.equals(gen4Key)) {
            Object gen4Val = bucket.gen4ValRef.get();
            this.buckets.set(index, new HashGenCacheMapBucket(bucket.gen3KeyRef, bucket.gen3ValRef, bucket.gen3Weight, bucket.gen2KeyRef, bucket.gen2ValRef, bucket.gen2Weight, bucket.gen1KeyRef, bucket.gen1ValRef, bucket.gen1Weight, HashGenCacheMap.nullRef(), HashGenCacheMap.nullRef(), 0));
            return gen4Val;
        }
        Object gen3Key = bucket.gen3KeyRef.get();
        if (gen3Key != null && key.equals(gen3Key)) {
            Object gen3Val = bucket.gen3ValRef.get();
            this.buckets.set(index, new HashGenCacheMapBucket(bucket.gen4KeyRef, bucket.gen4ValRef, bucket.gen4Weight, bucket.gen2KeyRef, bucket.gen2ValRef, bucket.gen2Weight, bucket.gen1KeyRef, bucket.gen1ValRef, bucket.gen1Weight, HashGenCacheMap.nullRef(), HashGenCacheMap.nullRef(), 0));
            return gen3Val;
        }
        Object gen2Key = bucket.gen2KeyRef.get();
        if (gen2Key != null && key.equals(gen2Key)) {
            Object gen2Val = bucket.gen2ValRef.get();
            this.buckets.set(index, new HashGenCacheMapBucket(bucket.gen4KeyRef, bucket.gen4ValRef, bucket.gen4Weight, bucket.gen3KeyRef, bucket.gen3ValRef, bucket.gen3Weight, bucket.gen1KeyRef, bucket.gen1ValRef, bucket.gen1Weight, HashGenCacheMap.nullRef(), HashGenCacheMap.nullRef(), 0));
            return gen2Val;
        }
        Object gen1Key = bucket.gen1KeyRef.get();
        if (gen1Key != null && key.equals(gen1Key)) {
            Object gen1Val = bucket.gen1ValRef.get();
            this.buckets.set(index, new HashGenCacheMapBucket(bucket.gen4KeyRef, bucket.gen4ValRef, bucket.gen4Weight, bucket.gen3KeyRef, bucket.gen3ValRef, bucket.gen3Weight, bucket.gen2KeyRef, bucket.gen2ValRef, bucket.gen2Weight, HashGenCacheMap.nullRef(), HashGenCacheMap.nullRef(), 0));
            return gen1Val;
        }
        return null;
    }

    public void clear() {
        for (int i = 0; i < this.buckets.length(); ++i) {
            this.buckets.set(i, null);
        }
    }

    long hits() {
        return (long)this.gen4Hits + (long)this.gen3Hits + (long)this.gen2Hits + (long)this.gen1Hits;
    }

    public double hitRatio() {
        double hits = this.hits();
        return hits / (hits + (double)this.misses);
    }

    static final <T> WeakReference<T> weakRef(Reference<T> ref) {
        if (ref instanceof WeakReference) {
            return (WeakReference)ref;
        }
        return new WeakReference<T>(ref.get());
    }

    static final <T> SoftReference<T> nullRef() {
        return NULL_REF;
    }
}

