/*
 * Decompiled with CFR 0.152.
 */
package swim.util;

import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceArray;
import swim.util.HashGenMapBucket;

public class HashGenMap<K, V> {
    final AtomicReferenceArray<HashGenMapBucket<K, V>> buckets;
    volatile int gen4Hits;
    volatile int gen3Hits;
    volatile int gen2Hits;
    volatile int gen1Hits;
    volatile int misses;
    volatile int evicts;
    static final AtomicIntegerFieldUpdater<HashGenMapBucket<?, ?>> BUCKET_GEN4_WEIGHT = AtomicIntegerFieldUpdater.newUpdater(HashGenMapBucket.class, "gen4Weight");
    static final AtomicIntegerFieldUpdater<HashGenMapBucket<?, ?>> BUCKET_GEN3_WEIGHT = AtomicIntegerFieldUpdater.newUpdater(HashGenMapBucket.class, "gen3Weight");
    static final AtomicIntegerFieldUpdater<HashGenMapBucket<?, ?>> BUCKET_GEN2_WEIGHT = AtomicIntegerFieldUpdater.newUpdater(HashGenMapBucket.class, "gen2Weight");
    static final AtomicIntegerFieldUpdater<HashGenMapBucket<?, ?>> BUCKET_GEN1_WEIGHT = AtomicIntegerFieldUpdater.newUpdater(HashGenMapBucket.class, "gen1Weight");
    static final AtomicIntegerFieldUpdater<HashGenMap<?, ?>> GEN4_HITS = AtomicIntegerFieldUpdater.newUpdater(HashGenMap.class, "gen4Hits");
    static final AtomicIntegerFieldUpdater<HashGenMap<?, ?>> GEN3_HITS = AtomicIntegerFieldUpdater.newUpdater(HashGenMap.class, "gen3Hits");
    static final AtomicIntegerFieldUpdater<HashGenMap<?, ?>> GEN2_HITS = AtomicIntegerFieldUpdater.newUpdater(HashGenMap.class, "gen2Hits");
    static final AtomicIntegerFieldUpdater<HashGenMap<?, ?>> GEN1_HITS = AtomicIntegerFieldUpdater.newUpdater(HashGenMap.class, "gen1Hits");
    static final AtomicIntegerFieldUpdater<HashGenMap<?, ?>> MISSES = AtomicIntegerFieldUpdater.newUpdater(HashGenMap.class, "misses");
    static final AtomicIntegerFieldUpdater<HashGenMap<?, ?>> EVICTS = AtomicIntegerFieldUpdater.newUpdater(HashGenMap.class, "evicts");

    public HashGenMap(int size) {
        this.buckets = new AtomicReferenceArray(size);
    }

    protected void evict(K key, V value) {
    }

    public V get(K key) {
        Object cacheVal;
        HashGenMapBucket<K, V> newBucket;
        HashGenMapBucket<K, V> bucket;
        if (this.buckets.length() == 0) {
            return null;
        }
        int index = Math.abs(key.hashCode()) % this.buckets.length();
        do {
            if ((bucket = this.buckets.get(index)) == null) {
                newBucket = null;
                cacheVal = null;
                continue;
            }
            if (bucket.gen4Key != null && key.equals(bucket.gen4Key)) {
                GEN4_HITS.incrementAndGet(this);
                BUCKET_GEN4_WEIGHT.incrementAndGet(bucket);
                newBucket = bucket;
                cacheVal = bucket.gen4Val;
                continue;
            }
            if (bucket.gen3Key != null && key.equals(bucket.gen3Key)) {
                GEN3_HITS.incrementAndGet(this);
                newBucket = BUCKET_GEN3_WEIGHT.incrementAndGet(bucket) > bucket.gen4Weight ? new HashGenMapBucket(bucket.gen3Key, bucket.gen3Val, bucket.gen3Weight, bucket.gen4Key, bucket.gen4Val, bucket.gen4Weight, bucket.gen2Key, bucket.gen2Val, bucket.gen2Weight, bucket.gen1Key, bucket.gen1Val, bucket.gen1Weight) : bucket;
                cacheVal = bucket.gen3Val;
                continue;
            }
            if (bucket.gen2Key != null && key.equals(bucket.gen2Key)) {
                GEN2_HITS.incrementAndGet(this);
                newBucket = BUCKET_GEN2_WEIGHT.incrementAndGet(bucket) > bucket.gen3Weight ? new HashGenMapBucket(bucket.gen4Key, bucket.gen4Val, bucket.gen4Weight, bucket.gen2Key, bucket.gen2Val, bucket.gen2Weight, bucket.gen3Key, bucket.gen3Val, bucket.gen3Weight, bucket.gen1Key, bucket.gen1Val, bucket.gen1Weight) : bucket;
                cacheVal = bucket.gen2Val;
                continue;
            }
            if (bucket.gen1Key != null && key.equals(bucket.gen1Key)) {
                GEN1_HITS.incrementAndGet(this);
                newBucket = BUCKET_GEN1_WEIGHT.incrementAndGet(bucket) > bucket.gen2Weight ? new HashGenMapBucket(bucket.gen4Key, bucket.gen4Val, bucket.gen4Weight, bucket.gen3Key, bucket.gen3Val, bucket.gen3Weight, bucket.gen1Key, bucket.gen1Val, bucket.gen1Weight, bucket.gen2Key, bucket.gen2Val, bucket.gen2Weight) : bucket;
                cacheVal = bucket.gen1Val;
                continue;
            }
            MISSES.incrementAndGet(this);
            newBucket = bucket;
            cacheVal = null;
        } while (bucket != newBucket && !this.buckets.compareAndSet(index, bucket, newBucket));
        return cacheVal;
    }

    public V put(K key, V value) {
        V cacheVal;
        HashGenMapBucket<K, V> newBucket;
        HashGenMapBucket<K, V> bucket;
        if (this.buckets.length() == 0) {
            return value;
        }
        K evictKey = null;
        V evictVal = null;
        int index = Math.abs(key.hashCode()) % this.buckets.length();
        do {
            if ((bucket = this.buckets.get(index)) == null) {
                newBucket = new HashGenMapBucket<K, V>(key, value);
                cacheVal = value;
                continue;
            }
            if (bucket.gen4Key != null && key.equals(bucket.gen4Key)) {
                GEN4_HITS.incrementAndGet(this);
                BUCKET_GEN4_WEIGHT.incrementAndGet(bucket);
                newBucket = bucket;
                cacheVal = bucket.gen4Val;
                continue;
            }
            if (bucket.gen3Key != null && key.equals(bucket.gen3Key)) {
                GEN3_HITS.incrementAndGet(this);
                newBucket = BUCKET_GEN3_WEIGHT.incrementAndGet(bucket) > bucket.gen4Weight ? new HashGenMapBucket(bucket.gen3Key, bucket.gen3Val, bucket.gen3Weight, bucket.gen4Key, bucket.gen4Val, bucket.gen4Weight, bucket.gen2Key, bucket.gen2Val, bucket.gen2Weight, bucket.gen1Key, bucket.gen1Val, bucket.gen1Weight) : bucket;
                cacheVal = bucket.gen3Val;
                continue;
            }
            if (bucket.gen2Key != null && key.equals(bucket.gen2Key)) {
                GEN2_HITS.incrementAndGet(this);
                newBucket = BUCKET_GEN2_WEIGHT.incrementAndGet(bucket) > bucket.gen3Weight ? new HashGenMapBucket(bucket.gen4Key, bucket.gen4Val, bucket.gen4Weight, bucket.gen2Key, bucket.gen2Val, bucket.gen2Weight, bucket.gen3Key, bucket.gen3Val, bucket.gen3Weight, bucket.gen1Key, bucket.gen1Val, bucket.gen1Weight) : bucket;
                cacheVal = bucket.gen2Val;
                continue;
            }
            if (bucket.gen1Key != null && key.equals(bucket.gen1Key)) {
                GEN1_HITS.incrementAndGet(this);
                newBucket = BUCKET_GEN1_WEIGHT.incrementAndGet(bucket) > bucket.gen2Weight ? new HashGenMapBucket(bucket.gen4Key, bucket.gen4Val, bucket.gen4Weight, bucket.gen3Key, bucket.gen3Val, bucket.gen3Weight, bucket.gen1Key, bucket.gen1Val, bucket.gen1Weight, bucket.gen2Key, bucket.gen2Val, bucket.gen2Weight) : bucket;
                cacheVal = bucket.gen1Val;
                continue;
            }
            MISSES.incrementAndGet(this);
            evictKey = bucket.gen2Key;
            evictVal = bucket.gen2Val;
            newBucket = new HashGenMapBucket(bucket.gen4Key, bucket.gen4Val, bucket.gen4Weight - 1, bucket.gen3Key, bucket.gen3Val, bucket.gen3Weight - 1, bucket.gen1Key, bucket.gen1Val, bucket.gen1Weight, key, value, 1);
            cacheVal = value;
        } while (bucket != newBucket && !this.buckets.compareAndSet(index, bucket, newBucket));
        if (evictKey != null) {
            EVICTS.incrementAndGet(this);
            this.evict(evictKey, evictVal);
        }
        return cacheVal;
    }

    public V remove(K key) {
        Object cacheVal;
        HashGenMapBucket<Object, Object> newBucket;
        HashGenMapBucket<K, V> bucket;
        if (this.buckets.length() == 0) {
            return null;
        }
        int index = Math.abs(key.hashCode()) % this.buckets.length();
        do {
            if ((bucket = this.buckets.get(index)) == null) {
                cacheVal = null;
                newBucket = null;
                continue;
            }
            if (bucket.gen4Key != null && key.equals(bucket.gen4Key)) {
                cacheVal = bucket.gen4Val;
                newBucket = new HashGenMapBucket<Object, Object>(bucket.gen3Key, bucket.gen3Val, bucket.gen3Weight, bucket.gen2Key, bucket.gen2Val, bucket.gen2Weight, bucket.gen1Key, bucket.gen1Val, bucket.gen1Weight, null, null, 0);
                continue;
            }
            if (bucket.gen3Key != null && key.equals(bucket.gen3Key)) {
                cacheVal = bucket.gen3Val;
                newBucket = new HashGenMapBucket<Object, Object>(bucket.gen4Key, bucket.gen4Val, bucket.gen4Weight, bucket.gen2Key, bucket.gen2Val, bucket.gen2Weight, bucket.gen1Key, bucket.gen1Val, bucket.gen1Weight, null, null, 0);
                continue;
            }
            if (bucket.gen2Key != null && key.equals(bucket.gen2Key)) {
                cacheVal = bucket.gen2Val;
                newBucket = new HashGenMapBucket<Object, Object>(bucket.gen4Key, bucket.gen4Val, bucket.gen4Weight, bucket.gen3Key, bucket.gen3Val, bucket.gen3Weight, bucket.gen1Key, bucket.gen1Val, bucket.gen1Weight, null, null, 0);
                continue;
            }
            if (bucket.gen1Key != null && key.equals(bucket.gen1Key)) {
                cacheVal = bucket.gen1Val;
                newBucket = new HashGenMapBucket<Object, Object>(bucket.gen4Key, bucket.gen4Val, bucket.gen4Weight, bucket.gen3Key, bucket.gen3Val, bucket.gen3Weight, bucket.gen2Key, bucket.gen2Val, bucket.gen2Weight, null, null, 0);
                continue;
            }
            cacheVal = null;
            newBucket = bucket;
        } while (bucket != newBucket && !this.buckets.compareAndSet(index, bucket, newBucket));
        return cacheVal;
    }

    public void clear() {
        for (int i = 0; i < this.buckets.length(); ++i) {
            this.buckets.set(i, null);
        }
    }

    public long hits() {
        return (long)this.gen4Hits + (long)this.gen3Hits + (long)this.gen2Hits + (long)this.gen1Hits;
    }

    public double hitRatio() {
        double hits = this.hits();
        return hits / (hits + (double)this.misses);
    }
}

